/*
 *
 * COPYRIGHT:            See COPYING in the top level directory
 * PROJECT:              ReactOS Multimedia
 * FILE:                 dll/win32/mmdrv/mmioctl.h
 * PURPOSE:              Multimedia system NT4 compatibility
 * PROGRAMMER:           Andrew Greenwood
 * UPDATE HISTORY:
 *                       Jan 13, 2007: Split from mmdrv.h
 */

#ifndef MMDRV_IOCTLS
#define MMDRV_IOCTLS

/*
    Base names of the supported devices, as provided by drivers running in
    kernel mode.

    \Device\WaveIn0 etc.
*/

#define WAVE_OUT_DEVICE_NAME    L"\\Device\\WaveOut"
#define WAVE_IN_DEVICE_NAME     L"\\Device\\WaveIn"
#define MIDI_OUT_DEVICE_NAME    L"\\Device\\MidiOut"
#define MIDI_IN_DEVICE_NAME     L"\\Device\\MidiIn"
#define AUX_DEVICE_NAME         L"\\Device\\MMAux"


/*
    Base IOCTL codes
*/

#define IOCTL_SOUND_BASE    FILE_DEVICE_SOUND
#define IOCTL_WAVE_BASE     0x0000
#define IOCTL_MIDI_BASE     0x0080
#define IOCTL_AUX_BASE      0x0100


/*
    Wave IOCTLs
*/

#define IOCTL_WAVE_QUERY_FORMAT \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x0001, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_WAVE_SET_FORMAT \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x0002, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_GET_CAPABILITIES \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x0003, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_WAVE_SET_STATE \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x0004, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_GET_STATE \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x0005, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_GET_POSITION \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x0006, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_SET_VOLUME \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x0007, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_WAVE_GET_VOLUME \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x0008, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_WAVE_SET_PITCH \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x0009, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_GET_PITCH \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x000A, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_SET_PLAYBACK_RATE \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x000B, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_GET_PLAYBACK_RATE \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x000C, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_PLAY \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x000D, METHOD_IN_DIRECT, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_RECORD \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x000E, METHOD_OUT_DIRECT, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_BREAK_LOOP \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x000F, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_WAVE_SET_LOW_PRIORITY \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_WAVE_BASE + 0x0010, METHOD_BUFFERED, FILE_WRITE_ACCESS)


/*
    MIDI IOCTLs
*/

#define IOCTL_MIDI_GET_CAPABILITIES \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_MIDI_BASE + 0x0001, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_MIDI_SET_STATE \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_MIDI_BASE + 0x0002, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_MIDI_GET_STATE \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_MIDI_BASE + 0x0003, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_MIDI_SET_VOLUME \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_MIDI_BASE + 0x0004, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_MIDI_GET_VOLUME \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_MIDI_BASE + 0x0005, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_MIDI_PLAY \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_MIDI_BASE + 0x0006, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_MIDI_RECORD \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_MIDI_BASE + 0x0007, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_MIDI_CACHE_PATCHES \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_MIDI_BASE + 0x0008, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_MIDI_CACHE_DRUM_PATCHES \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_MIDI_BASE + 0x0009, METHOD_BUFFERED, FILE_WRITE_ACCESS)


/*
    Aux IOCTLs
*/

#define IOCTL_AUX_GET_CAPABILITIES \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_AUX_BASE + 0x0001, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_AUX_SET_VOLUME \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_AUX_BASE + 0x0002, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_AUX_GET_VOLUME \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_AUX_BASE + 0x0003, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_SOUND_GET_CHANGED_VOLUME \
    CTL_CODE(IOCTL_SOUND_BASE, IOCTL_AUX_BASE + 0x0004, METHOD_BUFFERED, FILE_READ_ACCESS)

#endif /* MMDRV_IOCTLS */
