/*
 * PROJECT:         ReactOS Setup
 * FILE:            base/setup/usetup/lang/sv-SE.h  
 * PURPOSE:         Swedish resource file
 * Translation:     Jaix Bly plus perhaps GreatLord if blame and translate.reactos.se is consulted.
 */
#pragma once

MUI_LAYOUTS svSELayouts[] =
{
    { L"041D", L"0000041D" },
    { L"0409", L"00000409" },
    { NULL, NULL }
};

static MUI_ENTRY svSELanguagePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Language Selection.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Please choose the language used for the installation process.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Then Tryck ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  This Language will be the default language for the final system.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Fortstt  F3 = Avsluta",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEWelcomePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Vlkommen till ReactOS Setup!",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        11,
        "Denna del av installationen kopierar ReactOS till eran",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "dator och frbereder den andra delen av installationen.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Tryck p ENTER fr att installera ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Tryck p R fr att reparera ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Tryck p L fr att lsa licensavtalet till ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Tryck p F3 fr att avbryta installationen av ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Fr mer information om ReactOS, besk:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "http://www.reactos.org",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        0,
        0,
        "   ENTER = Fortstt  R = Reparera F3 = Avbryt",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEIntroPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ReactOS Setup r i en tidig utvecklingsfas och saknar drfr ett antal",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "funktioner som kan frvntas av ett fullt anvndbart setup-program.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Fljande begrnsningar gller:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "- Setup stder endast filsystem av typen FAT.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "- Kontrollering av hrddiskens filsystem stds (nnu) ej.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        23,
        "\x07  Tryck p ENTER fr att installera ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "\x07  Tryck p F3 fr att avbryta installationen.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Fortstt   F3 = Avbryt",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSELicensePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        6,
        "Licensering:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        8,
        "ReactOS r licenserad under GNU GPL med delar",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        9,
        "av den medfljande koden licenserad under GPL-frenliga",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "licenser ssom X11-, BSD- och GNU LGPL-licenserna.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "All mjukvara som r del av ReactOS r publicerad",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "under GNU GPL, men ven den ursprungliga",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "licensen r upprtthllen.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Denna mjukvara har INGEN GARANTI eller begrnsing p anvndning",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "bortsett frn tillmplig lokal och internationell lag. Licenseringen av",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "ReactOS tcker endast distrubering till tredje part.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "Om Ni av ngon anledning ej ftt en kopia av",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "GNU General Public License med ReactOS, besk",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "http://www.gnu.org/licenses/licenses.html",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        22,
        "Garanti:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        24,
        "Detta r gratis mjukvara; se kllkoden fr restriktioner angende kopiering.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "INGEN GARANTI ges; inte ens fr SLJBARHET eller PASSANDE FR ETT",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        26,
        "SPECIELLT SYFTE. ALL ANVNDNING SKER P EGEN RISK!",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = tervnd",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEDevicePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Listan nedanfr visar instllningarna fr maskinvaran.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "       Dator:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "        Bildskrm:",
        TEXT_STYLE_NORMAL,
    },
    {
        8,
        13,
        "       Tangentbord:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "Tangentbordslayout:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "         Acceptera:",
        TEXT_STYLE_NORMAL
    },
    {
        25,
        16, "Acceptera dessa maskinvaruinstllningar",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        19,
        "ndra instllningarna genom att trycka p UPP- och NED-piltangenterna",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        20,
        "fr att markera en instllning, och tryck p ENTER fr att vlja",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        21,
        "instllningen.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Nr alla instllningar r korrekta, vlj \"Acceptera dessa maskinvaruinstllningar\"",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "och tryck p ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Fortstt   F3 = Avbryt",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSERepairPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ReactOS Setup r i en tidig utvecklingsfas och saknar drfr ett antal",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "funktioner som kan frvntas av ett fullt anvndbart setup-program.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Reparations- och uppdateringsfunktionerna fungerar ej.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Tryck p U fr att uppdatera ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Tryck p R fr terstllningskonsolen.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Tryck p ESC fr att tervnda till fregende sida.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Tryck p ENTER fr att starta om datorn.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ESC = G till fregende sida  ENTER = Starta om datorn",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEComputerPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ndra vilken typ av dator som ska installeras.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Anvnd UPP- och NED-piltangenterna fr att vlja nskad datortyp.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Tryck sen p ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Tryck p ESC fr att tervnda till den fregende sidan utan",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   att ndra datortypen.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Fortstt   ESC = tervnd   F3 = Avbryt",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEFlushPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Datorn frskrar sig om att all data r lagrad p hrdisken.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Detta kommer att ta en stund.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "Nr detta r frdigt kommer datorn att startas om automatiskt.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   Rensar cachen",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEQuitPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Installationen av ReactOS har inte slutfrts.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Se till att ingen floppy-disk finns i floppy-lsare A:",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "och tag ur alla skivor frn CD/DVD-lsarna.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Tryck p ENTER fr att starta om datorn.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   Var god vnta ...",
        TEXT_TYPE_STATUS,
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEDisplayPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ndra vilken typ av bildskrmsinstllning som ska installeras.",
        TEXT_STYLE_NORMAL
    },
    {   8,
        10,
         "\x07  Anvnd UPP- och NED-piltangenterna fr att vlja nskad instllning.",
         TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Tryck sedan p ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Tryck p ESC fr att tervnda till den fregende sidan utan",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   att ndra bildskrmsinstllningen.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Fortstt   ESC = tervnd   F3 = Avbryt",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSESuccessPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "ReactOS har nu installerats p datorn.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Se till att ingen floppy-disk finns i floppy-lsare A:",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "och tag ur alla skivor frn CD/DVD-lsarna.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Tryck p ENTER fr att starta om datorn.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Starta om datorn",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEBootPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Setup misslyckades med att installera bootloadern p datorns",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "hrddisk",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "Var god stt in en formatterad floppy-disk i lsare A: och",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "tryck p ENTER.",
        TEXT_STYLE_NORMAL,
    },
    {
        0,
        0,
        "   ENTER = Fortstt   F3 = Avbryt",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }

};

static MUI_ENTRY svSESelectPartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Lista nedan visar befintliga partitioner och oanvndt",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "diskutrymme fr nya partitioner.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "\x07  Tryck UPP eller NER tangenten fr att vlja i listan.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Tryck ENTER fr att installerara ReactOS till vald partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Press P to create a primary partition.",
//        "\x07  Tryck C fr att skapa en ny partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Press E to create an extended partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Press L to create a logical partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Tryck D fr att ta bort en befintlig partititon.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   Var Vnlig Vnta...",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEConfirmDeleteSystemPartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "You have chosen to delete the system partition.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "System partitions can contain diagnostic programs, hardware configuration",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "programs, programs to start an operating system (like ReactOS) or other",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "programs provided by the hardware manufacturer.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Delete a system partition only when you are sure that there are no such",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "programs on the partition, or when you are sure you want to delete them.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "When you delete the partition, you might not be able to boot the",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        17,
        "computer from the harddisk until you finished the ReactOS Setup.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "\x07  Press ENTER to delete the system partition. You will be asked",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "   to confirm the deletion of the partition again later.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "\x07  Press ESC to return to the previous page. The partition will",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "   not be deleted.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continue  ESC=Cancel",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEFormatPartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Formatera partition",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Partitionen kommer nu att formaters Tryck ENTER fr att fortstta.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Fortstt   F3 = Avsluta",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        TEXT_STYLE_NORMAL
    }
};

static MUI_ENTRY svSEInstallDirectoryEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ReactOS installeras till vald partition. Vlj en",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "mapp som du vill installera ReactOS till.:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Fr att ndra den freslagna mappen, tryck BACKSTEG fr att radera",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "bokstver och skriv sedan in mappen dit du vill att ReactOS ska bli",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "installerad.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Fortstt   F3 = Avsluta",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEFileCopyEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        11,
        12,
        "Var vnlig vnta medans ReactOS Setup kopieras till din ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        30,
        13,
        "installationsmapp.",
        TEXT_STYLE_NORMAL
    },
    {
        20,
        14,
        "Detta kan ta flera minuter att fullflja.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "                                                           \xB3 Var Vnlig Vnta...    ",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEBootLoaderEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Setup installerar boot-loadern",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "Installera bootloadern till harddisken (MBR and VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "Installera bootloadern till hrddisken (VBR only).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "Installera bootloadern till en diskett.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Skippa installation av bootloader.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Fortstt   F3 = Avsluta",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEKeyboardSettingsEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Du vill ndra tangentbordstyp som ska intealleras.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Tryck UP eller NER tangenten fr att vlja nskat tangentbordstyp.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Tryck sedan ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Tryck ESC tangenten fr att terg till frra sidan utan att ndra ngot.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   tangentbordstyp.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Fortstt   ESC = Avbryt   F3 = Avsluta",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSELayoutSettingsEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Var vnlig och vlj layout du vill installera som standard.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Tryck UPP eller NER tangenten fr att vlja nskad",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "    tangentbordslayout. Tryck sedan ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Tryck ESC tangenten fr att terg till frra sidan utan att ndra",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   tangentbordslayout.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ENTER = Fortstt   ESC = Avbryt   F3 = Avsluta",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY svSEPrepareCopyEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Setup frbereder din dator fr kopiering av ReactOS filer. ",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   Sammanstller filkopieringslistan...",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY svSESelectFSEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        17,
        "Vlj ett filsystem i listan nedan.",
        0
    },
    {
        8,
        19,
        "\x07  Tryck UPP or NER tangenten fr att vlja filsystem.",
        0
    },
    {
        8,
        21,
        "\x07  Tryck ENTER fr att formatera partitionen.",
        0
    },
    {
        8,
        23,
        "\x07  Tryck ESC fr att vlja en annan partition.",
        0
    },
    {
        0,
        0,
        "   ENTER = Fortstt   ESC = Avbryt   F3 = Avsluta",
        TEXT_TYPE_STATUS
    },

    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSEDeletePartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Du har valt att ta bort partitionen",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "\x07  Tryck D fr att ta bort partitionen.",
        TEXT_STYLE_NORMAL
    },
    {
        11,
        19,
        "VARNING: Alla data p denna partition kommer att frloras!",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Tryck ESC fr att avbryta.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   D = Tar bort Partitionen   ESC = Avbryt   F3 = Avsluta",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY svSERegistryEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Setup ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Setup uppdaterar systemkonfigurationen. ",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   Skapar regististerdatafiler...",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    },

};

MUI_ERROR svSEErrorEntries[] =
{
    {
        // NOT_AN_ERROR
        "Success\n"
    },
    {
        //ERROR_NOT_INSTALLED
        "ReactOS installerades inte fullstndigt p din\n"
        "dator. Om du avslutar Setup nu, kommer du att behva\n"
        "kra Setup igen fr att installera ReactOS.\n"
        "\n"
        "  \x07  Tryck ENTER fr att fortstta Setup.\n"
        "  \x07  Tryck F3 fr att avsluta Setup.",
        "F3 = Avsluta  ENTER = Fortstta"
    },
    {
        //ERROR_NO_HDD
        "Setup kunde inte hitta ngon hrddisk.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_NO_SOURCE_DRIVE
        "Setup kunde inte hitta sin klldisk.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_LOAD_TXTSETUPSIF
        "Setup misslyckades att lsa in filen TXTSETUP.SIF.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_CORRUPT_TXTSETUPSIF
        "Setup fann en korrupt TXTSETUP.SIF.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_SIGNATURE_TXTSETUPSIF,
        "Setup hittade en ogiltig signatur i TXTSETUP.SIF.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_DRIVE_INFORMATION
        "Setup kunde inte lsa in informationen om systemenheten.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_WRITE_BOOT,
        "Setup misslyckades installera FAT bootkod p systempartitionen.",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_LOAD_COMPUTER,
        "Setup misslyckades att lsa datortypslistan.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_LOAD_DISPLAY,
        "Setup misslyckades att lsa in skrminstllningslistan.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_LOAD_KEYBOARD,
        "Setup misslyckades att lsa in tangentbordstypslistan.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_LOAD_KBLAYOUT,
        "Setup misslyckades att lsa in tangentbordslayoutslistan.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_WARN_PARTITION,
        "Setup fann att minst en hrdisk innehller en partitionstabell\n"
        "inte r kompatibel och inte kan hanteras korrekt!\n"
        "\n"
        "Skapa eller ta bort partitioner kan frstra partitionstabellen.\n"
        "\n"
        "  \x07  Tryck F3 fr att avsluta Setup."
        "  \x07  Tryck ENTER fr att fortstta.",
        "F3 = Avsluta  ENTER = Fortstt"
    },
    {
        //ERROR_NEW_PARTITION,
        "Du kan inte skapa en partition inuti\n"
        "en redat befintlig partition!\n"
        "\n"
        "  * Tryck valfri tangent fr att fortstta.",
        NULL
    },
    {
        //ERROR_DELETE_SPACE,
        "Du kan inte ta bort opartitionerrat diskutrymme!\n"
        "\n"
        "  * Tryck valfri tangent fr att fortstta.",
        NULL
    },
    {
        //ERROR_INSTALL_BOOTCODE,
        "Setup misslyckades att installera FAT bootkoden p systempartitionen.",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_NO_FLOPPY,
        "Ingen disk i enhet A:.",
        "ENTER = Fortstt"
    },
    {
        //ERROR_UPDATE_KBSETTINGS,
        "Setup misslyckades att updatera instllninarna fr tangentbordslayout.",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_UPDATE_DISPLAY_SETTINGS,
        "Setup misslyckades att uppdatera skrmregisterinstllningen.",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_IMPORT_HIVE,
        "Setup misslyckades att improterea en registerdatafil.",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_FIND_REGISTRY
        "Setup misslyckades att hitta registerdatafilerna.",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_CREATE_HIVE,
        "Setup misslyckades att skapa registerdatafilerna.",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_INITIALIZE_REGISTRY,
        "Setup misslyckades att initialisera registret.",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_INVALID_CABINET_INF,
        "Kabinettet has inen giltig inf fil.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_CABINET_MISSING,
        "Kabinettet hittades inte.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_CABINET_SCRIPT,
        "Kabinettet har inget installationsskript.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_COPY_QUEUE,
        "Setup misslyckades att ppna filkopierningskn.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_CREATE_DIR,
        "Setup kunnde inte skapa installationsmapparna.",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_TXTSETUP_SECTION,
        "Setup misslyckades att hitta 'Directories' sektionen\n"
        "i TXTSETUP.SIF.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_CABINET_SECTION,
        "Setup misslyckades att hitta 'Directories' sektionen\n"
        "i kabinettet.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_CREATE_INSTALL_DIR
        "Setup kunnde inte skapa installationsmappen.",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_FIND_SETUPDATA,
        "Setup misslyckades att hitta 'SetupData' sektionen\n"
        "i TXTSETUP.SIF.\n",
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_WRITE_PTABLE,
        "Setup misslyckades att skriva partitionstabellen.\n"
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_ADDING_CODEPAGE,
        "Setup misslyckades att lgga till vald codepage till registret.\n"
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_UPDATE_LOCALESETTINGS,
        "Setup kunnde inte stlla in 'system locale'.\n"
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_ADDING_KBLAYOUTS,
        "Setup misslyckades att lgga till tangentbordslayouten till registret.\n"
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_UPDATE_GEOID,
        "Setup kunde inte stalla int 'geo id'.\n"
        "ENTER = Starta om datorn"
    },
    {
        //ERROR_DIRECTORY_NAME,
        "Invalid directory name.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_INSUFFICIENT_PARTITION_SIZE,
        "The selected partition is not large enough to install ReactOS.\n"
        "The install partition must have a size of at least %lu MB.\n"
        "\n"
        "  * Tryck valfri tangent fr att fortstta.",
        NULL
    },
    {
        //ERROR_PARTITION_TABLE_FULL,
        "You can not create a new primary or extended partition in the\n"
        "partition table of this disk because the partition table is full.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_ONLY_ONE_EXTENDED,
        "You can not create more than one extended partition per disk.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_FORMATTING_PARTITION,
        "Setup is unable to format the partition:\n"
        " %S\n"
        "\n"
        "ENTER = Reboot computer"
    },
    {
        NULL,
        NULL
    }
};

MUI_PAGE svSEPages[] =
{
    {
        LANGUAGE_PAGE,
        svSELanguagePageEntries
    },
    {
       START_PAGE,
       svSEWelcomePageEntries
    },
    {
        INSTALL_INTRO_PAGE,
        svSEIntroPageEntries
    },
    {
        LICENSE_PAGE,
        svSELicensePageEntries
    },
    {
        DEVICE_SETTINGS_PAGE,
        svSEDevicePageEntries
    },
    {
        REPAIR_INTRO_PAGE,
        svSERepairPageEntries
    },
    {
        COMPUTER_SETTINGS_PAGE,
        svSEComputerPageEntries
    },
    {
        DISPLAY_SETTINGS_PAGE,
        svSEDisplayPageEntries
    },
    {
        FLUSH_PAGE,
        svSEFlushPageEntries
    },
    {
        SELECT_PARTITION_PAGE,
        svSESelectPartitionEntries
    },
    {
        CONFIRM_DELETE_SYSTEM_PARTITION_PAGE,
        svSEConfirmDeleteSystemPartitionEntries
    },
    {
        SELECT_FILE_SYSTEM_PAGE,
        svSESelectFSEntries
    },
    {
        FORMAT_PARTITION_PAGE,
        svSEFormatPartitionEntries
    },
    {
        DELETE_PARTITION_PAGE,
        svSEDeletePartitionEntries
    },
    {
        INSTALL_DIRECTORY_PAGE,
        svSEInstallDirectoryEntries
    },
    {
        PREPARE_COPY_PAGE,
        svSEPrepareCopyEntries
    },
    {
        FILE_COPY_PAGE,
        svSEFileCopyEntries
    },
    {
        KEYBOARD_SETTINGS_PAGE,
        svSEKeyboardSettingsEntries
    },
    {
        BOOT_LOADER_PAGE,
        svSEBootLoaderEntries
    },
    {
        LAYOUT_SETTINGS_PAGE,
        svSELayoutSettingsEntries
    },
    {
        QUIT_PAGE,
        svSEQuitPageEntries
    },
    {
        SUCCESS_PAGE,
        svSESuccessPageEntries
    },
    {
        BOOT_LOADER_FLOPPY_PAGE,
        svSEBootPageEntries
    },
    {
        REGISTRY_PAGE,
        svSERegistryEntries
    },
    {
        -1,
        NULL
    }
};

MUI_STRING svSEStrings[] =
{
    {STRING_PLEASEWAIT,
     "   Var vnlig vnta..."},
    {STRING_INSTALLCREATEPARTITION,
     "   ENTER = Install   P = Create Primary   E = Create Extended   F3 = Quit"},
//     "   ENTER = Installera   C = Skapa Partition   F3 = Avsluta"},
    {STRING_INSTALLCREATELOGICAL,
     "   ENTER = Install   L = Create Logical Partition   F3 = Quit"},
    {STRING_INSTALLDELETEPARTITION,
     "   ENTER = Installera   D = Ta bort Partition   F3 = Avsluta"},
    {STRING_DELETEPARTITION,
     "   D = Delete Partition   F3 = Quit"},
    {STRING_PARTITIONSIZE,
     "Storlek p den nya partitionen:"},
    {STRING_CHOOSENEWPARTITION,
     "You have chosen to create a primary partition on"},
//     "Du har valt att skapa en ny partition p"},
    {STRING_CHOOSE_NEW_EXTENDED_PARTITION,
     "You have chosen to create an extended partition on"},
    {STRING_CHOOSE_NEW_LOGICAL_PARTITION,
     "You have chosen to create a logical partition on"},
    {STRING_HDDSIZE,
    "Vnligen skriv in storleken av den nya partitionen i megabytes."},
    {STRING_CREATEPARTITION,
     "   ENTER = Skapa Partition   ESC = Avbryt   F3 = Avsluta"},
    {STRING_PARTFORMAT,
    "Denna Partition kommer att bli formaterad hrnst."},
    {STRING_NONFORMATTEDPART,
    "Du valde att installera ReactOS p en oformaterad partition."},
    {STRING_NONFORMATTEDSYSTEMPART,
    "The system partition is not formatted yet."},
    {STRING_NONFORMATTEDOTHERPART,
    "The new partition is not formatted yet."},
    {STRING_INSTALLONPART,
    "Setup installerar ReactOS till Partitionen"},
    {STRING_CHECKINGPART,
    "Setup undersker nu den valda partitionen."},
    {STRING_CONTINUE,
    "ENTER = Fortstt"},
    {STRING_QUITCONTINUE,
    "F3 = Avsluta  ENTER = Fortstt"},
    {STRING_REBOOTCOMPUTER,
    "ENTER = Starta om datorn"},
    {STRING_TXTSETUPFAILED,
    "Setup misslyckades att hitta '%S' sektionen\ni TXTSETUP.SIF.\n"},
    {STRING_COPYING,
     "   Kopierar fil: %S"},
    {STRING_SETUPCOPYINGFILES,
     "Setup kopierar filer..."},
    {STRING_REGHIVEUPDATE,
    "   Uppdaterar registerdatafiler..."},
    {STRING_IMPORTFILE,
    "   Importerar %S..."},
    {STRING_DISPLAYETTINGSUPDATE,
    "   Uppdaterar skrmregisterinstllningar..."},
    {STRING_LOCALESETTINGSUPDATE,
    "   Uppdaterar lokala instllningar..."},
    {STRING_KEYBOARDSETTINGSUPDATE,
    "   Uppdaterar tangentbordslayoutinstllningar..."},
    {STRING_CODEPAGEINFOUPDATE,
    "   Lgger till information om codepage till registret..."},
    {STRING_DONE,
    "   Frdigt..."},
    {STRING_REBOOTCOMPUTER2,
    "   ENTER = Starta om datorn"},
    {STRING_CONSOLEFAIL1,
    "Det gr inte ppna Konsollen\r\n\r\n"},
    {STRING_CONSOLEFAIL2,
    "Den vanligaste orsaken till detta r att ett USB tangentbord anvnds\r\n"},
    {STRING_CONSOLEFAIL3,
    "USB tangentbord r itne helt sttt n\r\n"},
    {STRING_FORMATTINGDISK,
    "Setup formaterar din disk"},
    {STRING_CHECKINGDISK,
    "Setup underker din disk"},
    {STRING_FORMATDISK1,
    " Formaterar partition som %S filsystem (snabbformatering) "},
    {STRING_FORMATDISK2,
    " Formaterar partition som %S filsystem "},
    {STRING_KEEPFORMAT,
    " Behll nuvarande filsystem (inga frndringar) "},
    {STRING_HDINFOPARTCREATE,
    "%I64u %s  Hrddisk %lu  (Port=%hu, Bus=%hu, Id=%hu) p %wZ."},
    {STRING_HDDINFOUNK1,
    "%I64u %s  Hrddisk %lu  (Port=%hu, Bus=%hu, Id=%hu)."},
    {STRING_HDDINFOUNK2,
    "   %c%c  Typ 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTDELETE,
    "on %I64u %s  Hrddisk %lu  (Port=%hu, Bus=%hu, Id=%hu) p %wZ."},
    {STRING_HDDINFOUNK3,
    "on %I64u %s  Hrddisk %lu  (Port=%hu, Bus=%hu, Id=%hu)."},
    {STRING_HDINFOPARTZEROED,
    "Hrddisk %lu (%I64u %s), Port=%hu, Bus=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK4,
    "%c%c  Typ 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTEXISTS,
    "p Hrddisk %lu (%I64u %s), Port=%hu, Bus=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK5,
    "%c%c %c %sTyp %-3u%s                      %6lu %s"},
    {STRING_HDINFOPARTSELECT,
    "%6lu %s  Hrddisk %lu  (Port=%hu, Bus=%hu, Id=%hu) p %S"},
    {STRING_HDDINFOUNK6,
    "%6lu %s  Hrddisk %lu  (Port=%hu, Bus=%hu, Id=%hu)"},
    {STRING_NEWPARTITION,
    "Setup skapade en ny partition p"},
    {STRING_UNPSPACE,
    "    %sOpartitionerat utrymme%s            %6lu %s"},
    {STRING_MAXSIZE,
    "MB (max. %lu MB)"},
    {STRING_EXTENDED_PARTITION,
    "Extended Partition"},
    {STRING_UNFORMATTED,
    "Ny (Oformaterad)"},
    {STRING_FORMATUNUSED,
    "Oanvnt"},
    {STRING_FORMATUNKNOWN,
    "Oknd"},
    {STRING_KB,
    "KB"},
    {STRING_MB,
    "MB"},
    {STRING_GB,
    "GB"},
    {STRING_ADDKBLAYOUTS,
    "Lgger till tangentbordslayouter"},
    {0, 0}
};
