/* tefan Fulea (stefan dot fulea at mail dot md) */
#pragma once

MUI_LAYOUTS roROLayouts[] =
{
    { L"0418", L"00000418" },
    { L"0409", L"00000409" },
    { NULL, NULL }
};

static MUI_ENTRY roROLanguagePageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR,
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Selecie limb",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Selectai limba pentru procesul de instalare.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Apoi apsai ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Aceasta va fi n final limba implicit pentru tot sistemul.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare  F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROWelcomePageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Bun venit la instalarea ReactOS",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        11,
        "Aceast prim etap din instalarea ReactOS va copia fiierele",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "necesare n calculatorul dumneavoastr i-l va pregti pentru",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "cea de-a doua etap a instalrii.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "\x07  Apsai ENTER pentru a instala ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "\x07  Tastai R pentru a reface un sistem deteriorat sau pentru",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "   a actualiza ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Tastai L pentru Termenii i Condiiile de Liceniere.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        23,
        "\x07  Apsai F3 pentru a iei fr a instala ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        26,
        "Pentru mai multe informaii despre ReactOS, vizitai:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        27,
        "http://www.reactos.org",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        0,
        0,
        "ENTER = Continuare  R = Refacere  L = Licen  F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROIntroPageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Programul curent de instalare este nc ntr-un stadiu primar",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "de dezvoltare i nu conine toate funcionalitile unui",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "program de instalare complet.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "Sunt aplicabile urmtoarele limitri:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "- Programul curent de instalare poate opera doar cu sisteme",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "  de fiiere FAT.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "- Verificrile de integritate pentru fiiere nu sunt",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "  nc implementate.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        26,
        "\x07  Apsai ENTER pentru a instala ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        28,
        "\x07  Apsai F3 pentru a iei fr a instala ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare   F3 = Ieire",
        TEXT_TYPE_STATUS| TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROLicensePageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        6,
        "Liceniere:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        8,
        "Sistemul de operare ReactOS este oferit n termenii Licenei",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        9,
        "Publice Generale GNU, referit n continuare ca GPL, cu pri",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "de cod din alte licene compatibile (ca X11, BSD, i LGPL).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "Toate componentele care fac parte din sistemul ReactOS sunt",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "prin urmare oferite sub licena GPL, meninndu-i astfel i",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "licenierea original n acelai timp.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "Acest sistem vine fr vreo restricie de utilizare, aceasta",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "fiind o condiie legislativ aplicabil att la nivel local",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "ct i internaional. Licenierea se refer doar la distri-",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "buirea sistemului ReactOS ctre pri tere.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "Dac din vreun careva motiv nu deinei o copie a licenei",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        22,
        "GPL mpreun cu ReactOS, o putei consulta (n englez)",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        23,
        "accesnd pagina:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "http://www.gnu.org/licenses/licenses.html",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        27,
        "Garanie:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        29,
        "Acest sistem de operare este distribuit doar n sperana c",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        30,
        "va fi util, neavnd ns ataat NICI O GARANIE; nici mcar",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        31,
        "garania implicit a VANDABILITII sau a UTILITII NTR-UN",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        32,
        "SCOP ANUME.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Revenire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roRODevicePageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Configurare dispozitive de baz",
        TEXT_STYLE_NORMAL
    },
    {
        24,
        11,
        "Arh. de calcul:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        12,
        "Parametri grafici:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        13,
        "Model tastatur:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        14,
        "Aranj. tastatur:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        16,
        "Accept:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        25,
        16,
        "Accept configuraia dispozitivelor",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        19,
        "Putei modifica starea curent. Utilizai tastele SUS/JOS pentru",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        20,
        "alegerea unui dispozitiv, apoi apsai ENTER pentru a-i modifica",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        21,
        "configuraia ataat.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Cnd configuraia dispozitivele enumerate este cea corect,",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "selectai \"Accept configuraia dispozitivelor\", apoi confirmai",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        25,
        "apsnd ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roRORepairPageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Programul de instalare ReactOS este nc ntr-o faz incipient de",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "dezvoltare i nu posed o funcionalitate complet.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Funcionalitatea de refacere nc nu este implementat.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Tastai U pentru actualizarea sistemului.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Tastai R pentru consola de Recuperare.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Apsai ESC pentru a reveni la pagina principal.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Apsai ENTER pentru a reporni calculatorul.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ESC = Revenire  U = Actualizare  R = Recuperare  ENTER = Repornire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROComputerPageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Dorii specificarea unei alte arhitecturi de calcul?",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Utilizai tastele SUS/JOS pentru a selecta o",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   arhitectur de calcul, apoi apsai ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Apsai ESC pentru a reveni la pagina precedent",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   fr a specifica o alt arhitectur de calcul.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare   ESC = Anulare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROFlushPageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Sistemul verific integritatea datelor scrise pe disc.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Aceasta poate dura cteva momente.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "La final, calculatorul va fi repornit automat.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Eliberare memorie...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROQuitPageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "ReactOS nu a fost instalat n ntregime.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Scoatei discul flexibil din unitatea A:",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "i toate mediile CD-ROM din unitile CD.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Apsai ENTER pentru a reporni calculatorul.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Ateptai...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG,
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roRODisplayPageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Dorii modificarea parametrilor grafici de afiare?",
        TEXT_STYLE_NORMAL
    },
    {   8,
        10,
        "\x07  Utilizai tastele SUS/JOS pentru a selecta",
         TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   un grup de parametri, apoi apsai ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Apsai ESC pentru a reveni la pagina precedent",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   fara a modifica parametrii grafici actuali.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare   ESC = Anulare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROSuccessPageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Componentele de baz ale ReactOS au fost instalate cu succes.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Scoatei discul flexibil din unitatea A: i toate mediile",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "CD-ROM din unitile CD.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Apsai ENTER pentru a reporni calculatorul.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Repornire calculator",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROBootPageEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Programul de instalare nu poate instala modulul de",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "iniializare a calculatorului pe discul local.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "Introducei un disc flexibil formatat n",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "unitatea A: apoi s apsai ENTER.",
        TEXT_STYLE_NORMAL,
    },
    {
        0,
        0,
        "ENTER = Continuare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }

};

static MUI_ENTRY roROSelectPartitionEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Urmtoarea list cuprinde partiiile existente, precum i",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "spaiul liber disponibil pentru crearea de noi partiii.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "\x07  Utilizai tastele SUS/JOS pentru a selecta o opiune.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Apsai ENTER pentru a instala pe partiia selectat.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Tastai P pentru a crea o partiie primar.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Tastai E pentru a crea o partiie extins.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Tastai L pentru a crea o partiie logic.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Tastai D pentru a terge o partiie existent.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Ateptai...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROConfirmDeleteSystemPartitionEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR,
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Ai solicitat tergerea partiiei de sistem.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Partiiile de sistem pot conine programe de diagnoz, programe de con-",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "figurare a echipamentelor, programe de lansare a unui sistem de operare",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "(ca ReactOS) i alte programe furnizate de productorii calculorului.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "tergei o partiie de sistem doar cnd suntei siguri c nu exist aa",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "programe pe partiie, sau cnd suntei siguri c dorii s le tergei.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "tergnd partiia apare riscul de a nu mai putea porni calculatorul de",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        17,
        "pe discul local dect dup finalizarea instalrii ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "\x07  Apsai ENTER pentru a terge partiia de sistem. Vi se va",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "   cere s confirmai din nou aceast tergere a partiiei.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "\x07  Apsai ESC pentru a reveni la pagina precedent. Partiia",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "   nu va fi tears.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare   ESC = Anulare",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROFormatPartitionEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Urmeaz formatarea partiiei.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Apsai ENTER pentru a continua.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        TEXT_STYLE_NORMAL
    }
};

static MUI_ENTRY roROInstallDirectoryEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Alegei un director de instalare pe partiia aleas.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "Aici vor fi amplasate fiierele sistemului ReactOS:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Putei indica un alt director, apsnd BACKSPACE pentru",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "a terge caractere, apoi scriind calea directorului unde",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "dorii s instalai ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROFileCopyEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        0,
        12,
        "Are loc copierea de fiiere n directorul ReactOS specificat.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        14,
        "(aceasta poate dura cteva momente)",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        50,
        0,
        "\xB3 Ateptai...",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROBootLoaderEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalare modul de iniializare al calculatorului",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "Instaleaz iniializatorul pe discul intern (MBR i VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "Instaleaz iniializatorul pe discul intern (doar VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "Instaleaz iniializatorul pe un disc flexibil.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Omite instalarea modulului de iniializare.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROKeyboardSettingsEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Dorii specificarea modelului tastaturii instalate?",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Utilizai tastele SUS/JOS pentru a selecta un model",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   de tastatur, apoi apsai ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Apsai ESC pentru a reveni la pagina precedent fr",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   a schimba modelul tastaturii curente.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare   ESC = Anulare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roROLayoutSettingsEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Dorii specificarea unui aranjament implicit de tastatur?",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Utilizai tastele SUS/JOS pentru a selecta un aranjament",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "    dorit de tastatur, apoi apsai ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Apsai ESC pentru a reveni la pagina precedent fr",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   a schimba aranjamentul curent al tastaturii.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Continuare   ESC = Anulare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY roROPrepareCopyEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Au loc pregtirile necesare pentru copierea de fiiere.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "List de fiiere n curs de creare...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY roROSelectFSEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        14,
        "Alegei un sistem de fiiere din lista de mai jos.",
        0
    },
    {
        8,
        16,
        "\x07  Utilizai tastele SUS/JOS pentru a selecta",
        0
    },
    {
        8,
        17,
        "   un sistem de fiiere.",
        0
    },
    {
        8,
        19,
        "\x07  Apsai ENTER pentru a formata partiia.",
        0
    },
    {
        8,
        21,
        "\x07  Apsai ESC pentru a alege o alt partiie.",
        0
    },
    {
        0,
        0,
        "ENTER = Continuare   ESC = Anulare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },

    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roRODeletePartitionEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Ai ales s tergei partiia",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "\x07  Tastai D pentru a terge partiia.",
        TEXT_STYLE_NORMAL
    },
    {
        11,
        19,
        "ATENIE: Toate datele de pe aceast partiie vor fi pierdute!",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Apsai ESC pentru a anula.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "D = tergere partiie   ESC = Anulare   F3 = Ieire",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY roRORegistryEntries[] =
{
    {
        4,
        3,
        " Instalare ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Are loc actualizarea configuraiei sistemului.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Registru n curs de creare...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

MUI_ERROR roROErrorEntries[] =
{
    {
        // NOT_AN_ERROR
        "Succes\n"
    },
    {
        //ERROR_NOT_INSTALLED
        "ReactOS nu a fost instalat n totalitate n calculator.\n"
        "Dac abandonai instalarea acum, alt dat, pentru a\n"
        "instala ReactOS, va fi nevoie s repetai toi paii.\n"
        "\n"
        "  \x07  Apsai ENTER pentru a continua instalarea.\n"
        "  \x07  Apsai F3 pentru a abandona instalarea.",
        "F3 = Ieire  ENTER = Continuare"
    },
    {
        //ERROR_NO_HDD
        "Eec la identificarea unitilor interne de stocare.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_NO_SOURCE_DRIVE
        "Eec la accesarea unitatii de instalare.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_LOAD_TXTSETUPSIF
        "Eec la ncrcarea fiierul TXTSETUP.SIF.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_CORRUPT_TXTSETUPSIF
        "Fiieul TXTSETUP.SIF a fos gsit deteriorat.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_SIGNATURE_TXTSETUPSIF,
        "Fiierul TXTSETUP.SIF conine o semntur nevalid.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_DRIVE_INFORMATION
        "Eec la obinerea de informaii despre\n"
        "dispozitivele din calculator.\n",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_WRITE_BOOT,
        "Eec la instalarea codului FAT de iniializare\n"
        "pe partiia de sistem.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_LOAD_COMPUTER,
        "Eec la ncrcarea listei cu arhitecturi de\n"
        "calcul disponibile.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_LOAD_DISPLAY,
        "Eec la ncrcarea listei cu parametri de\n"
        "afiare pentru ecran.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_LOAD_KEYBOARD,
        "Eec la ncrcarea listei cu tipuri\n"
        "disponibile de tastatur.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_LOAD_KBLAYOUT,
        "Eec la ncrcarea listei de configuraii\n"
        "ale tastaturii.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_WARN_PARTITION,
        "A fost gsit cel puin un disc cu tabel nerecunoscut\n"
        "de partiii, care nu poate fi gestionat corespunztor!\n"
        "\n"
        "Crearea sau tergerea de partiii poate astfel cauza\n"
        "distrugerea tabelei de partiii."
        "\n"
        "  \x07  Apsai F3 pentru a abandona instalarea.\n"
        "  \x07  Apsai ENTER pentru a continua.",
        "F3 = Ieire  ENTER = Continuare"
    },
    {
        //ERROR_NEW_PARTITION,
        "O partiie nou nu poate fi creat n interiorul\n"
        "unei partiii existente!\n"
        "\n"
        "  * Tastai pentru a continua.",
        NULL
    },
    {
        //ERROR_DELETE_SPACE,
        "Ai ncercat tergerea de spaiu nepartiionat,\n"
        "ns doar spaiul partiionat poate fi ters!\n"
        "\n"
        "  * Tastai pentru a continua.",
        NULL
    },
    {
        //ERROR_INSTALL_BOOTCODE,
        "Eec la instalarea codului FAT de iniializare\n"
        "pe partiia de sistem.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_NO_FLOPPY,
        "Nu exist discuri flexibile n unitatea A:",
        "ENTER = Continuare"
    },
    {
        //ERROR_UPDATE_KBSETTINGS,
        "Eec la actualizarea configuraiei de tastatur.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_UPDATE_DISPLAY_SETTINGS,
        "Eec la actualizarea registrului cu\n"
        "parametrii grafici ai ecranului!",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_IMPORT_HIVE,
        "Eec la importarea registrului.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_FIND_REGISTRY
        "Eec la localizarea fiierelor\n"
        "cu datele registrului.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_CREATE_HIVE,
        "Eec la crearea registrului.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_INITIALIZE_REGISTRY,
        "Eec la iniializarea registrului.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_INVALID_CABINET_INF,
        "Fiierul cabinet nu conine nici\n"
        "un fiier valid de tip inf.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_CABINET_MISSING,
        "Eec la localizarea fiierului cabinet.\n",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_CABINET_SCRIPT,
        "Fiierul cabinet nu conine nici\n"
        "un script de instalare.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_COPY_QUEUE,
        "Eec la accesarea listei cu\n"
        "fiiere pentru copiere.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_CREATE_DIR,
        "Eec la crearea directoarelor de instalare.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_TXTSETUP_SECTION,
        "Eec la identificarea seciunii de\n"
        "directoare n fiierul TXTSETUP.SIF.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_CABINET_SECTION,
        "Eec la identificarea seciunii de\n"
        "directoare n fiierul cabinet.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_CREATE_INSTALL_DIR
        "Eec la crearea directorului de instalare.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_FIND_SETUPDATA,
        "Eec la localizarea seciunii pentru date\n"
        "de instalare din fiierul TXTSETUP.SIF.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_WRITE_PTABLE,
        "Eec la scrierea tabelelor de partiii.\n",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_ADDING_CODEPAGE,
        "Eec la includerea paginrii n registru.\n",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_UPDATE_LOCALESETTINGS,
        "Eec la instituirea sistemului de localizare.\n",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_ADDING_KBLAYOUTS,
        "Eec la includerea n registru a configuraiei\n"
        "de tastatur.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_UPDATE_GEOID,
        "Eec la instituirea de geo id.",
        "ENTER = Repornire calculator"
    },
    {
        //ERROR_DIRECTORY_NAME,
        "Numele de director este nevalid.\n"
        "\n"
        "  * Tastai pentru a continua."
    },
    {
        //ERROR_INSUFFICIENT_PARTITION_SIZE,
        "Partiia selectat este prea mic pentru a instala ReactOS.\n"
        "Partiia de instalare trebuie s aib cel puin %lu Moctei.\n"
        "\n"
        "  * Tastai pentru a continua.",
        NULL
    },
    {
        //ERROR_PARTITION_TABLE_FULL,
        "Nu poate fi creat o nou partiie primar sau extins n tabela\n"
        "de partiii a acestui disc deoarece tabela de partiii e plin.\n"
        "\n"
        "  * Tastai pentru a continua."
    },
    {
        //ERROR_ONLY_ONE_EXTENDED,
        "Nu poate fi creat mai mult de o partiie extins pe un disc.\n"
        "\n"
        "  * Tastai pentru a continua."
    },
    {
        //ERROR_FORMATTING_PARTITION,
        "Eec la formatarea partiiei:\n"
        " %S\n"
        "\n"
        "ENTER = Repornire calculator"
    },
    {
        NULL,
        NULL
    }
};

MUI_PAGE roROPages[] =
{
    {
        LANGUAGE_PAGE,
        roROLanguagePageEntries
    },
    {
        START_PAGE,
        roROWelcomePageEntries
    },
    {
        INSTALL_INTRO_PAGE,
        roROIntroPageEntries
    },
    {
        LICENSE_PAGE,
        roROLicensePageEntries
    },
    {
        DEVICE_SETTINGS_PAGE,
        roRODevicePageEntries
    },
    {
        REPAIR_INTRO_PAGE,
        roRORepairPageEntries
    },
    {
        COMPUTER_SETTINGS_PAGE,
        roROComputerPageEntries
    },
    {
        DISPLAY_SETTINGS_PAGE,
        roRODisplayPageEntries
    },
    {
        FLUSH_PAGE,
        roROFlushPageEntries
    },
    {
        SELECT_PARTITION_PAGE,
        roROSelectPartitionEntries
    },
    {
        CONFIRM_DELETE_SYSTEM_PARTITION_PAGE,
        roROConfirmDeleteSystemPartitionEntries
    },
    {
        SELECT_FILE_SYSTEM_PAGE,
        roROSelectFSEntries
    },
    {
        FORMAT_PARTITION_PAGE,
        roROFormatPartitionEntries
    },
    {
        DELETE_PARTITION_PAGE,
        roRODeletePartitionEntries
    },
    {
        INSTALL_DIRECTORY_PAGE,
        roROInstallDirectoryEntries
    },
    {
        PREPARE_COPY_PAGE,
        roROPrepareCopyEntries
    },
    {
        FILE_COPY_PAGE,
        roROFileCopyEntries
    },
    {
        KEYBOARD_SETTINGS_PAGE,
        roROKeyboardSettingsEntries
    },
    {
        BOOT_LOADER_PAGE,
        roROBootLoaderEntries
    },
    {
        LAYOUT_SETTINGS_PAGE,
        roROLayoutSettingsEntries
    },
    {
        QUIT_PAGE,
        roROQuitPageEntries
    },
    {
        SUCCESS_PAGE,
        roROSuccessPageEntries
    },
    {
        BOOT_LOADER_FLOPPY_PAGE,
        roROBootPageEntries
    },
    {
        REGISTRY_PAGE,
        roRORegistryEntries
    },
    {
        -1,
        NULL
    }
};

MUI_STRING roROStrings[] =
{
    {STRING_PLEASEWAIT,
     "   Ateptai..."},
    {STRING_INSTALLCREATEPARTITION,
     "   ENTER = Instalare   P/E = Creare partiie Primar/Extins   F3 = Ieire"},
    {STRING_INSTALLCREATELOGICAL,
     "   ENTER = Instalare   L = Creare partiie Logic   F3 = Ieire"},
    {STRING_INSTALLDELETEPARTITION,
     "   ENTER = Instalare   D = tergere partiie   F3 = Ieire"},
    {STRING_DELETEPARTITION,
     "   D = tergere partiie   F3 = Ieire"},
    {STRING_PARTITIONSIZE,
     "Mrimea noii partiii:"},
    {STRING_CHOOSENEWPARTITION,
     "Ai ales crearea unei partiii primare pe"},
    {STRING_CHOOSE_NEW_EXTENDED_PARTITION,
     "Ai ales crearea unei partiii extinse pe"},
    {STRING_CHOOSE_NEW_LOGICAL_PARTITION,
     "Ai ales crearea unei partiii logice pe"},
    {STRING_HDDSIZE,
    "Introducei mrimea noii partiii n megaoctei."},
    {STRING_CREATEPARTITION,
     "   ENTER = Creare partiie   ESC = Anulare   F3 = Ieire"},
    {STRING_PARTFORMAT,
    "Aceast partiie urmeaz s fie formatat."},
    {STRING_NONFORMATTEDPART,
    "Alegei s instalai ReactOS pe partiie nou sau neformatat."},
    {STRING_NONFORMATTEDSYSTEMPART,
    "Partiia de sistem nc nu a fost formatat."},
    {STRING_NONFORMATTEDOTHERPART,
    "Noua partiie nc nu a fost formatat."},
    {STRING_INSTALLONPART,
    "ReactOS va fi instalat pe partiia"},
    {STRING_CHECKINGPART,
    "Programul de instalare verific acum partiia aleas."},
    {STRING_CONTINUE,
    "ENTER = Continuare"},
    {STRING_QUITCONTINUE,
    "F3 = Ieire  ENTER = Continuare"},
    {STRING_REBOOTCOMPUTER,
    "ENTER = Repornire calculator"},
    {STRING_TXTSETUPFAILED,
    "Nu s-a reuit gsirea sesiunii\n'%S' n TXTSETUP.SIF.\n"},
    {STRING_COPYING,
     "   Fiierul curent: %S"},
    {STRING_SETUPCOPYINGFILES,
     "Fiiere n curs de copiere..."},
    {STRING_REGHIVEUPDATE,
    "   Registru n curs de actualizare..."},
    {STRING_IMPORTFILE,
    "   n curs de importare din %S..."},
    {STRING_DISPLAYETTINGSUPDATE,
    "   Registru de configuraie grafic n actualizare..."},
    {STRING_LOCALESETTINGSUPDATE,
    "   Particulariti locale n actualizare..."},
    {STRING_KEYBOARDSETTINGSUPDATE,
    "   Configuraie de tastatur n actualizare..."},
    {STRING_CODEPAGEINFOUPDATE,
    "   Date de paginare n curs de adaugare n registru..."},
    {STRING_DONE,
    "   Terminat!"},
    {STRING_REBOOTCOMPUTER2,
    "   ENTER = Repornire calculator"},
    {STRING_CONSOLEFAIL1,
    "Eec la deschiderea consolei\r\n\r\n"},
    {STRING_CONSOLEFAIL2,
    "Cea mai frecvent cauz pentru asta este utilizarea unei tastaturi USB\r\n"},
    {STRING_CONSOLEFAIL3,
    "Tastaturile USB nu sunt nc toate acceptate\r\n"},
    {STRING_FORMATTINGDISK,
    "Disc n curs de formatare..."},
    {STRING_CHECKINGDISK,
    "Disc n curs de verificare..."},
    {STRING_FORMATDISK1,
    " Formateaz partiia ca sistem de fiiere %S (formatare rapid) "},
    {STRING_FORMATDISK2,
    " Formateaz partiia ca sistem de fiiere %S "},
    {STRING_KEEPFORMAT,
    " Pstreaz sistemul de fiiere actual (fr schimbri) "},
    {STRING_HDINFOPARTCREATE,
    "%I64u %s  Discul %lu  (Port=%hu, Magistrala=%hu, Id=%hu) de tip %wZ."},
    {STRING_HDDINFOUNK1,
    "%I64u %s  Discul %lu  (Port=%hu, Magistrala=%hu, Id=%hu)."},
    {STRING_HDDINFOUNK2,
    "   %c%c  Tip 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTDELETE,
    "de pe %I64u %s  Discul %lu  (Port=%hu, Magistrala=%hu, Id=%hu) de tip %wZ."},
    {STRING_HDDINFOUNK3,
    "de pe %I64u %s  Discul %lu  (Port=%hu, Magistrala=%hu, Id=%hu)."},
    {STRING_HDINFOPARTZEROED,
    "Discul %lu (%I64u %s), Port=%hu, Magistrala=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK4,
    "%c%c  Tip 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTEXISTS,
    "de pe Discul %lu (%I64u %s), Port=%hu, Magistrala=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK5,
    "%c%c %c %sTip %-3u%s                      %6lu %s"},
    {STRING_HDINFOPARTSELECT,
    "%6lu %s  Discul %lu  (Port=%hu, Magistrala=%hu, Id=%hu) de tip %S"},
    {STRING_HDDINFOUNK6,
    "%6lu %s  Discul %lu  (Port=%hu, Magistrala=%hu, Id=%hu)"},
    {STRING_NEWPARTITION,
    "O nou partiie a fost creat n"},
    {STRING_UNPSPACE,
    "    %sSpaiu nepartiionat%s           %6lu %s"},
    {STRING_MAXSIZE,
    "Mo (max. %lu Mo)"},
    {STRING_EXTENDED_PARTITION,
    "Partiie extins"},
    {STRING_UNFORMATTED,
    "Part. nou (neformatat)"},
    {STRING_FORMATUNUSED,
    "Nefolosit"},
    {STRING_FORMATUNKNOWN,
    "Necunoscut"},
    {STRING_KB,
    "ko"},
    {STRING_MB,
    "Mo"},
    {STRING_GB,
    "Go"},
    {STRING_ADDKBLAYOUTS,
    "Adugare configuraii de tastatur"},
    {0, 0}
};
