/* Translated by ??? and Ismael Ferreras Morezuelas (Swyter) */

#pragma once

MUI_LAYOUTS esESLayouts[] =
{
    { L"040A", L"0000040A" },
    { L"0409", L"00000409" },
    { NULL, NULL }
};

static MUI_ENTRY esESLanguagePageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Seleccin del idioma",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Seleccione el idioma a utilizar durante la instalacin.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Luego presione INTRO.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  El idioma seleccionado tambin ser el idioma del sistema.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Continuar F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESWelcomePageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Bienvenido a la instalacin de ReactOS",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        11,
        "Esta parte de la instalacin copiar ReactOS en su equipo y",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "prepara la segunda parte de la instalacin.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Presione INTRO para instalar ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Presione R para reparar ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Presione L para ver las condiciones y trminos de licencia.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Presione F3 para salir sin instalar ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Para ms informacin sobre ReactOS, visite la Web:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "http://www.reactos.org",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        0,
        0,
        "   INTRO = Continuar  R = Reparar  L = Licencia  F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESIntroPageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "El instalador de ReactOS se encuentra en una etapa preliminar.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "An no posee todas las funciones de un instalador.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Se presentan las siguientes limitaciones:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "- El instalador slo puede utilizar el sistema de archivos FAT.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "- El comprobador de integridad del sistema de archivos no est an",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "  implementado.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "\x07  Presione INTRO para instalar ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        27,
        "\x07  Presione F3 para salir sin instalar ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Continuar   F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESLicensePageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        6,
        "Licencia:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        8,
        "ReactOS se distribuye bajo los trminos de la licencia",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        9,
        "GNU GPL con partes que contienen cdigo de otras",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "licencias compatibles como la X11 o BSD y la GNU LGPL.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "Todo el software que forma parte del sistema ReactOS est",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "por tanto liberado bajo licencia GNU GPL as como manteniendo",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "la licencia original.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Este software viene SIN GARANTIA o restricciones de uso",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "excepto leyes locales o internacionales aplicables. La licencia",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "de ReactOS cubre solo la distribucin a terceras partes.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "Si por algn motivo no recibi una copia de la",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "GNU General Public License con ReactOS visite:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "http://www.gnu.org/licenses/licenses.html",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        22,
        "Garanta:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        24,
        "Este es un software libre; vea el cdigo para las condiciones de copia.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "No existe garanta; ni siquiera de MERCANTIBILIDAD",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        26,
        "o el cumplimiento de algn propsito particular",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "INTRO = Regresar",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESDevicePageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "La lista inferior muestra la configuracin actual de dispositivos.",
        TEXT_STYLE_NORMAL
    },
    {
        24,
        11,
        "Equipo:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        12,
        "Pantalla:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        13,
        "Tipo de teclado:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        14,
        "Distrib. del teclado:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        16,
        "Aceptar:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        25,
        16, "Aceptar la configuracin de los dispositivos",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        19,
        "Puede modificar la configuracin con las teclas ARRIBA y ABAJO",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        20,
        "para elegir. Luego presione INTRO para cambiar a una configuracin",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        21,
        "alternativa.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Cuando la configuracin sea correcta, elija \"Aceptar la configuracin",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "de los dispostivos\" y presione INTRO.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Continuar   F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESRepairPageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "El instalador de ReactOS se encuentra en una etapa preliminar.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "An no posee todas las funciones de un instalador.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Las funciones de reparacin no han sido an implementadas.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Presione U para actualizar el sistema operativo.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Presione R para la consola de recuperacin.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Presione ESC para volver al men principal.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Presione INTRO para reiniciar su equipo.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ESC = Men inicial  U = Actualizar  R = Recuperar  INTRO = Reiniciar",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESComputerPageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Desea modificar el tipo de equipo a instalar.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Presione ARRIBA y ABAJO para elegir el tipo.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "Luego presione INTRO.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Presione ESC para volver a la pgina anterior sin cambiar",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "el tipo de equipo.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Continuar   ESC = Cancelar   F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESFlushPageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "El sistema se est asegurando que todos los datos sean salvados",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Esta operacin puede durar varios minutos",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "Cuando haya terminado, su equipo se reiniciar automticamente",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Vaciando la cach",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESQuitPageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "ReactOS no ha sido instalado completamente",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Retire cualquier disquete de la unidad A: y los CDs de sus unidades.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Presione INTRO para reiniciar su equipo.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Espere un momento...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG,
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESDisplayPageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Desea modificar el tipo de pantalla a instalar.",
        TEXT_STYLE_NORMAL
    },
    {   8,
        10,
         "\x07  Presione ARRIBA y ABAJO para modificar el tipo.",
         TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Luego presione INTRO.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Presione la tecla ESC para volver a la pgina anterior sin",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   modificar el tipo de pantalla.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Continuar   ESC = Cancelar   F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESSuccessPageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Los componentes bsicos de ReactOS han sido instalados correctamente.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Retire cualquier disquete de la unidad A: y todos los",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "CD-ROMs de sus respectivas unidades.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Presione INTRO para reiniciar su equipo.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Reiniciar su equipo",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESBootPageEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "El instalador no pudo instalar el cargador de arranque en el disco",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "de su equipo",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "Inserte un disquete formateado en la unidad A: y",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "presione INTRO.",
        TEXT_STYLE_NORMAL,
    },
    {
        0,
        0,
        "   INTRO = Continuar   F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }

};

static MUI_ENTRY esESSelectPartitionEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "La lista inferior muestra las particiones existentes y el espacio libre",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "en el disco para nuevas particiones.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "\x07  Presione ARRIBA o ABAJO para seleccionar un elemento de la lista.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Presione INTRO para instalar ReactOS en la particin seleccionada.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Presione P para crear una particin primaria.",
//        "\x07  Presione C para crear una nueva particin.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Presione E para crear una particin extendida.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Presione L para crear una particin lgica.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Presione D para borrar una particin existente.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Espere un momento...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESConfirmDeleteSystemPartitionEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Ha solicitado borrar la particin del sistema.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Las particiones del sistema contienen programas de diagnstico y configuracin",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "de dispositivos, para arrancar un sistema operativo (como ReactOS) u otros",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "programas fundamentales proporcionados por el fabricante de hardware.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Borre particiones del sistema nicamente cuando est seguro de que no",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "haya programas de ese tipo en la particin, o cuando est seguro de borrarlos.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "Cuando se elimina una particin puede perder la posibilidad de arrancar el",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        17,
        "equipo desde ese disco duro hasta que termine de instalar ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "\x07  Presione INTRO para borrar la particin del sistema, se",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "   volver a pedir confirmacin ms tarde.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "\x07  Presione ESC para volver a la pgina anterior. Si lo hace ",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "   la particin no se borrar.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "INTRO=Continuar  ESC=Cancelar",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESFormatPartitionEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Formato de la particin",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "El instalador formatear la particin. Presione INTRO para continuar.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Continuar   F3 = Salir",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        TEXT_STYLE_NORMAL
    }
};

static MUI_ENTRY esESInstallDirectoryEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "El programa instalar los archivos en la particin seleccionada. ",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "Seleccione un directorio donde quiere que sea instalado ReactOS:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Para cambiar el directorio sugerido, presione RETROCESO para borrar",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "caracteres y escriba el directorio donde desea que ReactOS",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "sea instalado.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Continuar   F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESFileCopyEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        0,
        12,
        "Espere un momento mientras el Instalador de ReactOS copia",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        13,
        "archivos en su carpeta de instalacin de ReactOS.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        14,
        "Esta operacin puede durar varios minutos.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        50,
        0,
        "\xB3 Espere un momento...",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESBootLoaderEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "A continuacin el programa instalar el cargador de arranque",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "Instalar el cargador de arranque en el disco duro (MBR y VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "Instalar el cargador de arranque en el disco duro (slo VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "Instalar el cargador de inicio en un disquete.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Omitir la instalacin del cargador de arranque.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Continuar   F3 = Salir",
        TEXT_TYPE_STATUS  | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESKeyboardSettingsEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Desea cambiar el tipo de teclado instalado.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Presione ARRIBA o ABAJO para seleccionar el tipo de teclado.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Luego presione INTRO.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Presione la tecla ESC para volver a la pgina anterior sin cambiar",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   el tipo de teclado.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Continuar   ESC = Cancelar   F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESLayoutSettingsEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Seleccione la distribucin de teclado a instalar de forma predeterminada.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Presione ARRIBA o ABAJO para seleccionar la distribucin de teclado",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "    deseada. Luego presione INTRO.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Presione la tecla ESC para volver a la pgina anterior sin cambiar",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   la distribucin de teclado.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   INTRO = Continuar   ESC = Cancelar   F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY esESPrepareCopyEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "El programa prepara su equipo para copiar los archivos de ReactOS. ",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Creando la lista de archivos a copiar...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY esESSelectFSEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        17,
        "Seleccione un sistema de archivos de la lista inferior.",
        0
    },
    {
        8,
        19,
        "\x07  Presione ARRIBA o ABAJO para seleccionar el sistema de archivos.",
        0
    },
    {
        8,
        21,
        "\x07  Presione INTRO para formatear particin.",
        0
    },
    {
        8,
        23,
        "\x07  Presione ESC para seleccionar otra particin.",
        0
    },
    {
        0,
        0,
        "   INTRO = Continuar   ESC = Cancelar   F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },

    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESDeletePartitionEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Ha elegido borrar la particin",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "\x07  Presione D para borrar la particin.",
        TEXT_STYLE_NORMAL
    },
    {
        11,
        19,
        "ADVERTENCIA: Se perdern todos los datos de esta particin!",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Presione ESC para cancelar.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   D = Borrar particin   ESC = Cancelar   F3 = Salir",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY esESRegistryEntries[] =
{
    {
        4,
        3,
        " Instalacin de ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "El instalador est actualizando la configuracin del sistema. ",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   Creando la estructura del Registro...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

MUI_ERROR esESErrorEntries[] =
{
    {
        // NOT_AN_ERROR
        "Completado correctamente\n"
    },
    {
        //ERROR_NOT_INSTALLED
        "ReactOS no est completamente instalado en su\n"
        "equipo. Si cierra ahora el Instalador, necesitar\n"
        "ejecutarlo otra vez para instalar ReactOS.\n"
        "\n"
        "  \x07  Presione INTRO para continuar con el instalador.\n"
        "  \x07  Presione F3 para abandonar el instalador.",
        "F3 = Salir  INTRO = Continuar"
    },
    {
        //ERROR_NO_HDD
        "El instalador no pudo encontrar un disco duro.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_NO_SOURCE_DRIVE
        "El instalador no pudo encontrar su unidad fuente.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_LOAD_TXTSETUPSIF
        "El instalador fall al cargar el archivo TXTSETUP.SIF.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_CORRUPT_TXTSETUPSIF
        "El instalador encontr un archivo TXTSETUP.SIF corrupto.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_SIGNATURE_TXTSETUPSIF,
        "El instalador encontr una firma incorrecta en TXTSETUP.SIF.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_DRIVE_INFORMATION
        "El instalador no pudo recibir informacin del disco del sistema.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_WRITE_BOOT,
        "El instalador fall al instalar el cdigo de inicio FAT en la particin del sistema.",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_LOAD_COMPUTER,
        "El instalador fall al cargar la lista de tipos de equipos.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_LOAD_DISPLAY,
        "El instalador fall al cargar la lista de resoluciones de pantalla.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_LOAD_KEYBOARD,
        "El instalador fall al cargar la lista de teclados.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_LOAD_KBLAYOUT,
        "El instalador fall al cargar la lista de distribuciones de teclado.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_WARN_PARTITION,
        "El instalador encontr que al menos un disco duro contiene una tabla\n"
        "de particin incompatible que no puede ser manejada correctamente!\n"
        "\n"
        "Crear o borrar particiones puede destruir la tabla de particiones.\n"
        "\n"
        "  \x07  Presione F3 para salir del instalador.\n"
        "  \x07  Presione INTRO para continuar.",
        "F3 = Salir  INTRO = Continuar"
    },
    {
        //ERROR_NEW_PARTITION,
        "No puede crear una nueva particin dentro\n"
        "de una particin existente!\n"
        "\n"
        "  * Presione cualquier tecla para continuar.",
        NULL
    },
    {
        //ERROR_DELETE_SPACE,
        "No se puede borrar un espacio de disco sin particionar!\n"
        "\n"
        "  * Presione cualquier tecla para continuar.",
        NULL
    },
    {
        //ERROR_INSTALL_BOOTCODE,
        "El instalador fall al instalar el cdigo de inicio FAT en la particin del sistema.",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_NO_FLOPPY,
        "No hay disco en la unidad A:.",
        "INTRO = Continuar"
    },
    {
        //ERROR_UPDATE_KBSETTINGS,
        "El instalador fall al actualizar la configuracin de distribucin de teclado.",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_UPDATE_DISPLAY_SETTINGS,
        "El instalador fall al actualizar la configuracin de la pantalla.",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_IMPORT_HIVE,
        "El instalador fall al importar un archivo de la estructura.",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_FIND_REGISTRY
        "El instalador fall al buscar los archivos de datos registrados.",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_CREATE_HIVE,
        "El instalador fall al crear el registro de la estructura.",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_INITIALIZE_REGISTRY,
        "El instalador fall al configurar el registro de inicio.",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_INVALID_CABINET_INF,
        "Cabinet no tiene un archivo inf vlido.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_CABINET_MISSING,
        "Cabinet no encontrado.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_CABINET_SCRIPT,
        "Cabinet no tiene ningn script de instalacin.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_COPY_QUEUE,
        "El instalador fall al abrir la lista de archivos a copiar.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_CREATE_DIR,
        "El instalador no puede crear los directorios de instalacin.",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_TXTSETUP_SECTION,
        "El instalador fall al buscar la seccin 'Directorios'\n"
        "en TXTSETUP.SIF.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_CABINET_SECTION,
        "El instalador fall al buscar la seccin 'Directorios'\n"
        "en el cabinet.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_CREATE_INSTALL_DIR
        "El instalador no puede crear el directorio de instalacin.",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_FIND_SETUPDATA,
        "El instalador fall al buscar la seccin 'SetupData'\n"
        "en TXTSETUP.SIF.\n",
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_WRITE_PTABLE,
        "El instalador fall al escribir la tabla de particiones.\n"
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_ADDING_CODEPAGE,
        "El instalador fall al aadir el cdigo de pginas al registro.\n"
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_UPDATE_LOCALESETTINGS,
        "El instalador no pudo configurar el idioma del sistema.\n"
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_ADDING_KBLAYOUTS,
        "El instalador no ha podido agregar los layouts de teclado al registro.\n"
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_UPDATE_GEOID,
        "El instalador no ha podido configurar el ID geogrfico.\n"
        "INTRO = Reiniciar el equipo"
    },
    {
        //ERROR_DIRECTORY_NAME,
        "Nombre de carpeta no vlido.\n"
        "\n"
        "  * Presione una tecla para continuar."
    },
    {
        //ERROR_INSUFFICIENT_PARTITION_SIZE,
        "La particin selecionada no es lo suficientemente grande como para.\n"
        "instalar ReactOS. Se necesita una particin de al menos %lu MB.\n"
        "\n"
        "  * Presione una tecla para continuar.",
        NULL
    },
    {
        //ERROR_PARTITION_TABLE_FULL,
        "No es posible aadir una particin primaria o extendida en la\n"
        "tabla de particin de este disco, ya que est completamente llena.\n"
        "\n"
        "  * Presione una tecla para continuar."
    },
    {
        //ERROR_ONLY_ONE_EXTENDED,
        "No es posible crear ms de una particin extendida por disco.\n"
        "\n"
        "  * Presione una tecla para continuar."
    },
    {
        //ERROR_FORMATTING_PARTITION,
        "El instalador es incapaz de formatear la particin:\n"
        " %S\n"
        "\n"
        "INTRO = reiniciar equipo"
    },
    {
        NULL,
        NULL
    }
};

MUI_PAGE esESPages[] =
{
    {
        LANGUAGE_PAGE,
        esESLanguagePageEntries
    },
    {
        START_PAGE,
        esESWelcomePageEntries
    },
    {
        INSTALL_INTRO_PAGE,
        esESIntroPageEntries
    },
    {
        LICENSE_PAGE,
        esESLicensePageEntries
    },
    {
        DEVICE_SETTINGS_PAGE,
        esESDevicePageEntries
    },
    {
        REPAIR_INTRO_PAGE,
        esESRepairPageEntries
    },
    {
        COMPUTER_SETTINGS_PAGE,
        esESComputerPageEntries
    },
    {
        DISPLAY_SETTINGS_PAGE,
        esESDisplayPageEntries
    },
    {
        FLUSH_PAGE,
        esESFlushPageEntries
    },
    {
        SELECT_PARTITION_PAGE,
        esESSelectPartitionEntries
    },
    {
        CONFIRM_DELETE_SYSTEM_PARTITION_PAGE,
        esESConfirmDeleteSystemPartitionEntries
    },
    {
        SELECT_FILE_SYSTEM_PAGE,
        esESSelectFSEntries
    },
    {
        FORMAT_PARTITION_PAGE,
        esESFormatPartitionEntries
    },
    {
        DELETE_PARTITION_PAGE,
        esESDeletePartitionEntries
    },
    {
        INSTALL_DIRECTORY_PAGE,
        esESInstallDirectoryEntries
    },
    {
        PREPARE_COPY_PAGE,
        esESPrepareCopyEntries
    },
    {
        FILE_COPY_PAGE,
        esESFileCopyEntries
    },
    {
        KEYBOARD_SETTINGS_PAGE,
        esESKeyboardSettingsEntries
    },
    {
        BOOT_LOADER_PAGE,
        esESBootLoaderEntries
    },
    {
        LAYOUT_SETTINGS_PAGE,
        esESLayoutSettingsEntries
    },
    {
        QUIT_PAGE,
        esESQuitPageEntries
    },
    {
        SUCCESS_PAGE,
        esESSuccessPageEntries
    },
    {
        BOOT_LOADER_FLOPPY_PAGE,
        esESBootPageEntries
    },
    {
        REGISTRY_PAGE,
        esESRegistryEntries
    },
    {
        -1,
        NULL
    }
};

MUI_STRING esESStrings[] =
{
    {STRING_PLEASEWAIT,
     "   Espere un momento..."},
    {STRING_INSTALLCREATEPARTITION,
     "   INTRO = Instalar  P = Crear primaria   E = Crear extendida   F3 = Salir"},
    {STRING_INSTALLCREATELOGICAL,
     "   INTRO = Instalar  C = Crear particin lgica   F3 = Salir"},
    {STRING_DELETEPARTITION,
     "   D = Borrar particin   F3 = Salir"},
    {STRING_INSTALLDELETEPARTITION,
     "   INTRO = Instalar   D = Borrar particin   F3 = Salir"},
    {STRING_PARTITIONSIZE,
     "Tamao de la nueva particin:"},
    {STRING_CHOOSENEWPARTITION,
     "Ha elegido crear una nueva particin primaria en"},
    {STRING_CHOOSE_NEW_EXTENDED_PARTITION,
     "Ha elegido crear una nueva particin extendida en"},
    {STRING_CHOOSE_NEW_LOGICAL_PARTITION,
     "Ha elegido crear una nueva particin lgica en"},
    {STRING_HDDSIZE,
    "Escriba el tamao de la nueva particin en megabytes."},
    {STRING_CREATEPARTITION,
     "   INTRO = Crear particin   ESC = Cancelar   F3 = Salir"},
    {STRING_PARTFORMAT,
    "A continuacin se formatear esta particin."},
    {STRING_NONFORMATTEDPART,
    "Ha elegido instalar ReactOS en una nueva particin o en una particin sin formato."},
    {STRING_NONFORMATTEDSYSTEMPART,
    "La particin del sistema todava no ha sido formateada."},
    {STRING_NONFORMATTEDOTHERPART,
    "La particin nueva todava no ha sido formateada."},
    {STRING_INSTALLONPART,
    "El instalador est instalando ReactOS en la particin"},
    {STRING_CHECKINGPART,
    "El instalador est comprobando la particin seleccionada."},
    {STRING_CONTINUE,
    "INTRO = Continuar"},
    {STRING_QUITCONTINUE,
    "F3 = Salir  INTRO = Continuar"},
    {STRING_REBOOTCOMPUTER,
    "INTRO = Reiniciar el equipo"},
    {STRING_TXTSETUPFAILED,
    "El instalador fall al buscar la seccin\nen TXTSETUP.SIF.\n"},
    {STRING_COPYING,
     "   Copiando archivo: %S"},
    {STRING_SETUPCOPYINGFILES,
     "El instalador est copiando archivos..."},
    {STRING_REGHIVEUPDATE,
    "   Actualizando el rbol del registro..."},
    {STRING_IMPORTFILE,
    "   Importando %S..."},
    {STRING_DISPLAYETTINGSUPDATE,
    "   Actualizando configuracin del tipo de pantalla..."},
    {STRING_LOCALESETTINGSUPDATE,
    "   Actualizando configuracin regional..."},
    {STRING_KEYBOARDSETTINGSUPDATE,
    "   Actualizando configuracin de distribucin de teclado..."},
    {STRING_CODEPAGEINFOUPDATE,
    "   Aadiendo informacin al registro..."},
    {STRING_DONE,
    "   Terminado..."},
    {STRING_REBOOTCOMPUTER2,
    "   INTRO = Reiniciar el equipo"},
    {STRING_CONSOLEFAIL1,
    "No se pudo abrir la consola\r\n\r\n"},
    {STRING_CONSOLEFAIL2,
    "La causa ms comn es la utilizacin de un teclado USB\r\n"},
    {STRING_CONSOLEFAIL3,
    "Todava no se soportan los teclados USB por completo\r\n"},
    {STRING_FORMATTINGDISK,
    "El instalador est formateando el disco"},
    {STRING_CHECKINGDISK,
    "El instalador est verificando el disco"},
    {STRING_FORMATDISK1,
    " Formatear la particin con sistema de archivos %S (formato rpido) "},
    {STRING_FORMATDISK2,
    " Formatear la particin con sistema de archivos %S "},
    {STRING_KEEPFORMAT,
    " Mantener el sistema de archivos actual (sin cambios) "},
    {STRING_HDINFOPARTCREATE,
    "%I64u %s  Disco duro %lu  (Port=%hu, Bus=%hu, Id=%hu) en %wZ."},
    {STRING_HDDINFOUNK1,
    "%I64u %s  Disco duro %lu  (Port=%hu, Bus=%hu, Id=%hu)."},
    {STRING_HDDINFOUNK2,
    "   %c%c  Tipo 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTDELETE,
    "en %I64u %s  Disco duro %lu  (Port=%hu, Bus=%hu, Id=%hu) en %wZ."},
    {STRING_HDDINFOUNK3,
    "en %I64u %s  Disco duro %lu  (Port=%hu, Bus=%hu, Id=%hu)."},
    {STRING_HDINFOPARTZEROED,
    "Disco duro %lu (%I64u %s), Port=%hu, Bus=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK4,
    "%c%c  Tipo 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTEXISTS,
    "en Disco duro %lu (%I64u %s), Port=%hu, Bus=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK5,
    "%c%c %c %sTipo %-3u%s                      %6lu %s"},
    {STRING_HDINFOPARTSELECT,
    "%6lu %s  Disco duro %lu  (Port=%hu, Bus=%hu, Id=%hu) en %S"},
    {STRING_HDDINFOUNK6,
    "%6lu %s  Disco duro %lu  (Port=%hu, Bus=%hu, Id=%hu)"},
    {STRING_NEWPARTITION,
    "El instalador ha creado una nueva particin en"},
    {STRING_UNPSPACE,
    "    %sEspacio sin particionar%s            %6lu %s"},
    {STRING_MAXSIZE,
    "MB (mx. %lu MB)"},
    {STRING_EXTENDED_PARTITION,
    "Particin extendida"},
    {STRING_UNFORMATTED,
    "Nueva (sin formato)"},
    {STRING_FORMATUNUSED,
    "Libre"},
    {STRING_FORMATUNKNOWN,
    "desconocido"},
    {STRING_KB,
    "KB"},
    {STRING_MB,
    "MB"},
    {STRING_GB,
    "GB"},
    {STRING_ADDKBLAYOUTS,
    "Aadiendo distribucin de teclado"},
    {0, 0}
};
