/* FILE:        base/setup/usetup/lang/cs-CZ.rc
 * TRANSLATOR:  Radek Liska aka Black_Fox (radekliska at gmail dot com)
 * THANKS TO:   preston for bugfix advice at line 848
 * UPDATED:     2015-04-12
 */

#pragma once

MUI_LAYOUTS csCZLayouts[] =
{
    { L"0405", L"00000405" },
    { L"0405", L"00010405" },
    { L"0409", L"00000409" },
    { NULL, NULL }
};

static MUI_ENTRY csCZLanguagePageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Vbr jazyka",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Prosm zvolte jazyk, kter bude bhem instalace pouit.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Pot stisknte ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Tento jazyk bude vchozm jazykem v nainstalovanm systmu.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraovat  F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZWelcomePageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Vtejte v instalaci ReactOS",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        11,
        "Tato st instalace nakopruje operan systm ReactOS do vaeho",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "potae a piprav druhou st instalace.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Stisknutm klvesy ENTER zahjte instalaci ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Stisknutm R zahjte opravu nebo aktualizaci ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Stiskutm L zobrazte Licenn podmnky ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Stisknutm F3 ukonte instalaci ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Vce informac o ReactOS naleznete na adrese:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "http://www.reactos.org",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        0,
        0,
        "ENTER = Pokraovat  R = Opravit  L = Licence  F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZIntroPageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalace ReactOS je v ran vvojov fzi. Zatm nejsou podporovny",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "vechny funkce pln pouiteln instalan aplikace.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Plat nsledujc omezen:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "- Instalace podporuje pouze souborov systm FAT.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "- Kontroly souborovch systm zatm nejsou implementovny.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        23,
        "\x07  Stisknutm klvesy ENTER zahjte instalaci ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "\x07  Stisknutm F3 ukonte instalaci ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraovat   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZLicensePageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        6,
        "Licence:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        8,
        "The ReactOS System is licensed under the terms of the",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        9,
        "GNU GPL with parts containing code from other compatible",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "licenses such as the X11 or BSD and GNU LGPL licenses.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "All software that is part of the ReactOS system is",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "therefore released under the GNU GPL as well as maintaining",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "the original license.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "This software comes with NO WARRANTY or restrictions on usage",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "save applicable local and international law. The licensing of",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "ReactOS only covers distribution to third parties.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "If for some reason you did not receive a copy of the",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "GNU General Public License with ReactOS please visit",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "http://www.gnu.org/licenses/licenses.html",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        22,
        "Zruka:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        24,
        "This is free software; see the source for copying conditions.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "There is NO warranty; not even for MERCHANTABILITY or",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        26,
        "FITNESS FOR A PARTICULAR PURPOSE",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Zpt",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZDevicePageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Nsledujc seznam zobrazuje souasn nastaven zazen.",
        TEXT_STYLE_NORMAL
    },
    {
        24,
        11,
        "Pota:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        12,
        "Obrazovka:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        13,
        "Klvesnice:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        14,
        "Rozloen klves:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        16,
        "Pijmout:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        25,
        16, "Pijmout toto nastaven zazen",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        19,
        "Nastaven hardwaru lze zmnit stiskem klvesy ENTER na dku",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        20,
        "zvolenm ipkami nahoru a dol. Pot lze zvolit jin nastaven.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        21,
        " ",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Jakmile budou vechna nastaven v podku, oznate \"Pijmout toto",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "nastaven zazen\" a stisknte ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraovat   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZRepairPageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalace ReactOS je v ran vvojov fzi. Zatm nejsou",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "podporovny vechny funkce pln pouiteln instalan aplikace.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Opravn funkce zatm nejsou implementovny.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Stisknutm U zahjte Update systmu.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Stisknutm R spustte Konzoli obnoven.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Stisknutm ESC se vrtte na hlavn strnku.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Stisknutm klvesy ENTER restartujete pota.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ESC = Hlavn strnka  U = Aktualizovat  R = Zchrana  ENTER = Restartovat",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZComputerPageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Chcete zmnit typ potae, kter bude nainstalovn.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Poadovan typ potae zvolte pomoc ipek nahoru a dol.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Pot stisknte ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Stisknutm ESC se vrtte na pedchoz strnku bez zmny typu",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   potae.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraovat   ESC = Zruit   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZFlushPageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Systm se nyn ujiuje, e vechna data budou uloena na disk.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Toto me trvat nkolik minut.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "Po dokonen bude pota automaticky zrestartovn.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Uvoluji cache",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZQuitPageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "ReactOS nen kompletn nainstalovn",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Vyjmte disketu z jednotky A:",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "a vechny CD-ROM z CD mechanik.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Stisknutm klvesy ENTER restartujete pota.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "   ekejte, prosm...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG,
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZDisplayPageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Chcete zmnit typ obrazovky, kter bude nainstalovna.",
        TEXT_STYLE_NORMAL
    },
    {   8,
        10,
         "\x07  Poadovan typ obrazovky zvolte pomoc ipek nahoru a dol.",
         TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Pot stisknte ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Stisknutm ESC se vrtte na pedchoz strnku bez zmny typu",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   obrazovky.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraovat   ESC = Zruit   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZSuccessPageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Zkladn sousti ReactOS byly spn nainstalovny.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Vyjmte disketu z jednotky A:",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "a vechny CD-ROM z CD mechanik.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Stisknutm klvesy ENTER restartujete pota.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Restartovat pota",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZBootPageEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalan aplikace nedoke nainstalovat zavad؟ na tento",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "disk",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "Vlote naformtovanou disketu do jednotky A:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "a stisknte ENTER.",
        TEXT_STYLE_NORMAL,
    },
    {
        0,
        0,
        "ENTER = Pokraovat   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }

};

static MUI_ENTRY csCZSelectPartitionEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Na nsledujcm seznamu jsou existujc oddly a nevyuit",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "msto pro nov oddly.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "\x07  Vyberte poloku v seznamu pomoc ipek nahoru a dol.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Stisknutm klvesy ENTER nainstalujete ReactOS na zvolen oddl.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Stistknutm P vytvote primrn oddl.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Stistknutm E vytvote rozen oddl.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Press L to create a logical partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Stisknutm D umonte smazn existujcho oddlu.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Cekejte, prosim...", //MUSI ZUSTAT BEZ DIAKRITIKY!
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZConfirmDeleteSystemPartitionEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "You have chosen to delete the system partition.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "System partitions can contain diagnostic programs, hardware configuration",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "programs, programs to start an operating system (like ReactOS) or other",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "programs provided by the hardware manufacturer.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Delete a system partition only when you are sure that there are no such",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "programs on the partition, or when you are sure you want to delete them.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "When you delete the partition, you might not be able to boot the",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        17,
        "computer from the harddisk until you finished the ReactOS Setup.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "\x07  Press ENTER to delete the system partition. You will be asked",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "   to confirm the deletion of the partition again later.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "\x07  Press ESC to return to the previous page. The partition will",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "   not be deleted.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continue  ESC=Cancel",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZFormatPartitionEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Formtovn oddlu",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Tento oddl bude nyn zformtovn. Stisknutm klvesy ENTER zanete.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraovat   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        TEXT_STYLE_NORMAL
    }
};

static MUI_ENTRY csCZInstallDirectoryEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalace nyn na zvolen oddl nakopruje soubory ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "Zvolte adres, kam bude ReactOS nainstalovn:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Chcete-li zmnit navrhnut adres, stisknutm klvesy BACKSPACE",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "vymate text cesty a pot zapite cestu, do kter chcete ReactOS",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "nainstalovat.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraovat   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZFileCopyEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        0,
        12,
        "ekejte, prosm, instalace nyn kopruje soubory do zvolenho adrese.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        13,
        " ",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        14,
        "Toto me trvat nkolik minut.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        49,
        0,
        "\xB3 ekejte, prosm...    ",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZBootLoaderEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalace nyn nainstaluje zavad؟.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "Nainstalovat zavad؟ na pevn disk (MBR a VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "Nainstalovat zavad؟ na pevn disk (pouze VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "Nainstalovat zavad؟ na disketu.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Peskoit instalaci zavad؟e.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraovat   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZKeyboardSettingsEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Chcete zmnit typ klvesnice, kter bude nainstalovna.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Poadovan typ klvesnice zvolte pomoc ipek nahoru a dol.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Pot stisknte ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Stisknutm ESC se vrtte na pedchoz strnku bez zmny typu",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   klvesnice.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraovat   ESC = Zruit   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZLayoutSettingsEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Prosm zvolte rozloen, kter bude implicitn nainstalovno.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Poadovan rozloen klves zvolte pomoc ipek nahoru a dol.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "    Pot stisknte ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Stisknutm ESC se vrtte na pedchoz strnku bez zmny rozloen",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   klves.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraovat   ESC = Zruit   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY csCZPrepareCopyEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalace piprav pota na koprovn soubor ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Sestavuji seznam soubor ke zkoprovn...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY csCZSelectFSEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        17,
        "Zvolte souborov systm z nsledujcho seznamu.",
        0
    },
    {
        8,
        19,
        "\x07  Souborov systm zvolte ipkami nahoru a dol.",
        0
    },
    {
        8,
        21,
        "\x07  Stisknutm klvesy ENTER zformtujete oddl.",
        0
    },
    {
        8,
        23,
        "\x07  Stisknutm ESC se vrtte na vbr oddlu.",
        0
    },
    {
        0,
        0,
        "ENTER = Pokraovat   ESC = Zruit   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },

    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZDeletePartitionEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Zvolili jste odstrann oddlu",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "\x07  Stisknutm D odstrante oddl.",
        TEXT_STYLE_NORMAL
    },
    {
        11,
        19,
        "POZOR: Vechna data na tomto oddlu budou ztracena!",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Stisknutm ESC zrute akci.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "D = Odstranit oddl   ESC = Zruit   F3 = Ukonit",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY csCZRegistryEntries[] =
{
    {
        4,
        3,
        " Instalace ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalace aktualizuje nastaven systmu.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Vytvm registry...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

MUI_ERROR csCZErrorEntries[] =
{
    {
        // NOT_AN_ERROR
        "Success\n"
    },
    {
        //ERROR_NOT_INSTALLED
        "ReactOS nen ve vaem potai kompletn nainstalovn.\n"
        "Pokud nyn instalaci ukonte, budete ji muset pro\n"
        "nainstalovn ReactOS spustit znovu.\n"
        "\n"
        "  \x07  Stisknutm klvesy ENTER budete pokraovat v instalaci.\n"
        "  \x07  Stisknutm F3 ukonte instalaci.",
        "F3 = Ukonit  ENTER = Pokraovat"
    },
    {
        //ERROR_NO_HDD
        "Instalace nedokzala najt harddisk.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_NO_SOURCE_DRIVE
        "Instalace nedokzala najt svou zdrojovou mechaniku.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_LOAD_TXTSETUPSIF
        "Nepodailo se nast soubor TXTSETUP.SIF.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_CORRUPT_TXTSETUPSIF
        "Soubor TXTSETUP.SIF je pokozen.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_SIGNATURE_TXTSETUPSIF,
        "Soubor TXTSETUP.SIF je neplatn podepsan.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_DRIVE_INFORMATION
        "Instalace nedokzala zskat informace o systmovch discch.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_WRITE_BOOT,
        "Nepodailo se nainstalovat FAT zavad؟ na systmov oddl.",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_LOAD_COMPUTER,
        "Nepodailo se nast seznam typ potae.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_LOAD_DISPLAY,
        "Nepodailo se nast seznam nastaven obrazovek.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_LOAD_KEYBOARD,
        "Nepodailo se nast seznam typ klvesnic.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_LOAD_KBLAYOUT,
        "Nepodailo se nast seznam rozloen klves.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_WARN_PARTITION,
          "Instalace zjistila, e alespo jeden pevn disk obsahuje\n"
          "nekompatibiln tabulku oddl, kter neme bt sprvn zpracovna!\n"
          "\n"
          "Vytven nebo odstraovn oddl me tuto tabulku oddl zniit.\n"
          "\n"
          "  \x07  Stisknutm F3 ukonte instalaci.\n"
          "  \x07  Stisknutm ENTER budete pokraovat v instalaci.",
          "F3 = Ukonit  ENTER = Pokraovat"
    },
    {
        //ERROR_NEW_PARTITION,
        "Nelze vytvoit nov oddl uvnit ji\n"
        "existujcho oddlu!\n"
        "\n"
        "  * Pokraujte stisknutm libovoln klvesy.",
        NULL
    },
    {
        //ERROR_DELETE_SPACE,
        "Nelze vymazat msto na disku, kter nepat dnmu oddlu!\n"
        "\n"
        "  * Pokraujte stisknutm libovoln klvesy.",
        NULL
    },
    {
        //ERROR_INSTALL_BOOTCODE,
        "Nepodailo se nainstalovat FAT zavad؟ na systmov oddl.",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_NO_FLOPPY,
        "V jednotce A: nen disketa.",
        "ENTER = Pokraovat"
    },
    {
        //ERROR_UPDATE_KBSETTINGS,
        "Nepodailo se aktualizovat nastaven rozloen klves.",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_UPDATE_DISPLAY_SETTINGS,
        "Nepodailo se aktualizovat nastaven zobrazen registru.", //display registry settings
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_IMPORT_HIVE,
        "Nepodailo se naimportovat soubor registru.",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_FIND_REGISTRY
        "Nepodailo se nalzt datov soubory registru.",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_CREATE_HIVE,
        "Nepodailo se zaloit registr.",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_INITIALIZE_REGISTRY,
        "Nepodailo se inicializovat registry.",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_INVALID_CABINET_INF,
        "V archivu nen platn soubor inf.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_CABINET_MISSING,
        "Archiv nebyl nalezen.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_CABINET_SCRIPT,
        "Archiv neobsahuje instalan skript.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_COPY_QUEUE,
        "Nepodailo se otevt frontu koprovn.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_CREATE_DIR,
        "Nepodailo se vytvoit instalan adrese.",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_TXTSETUP_SECTION,
        "Nepodailo se nalzt sekci 'Directories' v souboru\n"
        "TXTSETUP.SIF.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_CABINET_SECTION,
        "Nepodailo se nalzt sekci 'Directories' v archivu.\n"
        "\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_CREATE_INSTALL_DIR
        "Nepodailo se vytvoit instalan adres.",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_FIND_SETUPDATA,
        "Nepodailo se nalzt sekci 'SetupData' v souboru\n"
        "TXTSETUP.SIF.\n",
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_WRITE_PTABLE,
        "Nepodailo se zapsat tabulky oddl.\n"
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_ADDING_CODEPAGE,
        "Nepodailo se pidat kdovou strnku do registru.\n"
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_UPDATE_LOCALESETTINGS,
        "Nepodailo se nastavit mstn nastaven.\n"
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_ADDING_KBLAYOUTS,
        "Nepodailo se pidat rozloen klvesnice do registru.\n"
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_UPDATE_GEOID,
        "Nepodailo se nastavit geo id.\n"
        "ENTER = Restartovat pota"
    },
    {
        //ERROR_DIRECTORY_NAME,
        "Neplatn nzev adrese.\n"
        "\n"
        "  * Pokraujte stisknutm libovoln klvesy."
    },
    {
        //ERROR_INSUFFICIENT_PARTITION_SIZE,
        "Zvolen oddl nen pro instalaci ReactOS dostaten velk.\n"
        "Instalan oddl mus mt velikost alespo %lu MB.\n"
        "\n"
        "  * Pokraujte stisknutm libovoln klvesy.",
        NULL
    },
    {
        //ERROR_PARTITION_TABLE_FULL,
        "Nepodailo se vytvoit nov primrn nebo rozen oddl\n"
        "v tabulce oddl na zvolenm disku, protoe tabulka oddl je pln.\n"
        "\n"
        "  * Pokraujte stisknutm libovoln klvesy."
    },
    {
        //ERROR_ONLY_ONE_EXTENDED,
        "Nen mon vytvoit vce ne jeden rozen oddl na disk.\n"
        "\n"
        "  * Pokraujte stisknutm libovoln klvesy."
    },
    {
        //ERROR_FORMATTING_PARTITION,
        "Setup is unable to format the partition:\n"
        " %S\n"
        "\n"
        "ENTER = Reboot computer"
    },
    {
        NULL,
        NULL
    }
};

MUI_PAGE csCZPages[] =
{
    {
        LANGUAGE_PAGE,
        csCZLanguagePageEntries
    },
    {
        START_PAGE,
        csCZWelcomePageEntries
    },
    {
        INSTALL_INTRO_PAGE,
        csCZIntroPageEntries
    },
    {
        LICENSE_PAGE,
        csCZLicensePageEntries
    },
    {
        DEVICE_SETTINGS_PAGE,
        csCZDevicePageEntries
    },
    {
        REPAIR_INTRO_PAGE,
        csCZRepairPageEntries
    },
    {
        COMPUTER_SETTINGS_PAGE,
        csCZComputerPageEntries
    },
    {
        DISPLAY_SETTINGS_PAGE,
        csCZDisplayPageEntries
    },
    {
        FLUSH_PAGE,
        csCZFlushPageEntries
    },
    {
        SELECT_PARTITION_PAGE,
        csCZSelectPartitionEntries
    },
    {
        CONFIRM_DELETE_SYSTEM_PARTITION_PAGE,
        csCZConfirmDeleteSystemPartitionEntries
    },
    {
        SELECT_FILE_SYSTEM_PAGE,
        csCZSelectFSEntries
    },
    {
        FORMAT_PARTITION_PAGE,
        csCZFormatPartitionEntries
    },
    {
        DELETE_PARTITION_PAGE,
        csCZDeletePartitionEntries
    },
    {
        INSTALL_DIRECTORY_PAGE,
        csCZInstallDirectoryEntries
    },
    {
        PREPARE_COPY_PAGE,
        csCZPrepareCopyEntries
    },
    {
        FILE_COPY_PAGE,
        csCZFileCopyEntries
    },
    {
        KEYBOARD_SETTINGS_PAGE,
        csCZKeyboardSettingsEntries
    },
    {
        BOOT_LOADER_PAGE,
        csCZBootLoaderEntries
    },
    {
        LAYOUT_SETTINGS_PAGE,
        csCZLayoutSettingsEntries
    },
    {
        QUIT_PAGE,
        csCZQuitPageEntries
    },
    {
        SUCCESS_PAGE,
        csCZSuccessPageEntries
    },
    {
        BOOT_LOADER_FLOPPY_PAGE,
        csCZBootPageEntries
    },
    {
        REGISTRY_PAGE,
        csCZRegistryEntries
    },
    {
        -1,
        NULL
    }
};

MUI_STRING csCZStrings[] =
{
    {STRING_PLEASEWAIT,
     "   ekejte, prosm..."},
    {STRING_INSTALLCREATEPARTITION,
     "   ENTER = Instalovat   P = Nov primrn   E = Nov rozen   F3 = Ukonit"},
    {STRING_INSTALLCREATELOGICAL,
     "   ENTER = Instalovat   L = Vytvoit logick oddl   F3 = Ukonit"},
    {STRING_INSTALLDELETEPARTITION,
     "   ENTER = Instalovat   D = Odstranit oddl   F3 = Ukonit"},
    {STRING_DELETEPARTITION,
     "   D = Odstranit oddl   F3 = Ukonit"},
    {STRING_PARTITIONSIZE,
     "Velikost novho oddlu:"},
    {STRING_CHOOSENEWPARTITION,
     "Zvolili jste vytvoen novho primrnho oddlu na"},
    {STRING_CHOOSE_NEW_EXTENDED_PARTITION,
     "Zvolili jste vytvoen novho rozenho oddlu na"},
    {STRING_CHOOSE_NEW_LOGICAL_PARTITION,
     "Zvolili jste vytvoen novho logickho oddlu na"},
    {STRING_HDDSIZE,
    "Zadejte velikost novho oddlu v megabajtech."},
    {STRING_CREATEPARTITION,
     "   ENTER = Vytvoit oddl   ESC = Zruit   F3 = Ukonit"},
    {STRING_PARTFORMAT,
    "Tento oddl bude zformtovn."},
    {STRING_NONFORMATTEDPART,
    "Zvolili jste instalaci ReactOS na nov nebo nezformtovan oddl."},
    {STRING_NONFORMATTEDSYSTEMPART,
    "The system partition is not formatted yet."},
    {STRING_NONFORMATTEDOTHERPART,
    "The new partition is not formatted yet."},
    {STRING_INSTALLONPART,
    "Instalace nakopruje ReactOS na oddl"},
    {STRING_CHECKINGPART,
    "Instalace nyn kontroluje zvolen oddl."},
    {STRING_CONTINUE,
    "ENTER = Pokraovat"},
    {STRING_QUITCONTINUE,
    "F3 = Ukonit  ENTER = Pokraovat"},
    {STRING_REBOOTCOMPUTER,
    "ENTER = Restartovat pota"},
    {STRING_TXTSETUPFAILED,
    "Nepodailo se najt sekci '%S' v souboru\n TXTSETUP.SIF.\n"},
    {STRING_COPYING,
     "   Kopruji soubor: %S"},
    {STRING_SETUPCOPYINGFILES,
     "Instalace kopruje soubory..."},
    {STRING_REGHIVEUPDATE,
    "   Aktualizuji registr..."},
    {STRING_IMPORTFILE,
    "   Importuji %S..."},
    {STRING_DISPLAYETTINGSUPDATE,
    "   Aktualizuji nastaven zobrazen registru..."}, //display registry settings
    {STRING_LOCALESETTINGSUPDATE,
    "   Aktualizuji mstn nastaven..."},
    {STRING_KEYBOARDSETTINGSUPDATE,
    "   Aktualizuji nastaven rozloen klves..."},
    {STRING_CODEPAGEINFOUPDATE,
    "   Pidvm do registru informaci o znakov strnce..."},
    {STRING_DONE,
    "   Hotovo..."},
    {STRING_REBOOTCOMPUTER2,
    "   ENTER = Restartovat pota"},
    {STRING_CONSOLEFAIL1,
    "Nelze otevt konzoli\r\n\r\n"},
    {STRING_CONSOLEFAIL2,
    "Nejbاnj pinou je pouvn USB klvesnice\r\n"},
    {STRING_CONSOLEFAIL3,
    "USB klvesnice zatm nejsou pln podporovny\r\n"},
    {STRING_FORMATTINGDISK,
    "Instalace formtuje disk"},
    {STRING_CHECKINGDISK,
    "Instalace kontroluje disk"},
    {STRING_FORMATDISK1,
    " Zformtovat oddl na souborov systm %S (rychle) "},
    {STRING_FORMATDISK2,
    " Zformtovat oddl na souborov systm %S "},
    {STRING_KEEPFORMAT,
    " Ponechat souasn souborov systm (bez zmny) "},
    {STRING_HDINFOPARTCREATE,
    "%I64u %s  Harddisk %lu  (Port=%hu, Bus=%hu, Id=%hu) na %wZ."},
    {STRING_HDDINFOUNK1,
    "%I64u %s  Harddisk %lu  (Port=%hu, Bus=%hu, Id=%hu)."},
    {STRING_HDDINFOUNK2,
    "   %c%c  Typ 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTDELETE,
    "na %I64u %s  Harddisk %lu  (Port=%hu, Bus=%hu, Id=%hu) na %wZ."},
    {STRING_HDDINFOUNK3,
    "na %I64u %s  Harddisk %lu  (Port=%hu, Bus=%hu, Id=%hu)."},
    {STRING_HDINFOPARTZEROED,
    "Harddisk %lu (%I64u %s), Port=%hu, Bus=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK4,
    "%c%c  Typ 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTEXISTS,
    "na harddisku %lu (%I64u %s), Port=%hu, Bus=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK5,
    "%c%c %c %sTyp %-3u%s                     %6lu %s"},
    {STRING_HDINFOPARTSELECT,
    "%6lu %s  Harddisk %lu  (Port=%hu, Bus=%hu, Id=%hu) na %S"},
    {STRING_HDDINFOUNK6,
    "%6lu %s  Harddisk %lu  (Port=%hu, Bus=%hu, Id=%hu)"},
    {STRING_NEWPARTITION,
    "Instalace vytvoila nov oddl na"},
    {STRING_UNPSPACE,
    "    %sMsto bez oddl%s               %6lu %s"},
    {STRING_MAXSIZE,
    "MB (max. %lu MB)"},
    {STRING_EXTENDED_PARTITION,
    "Rozen oddl"},
    {STRING_UNFORMATTED,
    "Nov (Nenaformtovan)"},
    {STRING_FORMATUNUSED,
    "Nepouit"},
    {STRING_FORMATUNKNOWN,
    "Neznm"},
    {STRING_KB,
    "KB"},
    {STRING_MB,
    "MB"},
    {STRING_GB,
    "GB"},
    {STRING_ADDKBLAYOUTS,
    "Pidvm rozloen klves"},
    {0, 0}
};
