/* Version definitions */
#undef NTDDI_VERSION
#define NTDDI_VERSION NTDDI_WIN10
#undef _WIN32_WINNT
#define _WIN32_WINNT _WIN32_WINNT_WIN10

#include <ntifs.h>
#include <ndk/ntndk.h>

#define C_ASSERT_FIELD(Type, Offset, MemberType, MemberName) \
    C_ASSERT(FIELD_OFFSET(Type, MemberName) == Offset); \
    C_ASSERT(FIELD_SIZE(Type, MemberName) == sizeof(MemberType));

/* KTHREAD */
C_ASSERT_FIELD(KTHREAD, 0x000, DISPATCHER_HEADER, Header)
C_ASSERT_FIELD(KTHREAD, 0x018, PVOID, SListFaultAddress)
C_ASSERT_FIELD(KTHREAD, 0x020, ULONG64, QuantumTarget)
C_ASSERT_FIELD(KTHREAD, 0x028, PVOID, InitialStack)
C_ASSERT_FIELD(KTHREAD, 0x030, PVOID, StackLimit)
C_ASSERT_FIELD(KTHREAD, 0x038, PVOID, StackBase)
C_ASSERT_FIELD(KTHREAD, 0x040, ULONG64, ThreadLock)
C_ASSERT_FIELD(KTHREAD, 0x048, ULONG64, CycleTime)
C_ASSERT_FIELD(KTHREAD, 0x050, ULONG, CurrentRunTime)
C_ASSERT_FIELD(KTHREAD, 0x054, ULONG, ExpectedRunTime)
C_ASSERT_FIELD(KTHREAD, 0x058, PVOID, KernelStack)
C_ASSERT_FIELD(KTHREAD, 0x060, PXSAVE_FORMAT, StateSaveArea)
C_ASSERT_FIELD(KTHREAD, 0x068, struct _KSCHEDULING_GROUP*, SchedulingGroup)
C_ASSERT_FIELD(KTHREAD, 0x070, KWAIT_STATUS_REGISTER, WaitRegister)
C_ASSERT_FIELD(KTHREAD, 0x071, UCHAR, Running)
C_ASSERT_FIELD(KTHREAD, 0x072, UCHAR[2], Alerted)
C_ASSERT_FIELD(KTHREAD, 0x074, LONG, MiscFlags)
C_ASSERT_FIELD(KTHREAD, 0x078, LONG, ThreadFlags)
C_ASSERT_FIELD(KTHREAD, 0x07C, UCHAR, Tag)
C_ASSERT_FIELD(KTHREAD, 0x07D, UCHAR, SystemHeteroCpuPolicy)
C_ASSERT_FIELD(KTHREAD, 0x080, ULONG, SystemCallNumber)
C_ASSERT_FIELD(KTHREAD, 0x084, ULONG, Spare1)
C_ASSERT_FIELD(KTHREAD, 0x088, PVOID, FirstArgument)
C_ASSERT_FIELD(KTHREAD, 0x090, PKTRAP_FRAME, TrapFrame)
C_ASSERT_FIELD(KTHREAD, 0x098, KAPC_STATE, ApcState)
C_ASSERT_FIELD(KTHREAD, 0x0C3, CHAR, Priority)
C_ASSERT_FIELD(KTHREAD, 0x0C4, ULONG, UserIdealProcessor)
C_ASSERT_FIELD(KTHREAD, 0x0C8, LONG64, WaitStatus)
C_ASSERT_FIELD(KTHREAD, 0x0D0, PKWAIT_BLOCK, WaitBlockList)
C_ASSERT_FIELD(KTHREAD, 0x0D8, LIST_ENTRY, WaitListEntry)
C_ASSERT_FIELD(KTHREAD, 0x0D8, SINGLE_LIST_ENTRY, SwapListEntry)
C_ASSERT_FIELD(KTHREAD, 0x0E8, PDISPATCHER_HEADER, Queue)
C_ASSERT_FIELD(KTHREAD, 0x0F0, PVOID, Teb)
C_ASSERT_FIELD(KTHREAD, 0x0F8, ULONG64, RelativeTimerBias)
C_ASSERT_FIELD(KTHREAD, 0x100, KTIMER, Timer)
C_ASSERT_FIELD(KTHREAD, 0x140, KWAIT_BLOCK[4], WaitBlock)
C_ASSERT_FIELD(KTHREAD, 0x154, ULONG, ContextSwitches)
C_ASSERT_FIELD(KTHREAD, 0x184, UCHAR, State)
C_ASSERT_FIELD(KTHREAD, 0x185, CHAR, Spare13)
C_ASSERT_FIELD(KTHREAD, 0x186, UCHAR, WaitIrql)
C_ASSERT_FIELD(KTHREAD, 0x187, CHAR, WaitMode)
C_ASSERT_FIELD(KTHREAD, 0x1B4, ULONG, WaitTime)
C_ASSERT_FIELD(KTHREAD, 0x1E4, SHORT, KernelApcDisable)
C_ASSERT_FIELD(KTHREAD, 0x1E6, SHORT, SpecialApcDisable)
C_ASSERT_FIELD(KTHREAD, 0x1E4, ULONG, CombinedApcDisable)
C_ASSERT_FIELD(KTHREAD, 0x168, PKTHREAD_COUNTERS, ThreadCounters)
C_ASSERT_FIELD(KTHREAD, 0x198, PXSTATE_SAVE, XStateSave)
C_ASSERT_FIELD(KTHREAD, 0x1C8, PVOID, Win32Thread)
C_ASSERT_FIELD(KTHREAD, 0x1F0, struct _UMS_CONTROL_BLOCK*, Ucb)
C_ASSERT_FIELD(KTHREAD, 0x1F8, struct _KUMS_CONTEXT_HEADER*, Uch)
C_ASSERT_FIELD(KTHREAD, 0x200, PVOID, TebMappedLowVa)
C_ASSERT_FIELD(KTHREAD, 0x208, LIST_ENTRY, QueueListEntry)
C_ASSERT_FIELD(KTHREAD, 0x218, ULONG, NextProcessor)
C_ASSERT_FIELD(KTHREAD, 0x21C, LONG, QueuePriority)
C_ASSERT_FIELD(KTHREAD, 0x220, PKPROCESS, Process)
C_ASSERT_FIELD(KTHREAD, 0x228, GROUP_AFFINITY, UserAffinity)
C_ASSERT_FIELD(KTHREAD, 0x232, CHAR, PreviousMode)
C_ASSERT_FIELD(KTHREAD, 0x233, CHAR, BasePriority)
C_ASSERT_FIELD(KTHREAD, 0x234, CHAR, PriorityDecrement)
C_ASSERT_FIELD(KTHREAD, 0x235, UCHAR, Preempted)
C_ASSERT_FIELD(KTHREAD, 0x236, UCHAR, AdjustReason)
C_ASSERT_FIELD(KTHREAD, 0x237, CHAR, AdjustIncrement)
C_ASSERT_FIELD(KTHREAD, 0x238, ULONG64, AffinityVersion)
C_ASSERT_FIELD(KTHREAD, 0x240, GROUP_AFFINITY, Affinity)
C_ASSERT_FIELD(KTHREAD, 0x24A, UCHAR, ApcStateIndex)
C_ASSERT_FIELD(KTHREAD, 0x24B, UCHAR, WaitBlockCount)
C_ASSERT_FIELD(KTHREAD, 0x24C, ULONG, IdealProcessor)
C_ASSERT_FIELD(KTHREAD, 0x250, ULONG64, NpxState)
C_ASSERT_FIELD(KTHREAD, 0x258, KAPC_STATE, SavedApcState)
C_ASSERT_FIELD(KTHREAD, 0x283, UCHAR, WaitReason)
C_ASSERT_FIELD(KTHREAD, 0x284, CHAR, SuspendCount)
C_ASSERT_FIELD(KTHREAD, 0x285, CHAR, Saturation)
C_ASSERT_FIELD(KTHREAD, 0x286, USHORT, SListFaultCount)
C_ASSERT_FIELD(KTHREAD, 0x288, KAPC, SchedulerApc)
C_ASSERT_FIELD(KTHREAD, 0x289, UCHAR, ResourceIndex)
C_ASSERT_FIELD(KTHREAD, 0x28B, UCHAR, QuantumReset)
C_ASSERT_FIELD(KTHREAD, 0x28C, ULONG, KernelTime)
C_ASSERT_FIELD(KTHREAD, 0x2C8, PKPRCB, WaitPrcb)
C_ASSERT_FIELD(KTHREAD, 0x2D0, PVOID, LegoData)
C_ASSERT_FIELD(KTHREAD, 0x2DB, UCHAR, CallbackNestingLevel)
C_ASSERT_FIELD(KTHREAD, 0x2DC, ULONG, UserTime)
C_ASSERT_FIELD(KTHREAD, 0x2E0, KEVENT, SuspendEvent)
C_ASSERT_FIELD(KTHREAD, 0x2F8, LIST_ENTRY, ThreadListEntry)
C_ASSERT_FIELD(KTHREAD, 0x308, LIST_ENTRY, MutantListHead)
C_ASSERT_FIELD(KTHREAD, 0x318, UCHAR, AbEntrySummary)
C_ASSERT_FIELD(KTHREAD, 0x319, UCHAR, AbWaitEntryCount)
C_ASSERT_FIELD(KTHREAD, 0x31A, USHORT, Spare20)
C_ASSERT_FIELD(KTHREAD, 0x31C, ULONG, SecureThreadCookie)
C_ASSERT_FIELD(KTHREAD, 0x320, KLOCK_ENTRY[6], LockEntries)
C_ASSERT_FIELD(KTHREAD, 0x560, SINGLE_LIST_ENTRY, PropagateBoostsEntry)
C_ASSERT_FIELD(KTHREAD, 0x568, SINGLE_LIST_ENTRY, IoSelfBoostsEntry)
C_ASSERT_FIELD(KTHREAD, 0x570, UCHAR[16], PriorityFloorCounts)
C_ASSERT_FIELD(KTHREAD, 0x580, ULONG, PriorityFloorSummary)
C_ASSERT_FIELD(KTHREAD, 0x584, LONG, AbCompletedIoBoostCount)
C_ASSERT_FIELD(KTHREAD, 0x588, SHORT, KeReferenceCount)
C_ASSERT_FIELD(KTHREAD, 0x58A, UCHAR, AbOrphanedEntrySummary)
C_ASSERT_FIELD(KTHREAD, 0x58B, UCHAR, AbOwnedEntryCount)
C_ASSERT_FIELD(KTHREAD, 0x58C, ULONG, ForegroundLossTime)
C_ASSERT_FIELD(KTHREAD, 0x590, LIST_ENTRY, GlobalForegroundListEntry)
C_ASSERT_FIELD(KTHREAD, 0x590, SINGLE_LIST_ENTRY, ForegroundDpcStackListEntry)
C_ASSERT_FIELD(KTHREAD, 0x598, ULONG64, InGlobalForegroundList)
C_ASSERT_FIELD(KTHREAD, 0x5A0, LONG64, ReadOperationCount)
C_ASSERT_FIELD(KTHREAD, 0x5A8, LONG64, WriteOperationCount)
C_ASSERT_FIELD(KTHREAD, 0x5B0, LONG64, OtherOperationCount)
C_ASSERT_FIELD(KTHREAD, 0x5B8, LONG64, ReadTransferCount)
C_ASSERT_FIELD(KTHREAD, 0x5C0, LONG64, WriteTransferCount)
C_ASSERT_FIELD(KTHREAD, 0x5C8, LONG64, OtherTransferCount)
C_ASSERT_FIELD(KTHREAD, 0x5D0, struct _KSCB*, QueuedScb)

/* TEB */
C_ASSERT_FIELD(TEB, 0x000, NT_TIB, NtTib)
C_ASSERT_FIELD(TEB, 0x038, PVOID, EnvironmentPointer)
C_ASSERT_FIELD(TEB, 0x040, CLIENT_ID, ClientId)
C_ASSERT_FIELD(TEB, 0x050, PVOID, ActiveRpcHandle)
C_ASSERT_FIELD(TEB, 0x058, PVOID, ThreadLocalStoragePointer)
C_ASSERT_FIELD(TEB, 0x060, PPEB, ProcessEnvironmentBlock)
C_ASSERT_FIELD(TEB, 0x068, ULONG, LastErrorValue)
C_ASSERT_FIELD(TEB, 0x06C, ULONG, CountOfOwnedCriticalSections)
C_ASSERT_FIELD(TEB, 0x070, PVOID, CsrClientThread)
C_ASSERT_FIELD(TEB, 0x078, PVOID, Win32ThreadInfo)
C_ASSERT_FIELD(TEB, 0x080, ULONG[26], User32Reserved)
C_ASSERT_FIELD(TEB, 0x0E8, ULONG[5], UserReserved)
C_ASSERT_FIELD(TEB, 0x100, PVOID, WOW32Reserved)
C_ASSERT_FIELD(TEB, 0x108, ULONG, CurrentLocale)
C_ASSERT_FIELD(TEB, 0x10C, ULONG, FpSoftwareStatusRegister)
C_ASSERT_FIELD(TEB, 0x110, PVOID[16], ReservedForDebuggerInstrumentation)
//C_ASSERT_FIELD(TEB, 0x190, PVOID[32], SystemReserved1)
//C_ASSERT_FIELD(TEB, 0x290, ACTIVATION_CONTEXT_STACK, _ActivationStack)
//C_ASSERT_FIELD(TEB, 0x2B8, UCHAR[8], WorkingOnBehalfTicket)
C_ASSERT_FIELD(TEB, 0x2C0, LONG, ExceptionCode)
C_ASSERT_FIELD(TEB, 0x2C4, UCHAR[4], Padding0)
C_ASSERT_FIELD(TEB, 0x2C8, PACTIVATION_CONTEXT_STACK, ActivationContextStackPointer)
C_ASSERT_FIELD(TEB, 0x2D0, ULONG64, InstrumentationCallbackSp)
C_ASSERT_FIELD(TEB, 0x2D8, ULONG64, InstrumentationCallbackPreviousPc)
C_ASSERT_FIELD(TEB, 0x2E0, ULONG64, InstrumentationCallbackPreviousSp)
C_ASSERT_FIELD(TEB, 0x2E8, ULONG, TxFsContext)
C_ASSERT_FIELD(TEB, 0x2EC, UCHAR, InstrumentationCallbackDisabled)
C_ASSERT_FIELD(TEB, 0x2ED, UCHAR[3], Padding1)
C_ASSERT_FIELD(TEB, 0x2F0, GDI_TEB_BATCH, GdiTebBatch)
C_ASSERT_FIELD(TEB, 0x7D8, CLIENT_ID, RealClientId)
C_ASSERT_FIELD(TEB, 0x7E8, PVOID, GdiCachedProcessHandle)
C_ASSERT_FIELD(TEB, 0x7F0, ULONG, GdiClientPID)
C_ASSERT_FIELD(TEB, 0x7F4, ULONG, GdiClientTID)
C_ASSERT_FIELD(TEB, 0x7F8, PVOID, GdiThreadLocalInfo)
C_ASSERT_FIELD(TEB, 0x800, ULONG64[62], Win32ClientInfo)
C_ASSERT_FIELD(TEB, 0x9F0, PVOID[233], glDispatchTable)
C_ASSERT_FIELD(TEB, 0x1138, ULONG64[29], glReserved1)
C_ASSERT_FIELD(TEB, 0x1220, PVOID, glReserved2)
C_ASSERT_FIELD(TEB, 0x1228, PVOID, glSectionInfo)
C_ASSERT_FIELD(TEB, 0x1230, PVOID, glSection)
C_ASSERT_FIELD(TEB, 0x1238, PVOID, glTable)
C_ASSERT_FIELD(TEB, 0x1240, PVOID, glCurrentRC)
C_ASSERT_FIELD(TEB, 0x1248, PVOID, glContext)
C_ASSERT_FIELD(TEB, 0x1250, ULONG, LastStatusValue)
C_ASSERT_FIELD(TEB, 0x1254, UCHAR[4], Padding2)
C_ASSERT_FIELD(TEB, 0x1258, UNICODE_STRING, StaticUnicodeString)
C_ASSERT_FIELD(TEB, 0x1268, WCHAR[261], StaticUnicodeBuffer)
C_ASSERT_FIELD(TEB, 0x1472, UCHAR[6], Padding3)
C_ASSERT_FIELD(TEB, 0x1478, PVOID, DeallocationStack)
C_ASSERT_FIELD(TEB, 0x1480, PVOID[64], TlsSlots)
C_ASSERT_FIELD(TEB, 0x1680, LIST_ENTRY, TlsLinks)
C_ASSERT_FIELD(TEB, 0x1690, PVOID, Vdm)
C_ASSERT_FIELD(TEB, 0x1698, PVOID, ReservedForNtRpc)
C_ASSERT_FIELD(TEB, 0x16A0, PVOID[2], DbgSsReserved)
C_ASSERT_FIELD(TEB, 0x16B0, ULONG, HardErrorMode)
C_ASSERT_FIELD(TEB, 0x16B4, UCHAR[4], Padding4)
C_ASSERT_FIELD(TEB, 0x16B8, PVOID[11], Instrumentation)
C_ASSERT_FIELD(TEB, 0x1710, GUID, ActivityId)
C_ASSERT_FIELD(TEB, 0x1720, PVOID, SubProcessTag)
C_ASSERT_FIELD(TEB, 0x1728, PVOID, PerflibData)
C_ASSERT_FIELD(TEB, 0x1730, PVOID, EtwTraceData)
C_ASSERT_FIELD(TEB, 0x1738, PVOID, WinSockData)
C_ASSERT_FIELD(TEB, 0x1740, ULONG, GdiBatchCount)
C_ASSERT_FIELD(TEB, 0x1744, PROCESSOR_NUMBER, CurrentIdealProcessor)
C_ASSERT_FIELD(TEB, 0x1744, ULONG, IdealProcessorValue)
C_ASSERT_FIELD(TEB, 0x1744, UCHAR, ReservedPad0)
C_ASSERT_FIELD(TEB, 0x1745, UCHAR, ReservedPad1)
C_ASSERT_FIELD(TEB, 0x1746, UCHAR, ReservedPad2)
C_ASSERT_FIELD(TEB, 0x1747, UCHAR, IdealProcessor)
C_ASSERT_FIELD(TEB, 0x1748, ULONG, GuaranteedStackBytes)
C_ASSERT_FIELD(TEB, 0x174C, UCHAR[4], Padding5)
C_ASSERT_FIELD(TEB, 0x1750, PVOID, ReservedForPerf)
C_ASSERT_FIELD(TEB, 0x1758, PVOID, ReservedForOle)
C_ASSERT_FIELD(TEB, 0x1760, ULONG, WaitingOnLoaderLock)
C_ASSERT_FIELD(TEB, 0x1764, UCHAR[4], Padding6)
C_ASSERT_FIELD(TEB, 0x1768, PVOID, SavedPriorityState)
C_ASSERT_FIELD(TEB, 0x1770, ULONG64, ReservedForCodeCoverage)
C_ASSERT_FIELD(TEB, 0x1778, PVOID, ThreadPoolData)
C_ASSERT_FIELD(TEB, 0x1780, PVOID*, TlsExpansionSlots)
C_ASSERT_FIELD(TEB, 0x1788, PVOID, DeallocationBStore)
C_ASSERT_FIELD(TEB, 0x1790, PVOID, BStoreLimit)
C_ASSERT_FIELD(TEB, 0x1798, ULONG, MuiGeneration)
C_ASSERT_FIELD(TEB, 0x179C, ULONG, IsImpersonating)
C_ASSERT_FIELD(TEB, 0x17A0, PVOID, NlsCache)
C_ASSERT_FIELD(TEB, 0x17A8, PVOID, pShimData)
C_ASSERT_FIELD(TEB, 0x17B0, USHORT, HeapVirtualAffinity)
C_ASSERT_FIELD(TEB, 0x17B2, USHORT, LowFragHeapDataSlot)
C_ASSERT_FIELD(TEB, 0x17B4, UCHAR[4], Padding7)
C_ASSERT_FIELD(TEB, 0x17B8, PVOID, CurrentTransactionHandle)
C_ASSERT_FIELD(TEB, 0x17C0, PTEB_ACTIVE_FRAME, ActiveFrame)
C_ASSERT_FIELD(TEB, 0x17C8, PVOID, FlsData)
C_ASSERT_FIELD(TEB, 0x17D0, PVOID, PreferredLanguages)
C_ASSERT_FIELD(TEB, 0x17D8, PVOID, UserPrefLanguages)
C_ASSERT_FIELD(TEB, 0x17E0, PVOID, MergedPrefLanguages)
C_ASSERT_FIELD(TEB, 0x17E8, ULONG, MuiImpersonation)
C_ASSERT_FIELD(TEB, 0x17EC, USHORT, CrossTebFlags)
C_ASSERT_FIELD(TEB, 0x17EE, USHORT, SameTebFlags)
C_ASSERT_FIELD(TEB, 0x17F0, PVOID, TxnScopeEnterCallback)
C_ASSERT_FIELD(TEB, 0x17F8, PVOID, TxnScopeExitCallback)
C_ASSERT_FIELD(TEB, 0x1800, PVOID, TxnScopeContext)
C_ASSERT_FIELD(TEB, 0x1808, ULONG, LockCount)
C_ASSERT_FIELD(TEB, 0x180C, LONG, WowTebOffset)
C_ASSERT_FIELD(TEB, 0x1810, PVOID, ResourceRetValue)
C_ASSERT_FIELD(TEB, 0x1818, PVOID, ReservedForWdf)
C_ASSERT_FIELD(TEB, 0x1820, ULONG64, ReservedForCrt)
C_ASSERT_FIELD(TEB, 0x1828, GUID, EffectiveContainerId)

/* TEB32 */
C_ASSERT_FIELD(TEB32, 0x000, NT_TIB32, NtTib)
C_ASSERT_FIELD(TEB32, 0x01c, ULONG, EnvironmentPointer)
C_ASSERT_FIELD(TEB32, 0x020, CLIENT_ID32, ClientId)
C_ASSERT_FIELD(TEB32, 0x028, ULONG, ActiveRpcHandle)
C_ASSERT_FIELD(TEB32, 0x02c, ULONG, ThreadLocalStoragePointer)
C_ASSERT_FIELD(TEB32, 0x030, ULONG, ProcessEnvironmentBlock)
C_ASSERT_FIELD(TEB32, 0x034, ULONG, LastErrorValue)
C_ASSERT_FIELD(TEB32, 0x038, ULONG, CountOfOwnedCriticalSections)
C_ASSERT_FIELD(TEB32, 0x03c, ULONG, CsrClientThread)
C_ASSERT_FIELD(TEB32, 0x040, ULONG, Win32ThreadInfo)
C_ASSERT_FIELD(TEB32, 0x044, ULONG[26], User32Reserved)
C_ASSERT_FIELD(TEB32, 0x0ac, ULONG[5], UserReserved)
C_ASSERT_FIELD(TEB32, 0x0c0, ULONG, WOW32Reserved)
C_ASSERT_FIELD(TEB32, 0x0c4, ULONG, CurrentLocale)
C_ASSERT_FIELD(TEB32, 0x0c8, ULONG, FpSoftwareStatusRegister)
C_ASSERT_FIELD(TEB32, 0x0CC, ULONG[16], ReservedForDebuggerInstrumentation)
//C_ASSERT_FIELD(TEB32, 0x10c, ULONG[30], SystemReserved1)
//C_ASSERT_FIELD(TEB32, 0x184, ACTIVATION_CONTEXT_STACK32, _ActivationStack)
//C_ASSERT_FIELD(TEB32, 0x19C, UCHAR[8], WorkingOnBehalfTicket)
C_ASSERT_FIELD(TEB32, 0x1a4, LONG, ExceptionCode)
C_ASSERT_FIELD(TEB32, 0x1a8, ULONG, ActivationContextStackPointer)
C_ASSERT_FIELD(TEB32, 0x1AC, ULONG, InstrumentationCallbackSp)
C_ASSERT_FIELD(TEB32, 0x1B0, ULONG, InstrumentationCallbackPreviousPc)
C_ASSERT_FIELD(TEB32, 0x1B4, ULONG, InstrumentationCallbackPreviousSp)
C_ASSERT_FIELD(TEB32, 0x1B8, UCHAR, InstrumentationCallbackDisabled)
C_ASSERT_FIELD(TEB32, 0x1b9, UCHAR[23], SpareBytes)
C_ASSERT_FIELD(TEB32, 0x1d0, ULONG, TxFsContext)
C_ASSERT_FIELD(TEB32, 0x1d4, GDI_TEB_BATCH32, GdiTebBatch)
C_ASSERT_FIELD(TEB32, 0x6b4, CLIENT_ID32, RealClientId)
C_ASSERT_FIELD(TEB32, 0x6bc, ULONG, GdiCachedProcessHandle)
C_ASSERT_FIELD(TEB32, 0x6c0, ULONG, GdiClientPID)
C_ASSERT_FIELD(TEB32, 0x6c4, ULONG, GdiClientTID)
C_ASSERT_FIELD(TEB32, 0x6c8, ULONG, GdiThreadLocalInfo)
C_ASSERT_FIELD(TEB32, 0x6cc, ULONG[62], Win32ClientInfo)
C_ASSERT_FIELD(TEB32, 0x7c4, ULONG[233], glDispatchTable)
C_ASSERT_FIELD(TEB32, 0xb68, ULONG[29], glReserved1)
C_ASSERT_FIELD(TEB32, 0xbdc, ULONG, glReserved2)
C_ASSERT_FIELD(TEB32, 0xbe0, ULONG, glSectionInfo)
C_ASSERT_FIELD(TEB32, 0xbe4, ULONG, glSection)
C_ASSERT_FIELD(TEB32, 0xbe8, ULONG, glTable)
C_ASSERT_FIELD(TEB32, 0xbec, ULONG, glCurrentRC)
C_ASSERT_FIELD(TEB32, 0xbf0, ULONG, glContext)
C_ASSERT_FIELD(TEB32, 0xbf4, ULONG, LastStatusValue)
C_ASSERT_FIELD(TEB32, 0xbf8, STRING32, StaticUnicodeString)
C_ASSERT_FIELD(TEB32, 0xc00, WCHAR[261], StaticUnicodeBuffer)
C_ASSERT_FIELD(TEB32, 0xe0c, ULONG, DeallocationStack)
C_ASSERT_FIELD(TEB32, 0xe10, ULONG[64], TlsSlots)
C_ASSERT_FIELD(TEB32, 0xf10, LIST_ENTRY32, TlsLinks)
C_ASSERT_FIELD(TEB32, 0xf18, ULONG, Vdm)
C_ASSERT_FIELD(TEB32, 0xf1c, ULONG, ReservedForNtRpc)
C_ASSERT_FIELD(TEB32, 0xf20, ULONG[2], DbgSsReserved)
C_ASSERT_FIELD(TEB32, 0xf28, ULONG, HardErrorMode)
C_ASSERT_FIELD(TEB32, 0xf2c, ULONG[9], Instrumentation)
C_ASSERT_FIELD(TEB32, 0xf50, GUID, ActivityId)
C_ASSERT_FIELD(TEB32, 0xf60, ULONG, SubProcessTag)
C_ASSERT_FIELD(TEB32, 0xf64, ULONG, PerflibData)
C_ASSERT_FIELD(TEB32, 0xf68, ULONG, EtwTraceData)
C_ASSERT_FIELD(TEB32, 0xf6c, ULONG, WinSockData)
C_ASSERT_FIELD(TEB32, 0xf70, ULONG, GdiBatchCount)
C_ASSERT_FIELD(TEB32, 0xf74, PROCESSOR_NUMBER, CurrentIdealProcessor)
C_ASSERT_FIELD(TEB32, 0xf74, ULONG, IdealProcessorValue)
C_ASSERT_FIELD(TEB32, 0xf74, UCHAR, ReservedPad0)
C_ASSERT_FIELD(TEB32, 0xf75, UCHAR, ReservedPad1)
C_ASSERT_FIELD(TEB32, 0xf76, UCHAR, ReservedPad2)
C_ASSERT_FIELD(TEB32, 0xf77, UCHAR, IdealProcessor)
C_ASSERT_FIELD(TEB32, 0xf78, ULONG, GuaranteedStackBytes)
C_ASSERT_FIELD(TEB32, 0xf7c, ULONG, ReservedForPerf)
C_ASSERT_FIELD(TEB32, 0xf80, ULONG, ReservedForOle)
C_ASSERT_FIELD(TEB32, 0xf84, ULONG, WaitingOnLoaderLock)
C_ASSERT_FIELD(TEB32, 0xf88, ULONG, SavedPriorityState)
C_ASSERT_FIELD(TEB32, 0xf8c, ULONG, ReservedForCodeCoverage)
C_ASSERT_FIELD(TEB32, 0xf90, ULONG, ThreadPoolData)
C_ASSERT_FIELD(TEB32, 0xf94, ULONG, TlsExpansionSlots)
C_ASSERT_FIELD(TEB32, 0xf98, ULONG, MuiGeneration)
C_ASSERT_FIELD(TEB32, 0xf9c, ULONG, IsImpersonating)
C_ASSERT_FIELD(TEB32, 0xfa0, ULONG, NlsCache)
C_ASSERT_FIELD(TEB32, 0xfa4, ULONG, pShimData)
C_ASSERT_FIELD(TEB32, 0xfa8, USHORT, HeapVirtualAffinity)
C_ASSERT_FIELD(TEB32, 0xFAA, USHORT, LowFragHeapDataSlot)
C_ASSERT_FIELD(TEB32, 0xfac, ULONG, CurrentTransactionHandle)
C_ASSERT_FIELD(TEB32, 0xfb0, ULONG, ActiveFrame)
C_ASSERT_FIELD(TEB32, 0xfb4, ULONG, FlsData)
C_ASSERT_FIELD(TEB32, 0xfb8, ULONG, PreferredLanguages)
C_ASSERT_FIELD(TEB32, 0xfbc, ULONG, UserPrefLanguages)
C_ASSERT_FIELD(TEB32, 0xfc0, ULONG, MergedPrefLanguages)
C_ASSERT_FIELD(TEB32, 0xfc4, ULONG, MuiImpersonation)
C_ASSERT_FIELD(TEB32, 0xfc8, USHORT, CrossTebFlags)
C_ASSERT_FIELD(TEB32, 0xfca, USHORT, SameTebFlags)
C_ASSERT_FIELD(TEB32, 0xfcc, ULONG, TxnScopeEnterCallback)
C_ASSERT_FIELD(TEB32, 0xfd0, ULONG, TxnScopeExitCallback)
C_ASSERT_FIELD(TEB32, 0xfd4, ULONG, TxnScopeContext)
C_ASSERT_FIELD(TEB32, 0xfd8, ULONG, LockCount)
C_ASSERT_FIELD(TEB32, 0xfdc, ULONG, WowTebOffset)
C_ASSERT_FIELD(TEB32, 0xfe0, ULONG, ResourceRetValue)
C_ASSERT_FIELD(TEB32, 0xFE4, ULONG, ReservedForWdf)
C_ASSERT_FIELD(TEB32, 0xFE8, ULONG64, ReservedForCrt)
C_ASSERT_FIELD(TEB32, 0xFF0, GUID, EffectiveContainerId)
