/* TRANSLATOR: 2013-2015 Erdem Ersoy (eersoy93) (erdemersoy@live.com) */

#pragma once

MUI_LAYOUTS trTRLayouts[] =
{
    { L"041F", L"0000041F" },
    { L"041F", L"0001041f" },
    { L"0409", L"00000409" },
    { NULL, NULL }
};

static MUI_ENTRY trTRLanguagePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Dil Seimi",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Ltfen kurulum sreci iin kullanlacak dili seiniz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Ardndan Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Bu dil, kurulacak dizgenin n tanml dili olacaktr.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRWelcomePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ReactOS Kur'a ho geldiniz.",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        11,
        "Kurulumun bu blm, ReactOS letim Dizgesi'ni bilgisayarnza",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "oaltr ve kurulumun ikinci blmn anklar.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  ReactOS'u kurmak iin Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  ReactOS'u onarmak vey ykseltmek iin R'ye basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  ReactOS Ruhsatlama Istlahlar ve artlar'n grntlemek iin L'ye basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  ReactOS'u kurmadan kmak iin F3'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Daha ok bilgi iin ltfen uraynz:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "http://www.reactos.org",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        0,
        0,
        "Giri = Srdr  R = Onar vey Ykselt  L = Ruhsat F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRIntroPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ReactOS Kur, bir n gelime evresindedir. Daha tmyle kullanl",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "bir kurulum uygulamasnn tm ilevlerini desteklemez.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Aadaki kstlamalar uygulanr:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "- Kur, yalnzca FAT ktk dizgelerini destekler.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "- Ktk dizgesi denetimi daha bitirilmemitir.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        23,
        "\x07  ReactOS'u kurmak iin Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "\x07  ReactOS'u kurmadan kmak iin F3'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRLicensePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        6,
        "Ruhsatlama:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        8,
        "ReactOS Dizgesi, GNU GPL'yle X11, BSD ve GNU LPGL",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        9,
        "ruhsatlar gibi baka uygun ruhsatlardan kod ieren",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "ksmlarn artlar altnda ruhsatlanmtr.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "Bu yzden ReactOS dizgesinin ksm olan tm yazlmlar, korunan",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "zgn ruhsatyla birlikte GNU GPL altnda yaymlanr.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "Bu yazlm, yerli ve uluslararas yasa uygulanabilir kullanm",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "zerine hibir gvence ve kstlamayla gelmez. ReactOS'un",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        " ruhsatlanmas yalnzca nc yanlara datmay kapsar.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "Eer birtakm nedenlerden dolay ReactOS ile GNU Umm",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "Kamu Ruhsat'nn bir kopyasn almadysanz ltfen uraynz:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "http://www.gnu.org/licenses/licenses.html",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        21,
        "Gvence:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        23,
        "Bu zgr yazlmdr, oaltma artlar iin kaynaa baknz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "Burada hibir gvence YOKTUR, SATILABLRLK vey",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "BELRL BR AMACA UYGUNLUK iin bile.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Geri Dn",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRDevicePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Aadaki dizelge imdiki aygt ayarlarn gsterir.",
        TEXT_STYLE_NORMAL
    },
    {
        24,
        11,
        "Bilgisayar:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        12,
        "Grnt:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        13,
        "Dme Takm:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        14,
        "Dme Takm Dzeni:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        16,
        "Dorula:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        25,
        16,
        "Bu aygt ayarlarn dorula.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        19,
        "Aygt ayarlarn, bir seenek semek iin Yukar vey Aa dmelerine",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        20,
        "basarak deitirebilirsiniz. Sonra baka ayarlar semek iin Giri",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        21,
        "dmesine basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Tm ayarlar uygun olduunda ""Bu aygt ayarlarn dorula.""y",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "seiniz ve Giri dmesine basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRRepairPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ReactOS Kur, bir n gelime evresindedir. Daha tmyle kullanl",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "bir kurulum uygulamasnn tm ilevlerini desteklemez.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Onarma ilevleri daha bitirilmemitir.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  letim dizgesini ykseltmek iin U'ya basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Kurtarma Konsolu iin R'ye basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Ana sayfaya geri dnmek iin k'a basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Bilgisayarnz yeniden balatmak iin Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "k = Ana Sayfa  U = Ykselt  R = Kurtarma  Giri = Yeniden Balat",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRComputerPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Kurulum yaplacak bilgisayarn trn semek isteyebilirsiniz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  stenen bilgisyar trn semek iin Yukar'ya vey Aa'ya basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Ardndan Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Bilgisayar trn deitirmeden bir nceki sayfaya",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   dnmek iin k dmesine basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   k = ptal   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRFlushPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Dizge, imdi diskinize saklanm tm veriyi doruluyor.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Bu bir dakka srebilir.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "Bittiinde bilgisayarnz kendiliinden yeniden balayacaktr.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "n bellek arnyor...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRQuitPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "ReactOS, tmyle kurulmad.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "A: srcsnden disketi ve tm CD srclerinden",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "CD-ROM'lar kartnz.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Bilgisayarnz yeniden balatmak iin Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Ltfen bekleyiniz...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG,
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRDisplayPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Kurulum yaplacak grntnn trn semek isteyebilirsiniz.",
        TEXT_STYLE_NORMAL
    },
    {   8,
        10,
        "\x07  stenen grnt trn semek iin Yukar'ya vey Aa'ya basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Ardndan Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Grnt trn deitirmeden bir nceki sayfaya",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   dnmek iin k dmesine basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   k = ptal   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRSuccessPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "ReactOS'un ana bileenleri baarl olarak kuruldu.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "A: srcsnden disketi ve tm CD srclerinden",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "CD-ROM'lar kartnz.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Bilgisayarnz yeniden balatmak iin Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Bilgisayar Yeniden Balat",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRBootPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Kur, bilgisayarnzn sbit diskine n ykleyiciyi kuramad.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Ltfen A: srcsne biimlendirilmi bir disket taknz",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "ve Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }

};

static MUI_ENTRY trTRSelectPartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Aadaki dizelge, var olan blmleri ve yeni blmler iin",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "kullanlmayan disk boluunu gsterir.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "\x07  Bir dizelge girdisini semek iin Yukar'ya vey Aa'ya basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Seili blme ReactOS'u yklemek iin Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Bir ana blm oluturmak iin P'ye basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Bir geniletilmi blm oluturmak iin E'ye basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Mantklk bir blm oluturmak iin L'ye basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Var olan bir blm silmek iin D'ye basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Ltfen bekleyiniz...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRConfirmDeleteSystemPartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Kur'a dizge blmn silmeyi sordunuz.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Dizge blmleri; tanlama izlenceleri, donanm yaplandrma",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "izlenceleri, ReactOS gibi bir iletim dizgesini balatmak iin izlenceler",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "vey donanm reticisi eliyle salanan baka izlenceler ierebilir.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Yalnzca blmde byle izlencelerin olmadndan emin olduunuzda ya da",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "onlar silmek istediinizden emin olduunuzda bir dizge blmn siliniz.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "Blm sildiinizde ReactOS Kur'u bitirene dek bilgisayar sbit diskten",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        17,
        "n ykleyemeyebilirsiniz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "\x07  Dizge blmn silmek iin Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "Sonra blm silmeyi onaylamak iin yeniden sorulacaksnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "\x07  Bir nceki sayfaya dnmek iin k'a basnz. Blm silinmeyecek.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr  k = ptal",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRFormatPartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Blm Biimlendirme",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Kur, imdi blm biimlendirecek. Srdrmek iin Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        TEXT_STYLE_NORMAL
    }
};

static MUI_ENTRY trTRInstallDirectoryEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Kur, seili blme ReactOS ktklerini ykler. ReactOS'un",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "yklenmesini istediiniz bir dizin seiniz.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "nerilen dizini deitirmek iin, damgalar silmek iin Silme'ye basnz",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "ve ardndan ReactOS'un yklenmesini istediiniz dizini yaznz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRFileCopyEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        0,
        12,
        "ReactOS Kur, ReactOS kurulum dizininize ktkleri oaltrken",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        13,
        " ltfen bekleyiniz.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        14,
        "Bu, bitirmek iin birka dakka srebilir.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        50,
        0,
        "\xB3 Ltfen bekleyiniz...",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRBootLoaderEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Kur, n ykleyiciyi kuruyor.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "n ykleyiciyi sbit diskin zerine kur. (MBR ve VBR)",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "n ykleyiciyi sbit diskin zerine kur. (Yalnzca VBR)",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "n ykleyiciyi bir diskete kur.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "n ykleyici kurulumunu ge.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRKeyboardSettingsEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Kurulum yaplacak dme takmnn trn semek isteyebilirsiniz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  stenen dme takm trn semek iin Yukar'ya vey Aa'ya basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Ardndan Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Dme takm trn deitirmeden bir nceki sayfaya",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   dnmek iin k dmesine basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   k = ptal   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRLayoutSettingsEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Ltfen n tanml olarak kurulacak bir dzen seiniz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  stenen dme takm dzenini semek iin Yukar'ya vey Aa'ya basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Ardndan Giri'e basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Grnt trn deitirmeden bir nceki sayfaya",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   dnmek iin k dmesine basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Giri = Srdr   k = ptal   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY trTRPrepareCopyEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Kur, ReactOS ktklerini oaltmak iin bilgisayarnz anklyor.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Ktk oaltma dizelgesi oluturuluyor...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY trTRSelectFSEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        17,
        "Aadaki dizelgeden bir ktk dizgesi seiniz.",
        0
    },
    {
        8,
        19,
        "\x07  Bir ktk dizgesi semek iin Yukar'ya vey Aa'ya basnz.",
        0
    },
    {
        8,
        21,
        "\x07  Blm biimlendirmek iin Giri'e basnz.",
        0
    },
    {
        8,
        23,
        "\x07  Baka bir blm semek iin k'a basnz.",
        0
    },
    {
        0,
        0,
        "Giri = Srdr   k = ptal   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },

    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRDeletePartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Blm silmeyi setiniz.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "\x07  Blm silmek iin D'ye basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        11,
        19,
        "UYARI: Bu blmdeki tm veriler yitirilecektir!",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  ptal etmek iin k'a basnz.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "D = Blm Sil   k = ptal   F3 = k",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY trTRRegistryEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " Kur ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Kur, dizge yaplandrmasn imdikiletiriyor.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Deer ynlar oluturuluyor...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

MUI_ERROR trTRErrorEntries[] =
{
    {
        // NOT_AN_ERROR
        "Baarl\n"
    },
    {
        //ERROR_NOT_INSTALLED
        "ReactOS, bilgisayara tmyle kurulmad. Eer imdi\n"
        "Kur'dan karsanz ReactOS'u kurmak iin Kur'u\n"
        "yeniden altrmaya gereksinim duyacaksnz.\n"
        "\n"
        "  \x07  Kur'u srdrmek iin Giri'e basnz.\n"
        "  \x07  Kur'dan kmak iin F3'e basnz.",
        "F3 = k  Giri = Srdr"
    },
    {
        //ERROR_NO_HDD
        "Kur, bir sbit disk bulamad.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_NO_SOURCE_DRIVE
        "Kur, kaynak srcy bulamad.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_LOAD_TXTSETUPSIF
        "Kur, TXTSETUP.SIF ktn yklemede baarsz oldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_CORRUPT_TXTSETUPSIF
        "Kur, bozuk bir TXTSETUP.SIF buldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_SIGNATURE_TXTSETUPSIF,
        "Kur, TXTSETUP.SIF'ta geersiz bir im buldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_DRIVE_INFORMATION
        "Kur, dizge src bilgisini alamad.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_WRITE_BOOT,
        "Kur, dizge blmne FAT n ykleme kodunu kuramad.",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_LOAD_COMPUTER,
        "Kur, bilgisayar tr dizelgesini yklemede baarsz oldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_LOAD_DISPLAY,
        "Kur, grnt ayarlar dizelgesini yklemede baarsz oldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_LOAD_KEYBOARD,
        "Kur, dme takm tr dizelgesini yklemede baarsz oldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_LOAD_KBLAYOUT,
        "Kur, dme takm dzeni dizelgesini yklemede baarsz oldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_WARN_PARTITION,
        "Kur, dzgn ynetilemeyen bir uyumsuz blm tablosu ieren en az\n"
        "bir sbit disk buldu!\n"
        "\n"         
        "Blmleri oluturmak vey silmek blm tablosunu yok edebilir.\n"
        "\n"
        "  \x07  Kur'dan kmak iin F3'e basnz.\n"
        "  \x07  Srdrmek iin Giri'e basnz.",
        "F3 = k   Giri = Srdr"
    },
    {
        //ERROR_NEW_PARTITION,
        "neden var olan bir blmn iine yeni\n"
        "bir blm oluturamazsnz!\n"
        "\n"
        "  * Srdrmek iin bir dmeye basnz.",
        NULL
    },
    {
        //ERROR_DELETE_SPACE,
        "Blmlenmemi disk boluunu silemezsiniz!\n"
        "\n"
        "  * Srdrmek iin bir dmeye basnz.",
        NULL
    },
    {
        //ERROR_INSTALL_BOOTCODE,
        "Kur, dizge blm zerinde FAT n ykleme kodunu kurmada baarsz oldu.",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_NO_FLOPPY,
        "A: srcsnde disk yok.",
        "Giri = Srdr"
    },
    {
        //ERROR_UPDATE_KBSETTINGS,
        "Kur, dme takm dzeni ayarlarn imdikiletirmede baarsz oldu.",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_UPDATE_DISPLAY_SETTINGS,
        "Kur, grnt deer ayarlarn imdikiletirmede baarsz oldu.",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_IMPORT_HIVE,
        "Kur, bir yn kt almada baarsz oldu.",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_FIND_REGISTRY
        "Kur, deer veri ktklerini bulmada baarsz oldu.",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_CREATE_HIVE,
        "Kur, deer ynlarn oluturmada baarsz oldu.",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_INITIALIZE_REGISTRY,
        "Kur, Deer Defteri'ni balatmada baarsz oldu.",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_INVALID_CABINET_INF,
        "Dolabn geerli yaplandrma kt yok.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_CABINET_MISSING,
        "Dolap bulunamad.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_CABINET_SCRIPT,
        "Dolabn kurulum betii yok.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_COPY_QUEUE,
        "Kur, ktk oaltma kuyruunu amada baarsz oldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_CREATE_DIR,
        "Kur, kurulum dizinlerini oluturmada baarsz oldu.",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_TXTSETUP_SECTION,
        "Kur, TXTSETUP.SIF'de ""Directories"" blmn\n"
        "bulmada baarsz oldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_CABINET_SECTION,
        "Kur, dolapta ""Directories"" blmn\n"
        "bulmada baarsz oldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_CREATE_INSTALL_DIR
        "Kur, kurulum dizinini oluturamad.",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_FIND_SETUPDATA,
        "Kur, TXTSETUP.SIF'de ""SetupData"" blmn\n"
        "bulmada baarsz oldu.\n",
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_WRITE_PTABLE,
        "Kur, blm tablolar yazmada baarsz oldu.\n"
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_ADDING_CODEPAGE,
        "Kur, Deer Defteri'ne kod sayfas eklemede baarsz oldu.\n"
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_UPDATE_LOCALESETTINGS,
        "Kur, dizge yerli ayrn yapamad.\n"
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_ADDING_KBLAYOUTS,
        "Kur, Deer Defteri'ne dme takm dzenleri eklemede baarsz oldu.\n"
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_UPDATE_GEOID,
        "Kur, corf kimlii ayarlayamad.\n"
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        //ERROR_DIRECTORY_NAME,
        "Geersiz dizin ad.\n"
        "\n"
        "  * Srdrmek iin bir dmeye basnz."
    },
    {
        //ERROR_INSUFFICIENT_PARTITION_SIZE,
        "Seili blm ReactOS'u kurmak iin yetecek lde byk deil.\n"
        "Kurulum blm en az %lu MB byklnde olmal.\n"
        "\n"
        "  * Srdrmek iin bir dmeye basnz.",
        NULL
    },
    {
        //ERROR_PARTITION_TABLE_FULL,
        "Blm tablosu dolu olduundan dolay bu diskin blm tablosunda yeni bir ana blm\n"
        "ya da yeni bir geniletilmi blm oluturamazsnz.\n"
        "\n"
        "  * Srdrmek iin bir dmeye basnz."
    },
    {
        //ERROR_ONLY_ONE_EXTENDED,
        "Bir diskte birden ok geniletilmi blm oluturamazsnz.\n"
        "\n"
        "  * Srdrmek iin bir dmeye basnz."
    },
    {
        //ERROR_FORMATTING_PARTITION,
        "Kur, blm biimlendiremez::\n"
        " %S\n"
        "\n"
        "Giri = Bilgisayar Yeniden Balat"
    },
    {
        NULL,
        NULL
    }
};

MUI_PAGE trTRPages[] =
{
    {
        LANGUAGE_PAGE,
        trTRLanguagePageEntries
    },
    {
        START_PAGE,
        trTRWelcomePageEntries
    },
    {
        INSTALL_INTRO_PAGE,
        trTRIntroPageEntries
    },
    {
        LICENSE_PAGE,
        trTRLicensePageEntries
    },
    {
        DEVICE_SETTINGS_PAGE,
        trTRDevicePageEntries
    },
    {
        REPAIR_INTRO_PAGE,
        trTRRepairPageEntries
    },
    {
        COMPUTER_SETTINGS_PAGE,
        trTRComputerPageEntries
    },
    {
        DISPLAY_SETTINGS_PAGE,
        trTRDisplayPageEntries
    },
    {
        FLUSH_PAGE,
        trTRFlushPageEntries
    },
    {
        SELECT_PARTITION_PAGE,
        trTRSelectPartitionEntries
    },
    {
        CONFIRM_DELETE_SYSTEM_PARTITION_PAGE,
        trTRConfirmDeleteSystemPartitionEntries
    },
    {
        SELECT_FILE_SYSTEM_PAGE,
        trTRSelectFSEntries
    },
    {
        FORMAT_PARTITION_PAGE,
        trTRFormatPartitionEntries
    },
    {
        DELETE_PARTITION_PAGE,
        trTRDeletePartitionEntries
    },
    {
        INSTALL_DIRECTORY_PAGE,
        trTRInstallDirectoryEntries
    },
    {
        PREPARE_COPY_PAGE,
        trTRPrepareCopyEntries
    },
    {
        FILE_COPY_PAGE,
        trTRFileCopyEntries
    },
    {
        KEYBOARD_SETTINGS_PAGE,
        trTRKeyboardSettingsEntries
    },
    {
        BOOT_LOADER_PAGE,
        trTRBootLoaderEntries
    },
    {
        LAYOUT_SETTINGS_PAGE,
        trTRLayoutSettingsEntries
    },
    {
        QUIT_PAGE,
        trTRQuitPageEntries
    },
    {
        SUCCESS_PAGE,
        trTRSuccessPageEntries
    },
    {
        BOOT_LOADER_FLOPPY_PAGE,
        trTRBootPageEntries
    },
    {
        REGISTRY_PAGE,
        trTRRegistryEntries
    },
    {
        -1,
        NULL
    }
};

MUI_STRING trTRStrings[] =
{
    {STRING_PLEASEWAIT,
    "   Ltfen bekleyiniz..."},
    {STRING_INSTALLCREATEPARTITION,
    "   Giri = Kur  P = Ana Blm Olutur  E = Geniletilmi Blm Olutur  F3 = k"},
    {STRING_INSTALLCREATELOGICAL,
    "   ENTER = Kur   L = Mantklk Blm Olutur   F3 = k"},
    {STRING_INSTALLDELETEPARTITION,
    "   Giri = Kur   D = Blm Sil   F3 = k"},
    {STRING_DELETEPARTITION,
    "   D = Blm Sil   F3 = k"},
    {STRING_PARTITIONSIZE,
    "Yeni blmn bykln giriniz:"},
    {STRING_CHOOSENEWPARTITION,
    "zerinde bir ana blm oluturmay setiniz:"},
    {STRING_CHOOSE_NEW_EXTENDED_PARTITION,
    "zerinde bir geniletilmi blm oluturmay setiniz:"},
    {STRING_CHOOSE_NEW_LOGICAL_PARTITION,
    "zerinde bir mantklk blm oluturmay setiniz:"},
    {STRING_HDDSIZE,
    "Ltfen yeni blmn bykln megaoklu olarak giriniz."},
    {STRING_CREATEPARTITION,
    "   Giri = Blm Olutur   k = ptal   F3 = k"},
    {STRING_PARTFORMAT,
    "Bu blm ileride biimlendirilecektir."},
    {STRING_NONFORMATTEDPART,
    "ReactOS'u yeni ya da biimlendirilmemi bir blme kurmay setiniz."},
    {STRING_NONFORMATTEDSYSTEMPART,
    "Dizge blm daha biimlendirilmemi."},
    {STRING_NONFORMATTEDOTHERPART,
    "Yeni blm daha biimlendirilmemi."},
    {STRING_INSTALLONPART,
    "Kur, ReactOS'u blm zerine kurar."},
    {STRING_CHECKINGPART,
    "Kur, imdi seili blm gzden geiriyor."},
    {STRING_CONTINUE,
    "Giri = Srdr"},
    {STRING_QUITCONTINUE,
    "F3 = k   Giri = Srdr"},
    {STRING_REBOOTCOMPUTER,
    "Giri = Bilgisayar Yeniden Balat"},
    {STRING_TXTSETUPFAILED,
    "Kur, TXTSETUP.SIF'de ""%S"" blmn\nbulmada baarsz oldu.\n"},
    {STRING_COPYING,
    "   Ktk oaltlyor: %S..."},
    {STRING_SETUPCOPYINGFILES,
    "Kur, ktkleri oaltyor..."},
    {STRING_REGHIVEUPDATE,
    "   Deer ynlar imdikiletiriliyor..."},
    {STRING_IMPORTFILE,
    "   Alnyor: %S..."},
    {STRING_DISPLAYETTINGSUPDATE,
    "   Grnt ayarlar deerleri imdikiletiriliyor..."},
    {STRING_LOCALESETTINGSUPDATE,
    "   Yerli ayarlar imdikiletiriliyor..."},
    {STRING_KEYBOARDSETTINGSUPDATE,
    "   Dme takm dzeni ayarlar imdikiletiriliyor..."},
    {STRING_CODEPAGEINFOUPDATE,
    "   Deer Defteri'ne kod sayfas bilgisi ekleniyor..."},
    {STRING_DONE,
    "   Bitti..."},
    {STRING_REBOOTCOMPUTER2,
    "   Giri = Bilgisayar Yeniden Balat"},
    {STRING_CONSOLEFAIL1,
    "Konsol alamyor.\r\n\r\n"},
    {STRING_CONSOLEFAIL2,
    "Bunun en bilinen nedeni, bir USB dme takm kullanlmasdr.\r\n"},
    {STRING_CONSOLEFAIL3,
    "USB dme takmlar daha tmyle desteklenmemektedir.\r\n"},
    {STRING_FORMATTINGDISK,
    "Kur, diskinizi biimlendiriyor."},
    {STRING_CHECKINGDISK,
    "Kur, diskinizi gzden geiriyor."},
    {STRING_FORMATDISK1,
    " Blm %S ktk dizgesiyle hzl biimlendir. "},
    {STRING_FORMATDISK2,
    " Blm %S ktk dizgesiyle biimlendir. "},
    {STRING_KEEPFORMAT,
    " imdiki ktk dizgesini koru. (Deiiklik yok.) "},
    {STRING_HDINFOPARTCREATE,
    "%I64u %s  Sbit Disk %lu  (Giri=%hu, Veriyolu=%hu, Kimlik=%hu), %wZ zerinde."},
    {STRING_HDDINFOUNK1,
    "%I64u %s  Sbit Disk %lu  (Giri=%hu, Veriyolu=%hu, Kimlik=%hu)."},
    {STRING_HDDINFOUNK2,
    "   %c%c  Tr  0x%02X    %I64u %s"},
    {STRING_HDINFOPARTDELETE,
    "zerinde: %I64u %s  Sbit Disk %lu  (Giri=%hu, Veriyolu=%hu, Kimlik=%hu), %wZ zerinde."},
    {STRING_HDDINFOUNK3,
    "zerinde: %I64u %s  Sbit Disk %lu  (Giri=%hu, Veriyolu=%hu, Kimlik=%hu)."},
    {STRING_HDINFOPARTZEROED,
    "Sbit Disk %lu (%I64u %s), Giri=%hu, Veriyolu=%hu, Kimlik=%hu (%wZ)."},
    {STRING_HDDINFOUNK4,
    "%c%c  Tr  0x%02X    %I64u %s"},
    {STRING_HDINFOPARTEXISTS,
    "zerinde: Sbit Disk %lu (%I64u %s), Giri=%hu, Veriyolu=%hu, Kimlik=%hu (%wZ)."},
    {STRING_HDDINFOUNK5,
    "%c%c %c %sTr  %-3u%s                      %6lu %s"},
    {STRING_HDINFOPARTSELECT,
    "%6lu %s  Sbit Disk %lu  (Giri=%hu, Veriyolu=%hu, Kimlik=%hu), %S zerinde"},
    {STRING_HDDINFOUNK6,
    "%6lu %s  Sbit Disk %lu  (Giri=%hu, Veriyolu=%hu, Kimlik=%hu)"},
    {STRING_NEWPARTITION,
    "Kur, zerinde bir yeni blm oluturdu:"},
    {STRING_UNPSPACE,
    "    %sKullanlmayan Boluk%s           %6lu %s"},
    {STRING_MAXSIZE,
    "MB (En ok %lu MB)"},
    {STRING_EXTENDED_PARTITION,
    "Geniletilmi Blm"},
    {STRING_UNFORMATTED,
    "Yeni (Biimlendirilmemi)"},
    {STRING_FORMATUNUSED,
    "Kullanlmayan"},
    {STRING_FORMATUNKNOWN,
    "Bilinmeyen"},
    {STRING_KB,
    "KB"},
    {STRING_MB,
    "MB"},
    {STRING_GB,
    "GB"},
    {STRING_ADDKBLAYOUTS,
    "Dme takm dzenleri ekleniyor..."},
    {0, 0}
};
