#ifndef _WINGDI_H
#define _WINGDI_H
#define _WINGDI_

#ifndef NOGDI

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable:4201)
#pragma warning(disable:4820)
#endif

/* Get/SetSystemPaletteUse() values */
#define SYSPAL_ERROR        0
#define SYSPAL_STATIC       1
#define SYSPAL_NOSTATIC     2
#define SYSPAL_NOSTATIC256  3

#define WINGDIAPI

#define NTM_NONNEGATIVE_AC  0x00010000
#define NTM_PS_OPENTYPE     0x00020000
#define NTM_TT_OPENTYPE     0x00040000
#define NTM_MULTIPLEMASTER  0x00080000
#define NTM_TYPE1           0x00100000
#define NTM_DSIG            0x00200000

#define AC_SRC_OVER 0
#define AC_SRC_ALPHA 1
#define BI_RGB 0
#define BI_RLE8 1
#define BI_RLE4 2
#define BI_BITFIELDS 3
#define BI_JPEG 4
#define BI_PNG 5
#define LF_FACESIZE	32
#define LF_FULLFACESIZE	64
#define CA_NEGATIVE	1
#define CA_LOG_FILTER	2
#define ILLUMINANT_DEVICE_DEFAULT	0
#define ILLUMINANT_A	1
#define ILLUMINANT_B	2
#define ILLUMINANT_C	3
#define ILLUMINANT_D50	4
#define ILLUMINANT_D55	5
#define ILLUMINANT_D65	6
#define ILLUMINANT_D75	7
#define ILLUMINANT_F2	8
#define ILLUMINANT_MAX_INDEX	ILLUMINANT_F2
#define ILLUMINANT_TUNGSTEN	ILLUMINANT_A
#define ILLUMINANT_DAYLIGHT	ILLUMINANT_C
#define ILLUMINANT_FLUORESCENT	ILLUMINANT_F2
#define ILLUMINANT_NTSC	ILLUMINANT_C
#define RGB_GAMMA_MIN	2500
#define RGB_GAMMA_MAX	65000
#define REFERENCE_WHITE_MIN	6000
#define REFERENCE_WHITE_MAX	10000
#define REFERENCE_BLACK_MIN	0
#define REFERENCE_BLACK_MAX	4000
#define COLOR_ADJ_MIN	(-100)
#define COLOR_ADJ_MAX	100
#define CCHDEVICENAME 32
#define CCHFORMNAME 32
#define DI_COMPAT	4
#define DI_DEFAULTSIZE	8
#define DI_IMAGE	2
#define DI_MASK	1
#define DI_NORMAL	3
#define DI_APPBANDING 1
#define DI_NOMIRROR	16
#define EMR_HEADER	1
#define EMR_POLYBEZIER 2
#define EMR_POLYGON	3
#define EMR_POLYLINE	4
#define EMR_POLYBEZIERTO	5
#define EMR_POLYLINETO 6
#define EMR_POLYPOLYLINE	7
#define EMR_POLYPOLYGON 8
#define EMR_SETWINDOWEXTEX	9
#define EMR_SETWINDOWORGEX	10
#define EMR_SETVIEWPORTEXTEX 11
#define EMR_SETVIEWPORTORGEX 12
#define EMR_SETBRUSHORGEX 13
#define EMR_EOF 14
#define EMR_SETPIXELV 15
#define EMR_SETMAPPERFLAGS 16
#define EMR_SETMAPMODE 17
#define EMR_SETBKMODE 18
#define EMR_SETPOLYFILLMODE 19
#define EMR_SETROP2 20
#define EMR_SETSTRETCHBLTMODE 21
#define EMR_SETTEXTALIGN 22
#define EMR_SETCOLORADJUSTMENT 23
#define EMR_SETTEXTCOLOR 24
#define EMR_SETBKCOLOR 25
#define EMR_OFFSETCLIPRGN 26
#define EMR_MOVETOEX 27
#define EMR_SETMETARGN 28
#define EMR_EXCLUDECLIPRECT 29
#define EMR_INTERSECTCLIPRECT 30
#define EMR_SCALEVIEWPORTEXTEX 31
#define EMR_SCALEWINDOWEXTEX 32
#define EMR_SAVEDC 33
#define EMR_RESTOREDC 34
#define EMR_SETWORLDTRANSFORM 35
#define EMR_MODIFYWORLDTRANSFORM 36
#define EMR_SELECTOBJECT 37
#define EMR_CREATEPEN 38
#define EMR_CREATEBRUSHINDIRECT 39
#define EMR_DELETEOBJECT 40
#define EMR_ANGLEARC 41
#define EMR_ELLIPSE  42
#define EMR_RECTANGLE 43
#define EMR_ROUNDRECT 44
#define EMR_ARC 45
#define EMR_CHORD 46
#define EMR_PIE 47
#define EMR_SELECTPALETTE 48
#define EMR_CREATEPALETTE 49
#define EMR_SETPALETTEENTRIES 50
#define EMR_RESIZEPALETTE 51
#define EMR_REALIZEPALETTE 52
#define EMR_EXTFLOODFILL 53
#define EMR_LINETO 54
#define EMR_ARCTO 55
#define EMR_POLYDRAW 56
#define EMR_SETARCDIRECTION 57
#define EMR_SETMITERLIMIT 58
#define EMR_BEGINPATH 59
#define EMR_ENDPATH 60
#define EMR_CLOSEFIGURE 61
#define EMR_FILLPATH 62
#define EMR_STROKEANDFILLPATH 63
#define EMR_STROKEPATH 64
#define EMR_FLATTENPATH 65
#define EMR_WIDENPATH 66
#define EMR_SELECTCLIPPATH 67
#define EMR_ABORTPATH 68
#define EMR_GDICOMMENT 70
#define EMR_FILLRGN 71
#define EMR_FRAMERGN 72
#define EMR_INVERTRGN 73
#define EMR_PAINTRGN 74
#define EMR_EXTSELECTCLIPRGN 75
#define EMR_BITBLT 76
#define EMR_STRETCHBLT 77
#define EMR_MASKBLT 78
#define EMR_PLGBLT 79
#define EMR_SETDIBITSTODEVICE 80
#define EMR_STRETCHDIBITS 81
#define EMR_EXTCREATEFONTINDIRECTW 82
#define EMR_EXTTEXTOUTA 83
#define EMR_EXTTEXTOUTW 84
#define EMR_POLYBEZIER16 85
#define EMR_POLYGON16 86
#define EMR_POLYLINE16 87
#define EMR_POLYBEZIERTO16 88
#define EMR_POLYLINETO16 89
#define EMR_POLYPOLYLINE16 90
#define EMR_POLYPOLYGON16 91
#define EMR_POLYDRAW16 92
#define EMR_CREATEMONOBRUSH 93
#define EMR_CREATEDIBPATTERNBRUSHPT 94
#define EMR_EXTCREATEPEN 95
#define EMR_POLYTEXTOUTA 96
#define EMR_POLYTEXTOUTW 97
#define EMR_SETICMMODE 98
#define EMR_CREATECOLORSPACE 99
#define EMR_SETCOLORSPACE 100
#define EMR_DELETECOLORSPACE 101
#define EMR_GLSRECORD 102
#define EMR_GLSBOUNDEDRECORD 103
#define EMR_PIXELFORMAT 104
#if (_WIN32_WINNT >= 0x0500)
#define EMR_DRAWESCAPE 105
#define EMR_EXTESCAPE 106
#define EMR_STARTDOC 107
#define EMR_SMALLTEXTOUT 108
#define EMR_FORCEUFIMAPPING 109
#define EMR_NAMEDESCAPE 110
#define EMR_COLORCORRECTPALETTE 111
#define EMR_SETICMPROFILEA 112
#define EMR_SETICMPROFILEW 113
#define EMR_ALPHABLEND 114
#define EMR_ALPHADIBBLEND 115
#define EMR_SETLAYOUT 115
#define EMR_TRANSPARENTBLT 116
#define EMR_TRANSPARENTDIB 117
#define EMR_RESERVED_117 117
#define EMR_GRADIENTFILL 118
#define EMR_SETLINKEDUFIS 119
#define EMR_SETTEXTJUSTIFICATION 120
#define EMR_COLORMATCHTOTARGETW 121
#define EMR_CREATECOLORSPACEW 122

#define EMR_MIN 1
#define EMR_MAX 122

#endif
#define ENHMETA_SIGNATURE 1179469088
#define EPS_SIGNATURE 0x46535045
#if (_WIN32_WINNT >= 0x0500)
#define FR_PRIVATE 0x10
#define FR_NOT_ENUM 0x20
#endif
#define META_SETBKCOLOR	0x201
#define META_SETBKMODE	0x102
#define META_SETMAPMODE	0x103
#define META_SETROP2	0x104
#define META_SETRELABS	0x105
#define META_SETPOLYFILLMODE	0x106
#define META_SETSTRETCHBLTMODE	0x107
#define META_SETTEXTCHAREXTRA	0x108
#define META_SETTEXTCOLOR	0x209
#define META_SETTEXTJUSTIFICATION	0x20A
#define META_SETWINDOWORG	0x20B
#define META_SETWINDOWEXT	0x20C
#define META_SETVIEWPORTORG	0x20D
#define META_SETVIEWPORTEXT	0x20E
#define META_OFFSETWINDOWORG	0x20F
#define META_SCALEWINDOWEXT	0x410
#define META_OFFSETVIEWPORTORG	0x211
#define META_SCALEVIEWPORTEXT	0x412
#define META_LINETO	0x213
#define META_MOVETO	0x214
#define META_EXCLUDECLIPRECT	0x415
#define META_INTERSECTCLIPRECT	0x416
#define META_ARC	0x817
#define META_ELLIPSE	0x418
#define META_FLOODFILL	0x419
#define META_PIE	0x81A
#define META_RECTANGLE	0x41B
#define META_ROUNDRECT	0x61C
#define META_PATBLT	0x61D
#define META_SAVEDC	0x1E
#define META_SETPIXEL	0x41F
#define META_OFFSETCLIPRGN	0x220
#define META_TEXTOUT	0x521
#define META_BITBLT	0x922
#define META_STRETCHBLT	0xB23
#define META_POLYGON	0x324
#define META_POLYLINE	0x325
#define META_ESCAPE	0x626
#define META_RESTOREDC	0x127
#define META_FILLREGION	0x228
#define META_FRAMEREGION	0x429
#define META_INVERTREGION	0x12A
#define META_PAINTREGION	0x12B
#define META_SELECTCLIPREGION	0x12C
#define META_SELECTOBJECT	0x12D
#define META_SETTEXTALIGN	0x12E
#define META_CHORD	0x830
#define META_SETMAPPERFLAGS	0x231
#define META_EXTTEXTOUT	0xa32
#define META_SETDIBTODEV	0xd33
#define META_SELECTPALETTE	0x234
#define META_REALIZEPALETTE	0x35
#define META_ANIMATEPALETTE	0x436
#define META_SETPALENTRIES	0x37
#define META_POLYPOLYGON	0x538
#define META_RESIZEPALETTE	0x139
#define META_DIBBITBLT	0x940
#define META_DIBSTRETCHBLT	0xb41
#define META_DIBCREATEPATTERNBRUSH	0x142
#define META_STRETCHDIB	0xf43
#define META_EXTFLOODFILL	0x548
#define META_DELETEOBJECT	0x1f0
#define META_CREATEPALETTE	0xf7
#define META_CREATEPATTERNBRUSH	0x1F9
#define META_CREATEPENINDIRECT	0x2FA
#define META_CREATEFONTINDIRECT	0x2FB
#define META_CREATEBRUSHINDIRECT	0x2FC
#define META_CREATEREGION	0x6FF
#define META_DRAWTEXT	0x062F
#define META_RESETDC	0x014C
#define META_STARTDOC	0x014D
#define META_STARTPAGE	0x004F
#define META_ENDPAGE	0x0050
#define META_ABORTDOC	0x0052
#define META_ENDDOC	0x005E
#define META_CREATEBRUSH	0x00F8
#define META_CREATEBITMAPINDIRECT	0x02FD
#define META_CREATEBITMAP	0x06FE
#define PT_MOVETO	6
#define PT_LINETO	2
#define PT_BEZIERTO	4
#define PT_CLOSEFIGURE 1
#define ELF_VENDOR_SIZE	4
#define ELF_VERSION	0
#define ELF_CULTURE_LATIN	0
#define PFD_TYPE_RGBA	0
#define PFD_TYPE_COLORINDEX	1
#define PFD_MAIN_PLANE	0
#define PFD_OVERLAY_PLANE	1
#define PFD_UNDERLAY_PLANE	(-1)
#define PFD_DOUBLEBUFFER	1
#define PFD_STEREO	2
#define PFD_DRAW_TO_WINDOW	4
#define PFD_DRAW_TO_BITMAP	8
#define PFD_SUPPORT_GDI	16
#define PFD_SUPPORT_OPENGL	32
#define PFD_GENERIC_FORMAT	64
#define PFD_NEED_PALETTE	128
#define PFD_NEED_SYSTEM_PALETTE	0x00000100
#define PFD_SWAP_EXCHANGE	0x00000200
#define PFD_SWAP_COPY	0x00000400
#define PFD_SWAP_LAYER_BUFFERS	0x00000800
#define PFD_GENERIC_ACCELERATED	0x00001000
#define PFD_DEPTH_DONTCARE	0x20000000
#define PFD_DOUBLEBUFFER_DONTCARE	0x40000000
#define PFD_STEREO_DONTCARE	0x80000000
#define SP_ERROR	(-1)
#define SP_OUTOFDISK	(-4)
#define SP_OUTOFMEMORY	(-5)
#define SP_USERABORT	(-3)
#define SP_APPABORT	(-2)
#define BLACKNESS	0x42
#define NOTSRCERASE	0x1100A6
#define NOTSRCCOPY	0x330008
#define SRCERASE	0x440328
#define DSTINVERT	0x550009
#define PATINVERT	0x5A0049
#define SRCINVERT	0x660046
#define SRCAND	0x8800C6
#define MERGEPAINT	0xBB0226
#define MERGECOPY	0xC000CA
#define SRCCOPY 0xCC0020
#define SRCPAINT	0xEE0086
#define PATCOPY	0xF00021
#define PATPAINT	0xFB0A09
#define WHITENESS	0xFF0062
#define R2_BLACK	1
#define R2_COPYPEN	13
#define R2_MASKNOTPEN	3
#define R2_MASKPEN	9
#define R2_MASKPENNOT	5
#define R2_MERGENOTPEN	12
#define R2_MERGEPEN	15
#define R2_MERGEPENNOT	14
#define R2_NOP	11
#define R2_NOT	6
#define R2_NOTCOPYPEN	4
#define R2_NOTMASKPEN	8
#define R2_NOTMERGEPEN	2
#define R2_NOTXORPEN	10
#define R2_WHITE	16
#define R2_XORPEN	7
#define CM_OUT_OF_GAMUT	255
#define CM_IN_GAMUT	0
#define RGN_AND 1
#define RGN_COPY	5
#define RGN_DIFF	4
#define RGN_OR	2
#define RGN_XOR	3
#define NULLREGION	1
#define SIMPLEREGION	2
#define COMPLEXREGION	3
#define ERROR 0
#define CBM_INIT	4
#define DIB_PAL_COLORS	1
#define DIB_RGB_COLORS	0
#define FW_DONTCARE	0
#define FW_THIN	100
#define FW_EXTRALIGHT	200
#define FW_ULTRALIGHT	FW_EXTRALIGHT
#define FW_LIGHT	300
#define FW_NORMAL	400
#define FW_REGULAR	400
#define FW_MEDIUM	500
#define FW_SEMIBOLD	600
#define FW_DEMIBOLD	FW_SEMIBOLD
#define FW_BOLD	700
#define FW_EXTRABOLD	800
#define FW_ULTRABOLD	FW_EXTRABOLD
#define FW_HEAVY	900
#define FW_BLACK	FW_HEAVY
#define ANSI_CHARSET	0
#define DEFAULT_CHARSET	1
#define SYMBOL_CHARSET	2
#define SHIFTJIS_CHARSET	128
#define HANGEUL_CHARSET	129
#define HANGUL_CHARSET  129
#define GB2312_CHARSET	134
#define CHINESEBIG5_CHARSET	136
#define GREEK_CHARSET	161
#define TURKISH_CHARSET	162
#define HEBREW_CHARSET	177
#define ARABIC_CHARSET	178
#define BALTIC_CHARSET	186
#define RUSSIAN_CHARSET	204
#define THAI_CHARSET	222
#define EE_CHARSET	    238
#define EASTEUROPE_CHARSET	238
#define OEM_CHARSET	255
#define JOHAB_CHARSET	130
#define VIETNAMESE_CHARSET	163
#define MAC_CHARSET 77
/* I don't know if the values of *_CHARSET macros are defined in Windows
 * or if we can choose them as we want. -- srtxg
 */
#define VISCII_CHARSET        (BYTE)240 /* viscii1.1-1 */
#define TCVN_CHARSET          (BYTE)241 /* tcvn-0 */
#define KOI8_CHARSET          (BYTE)242 /* koi8-{r,u,ru} */
#define ISO3_CHARSET          (BYTE)243 /* iso8859-3 */
#define ISO4_CHARSET          (BYTE)244 /* iso8859-4 */
#define ISO10_CHARSET         (BYTE)245 /* iso8859-10 */
#define CELTIC_CHARSET        (BYTE)246 /* iso8859-14 */

#define OUT_DEFAULT_PRECIS	0
#define OUT_STRING_PRECIS	1
#define OUT_CHARACTER_PRECIS	2
#define OUT_STROKE_PRECIS	3
#define OUT_TT_PRECIS	4
#define OUT_DEVICE_PRECIS	5
#define OUT_RASTER_PRECIS	6
#define OUT_TT_ONLY_PRECIS	7
#define OUT_OUTLINE_PRECIS	8
#define OUT_SCREEN_OUTLINE_PRECIS	9
#define OUT_PS_ONLY_PRECIS	10
#define CLIP_DEFAULT_PRECIS	0
#define CLIP_CHARACTER_PRECIS	1
#define CLIP_STROKE_PRECIS	2
#define CLIP_MASK	15
#define CLIP_LH_ANGLES	16
#define CLIP_TT_ALWAYS	32
#if (_WIN32_WINNT >= _WIN32_WINNT_LONGHORN)
#define CLIP_DFA_DISABLE	64
#endif
#define CLIP_EMBEDDED	128
#define DEFAULT_QUALITY	0
#define DRAFT_QUALITY	1
#define PROOF_QUALITY	2
#define NONANTIALIASED_QUALITY 3
#define ANTIALIASED_QUALITY 4
#define CLEARTYPE_QUALITY 5
#define CLEARTYPE_NATURAL_QUALITY 6
#define DEFAULT_PITCH	0
#define FIXED_PITCH	1
#define VARIABLE_PITCH	2
#define MONO_FONT 8
#define FF_DECORATIVE	80
#define FF_DONTCARE	0
#define FF_MODERN	48
#define FF_ROMAN	16
#define FF_SCRIPT	64
#define FF_SWISS	32
#define PANOSE_COUNT 10
#define PAN_FAMILYTYPE_INDEX 0
#define PAN_SERIFSTYLE_INDEX 1
#define PAN_WEIGHT_INDEX 2
#define PAN_PROPORTION_INDEX 3
#define PAN_CONTRAST_INDEX 4
#define PAN_STROKEVARIATION_INDEX 5
#define PAN_ARMSTYLE_INDEX 6
#define PAN_LETTERFORM_INDEX 7
#define PAN_MIDLINE_INDEX 8
#define PAN_XHEIGHT_INDEX 9
#define PAN_CULTURE_LATIN 0
#define PAN_ANY 0
#define PAN_NO_FIT 1
#define PAN_FAMILY_TEXT_DISPLAY 2
#define PAN_FAMILY_SCRIPT 3
#define PAN_FAMILY_DECORATIVE 4
#define PAN_FAMILY_PICTORIAL 5
#define PAN_SERIF_COVE 2
#define PAN_SERIF_OBTUSE_COVE 3
#define PAN_SERIF_SQUARE_COVE 4
#define PAN_SERIF_OBTUSE_SQUARE_COVE 5
#define PAN_SERIF_SQUARE 6
#define PAN_SERIF_THIN 7
#define PAN_SERIF_BONE 8
#define PAN_SERIF_EXAGGERATED 9
#define PAN_SERIF_TRIANGLE 10
#define PAN_SERIF_NORMAL_SANS 11
#define PAN_SERIF_OBTUSE_SANS 12
#define PAN_SERIF_PERP_SANS 13
#define PAN_SERIF_FLARED 14
#define PAN_SERIF_ROUNDED 15
#define PAN_WEIGHT_VERY_LIGHT 2
#define PAN_WEIGHT_LIGHT 3
#define PAN_WEIGHT_THIN 4
#define PAN_WEIGHT_BOOK 5
#define PAN_WEIGHT_MEDIUM 6
#define PAN_WEIGHT_DEMI 7
#define PAN_WEIGHT_BOLD 8
#define PAN_WEIGHT_HEAVY 9
#define PAN_WEIGHT_BLACK 10
#define PAN_WEIGHT_NORD 11
#define PAN_PROP_OLD_STYLE 2
#define PAN_PROP_MODERN 3
#define PAN_PROP_EVEN_WIDTH 4
#define PAN_PROP_EXPANDED 5
#define PAN_PROP_CONDENSED 6
#define PAN_PROP_VERY_EXPANDED 7
#define PAN_PROP_VERY_CONDENSED 8
#define PAN_PROP_MONOSPACED 9
#define PAN_CONTRAST_NONE 2
#define PAN_CONTRAST_VERY_LOW 3
#define PAN_CONTRAST_LOW 4
#define PAN_CONTRAST_MEDIUM_LOW 5
#define PAN_CONTRAST_MEDIUM 6
#define PAN_CONTRAST_MEDIUM_HIGH 7
#define PAN_CONTRAST_HIGH 8
#define PAN_CONTRAST_VERY_HIGH 9
#define PAN_STROKE_GRADUAL_DIAG 2
#define PAN_STROKE_GRADUAL_TRAN 3
#define PAN_STROKE_GRADUAL_VERT 4
#define PAN_STROKE_GRADUAL_HORZ 5
#define PAN_STROKE_RAPID_VERT 6
#define PAN_STROKE_RAPID_HORZ 7
#define PAN_STROKE_INSTANT_VERT 8
#define PAN_STRAIGHT_ARMS_HORZ 2
#define PAN_STRAIGHT_ARMS_WEDGE 3
#define PAN_STRAIGHT_ARMS_VERT 4
#define PAN_STRAIGHT_ARMS_SINGLE_SERIF 5
#define PAN_STRAIGHT_ARMS_DOUBLE_SERIF 6
#define PAN_BENT_ARMS_HORZ 7
#define PAN_BENT_ARMS_WEDGE 8
#define PAN_BENT_ARMS_VERT 9
#define PAN_BENT_ARMS_SINGLE_SERIF 10
#define PAN_BENT_ARMS_DOUBLE_SERIF 11
#define PAN_LETT_NORMAL_CONTACT 2
#define PAN_LETT_NORMAL_WEIGHTED 3
#define PAN_LETT_NORMAL_BOXED 4
#define PAN_LETT_NORMAL_FLATTENED 5
#define PAN_LETT_NORMAL_ROUNDED 6
#define PAN_LETT_NORMAL_OFF_CENTER 7
#define PAN_LETT_NORMAL_SQUARE 8
#define PAN_LETT_OBLIQUE_CONTACT 9
#define PAN_LETT_OBLIQUE_WEIGHTED 10
#define PAN_LETT_OBLIQUE_BOXED 11
#define PAN_LETT_OBLIQUE_FLATTENED 12
#define PAN_LETT_OBLIQUE_ROUNDED 13
#define PAN_LETT_OBLIQUE_OFF_CENTER 14
#define PAN_LETT_OBLIQUE_SQUARE 15
#define PAN_MIDLINE_STANDARD_TRIMMED 2
#define PAN_MIDLINE_STANDARD_POINTED 3
#define PAN_MIDLINE_STANDARD_SERIFED 4
#define PAN_MIDLINE_HIGH_TRIMMED 5
#define PAN_MIDLINE_HIGH_POINTED 6
#define PAN_MIDLINE_HIGH_SERIFED 7
#define PAN_MIDLINE_CONSTANT_TRIMMED 8
#define PAN_MIDLINE_CONSTANT_POINTED 9
#define PAN_MIDLINE_CONSTANT_SERIFED 10
#define PAN_MIDLINE_LOW_TRIMMED 11
#define PAN_MIDLINE_LOW_POINTED 12
#define PAN_MIDLINE_LOW_SERIFED 13
#define PAN_XHEIGHT_CONSTANT_SMALL 2
#define PAN_XHEIGHT_CONSTANT_STD 3
#define PAN_XHEIGHT_CONSTANT_LARGE 4
#define PAN_XHEIGHT_DUCKING_SMALL 5
#define PAN_XHEIGHT_DUCKING_STD 6
#define PAN_XHEIGHT_DUCKING_LARGE 7
#define FS_LATIN1 1
#define FS_LATIN2 2
#define FS_CYRILLIC 4
#define FS_GREEK 8
#define FS_TURKISH 16
#define FS_HEBREW 32
#define FS_ARABIC 64
#define FS_BALTIC 128
#define FS_VIETNAMESE 256
#define FS_THAI 0x10000
#define FS_JISJAPAN 0x20000
#define FS_CHINESESIMP 0x40000
#define FS_WANSUNG 0x80000
#define FS_CHINESETRAD 0x100000
#define FS_JOHAB 0x200000
#define FS_SYMBOL 0x80000000
#define HS_BDIAGONAL	3
#define HS_CROSS	4
#define HS_DIAGCROSS	5
#define HS_FDIAGONAL	2
#define HS_HORIZONTAL	0
#define HS_VERTICAL	1
#define HS_API_MAX	12
#define PS_GEOMETRIC	65536
#define PS_COSMETIC	0
#define PS_ALTERNATE	8
#define PS_SOLID	0
#define PS_DASH	1
#define PS_DOT	2
#define PS_DASHDOT	3
#define PS_DASHDOTDOT	4
#define PS_NULL	5
#define PS_USERSTYLE	7
#define PS_INSIDEFRAME	6
#define PS_ENDCAP_ROUND	0
#define PS_ENDCAP_SQUARE	256
#define PS_ENDCAP_FLAT	512
#define PS_JOIN_BEVEL	4096
#define PS_JOIN_MITER	8192
#define PS_JOIN_ROUND	0
#define PS_JOIN_MASK    0x0000F000
#define PS_STYLE_MASK	15
#define PS_ENDCAP_MASK	3840
#define PS_TYPE_MASK	983040
#define ALTERNATE	1
#define WINDING	2
#define POLYFILL_LAST	2
#define DC_BINNAMES	12
#define DC_BINS	6
#define DC_COPIES	18
#define DC_DRIVER	11
#define DC_DATATYPE_PRODUCED	21
#define DC_DUPLEX	7
#define DC_EMF_COMPLIANT	20
#define DC_ENUMRESOLUTIONS	13
#define DC_EXTRA	9
#define DC_FIELDS	1
#define DC_FILEDEPENDENCIES	14
#define DC_MAXEXTENT	5
#define DC_MINEXTENT	4
#define DC_ORIENTATION	17
#define DC_PAPERNAMES	16
#define DC_PAPERS	2
#define DC_PAPERSIZE	3
#define DC_SIZE	8
#define DC_TRUETYPE	15
#define DCTT_BITMAP	1
#define DCTT_DOWNLOAD	2
#define DCTT_SUBDEV	4
#define DCTT_DOWNLOAD_OUTLINE 8
#define DC_VERSION	10
#define DC_BINADJUST	19
#define DC_EMF_COMPLIANT	20
#define DC_DATATYPE_PRODUCED	21
#define DC_MANUFACTURER	23
#define DC_MODEL	24
#define DCBA_FACEUPNONE	0
#define DCBA_FACEUPCENTER	1
#define DCBA_FACEUPLEFT	2
#define DCBA_FACEUPRIGHT	3
#define DCBA_FACEDOWNNONE	256
#define DCBA_FACEDOWNCENTER	257
#define DCBA_FACEDOWNLEFT	258
#define DCBA_FACEDOWNRIGHT	259
#define FLOODFILLBORDER 0
#define FLOODFILLSURFACE 1
#define ETO_GRAYED            0x00001
#define ETO_OPAQUE            0x00002
#define ETO_CLIPPED           0x00004
#if (WINVER >= 0x0400)
#define ETO_GLYPH_INDEX       0x00010
#define ETO_RTLREADING        0x00080
#define ETO_NUMERICSLOCAL     0x00400
#define ETO_NUMERICSLATIN     0x00800
#define ETO_IGNORELANGUAGE    0x01000
#endif
#if (_WIN32_WINNT >= _WIN32_WINNT_WIN2K)
#define ETO_PDY               0x02000
#endif
#if (_WIN32_WINNT >= _WIN32_WINNT_LONGHORN)
#define ETO_REVERSE_INDEX_MAP 0x10000
#endif
#define GDICOMMENT_WINDOWS_METAFILE (-2147483647)
#define GDICOMMENT_BEGINGROUP 2
#define GDICOMMENT_ENDGROUP 3
#define GDICOMMENT_MULTIFORMATS 1073741828
#define GDICOMMENT_IDENTIFIER 1128875079
#define AD_COUNTERCLOCKWISE 1
#define AD_CLOCKWISE 2
#define RDH_RECTANGLES	1
#define GCPCLASS_LATIN	1
#define GCPCLASS_HEBREW	2
#define GCPCLASS_ARABIC	2
#define GCPCLASS_NEUTRAL	3
#define GCPCLASS_LOCALNUMBER	4
#define GCPCLASS_LATINNUMBER	5
#define GCPCLASS_LATINNUMERICTERMINATOR	6
#define GCPCLASS_LATINNUMERICSEPARATOR	7
#define GCPCLASS_NUMERICSEPARATOR	8
#define GCPCLASS_PREBOUNDLTR	128
#define GCPCLASS_PREBOUNDRTL	64
#define GCPCLASS_POSTBOUNDLTR	32
#define GCPCLASS_POSTBOUNDRTL	16
#define GCPGLYPH_LINKBEFORE	0x8000
#define GCPGLYPH_LINKAFTER	0x4000
#define DCB_DISABLE 8
#define DCB_ENABLE 4
#define DCB_RESET 1
#define DCB_SET 3
#define DCB_ACCUMULATE 2
#define DCB_DIRTY	2
#define OBJ_BRUSH 2
#define OBJ_PEN 1
#define OBJ_PAL 5
#define OBJ_FONT 6
#define OBJ_BITMAP 7
#define OBJ_EXTPEN 11
#define OBJ_REGION 8
#define OBJ_DC 3
#define OBJ_MEMDC 10
#define OBJ_METAFILE 9
#define OBJ_METADC 4
#define OBJ_ENHMETAFILE 13
#define OBJ_ENHMETADC 12
#define OBJ_COLORSPACE 14
#define DRIVERVERSION 0
#define TECHNOLOGY 2
#define DT_PLOTTER 0
#define DT_RASDISPLAY 1
#define DT_RASPRINTER 2
#define DT_RASCAMERA 3
#define DT_CHARSTREAM 4
#define DT_METAFILE 5
#define DT_DISPFILE 6
#define HORZSIZE 4
#define VERTSIZE 6
#define HORZRES 8
#define VERTRES 10
#define LOGPIXELSX 88
#define LOGPIXELSY 90
#define BITSPIXEL 12
#define PLANES 14
#define NUMBRUSHES 16
#define NUMPENS 18
#define NUMFONTS 22
#define NUMCOLORS 24
#define NUMMARKERS 20
#define ASPECTX 40
#define ASPECTY 42
#define ASPECTXY 44
#define PDEVICESIZE 26
#define CLIPCAPS 36
#define SIZEPALETTE 104
#define NUMRESERVED 106
#define COLORRES 108
#define PHYSICALWIDTH 110
#define PHYSICALHEIGHT 111
#define PHYSICALOFFSETX 112
#define PHYSICALOFFSETY 113
#define SCALINGFACTORX 114
#define SCALINGFACTORY 115
#define VREFRESH 116
#define DESKTOPHORZRES 118
#define DESKTOPVERTRES 117
#define BLTALIGNMENT 119
#define RASTERCAPS 38
#define RC_BANDING 2
#define RC_BITBLT 1
#define RC_BITMAP64 8
#define RC_DI_BITMAP 128
#define RC_DIBTODEV 512
#define RC_FLOODFILL 4096
#define RC_GDI20_OUTPUT 16
#define RC_PALETTE 256
#define RC_SCALING 4
#define RC_STRETCHBLT 2048
#define RC_STRETCHDIB 8192
#define RC_DEVBITS 0x8000
#define RC_OP_DX_OUTPUT 0x4000
#define CURVECAPS 28
#define CC_NONE 0
#define CC_CIRCLES 1
#define CC_PIE 2
#define CC_CHORD 4
#define CC_ELLIPSES 8
#define CC_WIDE 16
#define CC_STYLED 32
#define CC_WIDESTYLED 64
#define CC_INTERIORS 128
#define CC_ROUNDRECT 256
#define LINECAPS 30
#define LC_NONE 0
#define LC_POLYLINE 2
#define LC_MARKER 4
#define LC_POLYMARKER 8
#define LC_WIDE 16
#define LC_STYLED 32
#define LC_WIDESTYLED 64
#define LC_INTERIORS 128
#define POLYGONALCAPS 32
#define RC_BANDING 2
#define RC_BIGFONT 1024
#define RC_BITBLT 1
#define RC_BITMAP64 8
#define RC_DEVBITS 0x8000
#define RC_DI_BITMAP 128
#define RC_GDI20_OUTPUT 16
#define RC_GDI20_STATE 32
#define RC_NONE 0
#define RC_OP_DX_OUTPUT 0x4000
#define RC_PALETTE 256
#define RC_SAVEBITMAP 64
#define RC_SCALING 4
#define PC_NONE 0
#define PC_POLYGON 1
#define PC_POLYPOLYGON 256
#define PC_PATHS 512
#define PC_RECTANGLE 2
#define PC_WINDPOLYGON 4
#define PC_SCANLINE 8
#define PC_TRAPEZOID 4
#define PC_WIDE 16
#define PC_STYLED 32
#define PC_WIDESTYLED 64
#define PC_INTERIORS 128
#define PC_PATHS 512
#define TEXTCAPS 34
#define TC_OP_CHARACTER 1
#define TC_OP_STROKE 2
#define TC_CP_STROKE 4
#define TC_CR_90 8
#define TC_CR_ANY 16
#define TC_SF_X_YINDEP 32
#define TC_SA_DOUBLE 64
#define TC_SA_INTEGER 128
#define TC_SA_CONTIN 256
#define TC_EA_DOUBLE 512
#define TC_IA_ABLE 1024
#define TC_UA_ABLE 2048
#define TC_SO_ABLE 4096
#define TC_RA_ABLE 8192
#define TC_VA_ABLE 16384
#define TC_RESERVED 32768
#define TC_SCROLLBLT 65536
/* CLIPCAPS */
#define CP_NONE 0
#define CP_RECTANGLE 1
#define CP_REGION 2
#define GCP_DBCS 1
#define GCP_ERROR 0x8000
#define GCP_CLASSIN 0x80000
#define GCP_DIACRITIC 256
#define GCP_DISPLAYZWG 0x400000
#define GCP_GLYPHSHAPE 16
#define GCP_JUSTIFY 0x10000
#define GCP_JUSTIFYIN 0x200000
#define GCP_KASHIDA 1024
#define GCP_LIGATE 32
#define GCP_MAXEXTENT 0x100000
#define GCP_NEUTRALOVERRIDE 0x2000000
#define GCP_NUMERICOVERRIDE 0x1000000
#define GCP_NUMERICSLATIN 0x4000000
#define GCP_NUMERICSLOCAL 0x8000000
#define GCP_REORDER 2
#define GCP_SYMSWAPOFF 0x800000
#define GCP_USEKERNING 8
#define FLI_GLYPHS 0x40000
#define FLI_MASK 0x103b
#define GGO_METRICS 0
#define GGO_BITMAP 1
#define GGO_NATIVE 2
#define GGO_BEZIER 3
#define GGO_GRAY2_BITMAP 4
#define GGO_GRAY4_BITMAP 5
#define GGO_GRAY8_BITMAP 6
#define GGO_GLYPH_INDEX 128
#define GGO_UNHINTED 256
#ifdef __WINESRC__
#define WINE_GGO_GRAY16_BITMAP 0x10
#define WINE_GGO_HRGB_BITMAP   0x11
#define WINE_GGO_HBGR_BITMAP   0x12
#define WINE_GGO_VRGB_BITMAP   0x13
#define WINE_GGO_VBGR_BITMAP   0x14
#endif
#define GM_COMPATIBLE 1
#define GM_ADVANCED 2
#define GM_LAST     2
#define MM_ANISOTROPIC 8
#define MM_HIENGLISH 5
#define MM_HIMETRIC 3
#define MM_ISOTROPIC 7
#define MM_LOENGLISH 4
#define MM_LOMETRIC 2
#define MM_TEXT 1
#define MM_TWIPS 6
#define MM_MAX_FIXEDSCALE	MM_TWIPS
#define MM_MIN MM_TEXT
#define MM_MAX MM_ANISOTROPIC
#define ABSOLUTE	1
#define RELATIVE	2
#define PC_EXPLICIT 2
#define PC_NOCOLLAPSE 4
#define PC_RESERVED 1
#define CLR_INVALID     0xFFFFFFFF
#define PT_MOVETO 6
#define PT_LINETO 2
#define PT_BEZIERTO 4
#define PT_CLOSEFIGURE 1
#define TT_AVAILABLE 1
#define TT_ENABLED 2

#ifdef __WINESRC__
#define WINE_TT_SUBPIXEL_RENDERING_ENABLED 0x4000
#define WINE_TT_HINTER_ENABLED 0x8000
#endif

#define BLACK_BRUSH 4
#define DKGRAY_BRUSH 3
#define GRAY_BRUSH 2
#define HOLLOW_BRUSH 5
#define LTGRAY_BRUSH 1
#define NULL_BRUSH 5
#define WHITE_BRUSH 0
#define BLACK_PEN 7
#define NULL_PEN 8
#define WHITE_PEN 6
#define ANSI_FIXED_FONT 11
#define ANSI_VAR_FONT 12
#define DEVICE_DEFAULT_FONT 14
#define DEFAULT_GUI_FONT 17
#define OEM_FIXED_FONT 10
#define SYSTEM_FONT 13
#define SYSTEM_FIXED_FONT 16
#define DEFAULT_PALETTE 15
#if (_WIN32_WINNT >= 0x0500)
#define DC_BRUSH	18
#define DC_PEN	19
#endif
#if (_WIN32_WINNT >= 0x0500)
#define STOCK_LAST          19
#elif (WINVER >= 0x0400)
#define STOCK_LAST          17
#else
#define STOCK_LAST          16
#endif
#define SYSPAL_NOSTATIC 2
#define SYSPAL_STATIC 1
#define SYSPAL_ERROR 0
#define TA_BASELINE 24
#define TA_BOTTOM 8
#define TA_TOP 0
#define TA_CENTER 6
#define TA_LEFT 0
#define TA_RIGHT 2
#define TA_RTLREADING 256
#define TA_NOUPDATECP 0
#define TA_UPDATECP 1
#define TA_MASK (TA_BASELINE+TA_CENTER+TA_UPDATECP+TA_RTLREADING)
#define VTA_BASELINE 24
#define VTA_CENTER 6
#define VTA_LEFT TA_BOTTOM
#define VTA_RIGHT TA_TOP
#define VTA_BOTTOM TA_RIGHT
#define VTA_TOP TA_LEFT
#define MWT_IDENTITY 1
#define MWT_LEFTMULTIPLY 2
#define MWT_RIGHTMULTIPLY 3
#define MWT_MIN MWT_IDENTITY
#define MWT_MAX MWT_RIGHTMULTIPLY
#define OPAQUE 2
#define TRANSPARENT 1
#define BKMODE_LAST  2
#define BLACKONWHITE 1
#define WHITEONBLACK 2
#define COLORONCOLOR 3
#define HALFTONE 4
#define MAXSTRETCHBLTMODE 4
#define STRETCH_ANDSCANS 1
#define STRETCH_DELETESCANS 3
#define STRETCH_HALFTONE 4
#define STRETCH_ORSCANS 2
#define TCI_SRCCHARSET 1
#define TCI_SRCCODEPAGE 2
#define TCI_SRCFONTSIG 3
#define TCI_SRCLOCALE 4096
#if (_WIN32_WINNT >= 0x0500)
#define SHADEBLENDCAPS    120
#define COLORMGMTCAPS     121
/* SHADEBLENDCAPS */
#define SB_NONE           0x00000000
#define SB_CONST_ALPHA    0x00000001
#define SB_PIXEL_ALPHA    0x00000002
#define SB_PREMULT_ALPHA  0x00000004
#define SB_GRAD_RECT      0x00000010
#define SB_GRAD_TRI       0x00000020
/* Color Management caps */
#define CM_NONE           0x00000000
#define CM_DEVICE_ICM     0x00000001
#define CM_GAMMA_RAMP     0x00000002
#define CM_CMYK_COLOR     0x00000004
#endif
#define ICM_ON 2
#define ICM_OFF 1
#define ICM_QUERY 3
#define NEWFRAME	1
#define ABORTDOC	2
#define NEXTBAND	3
#define SETCOLORTABLE	4
#define GETCOLORTABLE	5
#define FLUSHOUTPUT	6
#define DRAFTMODE	7
#define QUERYESCSUPPORT	8
#define SETABORTPROC	9
#define STARTDOC	10
#define ENDDOC	11
#define GETPHYSPAGESIZE	12
#define GETPRINTINGOFFSET	13
#define GETSCALINGFACTOR	14
#define MFCOMMENT	15
#define GETPENWIDTH	16
#define SETCOPYCOUNT	17
#define SELECTPAPERSOURCE	18
#define DEVICEDATA	19
#define PASSTHROUGH	19
#define GETTECHNOLGY	20
#define GETTECHNOLOGY	20
#define SETLINECAP	21
#define SETLINEJOIN	22
#define SETMITERLIMIT	23
#define BANDINFO	24
#define DRAWPATTERNRECT	25
#define GETVECTORPENSIZE	26
#define GETVECTORBRUSHSIZE	27
#define ENABLEDUPLEX	28
#define GETSETPAPERBINS	29
#define GETSETPRINTORIENT	30
#define ENUMPAPERBINS	31
#define SETDIBSCALING	32
#define EPSPRINTING	33
#define ENUMPAPERMETRICS	34
#define GETSETPAPERMETRICS	35
#define POSTSCRIPT_DATA	37
#define POSTSCRIPT_IGNORE	38
#define MOUSETRAILS	39
#define GETDEVICEUNITS	42
#define GETEXTENDEDTEXTMETRICS	256
#define GETEXTENTTABLE	257
#define GETPAIRKERNTABLE	258
#define GETTRACKKERNTABLE	259
#define EXTTEXTOUT	512
#define GETFACENAME	513
#define DOWNLOADFACE	514
#define ENABLERELATIVEWIDTHS	768
#define ENABLEPAIRKERNING	769
#define SETKERNTRACK	770
#define SETALLJUSTVALUES	771
#define SETCHARSET	772
#define STRETCHBLT	2048
#define GETSETSCREENPARAMS	3072
#define QUERYDIBSUPPORT	3073
#define BEGIN_PATH	4096
#define CLIP_TO_PATH	4097
#define END_PATH	4098
#define EXT_DEVICE_CAPS	4099
#define RESTORE_CTM	4100
#define SAVE_CTM	4101
#define SET_ARC_DIRECTION	4102
#define SET_BACKGROUND_COLOR	4103
#define SET_POLY_MODE	4104
#define SET_SCREEN_ANGLE	4105
#define SET_SPREAD	4106
#define TRANSFORM_CTM	4107
#define SET_CLIP_BOX	4108
#define SET_BOUNDS	4109
#define SET_MIRROR_MODE	4110
#define OPENCHANNEL	4110
#define DOWNLOADHEADER	4111
#define CLOSECHANNEL	4112
#define POSTSCRIPT_PASSTHROUGH	4115
#define ENCAPSULATED_POSTSCRIPT	4116
#define QDI_SETDIBITS	1
#define QDI_GETDIBITS	2
#define QDI_DIBTOSCREEN	4
#define QDI_STRETCHDIB	8
#define SP_NOTREPORTED	0x4000
#define PR_JOBSTATUS	0
#define ASPECT_FILTERING	1
#define GS_8BIT_INDICES     0x00000001
#define GGI_MARK_NONEXISTING_GLYPHS  0X0001
#define BS_SOLID	0
#define BS_NULL	1
#define BS_HOLLOW	1
#define BS_HATCHED	2
#define BS_PATTERN	3
#define BS_INDEXED	4
#define BS_DIBPATTERN	5
#define BS_DIBPATTERNPT	6
#define BS_PATTERN8X8	7
#define BS_DIBPATTERN8X8	8
#define BS_MONOPATTERN	9
#define LCS_CALIBRATED_RGB	0
#define LCS_DEVICE_RGB	1
#define LCS_DEVICE_CMYK	2
#define LCS_GM_BUSINESS	1
#define LCS_GM_GRAPHICS	2
#define LCS_GM_IMAGES	4
#define LCS_GM_ABS_COLORIMETRIC 8
#define LCS_SIGNATURE   0x50534F43 // 'PSOC'
#define LCS_sRGB        'sRGB'
#define LCS_WINDOWS_COLOR_SPACE 'Win '
#define RASTER_FONTTYPE	1
#define DEVICE_FONTTYPE	2
#define TRUETYPE_FONTTYPE	4
#define DMORIENT_PORTRAIT   1
#define DMORIENT_LANDSCAPE  2
#define DMPAPER_FIRST	1
#define DMPAPER_LETTER	1
#define DMPAPER_LETTERSMALL	2
#define DMPAPER_TABLOID	3
#define DMPAPER_LEDGER	4
#define DMPAPER_LEGAL	5
#define DMPAPER_STATEMENT	6
#define DMPAPER_EXECUTIVE	7
#define DMPAPER_A3	8
#define DMPAPER_A4	9
#define DMPAPER_A4SMALL	10
#define DMPAPER_A5	11
#define DMPAPER_B4	12
#define DMPAPER_B5	13
#define DMPAPER_FOLIO	14
#define DMPAPER_QUARTO	15
#define DMPAPER_10X14	16
#define DMPAPER_11X17	17
#define DMPAPER_NOTE	18
#define DMPAPER_ENV_9	19
#define DMPAPER_ENV_10	20
#define DMPAPER_ENV_11	21
#define DMPAPER_ENV_12	22
#define DMPAPER_ENV_14	23
#define DMPAPER_CSHEET	24
#define DMPAPER_DSHEET	25
#define DMPAPER_ESHEET	26
#define DMPAPER_ENV_DL	27
#define DMPAPER_ENV_C5	28
#define DMPAPER_ENV_C3	29
#define DMPAPER_ENV_C4	30
#define DMPAPER_ENV_C6	31
#define DMPAPER_ENV_C65	32
#define DMPAPER_ENV_B4	33
#define DMPAPER_ENV_B5	34
#define DMPAPER_ENV_B6	35
#define DMPAPER_ENV_ITALY	36
#define DMPAPER_ENV_MONARCH	37
#define DMPAPER_ENV_PERSONAL	38
#define DMPAPER_FANFOLD_US	39
#define DMPAPER_FANFOLD_STD_GERMAN	40
#define DMPAPER_FANFOLD_LGL_GERMAN	41
#define DMPAPER_ISO_B4	42
#define DMPAPER_JAPANESE_POSTCARD	43
#define DMPAPER_9X11	44
#define DMPAPER_10X11	45
#define DMPAPER_15X11	46
#define DMPAPER_ENV_INVITE	47
#define DMPAPER_RESERVED_48	48
#define DMPAPER_RESERVED_49	49
#define DMPAPER_LETTER_EXTRA	50
#define DMPAPER_LEGAL_EXTRA	51
#define DMPAPER_TABLOID_EXTRA	52
#define DMPAPER_A4_EXTRA	53
#define DMPAPER_LETTER_TRANSVERSE	54
#define DMPAPER_A4_TRANSVERSE	55
#define DMPAPER_LETTER_EXTRA_TRANSVERSE	56
#define DMPAPER_A_PLUS	57
#define DMPAPER_B_PLUS	58
#define DMPAPER_LETTER_PLUS	59
#define DMPAPER_A4_PLUS	60
#define DMPAPER_A5_TRANSVERSE	61
#define DMPAPER_B5_TRANSVERSE	62
#define DMPAPER_A3_EXTRA	63
#define DMPAPER_A5_EXTRA	64
#define DMPAPER_B5_EXTRA	65
#define DMPAPER_A2	66
#define DMPAPER_A3_TRANSVERSE	67
#define DMPAPER_A3_EXTRA_TRANSVERSE	68
#define DMPAPER_LAST	68
#define DMPAPER_USER	256
#define DMBIN_FIRST	1
#define DMBIN_UPPER	1
#define DMBIN_ONLYONE	1
#define DMBIN_LOWER	2
#define DMBIN_MIDDLE	3
#define DMBIN_MANUAL	4
#define DMBIN_ENVELOPE	5
#define DMBIN_ENVMANUAL	6
#define DMBIN_AUTO	7
#define DMBIN_TRACTOR	8
#define DMBIN_SMALLFMT	9
#define DMBIN_LARGEFMT	10
#define DMBIN_LARGECAPACITY	11
#define DMBIN_CASSETTE	14
#define DMBIN_FORMSOURCE	15
#define DMBIN_LAST	15
#define DMBIN_USER	256
#define DMRES_DRAFT	(-1)
#define DMRES_LOW	(-2)
#define DMRES_MEDIUM	(-3)
#define DMRES_HIGH	(-4)
#define DMCOLOR_MONOCHROME	1
#define DMCOLOR_COLOR	2
#define DMDUP_SIMPLEX	1
#define DMDUP_VERTICAL	2
#define DMDUP_HORIZONTAL	3
#define DMTT_BITMAP	1
#define DMTT_DOWNLOAD	2
#define DMTT_SUBDEV	3
#define DMTT_DOWNLOAD_OUTLINE	4
#define DMCOLLATE_FALSE	0
#define DMCOLLATE_TRUE	1


#define DMDO_DEFAULT    0
#define DMDO_90         1
#define DMDO_180        2
#define DMDO_270        3

#define DMDFO_DEFAULT   0
#define DMDFO_STRETCH   1
#define DMDFO_CENTER    2


#define DM_GRAYSCALE            0x00000001
#define DM_INTERLACED           0x00000002
#define DMDISPLAYFLAGS_TEXTMODE 0x00000004


#define DM_UPDATE	1
#define DM_COPY	2
#define DM_PROMPT	4
#define DM_MODIFY	8
#define DM_IN_BUFFER	DM_MODIFY
#define DM_IN_PROMPT	DM_PROMPT
#define DM_OUT_BUFFER	DM_COPY
#define DM_OUT_DEFAULT	DM_UPDATE


#if (WINVER >= 0x0500) || (_WIN32_WINNT >= _WIN32_WINNT_NT4)
#define DM_SPECVERSION 0x0401
#elif (WINVER >= 0x0400)
#define DM_SPECVERSION 0x0400
#else
#define DM_SPECVERSION 0x0320
#endif

#define DM_ORIENTATION        0x00000001
#define DM_PAPERSIZE          0x00000002
#define DM_PAPERLENGTH        0x00000004
#define DM_PAPERWIDTH         0x00000008
#define DM_SCALE              0x00000010
#define DM_POSITION           0x00000020
#define DM_NUP                0x00000040
#define DM_DISPLAYORIENTATION 0x00000080
#define DM_COPIES             0x00000100
#define DM_DEFAULTSOURCE      0x00000200
#define DM_PRINTQUALITY       0x00000400
#define DM_COLOR              0x00000800
#define DM_DUPLEX             0x00001000
#define DM_YRESOLUTION        0x00002000
#define DM_TTOPTION           0x00004000
#define DM_COLLATE            0x00008000
#define DM_FORMNAME           0x00010000
#define DM_LOGPIXELS          0x00020000
#define DM_BITSPERPEL         0x00040000
#define DM_PELSWIDTH          0x00080000
#define DM_PELSHEIGHT         0x00100000
#define DM_DISPLAYFLAGS       0x00200000
#define DM_DISPLAYFREQUENCY   0x00400000
#define DM_ICMMETHOD          0x00800000
#define DM_ICMINTENT          0x01000000
#define DM_MEDIATYPE          0x02000000
#define DM_DITHERTYPE         0x04000000
#define DM_PANNINGWIDTH       0x08000000
#define DM_PANNINGHEIGHT      0x10000000
#if (WINVER >= 0x0501)
#define DM_DISPLAYFIXEDOUTPUT 0x20000000
#endif

#define QDC_ALL_PATHS 0x00000001

#define DMICMMETHOD_NONE	1
#define DMICMMETHOD_SYSTEM	2
#define DMICMMETHOD_DRIVER	3
#define DMICMMETHOD_DEVICE	4
#define DMICMMETHOD_USER	256
#define DMICM_SATURATE	1
#define DMICM_CONTRAST	2
#define DMICM_COLORMETRIC	3
#define DMICM_USER	256
#define DMMEDIA_STANDARD	1
#define DMMEDIA_TRANSPARENCY	2
#define DMMEDIA_GLOSSY	3
#define DMMEDIA_USER	256
#define DMDITHER_NONE	1
#define DMDITHER_COARSE	2
#define DMDITHER_FINE	3
#define DMDITHER_LINEART	4
#define DMDITHER_ERRORDIFFUSION	5
#define DMDITHER_RESERVED6	6
#define DMDITHER_RESERVED7	7
#define DMDITHER_RESERVED8	8
#define DMDITHER_RESERVED9	9
#define DMDITHER_GRAYSCALE	10
#define DMDITHER_USER	256
#define GDI_ERROR 0xFFFFFFFF
#define HGDI_ERROR ((HANDLE)GDI_ERROR)
#define TMPF_FIXED_PITCH 1
#define TMPF_VECTOR 2
#define TMPF_TRUETYPE 4
#define TMPF_DEVICE 8
#define NTM_ITALIC 1
#define NTM_BOLD 32
#define NTM_REGULAR 64
#define TT_POLYGON_TYPE 24
#define TT_PRIM_LINE 1
#define TT_PRIM_QSPLINE 2
#define TT_PRIM_CSPLINE 3
#define FONTMAPPER_MAX 10
#define ENHMETA_STOCK_OBJECT 0x80000000
#define WGL_FONT_LINES 0
#define WGL_FONT_POLYGONS 1
#define LPD_DOUBLEBUFFER 1
#define LPD_STEREO 2
#define LPD_SUPPORT_GDI 16
#define LPD_SUPPORT_OPENGL 32
#define LPD_SHARE_DEPTH 64
#define LPD_SHARE_STENCIL 128
#define LPD_SHARE_ACCUM 256
#define LPD_SWAP_EXCHANGE 512
#define LPD_SWAP_COPY 1024
#define LPD_TRANSPARENT 4096
#define LPD_TYPE_RGBA 0
#define LPD_TYPE_COLORINDEX 1
#define WGL_SWAP_MAIN_PLANE 1
#define WGL_SWAP_OVERLAY1 2
#define WGL_SWAP_OVERLAY2 4
#define WGL_SWAP_OVERLAY3 8
#define WGL_SWAP_OVERLAY4 16
#define WGL_SWAP_OVERLAY5 32
#define WGL_SWAP_OVERLAY6 64
#define WGL_SWAP_OVERLAY7 128
#define WGL_SWAP_OVERLAY8 256
#define WGL_SWAP_OVERLAY9 512
#define WGL_SWAP_OVERLAY10 1024
#define WGL_SWAP_OVERLAY11 2048
#define WGL_SWAP_OVERLAY12 4096
#define WGL_SWAP_OVERLAY13 8192
#define WGL_SWAP_OVERLAY14 16384
#define WGL_SWAP_OVERLAY15 32768
#define WGL_SWAP_UNDERLAY1 65536
#define WGL_SWAP_UNDERLAY2 0x20000
#define WGL_SWAP_UNDERLAY3 0x40000
#define WGL_SWAP_UNDERLAY4 0x80000
#define WGL_SWAP_UNDERLAY5 0x100000
#define WGL_SWAP_UNDERLAY6 0x200000
#define WGL_SWAP_UNDERLAY7 0x400000
#define WGL_SWAP_UNDERLAY8 0x800000
#define WGL_SWAP_UNDERLAY9 0x1000000
#define WGL_SWAP_UNDERLAY10 0x2000000
#define WGL_SWAP_UNDERLAY11 0x4000000
#define WGL_SWAP_UNDERLAY12 0x8000000
#define WGL_SWAP_UNDERLAY13 0x10000000
#define WGL_SWAP_UNDERLAY14 0x20000000
#define WGL_SWAP_UNDERLAY15 0x40000000
#define AC_SRC_OVER 0
#define LAYOUT_LTR 0
#define LAYOUT_RTL 1 // Right to left
#define LAYOUT_BTT 2 // Bottom to top
#define LAYOUT_VBH 4 // Vertical before horizontal
#define LAYOUT_ORIENTATIONMASK (LAYOUT_RTL | LAYOUT_BTT | LAYOUT_VBH)
#define LAYOUT_BITMAPORIENTATIONPRESERVED 8
#define CAPTUREBLT 0x40000000
#define NOMIRRORBITMAP 0x80000000
#if (WINVER > 0x400)
#define CS_ENABLE           0x00000001
#define CS_DISABLE          0x00000002
#define CS_DELETE_TRANSFORM 0x00000003
#endif



#if (WINVER > 0x500)
#define GRADIENT_FILL_RECT_H 0x00
#define GRADIENT_FILL_RECT_V 0x01
#define GRADIENT_FILL_TRIANGLE 0x02
#define GRADIENT_FILL_OP_FLAG 0xff
#define COLORMATCHTOTARGET_EMBEDED 0x00000001
#define CREATECOLORSPACE_EMBEDED   0x00000001
#define SETICMPROFILE_EMBEDED      0x00000001
#endif

#define DISPLAY_DEVICE_ATTACHED_TO_DESKTOP 0x00000001
#define DISPLAY_DEVICE_MULTI_DRIVER        0x00000002
#define DISPLAY_DEVICE_PRIMARY_DEVICE      0x00000004
#define DISPLAY_DEVICE_MIRRORING_DRIVER    0x00000008
#define DISPLAY_DEVICE_VGA_COMPATIBLE      0x00000010
#define DISPLAY_DEVICE_REMOVABLE           0x00000020
#define DISPLAY_DEVICE_DISCONNECT          0x02000000
#define DISPLAY_DEVICE_REMOTE              0x04000000
#define DISPLAY_DEVICE_MODESPRUNED         0x08000000
#ifndef RC_INVOKED
typedef struct _ABC {
	int abcA;
	UINT abcB;
	int abcC;
} ABC, *PABC, *LPABC;
typedef struct _ABCFLOAT {
	FLOAT abcfA;
	FLOAT abcfB;
	FLOAT abcfC;
} ABCFLOAT, *PABCFLOAT, *LPABCFLOAT;
typedef struct tagBITMAP {
	LONG	bmType;
	LONG	bmWidth;
	LONG	bmHeight;
	LONG	bmWidthBytes;
	WORD	bmPlanes;
	WORD	bmBitsPixel;
	LPVOID	bmBits;
} BITMAP,*PBITMAP,*LPBITMAP;
typedef struct tagBITMAPCOREHEADER {
	DWORD	bcSize;
	WORD	bcWidth;
	WORD	bcHeight;
	WORD	bcPlanes;
	WORD	bcBitCount;
} BITMAPCOREHEADER,*LPBITMAPCOREHEADER,*PBITMAPCOREHEADER;
#include "pshpack1.h"
typedef struct tagRGBTRIPLE {
	BYTE rgbtBlue;
	BYTE rgbtGreen;
	BYTE rgbtRed;
} RGBTRIPLE,*LPRGBTRIPLE;
#include "poppack.h"
#include "pshpack2.h"
typedef struct tagBITMAPFILEHEADER {
	WORD	bfType;
	DWORD	bfSize;
	WORD	bfReserved1;
	WORD	bfReserved2;
	DWORD	bfOffBits;
} BITMAPFILEHEADER,*LPBITMAPFILEHEADER,*PBITMAPFILEHEADER;
#include "poppack.h"
typedef struct _BITMAPCOREINFO {
	BITMAPCOREHEADER	bmciHeader;
	RGBTRIPLE	bmciColors[1];
} BITMAPCOREINFO,*LPBITMAPCOREINFO,*PBITMAPCOREINFO;
typedef struct tagBITMAPINFOHEADER{
	DWORD	biSize;
	LONG	biWidth;
	LONG	biHeight;
	WORD	biPlanes;
	WORD	biBitCount;
	DWORD	biCompression;
	DWORD	biSizeImage;
	LONG	biXPelsPerMeter;
	LONG	biYPelsPerMeter;
	DWORD	biClrUsed;
	DWORD	biClrImportant;
} BITMAPINFOHEADER,*LPBITMAPINFOHEADER,*PBITMAPINFOHEADER;
typedef struct tagRGBQUAD {
	BYTE	rgbBlue;
	BYTE	rgbGreen;
	BYTE	rgbRed;
	BYTE	rgbReserved;
} RGBQUAD,*LPRGBQUAD;
typedef struct tagBITMAPINFO {
	BITMAPINFOHEADER bmiHeader;
	RGBQUAD bmiColors[1];
} BITMAPINFO,*LPBITMAPINFO,*PBITMAPINFO;
typedef long FXPT16DOT16,*LPFXPT16DOT16;
typedef long FXPT2DOT30,*LPFXPT2DOT30;
typedef struct tagCIEXYZ {
	FXPT2DOT30 ciexyzX;
	FXPT2DOT30 ciexyzY;
	FXPT2DOT30 ciexyzZ;
} CIEXYZ,*LPCIEXYZ;
typedef struct tagCIEXYZTRIPLE {
	CIEXYZ ciexyzRed;
	CIEXYZ ciexyzGreen;
	CIEXYZ ciexyzBlue;
} CIEXYZTRIPLE,*LPCIEXYZTRIPLE;
typedef struct {
	DWORD	bV4Size;
	LONG	bV4Width;
	LONG	bV4Height;
	WORD	bV4Planes;
	WORD	bV4BitCount;
	DWORD	bV4V4Compression;
	DWORD	bV4SizeImage;
	LONG	bV4XPelsPerMeter;
	LONG	bV4YPelsPerMeter;
	DWORD	bV4ClrUsed;
	DWORD	bV4ClrImportant;
	DWORD	bV4RedMask;
	DWORD	bV4GreenMask;
	DWORD	bV4BlueMask;
	DWORD	bV4AlphaMask;
	DWORD	bV4CSType;
	CIEXYZTRIPLE bV4Endpoints;
	DWORD	bV4GammaRed;
	DWORD	bV4GammaGreen;
	DWORD	bV4GammaBlue;
} BITMAPV4HEADER,*LPBITMAPV4HEADER,*PBITMAPV4HEADER;
#if (WINVER >= 0x500)
typedef struct {
	DWORD	bV5Size;
	LONG	bV5Width;
	LONG	bV5Height;
	WORD	bV5Planes;
	WORD	bV5BitCount;
	DWORD	bV5Compression;
	DWORD	bV5SizeImage;
	LONG	bV5XPelsPerMeter;
	LONG	bV5YPelsPerMeter;
	DWORD	bV5ClrUsed;
	DWORD	bV5ClrImportant;
	DWORD	bV5RedMask;
	DWORD	bV5GreenMask;
	DWORD	bV5BlueMask;
	DWORD	bV5AlphaMask;
	DWORD	bV5CSType;
	CIEXYZTRIPLE	bV5Endpoints;
	DWORD	bV5GammaRed;
	DWORD	bV5GammaGreen;
	DWORD	bV5GammaBlue;
	DWORD	bV5Intent;
	DWORD	bV5ProfileData;
	DWORD	bV5ProfileSize;
	DWORD	bV5Reserved;
} BITMAPV5HEADER,*LPBITMAPV5HEADER,*PBITMAPV5HEADER;
#endif
typedef struct tagFONTSIGNATURE {
	DWORD	fsUsb[4];
	DWORD	fsCsb[2];
} FONTSIGNATURE, *PFONTSIGNATURE,*LPFONTSIGNATURE;
typedef struct tagCHARSETINFO {
	UINT ciCharset;
	UINT ciACP;
	FONTSIGNATURE fs;
} CHARSETINFO, *PCHARSETINFO, *LPCHARSETINFO;
typedef struct  tagCOLORADJUSTMENT {
	WORD	caSize;
	WORD	caFlags;
	WORD	caIlluminantIndex;
	WORD	caRedGamma;
	WORD	caGreenGamma;
	WORD	caBlueGamma;
	WORD	caReferenceBlack;
	WORD	caReferenceWhite;
	SHORT	caContrast;
	SHORT	caBrightness;
	SHORT	caColorfulness;
	SHORT	caRedGreenTint;
} COLORADJUSTMENT, *PCOLORADJUSTMENT, FAR *LPCOLORADJUSTMENT;
typedef struct _devicemodeA {
  BYTE   dmDeviceName[CCHDEVICENAME];
  WORD   dmSpecVersion;
  WORD   dmDriverVersion;
  WORD   dmSize;
  WORD   dmDriverExtra;
  DWORD  dmFields;
  _ANONYMOUS_UNION union {
    _ANONYMOUS_STRUCT struct {
      short dmOrientation;
      short dmPaperSize;
      short dmPaperLength;
      short dmPaperWidth;
      short dmScale;
      short dmCopies;
      short dmDefaultSource;
      short dmPrintQuality;
    } DUMMYSTRUCTNAME1;
    struct {
      POINTL dmPosition;
      DWORD  dmDisplayOrientation;
      DWORD  dmDisplayFixedOutput;
    } DUMMYSTRUCTNAME2;
  } DUMMYUNIONNAME1;
  short  dmColor;
  short  dmDuplex;
  short  dmYResolution;
  short  dmTTOption;
  short  dmCollate;
  BYTE   dmFormName[CCHFORMNAME];
  WORD   dmLogPixels;
  DWORD  dmBitsPerPel;
  DWORD  dmPelsWidth;
  DWORD  dmPelsHeight;
  _ANONYMOUS_UNION union {
    DWORD  dmDisplayFlags;
    DWORD  dmNup;
  } DUMMYUNIONNAME2;
  DWORD  dmDisplayFrequency;
#if(WINVER >= 0x0400)
  DWORD  dmICMMethod;
  DWORD  dmICMIntent;
  DWORD  dmMediaType;
  DWORD  dmDitherType;
  DWORD  dmReserved1;
  DWORD  dmReserved2;
#if (WINVER >= 0x0500) || (_WIN32_WINNT >= 0x0400)
  DWORD  dmPanningWidth;
  DWORD  dmPanningHeight;
#endif
#endif /* WINVER >= 0x0400 */
} DEVMODEA,*LPDEVMODEA,*PDEVMODEA;
typedef struct _devicemodeW {
  WCHAR   dmDeviceName[CCHDEVICENAME];
  WORD   dmSpecVersion;
  WORD   dmDriverVersion;
  WORD   dmSize;
  WORD   dmDriverExtra;
  DWORD  dmFields;
  _ANONYMOUS_UNION union {
    _ANONYMOUS_STRUCT struct {
      short dmOrientation;
      short dmPaperSize;
      short dmPaperLength;
      short dmPaperWidth;
      short dmScale;
      short dmCopies;
      short dmDefaultSource;
      short dmPrintQuality;
    } DUMMYSTRUCTNAME1;
    struct {
      POINTL dmPosition;
      DWORD  dmDisplayOrientation;
      DWORD  dmDisplayFixedOutput;
    } DUMMYSTRUCTNAME2;
  } DUMMYUNIONNAME1;
  short  dmColor;
  short  dmDuplex;
  short  dmYResolution;
  short  dmTTOption;
  short  dmCollate;
  WCHAR  dmFormName[CCHFORMNAME];
  WORD   dmLogPixels;
  DWORD  dmBitsPerPel;
  DWORD  dmPelsWidth;
  DWORD  dmPelsHeight;
  _ANONYMOUS_UNION union {
    DWORD  dmDisplayFlags;
    DWORD  dmNup;
  } DUMMYUNIONNAME2;
  DWORD  dmDisplayFrequency;
#if(WINVER >= 0x0400)
  DWORD  dmICMMethod;
  DWORD  dmICMIntent;
  DWORD  dmMediaType;
  DWORD  dmDitherType;
  DWORD  dmReserved1;
  DWORD  dmReserved2;
#if (WINVER >= 0x0500) || (_WIN32_WINNT >= 0x0400)
  DWORD  dmPanningWidth;
  DWORD  dmPanningHeight;
#endif
#endif /* WINVER >= 0x0400 */
} DEVMODEW,*LPDEVMODEW,*PDEVMODEW,*NPDEVMODEW;
typedef struct tagDIBSECTION {
	BITMAP dsBm;
	BITMAPINFOHEADER dsBmih;
	DWORD dsBitfields[3];
	HANDLE dshSection;
	DWORD dsOffset;
} DIBSECTION,*PDIBSECTION,*LPDIBSECTION;
typedef struct _DOCINFOA {
	int cbSize;
	LPCSTR lpszDocName;
	LPCSTR lpszOutput;
	LPCSTR lpszDatatype;
	DWORD fwType;
} DOCINFOA,*LPDOCINFOA;
typedef struct _DOCINFOW {
	int cbSize;
	LPCWSTR lpszDocName;
	LPCWSTR lpszOutput;
	LPCWSTR lpszDatatype;
	DWORD fwType;
} DOCINFOW,*LPDOCINFOW;
typedef struct tagEMR {
	DWORD iType;
	DWORD nSize;
} EMR,*PEMR;

#if(WINVER >= 0x0400)
typedef struct tagEMRGLSRECORD {
	EMR emr;
	DWORD cbData;
	BYTE Data[1];
} EMRGLSRECORD, *PEMRGLSRECORD;
typedef struct tagEMRGLSBOUNDEDRECORD {
	EMR emr;
	RECTL rclBounds;
	DWORD cbData;
	BYTE Data[1];
} EMRGLSBOUNDEDRECORD, *PEMRGLSBOUNDEDRECORD;
#endif
typedef struct tagEMRANGLEARC {
	EMR emr;
	POINTL ptlCenter;
	DWORD nRadius;
	FLOAT eStartAngle;
	FLOAT eSweepAngle;
} EMRANGLEARC,*PEMRANGLEARC;
typedef struct tagEMRARC {
	EMR emr;
	RECTL rclBox;
	POINTL ptlStart;
	POINTL ptlEnd;
} EMRARC,*PEMRARC,EMRARCTO,*PEMRARCTO,EMRCHORD,*PEMRCHORD,EMRPIE,*PEMRPIE;
typedef struct  _XFORM {
	FLOAT eM11;
	FLOAT eM12;
	FLOAT eM21;
	FLOAT eM22;
	FLOAT eDx;
	FLOAT eDy;
} XFORM,*PXFORM,*LPXFORM;
typedef struct tagEMRBITBLT {
	EMR emr;
	RECTL rclBounds;
	LONG xDest;
	LONG yDest;
	LONG cxDest;
	LONG cyDest;
	DWORD dwRop;
	LONG xSrc;
	LONG ySrc;
	XFORM xformSrc;
	COLORREF crBkColorSrc;
    DWORD iUsageSrc;
	DWORD offBmiSrc;
	DWORD cbBmiSrc;
	DWORD offBitsSrc;
	DWORD cbBitsSrc;
} EMRBITBLT,*PEMRBITBLT;
typedef struct tagLOGBRUSH {
	UINT lbStyle;
	COLORREF lbColor;
	ULONG_PTR lbHatch;
} LOGBRUSH,*PLOGBRUSH,*LPLOGBRUSH;
typedef LOGBRUSH PATTERN,*PPATTERN,*LPPATTERN;
typedef struct tagLOGBRUSH32 {
	UINT lbStyle;
	COLORREF lbColor;
	ULONG lbHatch;
} LOGBRUSH32, *PLOGBRUSH32;
typedef struct tagEMRCREATEBRUSHINDIRECT {
	EMR emr;
	DWORD ihBrush;
	LOGBRUSH32 lb;
} EMRCREATEBRUSHINDIRECT,*PEMRCREATEBRUSHINDIRECT;
typedef LONG LCSCSTYPE;
typedef LONG LCSGAMUTMATCH;
typedef struct tagLOGCOLORSPACEA {
	DWORD lcsSignature;
	DWORD lcsVersion;
	DWORD lcsSize;
	LCSCSTYPE lcsCSType;
	LCSGAMUTMATCH lcsIntent;
	CIEXYZTRIPLE lcsEndpoints;
	DWORD lcsGammaRed;
	DWORD lcsGammaGreen;
	DWORD lcsGammaBlue;
	CHAR lcsFilename[MAX_PATH];
} LOGCOLORSPACEA,*LPLOGCOLORSPACEA;
typedef struct tagLOGCOLORSPACEW {
	DWORD lcsSignature;
	DWORD lcsVersion;
	DWORD lcsSize;
	LCSCSTYPE lcsCSType;
	LCSGAMUTMATCH lcsIntent;
	CIEXYZTRIPLE lcsEndpoints;
	DWORD lcsGammaRed;
	DWORD lcsGammaGreen;
	DWORD lcsGammaBlue;
	WCHAR lcsFilename[MAX_PATH];
} LOGCOLORSPACEW,*LPLOGCOLORSPACEW;
typedef struct tagEMRCREATECOLORSPACEW {
	EMR emr;
	DWORD ihCS;
	LOGCOLORSPACEW lcs;
	DWORD dwFlags;
	DWORD cbData;
	BYTE Data[1];
} EMRCREATECOLORSPACEW, *PEMRCREATECOLORSPACEW;
typedef struct tagEMRCREATECOLORSPACE {
	EMR emr;
	DWORD ihCS;
	LOGCOLORSPACEA lcs;
} EMRCREATECOLORSPACE,*PEMRCREATECOLORSPACE;
typedef struct tagEMRCREATEDIBPATTERNBRUSHPT {
	EMR emr;
	DWORD ihBrush;
	DWORD iUsage;
	DWORD offBmi;
	DWORD cbBmi;
	DWORD offBits;
	DWORD cbBits;
} EMRCREATEDIBPATTERNBRUSHPT,*PEMRCREATEDIBPATTERNBRUSHPT;
typedef struct tagEMRCREATEMONOBRUSH {
	EMR emr;
	DWORD ihBrush;
	DWORD iUsage;
	DWORD offBmi;
	DWORD cbBmi;
	DWORD offBits;
	DWORD cbBits;
} EMRCREATEMONOBRUSH,*PEMRCREATEMONOBRUSH;

#ifndef _PALETTEENTRY_DEFINED
#define _PALETTEENTRY_DEFINED
typedef struct tagPALETTEENTRY {
	BYTE peRed;
	BYTE peGreen;
	BYTE peBlue;
	BYTE peFlags;
} PALETTEENTRY,*LPPALETTEENTRY,*PPALETTEENTRY;
#endif

#ifndef _LOGPALETTE_DEFINED
#define _LOGPALETTE_DEFINED
typedef struct tagLOGPALETTE {
  WORD palVersion;
  WORD palNumEntries;
  _Field_size_opt_(palNumEntries) PALETTEENTRY palPalEntry[1];
} LOGPALETTE, *NPLOGPALETTE, *PLOGPALETTE, *LPLOGPALETTE;
#endif

typedef struct tagEMRCREATEPALETTE {
	EMR emr;
	DWORD ihPal;
	LOGPALETTE lgpl;
} EMRCREATEPALETTE,*PEMRCREATEPALETTE;
typedef struct tagLOGPEN {
	UINT lopnStyle;
	POINT lopnWidth;
	COLORREF lopnColor;
} LOGPEN,*PLOGPEN,*LPLOGPEN;
typedef struct tagEMRCREATEPEN {
	EMR emr;
	DWORD ihPen;
	LOGPEN lopn;
} EMRCREATEPEN,*PEMRCREATEPEN;
typedef struct tagEMRELLIPSE {
	EMR emr;
	RECTL rclBox;
} EMRELLIPSE,*PEMRELLIPSE,EMRRECTANGLE,*PEMRRECTANGLE;
typedef struct tagEMREOF {
	EMR emr;
	DWORD nPalEntries;
	DWORD offPalEntries;
	DWORD nSizeLast;
} EMREOF,*PEMREOF;
typedef struct tagEMREXCLUDECLIPRECT {
	EMR emr;
	RECTL rclClip;
} EMREXCLUDECLIPRECT,*PEMREXCLUDECLIPRECT,EMRINTERSECTCLIPRECT,*PEMRINTERSECTCLIPRECT;
typedef struct tagPANOSE {
	BYTE bFamilyType;
	BYTE bSerifStyle;
	BYTE bWeight;
	BYTE bProportion;
	BYTE bContrast;
	BYTE bStrokeVariation;
	BYTE bArmStyle;
	BYTE bLetterform;
	BYTE bMidline;
	BYTE bXHeight;
} PANOSE, *LPPANOSE;
typedef struct tagLOGFONTA {
	LONG	lfHeight;
	LONG	lfWidth;
	LONG	lfEscapement;
	LONG	lfOrientation;
	LONG	lfWeight;
	BYTE	lfItalic;
	BYTE	lfUnderline;
	BYTE	lfStrikeOut;
	BYTE	lfCharSet;
	BYTE	lfOutPrecision;
	BYTE	lfClipPrecision;
	BYTE	lfQuality;
	BYTE	lfPitchAndFamily;
	CHAR	lfFaceName[LF_FACESIZE];
} LOGFONTA,*PLOGFONTA,*LPLOGFONTA;
typedef struct tagLOGFONTW {
	LONG	lfHeight;
	LONG	lfWidth;
	LONG	lfEscapement;
	LONG	lfOrientation;
	LONG	lfWeight;
	BYTE	lfItalic;
	BYTE	lfUnderline;
	BYTE	lfStrikeOut;
	BYTE	lfCharSet;
	BYTE	lfOutPrecision;
	BYTE	lfClipPrecision;
	BYTE	lfQuality;
	BYTE	lfPitchAndFamily;
	WCHAR	lfFaceName[LF_FACESIZE];
} LOGFONTW,*PLOGFONTW,*LPLOGFONTW;
typedef struct tagEXTLOGFONTA {
	LOGFONTA	elfLogFont;
	BYTE	elfFullName[LF_FULLFACESIZE];
	BYTE	elfStyle[LF_FACESIZE];
	DWORD	elfVersion;
	DWORD	elfStyleSize;
	DWORD	elfMatch;
	DWORD	elfReserved;
	BYTE	elfVendorId[ELF_VENDOR_SIZE];
	DWORD	elfCulture;
	PANOSE	elfPanose;
} EXTLOGFONTA,*PEXTLOGFONTA,*LPEXTLOGFONTA;
typedef struct tagEXTLOGFONTW {
	LOGFONTW	elfLogFont;
	WCHAR	elfFullName[LF_FULLFACESIZE];
	WCHAR	elfStyle[LF_FACESIZE];
	DWORD	elfVersion;
	DWORD	elfStyleSize;
	DWORD	elfMatch;
	DWORD	elfReserved;
	BYTE	elfVendorId[ELF_VENDOR_SIZE];
	DWORD	elfCulture;
	PANOSE	elfPanose;
} EXTLOGFONTW,*PEXTLOGFONTW,*LPEXTLOGFONTW;
typedef struct tagEMREXTCREATEFONTINDIRECTW {
	EMR emr;
	DWORD ihFont;
	EXTLOGFONTW elfw;
} EMREXTCREATEFONTINDIRECTW,*PEMREXTCREATEFONTINDIRECTW;
typedef struct tagEXTLOGPEN {
	DWORD elpPenStyle;
	DWORD elpWidth;
	UINT elpBrushStyle;
	COLORREF elpColor;
	ULONG_PTR elpHatch;
	DWORD elpNumEntries;
	DWORD elpStyleEntry[1];
} EXTLOGPEN,*PEXTLOGPEN,*LPEXTLOGPEN,*NPEXTLOGPEN;
typedef struct tagEMREXTCREATEPEN {
	EMR emr;
	DWORD ihPen;
	DWORD offBmi;
	DWORD cbBmi;
	DWORD offBits;
	DWORD cbBits;
	EXTLOGPEN elp;
} EMREXTCREATEPEN,*PEMREXTCREATEPEN;
typedef struct tagEMREXTFLOODFILL {
	EMR emr;
	POINTL ptlStart;
	COLORREF crColor;
	DWORD iMode;
} EMREXTFLOODFILL,*PEMREXTFLOODFILL;
typedef struct tagEMREXTSELECTCLIPRGN {
	EMR emr;
	DWORD cbRgnData;
	DWORD iMode;
	BYTE RgnData[1];
} EMREXTSELECTCLIPRGN,*PEMREXTSELECTCLIPRGN;
typedef struct tagEMRTEXT {
	POINTL ptlReference;
	DWORD nChars;
	DWORD offString;
	DWORD fOptions;
	RECTL rcl;
	DWORD offDx;
} EMRTEXT,*PEMRTEXT;
typedef struct tagEMREXTTEXTOUTA {
	EMR emr;
	RECTL rclBounds;
	DWORD iGraphicsMode;
	FLOAT exScale;
	FLOAT eyScale;
	EMRTEXT emrtext;
} EMREXTTEXTOUTA,*PEMREXTTEXTOUTA,EMREXTTEXTOUTW,*PEMREXTTEXTOUTW;
typedef struct tagEMRFILLPATH {
	EMR emr;
	RECTL rclBounds;
} EMRFILLPATH,*PEMRFILLPATH,EMRSTROKEANDFILLPATH,*PEMRSTROKEANDFILLPATH,EMRSTROKEPATH,*PEMRSTROKEPATH;
typedef struct tagEMRFILLRGN {
	EMR emr;
	RECTL rclBounds;
	DWORD cbRgnData;
	DWORD ihBrush;
	BYTE RgnData[1];
} EMRFILLRGN,*PEMRFILLRGN;
typedef struct tagEMRFORMAT   {
	DWORD dSignature;
	DWORD nVersion;
	DWORD cbData;
	DWORD offData;
} EMRFORMAT, *PEMRFORMAT;


typedef struct tagEMRSETCOLORSPACE
{
    EMR   emr;
    DWORD ihCS;
} EMRSETCOLORSPACE, *PEMRSETCOLORSPACE, EMRSELECTCOLORSPACE, *PEMRSELECTCOLORSPACE,
  EMRDELETECOLORSPACE, *PEMRDELETECOLORSPACE;

typedef struct tagEMRFRAMERGN {
	EMR emr;
	RECTL rclBounds;
	DWORD cbRgnData;
	DWORD ihBrush;
	SIZEL szlStroke;
	BYTE RgnData[1];
} EMRFRAMERGN,*PEMRFRAMERGN;
typedef struct tagEMRGDICOMMENT {
	EMR emr;
	DWORD cbData;
	BYTE Data[1];
} EMRGDICOMMENT,*PEMRGDICOMMENT;
typedef struct tagEMRINVERTRGN {
	EMR emr;
	RECTL rclBounds;
	DWORD cbRgnData;
	BYTE RgnData[1];
} EMRINVERTRGN,*PEMRINVERTRGN,EMRPAINTRGN,*PEMRPAINTRGN;
typedef struct tagEMRLINETO {
	EMR emr;
	POINTL ptl;
} EMRLINETO,*PEMRLINETO,EMRMOVETOEX,*PEMRMOVETOEX;
typedef struct tagEMRMASKBLT {
	EMR emr;
	RECTL rclBounds;
	LONG xDest;
	LONG yDest;
	LONG cxDest;
	LONG cyDest;
	DWORD dwRop;
	LONG xSrc;
	LONG ySrc;
	XFORM xformSrc;
	COLORREF crBkColorSrc;
	DWORD iUsageSrc;
	DWORD offBmiSrc;
	DWORD cbBmiSrc;
	DWORD offBitsSrc;
	DWORD cbBitsSrc;
	LONG xMask;
	LONG yMask;
	DWORD iUsageMask;
	DWORD offBmiMask;
	DWORD cbBmiMask;
	DWORD offBitsMask;
	DWORD cbBitsMask;
} EMRMASKBLT,*PEMRMASKBLT;
typedef struct tagEMRMODIFYWORLDTRANSFORM {
	EMR emr;
	XFORM xform;
	DWORD iMode;
} EMRMODIFYWORLDTRANSFORM,*PEMRMODIFYWORLDTRANSFORM;
typedef struct tagEMROFFSETCLIPRGN {
	EMR emr;
	POINTL ptlOffset;
} EMROFFSETCLIPRGN,*PEMROFFSETCLIPRGN;
typedef struct tagEMRPLGBLT {
	EMR emr;
	RECTL rclBounds;
	POINTL aptlDest[3];
	LONG xSrc;
	LONG ySrc;
	LONG cxSrc;
	LONG cySrc;
	XFORM xformSrc;
	COLORREF crBkColorSrc;
	DWORD iUsageSrc;
	DWORD offBmiSrc;
	DWORD cbBmiSrc;
	DWORD offBitsSrc;
	DWORD cbBitsSrc;
	LONG xMask;
	LONG yMask;
	DWORD iUsageMask;
	DWORD offBmiMask;
	DWORD cbBmiMask;
	DWORD offBitsMask;
	DWORD cbBitsMask;
} EMRPLGBLT,*PEMRPLGBLT;
typedef struct tagEMRPOLYDRAW {
	EMR emr;
	RECTL rclBounds;
	DWORD cptl;
	POINTL aptl[1];
	BYTE abTypes[1];
} EMRPOLYDRAW,*PEMRPOLYDRAW;
typedef struct tagEMRPOLYDRAW16 {
	EMR emr;
	RECTL rclBounds;
	DWORD cpts;
	POINTS apts[1];
	BYTE abTypes[1];
} EMRPOLYDRAW16,*PEMRPOLYDRAW16;
typedef struct tagEMRPOLYLINE {
	EMR emr;
	RECTL rclBounds;
	DWORD cptl;
	POINTL aptl[1];
} EMRPOLYLINE,*PEMRPOLYLINE,EMRPOLYBEZIER,*PEMRPOLYBEZIER,EMRPOLYGON,*PEMRPOLYGON,EMRPOLYBEZIERTO,*PEMRPOLYBEZIERTO,EMRPOLYLINETO,*PEMRPOLYLINETO;
typedef struct tagEMRPOLYLINE16 {
	EMR emr;
	RECTL rclBounds;
	DWORD cpts;
	POINTS apts[1];
} EMRPOLYLINE16,*PEMRPOLYLINE16,EMRPOLYBEZIER16,*PEMRPOLYBEZIER16,EMRPOLYGON16,*PEMRPOLYGON16,EMRPOLYBEZIERTO16,*PEMRPOLYBEZIERTO16,EMRPOLYLINETO16,*PEMRPOLYLINETO16;
typedef struct tagEMRPOLYPOLYLINE {
	EMR emr;
	RECTL rclBounds;
	DWORD nPolys;
	DWORD cptl;
	DWORD aPolyCounts[1];
	POINTL aptl[1];
} EMRPOLYPOLYLINE,*PEMRPOLYPOLYLINE,EMRPOLYPOLYGON,*PEMRPOLYPOLYGON;
typedef struct tagEMRPOLYPOLYLINE16 {
	EMR emr;
	RECTL rclBounds;
	DWORD nPolys;
	DWORD cpts;
	DWORD aPolyCounts[1];
	POINTS apts[1];
} EMRPOLYPOLYLINE16,*PEMRPOLYPOLYLINE16,EMRPOLYPOLYGON16,*PEMRPOLYPOLYGON16;
typedef struct tagEMRPOLYTEXTOUTA {
	EMR emr;
	RECTL rclBounds;
	DWORD iGraphicsMode;
	FLOAT exScale;
	FLOAT eyScale;
	LONG cStrings;
	EMRTEXT aemrtext[1];
} EMRPOLYTEXTOUTA,*PEMRPOLYTEXTOUTA,EMRPOLYTEXTOUTW,*PEMRPOLYTEXTOUTW;
typedef struct tagEMRRESIZEPALETTE {
	EMR emr;
	DWORD ihPal;
	DWORD cEntries;
} EMRRESIZEPALETTE,*PEMRRESIZEPALETTE;
typedef struct tagEMRRESTOREDC {
	EMR emr;
	LONG iRelative;
} EMRRESTOREDC,*PEMRRESTOREDC;
typedef struct tagEMRROUNDRECT {
	EMR emr;
	RECTL rclBox;
	SIZEL szlCorner;
} EMRROUNDRECT,*PEMRROUNDRECT;
typedef struct tagEMRSCALEVIEWPORTEXTEX {
	EMR emr;
	LONG xNum;
	LONG xDenom;
	LONG yNum;
	LONG yDenom;
} EMRSCALEVIEWPORTEXTEX,*PEMRSCALEVIEWPORTEXTEX,EMRSCALEWINDOWEXTEX,*PEMRSCALEWINDOWEXTEX;


typedef struct tagEMRSELECTOBJECT {
	EMR emr;
	DWORD ihObject;
} EMRSELECTOBJECT,*PEMRSELECTOBJECT,EMRDELETEOBJECT,*PEMRDELETEOBJECT;
typedef struct tagEMRSELECTPALETTE {
	EMR emr;
	DWORD ihPal;
} EMRSELECTPALETTE,*PEMRSELECTPALETTE;
typedef struct tagEMRSETARCDIRECTION {
	EMR emr;
	DWORD iArcDirection;
} EMRSETARCDIRECTION,*PEMRSETARCDIRECTION;
typedef struct tagEMRSETTEXTCOLOR {
	EMR emr;
	COLORREF crColor;
} EMRSETBKCOLOR,*PEMRSETBKCOLOR,EMRSETTEXTCOLOR,*PEMRSETTEXTCOLOR;
typedef struct tagEMRSETCOLORADJUSTMENT {
	EMR emr;
	COLORADJUSTMENT ColorAdjustment;
} EMRSETCOLORADJUSTMENT,*PEMRSETCOLORADJUSTMENT;
typedef struct tagEMRSETDIBITSTODEVICE {
	EMR emr;
	RECTL rclBounds;
	LONG xDest;
	LONG yDest;
	LONG xSrc;
	LONG ySrc;
	LONG cxSrc;
	LONG cySrc;
	DWORD offBmiSrc;
	DWORD cbBmiSrc;
	DWORD offBitsSrc;
	DWORD cbBitsSrc;
	DWORD iUsageSrc;
	DWORD iStartScan;
	DWORD cScans;
} EMRSETDIBITSTODEVICE,*PEMRSETDIBITSTODEVICE;
typedef struct tagEMRSETMAPPERFLAGS {
	EMR emr;
	DWORD dwFlags;
} EMRSETMAPPERFLAGS,*PEMRSETMAPPERFLAGS;
typedef struct tagEMRSETMITERLIMIT {
	EMR emr;
	FLOAT eMiterLimit;
} EMRSETMITERLIMIT,*PEMRSETMITERLIMIT;
typedef struct tagEMRSETPALETTEENTRIES {
	EMR emr;
	DWORD ihPal;
	DWORD iStart;
	DWORD cEntries;
	PALETTEENTRY aPalEntries[1];
} EMRSETPALETTEENTRIES,*PEMRSETPALETTEENTRIES;
typedef struct tagEMRSETPIXELV {
	EMR emr;
	POINTL ptlPixel;
	COLORREF crColor;
} EMRSETPIXELV,*PEMRSETPIXELV;
typedef struct tagEMRSETVIEWPORTEXTEX {
	EMR emr;
	SIZEL szlExtent;
} EMRSETVIEWPORTEXTEX,*PEMRSETVIEWPORTEXTEX,EMRSETWINDOWEXTEX,*PEMRSETWINDOWEXTEX;
typedef struct tagEMRSETVIEWPORTORGEX {
	EMR emr;
	POINTL ptlOrigin;
} EMRSETVIEWPORTORGEX,*PEMRSETVIEWPORTORGEX,EMRSETWINDOWORGEX,*PEMRSETWINDOWORGEX,EMRSETBRUSHORGEX,*PEMRSETBRUSHORGEX;
typedef struct tagEMRSETWORLDTRANSFORM {
	EMR emr;
	XFORM xform;
} EMRSETWORLDTRANSFORM,*PEMRSETWORLDTRANSFORM;
typedef struct tagEMRSTRETCHBLT {
	EMR emr;
	RECTL rclBounds;
	LONG xDest;
	LONG yDest;
	LONG cxDest;
	LONG cyDest;
	DWORD dwRop;
	LONG xSrc;
	LONG ySrc;
	XFORM xformSrc;
	COLORREF crBkColorSrc;
	DWORD iUsageSrc;
	DWORD offBmiSrc;
	DWORD cbBmiSrc;
	DWORD offBitsSrc;
	DWORD cbBitsSrc;
	LONG cxSrc;
	LONG cySrc;
} EMRSTRETCHBLT,*PEMRSTRETCHBLT;
typedef struct tagEMRALPHABLEND {
	EMR      emr;
	RECTL    rclBounds;
	LONG     xDest;
	LONG     yDest;
	LONG     cxDest;
	LONG     cyDest;
	DWORD    dwRop;
	LONG     xSrc;
	LONG     ySrc;
	XFORM    xformSrc;
	COLORREF crBkColorSrc;
	DWORD    iUsageSrc;
	DWORD    offBmiSrc;
	DWORD    cbBmiSrc;
	DWORD    offBitsSrc;
	DWORD    cbBitsSrc;
	LONG     cxSrc;
	LONG     cySrc;
} EMRALPHABLEND, *PEMRALPHABLEND;
typedef struct tagEMRSTRETCHDIBITS {
	EMR emr;
	RECTL rclBounds;
	LONG xDest;
	LONG yDest;
	LONG xSrc;
	LONG ySrc;
	LONG cxSrc;
	LONG cySrc;
	DWORD offBmiSrc;
	DWORD cbBmiSrc;
	DWORD offBitsSrc;
	DWORD cbBitsSrc;
	DWORD iUsageSrc;
	DWORD dwRop;
	LONG cxDest;
	LONG cyDest;
} EMRSTRETCHDIBITS,*PEMRSTRETCHDIBITS;
typedef struct tagABORTPATH {
	EMR emr;
} EMRABORTPATH,*PEMRABORTPATH,EMRBEGINPATH,*PEMRBEGINPATH,EMRENDPATH,*PEMRENDPATH,EMRCLOSEFIGURE,*PEMRCLOSEFIGURE,EMRFLATTENPATH,*PEMRFLATTENPATH,EMRWIDENPATH,*PEMRWIDENPATH,EMRSETMETARGN,*PEMRSETMETARGN,EMRSAVEDC,*PEMRSAVEDC,EMRREALIZEPALETTE,*PEMRREALIZEPALETTE;
typedef struct tagEMRSELECTCLIPPATH {
	EMR emr;
	DWORD iMode;
} EMRSELECTCLIPPATH,*PEMRSELECTCLIPPATH, EMRSETBKMODE,*PEMRSETBKMODE, EMRSETMAPMODE, *PEMRSETMAPMODE,
  EMRSETPOLYFILLMODE, *PEMRSETPOLYFILLMODE, EMRSETROP2, *PEMRSETROP2, EMRSETSTRETCHBLTMODE, *PEMRSETSTRETCHBLTMODE,
  EMRSETICMMODE, *PEMRSETICMMODE, EMRSETTEXTALIGN,
#if(WINVER >= 0x0500)
  EMRSETLAYOUT, *PEMRSETLAYOUT,
#endif
  *PEMRSETTEXTALIGN;

#include "pshpack2.h"
typedef struct tagMETAHEADER {
	WORD mtType;
	WORD mtHeaderSize;
	WORD mtVersion;
	DWORD mtSize;
	WORD mtNoObjects;
	DWORD mtMaxRecord;
	WORD mtNoParameters;
} METAHEADER,*PMETAHEADER,*LPMETAHEADER;
#include "poppack.h"
typedef struct tagENHMETAHEADER {
	DWORD iType;
	DWORD nSize;
	RECTL rclBounds;
	RECTL rclFrame;
	DWORD dSignature;
	DWORD nVersion;
	DWORD nBytes;
	DWORD nRecords;
	WORD nHandles;
	WORD sReserved;
	DWORD nDescription;
	DWORD offDescription;
	DWORD nPalEntries;
	SIZEL szlDevice;
	SIZEL szlMillimeters;
#if (WINVER >= 0x0400)
	DWORD cbPixelFormat;
	DWORD offPixelFormat;
	DWORD bOpenGL;
#endif
#if (WINVER >= 0x0500)
	SIZEL szlMicrometers;
#endif
} ENHMETAHEADER,*PENHMETAHEADER,*LPENHMETAHEADER;
typedef struct tagMETARECORD {
	DWORD rdSize;
	WORD rdFunction;
	WORD rdParm[1];
} METARECORD,*PMETARECORD,*LPMETARECORD;
typedef struct tagENHMETARECORD {
	DWORD iType;
	DWORD nSize;
	DWORD dParm[1];
} ENHMETARECORD,*LPENHMETARECORD;
typedef struct tagHANDLETABLE {
	HGDIOBJ objectHandle[1];
} HANDLETABLE,*PHANDLETABLE, *LPHANDLETABLE;

#ifndef _TEXTMETRIC_DEFINED
#define _TEXTMETRIC_DEFINED
typedef struct tagTEXTMETRICA {
	LONG tmHeight;
	LONG tmAscent;
	LONG tmDescent;
	LONG tmInternalLeading;
	LONG tmExternalLeading;
	LONG tmAveCharWidth;
	LONG tmMaxCharWidth;
	LONG tmWeight;
	LONG tmOverhang;
	LONG tmDigitizedAspectX;
	LONG tmDigitizedAspectY;
	BYTE tmFirstChar;
	BYTE tmLastChar;
	BYTE tmDefaultChar;
	BYTE tmBreakChar;
	BYTE tmItalic;
	BYTE tmUnderlined;
	BYTE tmStruckOut;
	BYTE tmPitchAndFamily;
	BYTE tmCharSet;
} TEXTMETRICA,*PTEXTMETRICA,*LPTEXTMETRICA;
typedef struct tagTEXTMETRICW {
	LONG tmHeight;
	LONG tmAscent;
	LONG tmDescent;
	LONG tmInternalLeading;
	LONG tmExternalLeading;
	LONG tmAveCharWidth;
	LONG tmMaxCharWidth;
	LONG tmWeight;
	LONG tmOverhang;
	LONG tmDigitizedAspectX;
	LONG tmDigitizedAspectY;
	WCHAR tmFirstChar;
	WCHAR tmLastChar;
	WCHAR tmDefaultChar;
	WCHAR tmBreakChar;
	BYTE tmItalic;
	BYTE tmUnderlined;
	BYTE tmStruckOut;
	BYTE tmPitchAndFamily;
	BYTE tmCharSet;
} TEXTMETRICW,*PTEXTMETRICW,*LPTEXTMETRICW;
#endif

typedef struct _RGNDATAHEADER {
	DWORD dwSize;
	DWORD iType;
	DWORD nCount;
	DWORD nRgnSize;
	RECT rcBound;
} RGNDATAHEADER, *PRGNDATAHEADER;
typedef struct _RGNDATA {
	RGNDATAHEADER rdh;
	char Buffer[1];
} RGNDATA,*PRGNDATA, *LPRGNDATA;
/* for GetRandomRgn */
#define SYSRGN  4
typedef struct tagGCP_RESULTSA {
	DWORD lStructSize;
	LPSTR lpOutString;
	UINT *lpOrder;
	INT *lpDx;
	INT *lpCaretPos;
	LPSTR lpClass;
	LPWSTR lpGlyphs;
	UINT nGlyphs;
	UINT nMaxFit;
} GCP_RESULTSA,*LPGCP_RESULTSA;
typedef struct tagGCP_RESULTSW {
	DWORD lStructSize;
	LPWSTR lpOutString;
	UINT *lpOrder;
	INT *lpDx;
	INT *lpCaretPos;
	LPWSTR lpClass;
	LPWSTR lpGlyphs;
	UINT nGlyphs;
	UINT nMaxFit;
} GCP_RESULTSW,*LPGCP_RESULTSW;
typedef struct _GLYPHMETRICS {
	UINT gmBlackBoxX;
	UINT gmBlackBoxY;
	POINT gmptGlyphOrigin;
	short gmCellIncX;
	short gmCellIncY;
} GLYPHMETRICS,*LPGLYPHMETRICS;
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagWCRANGE
{
    WCHAR  wcLow;
    USHORT cGlyphs;
} WCRANGE, *PWCRANGE, *LPWCRANGE;
typedef struct tagGLYPHSET
{
	DWORD cbThis;
	DWORD flAccel;
	DWORD cGlyphsSupported;
	DWORD cRanges;
	WCRANGE ranges[1];
} GLYPHSET, *PGLYPHSET, *LPGLYPHSET;
#endif
typedef struct tagKERNINGPAIR {
	WORD wFirst;
	WORD wSecond;
	int iKernAmount;
} KERNINGPAIR,*LPKERNINGPAIR;
typedef struct _FIXED {
	WORD fract;
	short value;
} FIXED;
typedef struct _MAT2 {
	FIXED eM11;
	FIXED eM12;
	FIXED eM21;
	FIXED eM22;
} MAT2,*LPMAT2;
typedef struct _OUTLINETEXTMETRICA {
	UINT otmSize;
	TEXTMETRICA otmTextMetrics;
	BYTE otmFiller;
	PANOSE otmPanoseNumber;
	UINT otmfsSelection;
	UINT otmfsType;
	int otmsCharSlopeRise;
	int otmsCharSlopeRun;
	int otmItalicAngle;
	UINT otmEMSquare;
	int otmAscent;
	int otmDescent;
	UINT otmLineGap;
	UINT otmsCapEmHeight;
	UINT otmsXHeight;
	RECT otmrcFontBox;
	int otmMacAscent;
	int otmMacDescent;
	UINT otmMacLineGap;
	UINT otmusMinimumPPEM;
	POINT otmptSubscriptSize;
	POINT otmptSubscriptOffset;
	POINT otmptSuperscriptSize;
	POINT otmptSuperscriptOffset;
	UINT otmsStrikeoutSize;
	int otmsStrikeoutPosition;
	int otmsUnderscoreSize;
	int otmsUnderscorePosition;
	PSTR otmpFamilyName;
	PSTR otmpFaceName;
	PSTR otmpStyleName;
	PSTR otmpFullName;
} OUTLINETEXTMETRICA,*POUTLINETEXTMETRICA,*LPOUTLINETEXTMETRICA;
typedef struct _OUTLINETEXTMETRICW {
	UINT otmSize;
	TEXTMETRICW otmTextMetrics;
	BYTE otmFiller;
	PANOSE otmPanoseNumber;
	UINT otmfsSelection;
	UINT otmfsType;
	int otmsCharSlopeRise;
	int otmsCharSlopeRun;
	int otmItalicAngle;
	UINT otmEMSquare;
	int otmAscent;
	int otmDescent;
	UINT otmLineGap;
	UINT otmsCapEmHeight;
	UINT otmsXHeight;
	RECT otmrcFontBox;
	int otmMacAscent;
	int otmMacDescent;
	UINT otmMacLineGap;
	UINT otmusMinimumPPEM;
	POINT otmptSubscriptSize;
	POINT otmptSubscriptOffset;
	POINT otmptSuperscriptSize;
	POINT otmptSuperscriptOffset;
	UINT otmsStrikeoutSize;
	int otmsStrikeoutPosition;
	int otmsUnderscoreSize;
	int otmsUnderscorePosition;
	PSTR otmpFamilyName;
	PSTR otmpFaceName;
	PSTR otmpStyleName;
	PSTR otmpFullName;
} OUTLINETEXTMETRICW,*POUTLINETEXTMETRICW,*LPOUTLINETEXTMETRICW;
typedef struct _RASTERIZER_STATUS {
	short nSize;
	short wFlags;
	short nLanguageID;
} RASTERIZER_STATUS,*LPRASTERIZER_STATUS;
typedef struct _POLYTEXTA {
	int x;
	int y;
	UINT n;
	LPCSTR lpstr;
	UINT uiFlags;
	RECT rcl;
	int *pdx;
} POLYTEXTA, *PPOLYTEXTA, *LPPOLYTEXTA;
typedef struct _POLYTEXTW {
	int x;
	int y;
	UINT n;
	LPCWSTR lpstr;
	UINT uiFlags;
	RECT rcl;
	int *pdx;
} POLYTEXTW, *PPOLYTEXTW, *LPPOLYTEXTW;
typedef struct tagPIXELFORMATDESCRIPTOR {
	WORD nSize;
	WORD nVersion;
	DWORD dwFlags;
	BYTE iPixelType;
	BYTE cColorBits;
	BYTE cRedBits;
	BYTE cRedShift;
	BYTE cGreenBits;
	BYTE cGreenShift;
	BYTE cBlueBits;
	BYTE cBlueShift;
	BYTE cAlphaBits;
	BYTE cAlphaShift;
	BYTE cAccumBits;
	BYTE cAccumRedBits;
	BYTE cAccumGreenBits;
	BYTE cAccumBlueBits;
	BYTE cAccumAlphaBits;
	BYTE cDepthBits;
	BYTE cStencilBits;
	BYTE cAuxBuffers;
	BYTE iLayerType;
	BYTE bReserved;
	DWORD dwLayerMask;
	DWORD dwVisibleMask;
	DWORD dwDamageMask;
} PIXELFORMATDESCRIPTOR,*PPIXELFORMATDESCRIPTOR,*LPPIXELFORMATDESCRIPTOR;

typedef struct tagEMRPIXELFORMAT
{
    EMR emr;
    PIXELFORMATDESCRIPTOR pfd;
} EMRPIXELFORMAT, *PEMRPIXELFORMAT;

typedef struct tagMETAFILEPICT {
	LONG mm;
	LONG xExt;
	LONG yExt;
	HMETAFILE hMF;
} METAFILEPICT,*LPMETAFILEPICT;
typedef struct tagLOCALESIGNATURE {
	DWORD lsUsb[4];
	DWORD lsCsbDefault[2];
	DWORD lsCsbSupported[2];
} LOCALESIGNATURE,*PLOCALESIGNATURE,*LPLOCALESIGNATURE;
typedef LONG LCSTYPE;
#include "pshpack4.h"
typedef struct tagNEWTEXTMETRICA {
	LONG tmHeight;
	LONG tmAscent;
	LONG tmDescent;
	LONG tmInternalLeading;
	LONG tmExternalLeading;
	LONG tmAveCharWidth;
	LONG tmMaxCharWidth;
	LONG tmWeight;
	LONG tmOverhang;
	LONG tmDigitizedAspectX;
	LONG tmDigitizedAspectY;
	BYTE tmFirstChar;
	BYTE tmLastChar;
	BYTE tmDefaultChar;
	BYTE tmBreakChar;
	BYTE tmItalic;
	BYTE tmUnderlined;
	BYTE tmStruckOut;
	BYTE tmPitchAndFamily;
	BYTE tmCharSet;
	DWORD ntmFlags;
	UINT ntmSizeEM;
	UINT ntmCellHeight;
	UINT ntmAvgWidth;
} NEWTEXTMETRICA,*PNEWTEXTMETRICA,*LPNEWTEXTMETRICA;
typedef struct tagNEWTEXTMETRICW {
	LONG tmHeight;
	LONG tmAscent;
	LONG tmDescent;
	LONG tmInternalLeading;
	LONG tmExternalLeading;
	LONG tmAveCharWidth;
	LONG tmMaxCharWidth;
	LONG tmWeight;
	LONG tmOverhang;
	LONG tmDigitizedAspectX;
	LONG tmDigitizedAspectY;
	WCHAR tmFirstChar;
	WCHAR tmLastChar;
	WCHAR tmDefaultChar;
	WCHAR tmBreakChar;
	BYTE tmItalic;
	BYTE tmUnderlined;
	BYTE tmStruckOut;
	BYTE tmPitchAndFamily;
	BYTE tmCharSet;
	DWORD ntmFlags;
	UINT ntmSizeEM;
	UINT ntmCellHeight;
	UINT ntmAvgWidth;
} NEWTEXTMETRICW,*PNEWTEXTMETRICW,*LPNEWTEXTMETRICW;
#include "poppack.h"
typedef struct tagNEWTEXTMETRICEXA {
	NEWTEXTMETRICA ntmTm;
	FONTSIGNATURE ntmFontSig;
} NEWTEXTMETRICEXA;
typedef struct tagNEWTEXTMETRICEXW {
	NEWTEXTMETRICW ntmTm;
	FONTSIGNATURE ntmFontSig;
} NEWTEXTMETRICEXW;
typedef struct tagPELARRAY {
	LONG paXCount;
	LONG paYCount;
	LONG paXExt;
	LONG paYExt;
	BYTE paRGBs;
} PELARRAY,*PPELARRAY,*LPPELARRAY;
typedef struct tagENUMLOGFONTA {
	LOGFONTA elfLogFont;
	BYTE elfFullName[LF_FULLFACESIZE];
	BYTE elfStyle[LF_FACESIZE];
} ENUMLOGFONTA,*LPENUMLOGFONTA;
typedef struct tagENUMLOGFONTW {
	LOGFONTW elfLogFont;
	WCHAR elfFullName[LF_FULLFACESIZE];
	WCHAR elfStyle[LF_FACESIZE];
} ENUMLOGFONTW,*LPENUMLOGFONTW;
typedef struct tagENUMLOGFONTEXA {
	LOGFONTA elfLogFont;
	BYTE elfFullName[LF_FULLFACESIZE];
	BYTE elfStyle[LF_FACESIZE];
	BYTE elfScript[LF_FACESIZE];
} ENUMLOGFONTEXA,*LPENUMLOGFONTEXA;
typedef struct tagENUMLOGFONTEXW {
	LOGFONTW elfLogFont;
	WCHAR elfFullName[LF_FULLFACESIZE];
	WCHAR elfStyle[LF_FACESIZE];
	WCHAR elfScript[LF_FACESIZE];
} ENUMLOGFONTEXW,*LPENUMLOGFONTEXW;
typedef struct tagPOINTFX {
	FIXED x;
	FIXED y;
} POINTFX,*LPPOINTFX;
typedef struct tagTTPOLYCURVE {
	WORD wType;
	WORD cpfx;
	POINTFX apfx[1];
} TTPOLYCURVE,*LPTTPOLYCURVE;
typedef struct tagTTPOLYGONHEADER {
	DWORD cb;
	DWORD dwType;
	POINTFX pfxStart;
} TTPOLYGONHEADER,*LPTTPOLYGONHEADER;
typedef struct _POINTFLOAT {
	FLOAT x;
	FLOAT y;
} POINTFLOAT,*PPOINTFLOAT;
typedef struct _GLYPHMETRICSFLOAT {
	FLOAT gmfBlackBoxX;
	FLOAT gmfBlackBoxY;
	POINTFLOAT gmfptGlyphOrigin;
	FLOAT gmfCellIncX;
	FLOAT gmfCellIncY;
} GLYPHMETRICSFLOAT,*PGLYPHMETRICSFLOAT,*LPGLYPHMETRICSFLOAT;
typedef struct tagLAYERPLANEDESCRIPTOR {
	WORD nSize;
	WORD nVersion;
	DWORD dwFlags;
	BYTE iPixelType;
	BYTE cColorBits;
	BYTE cRedBits;
	BYTE cRedShift;
	BYTE cGreenBits;
	BYTE cGreenShift;
	BYTE cBlueBits;
	BYTE cBlueShift;
	BYTE cAlphaBits;
	BYTE cAlphaShift;
	BYTE cAccumBits;
	BYTE cAccumRedBits;
	BYTE cAccumGreenBits;
	BYTE cAccumBlueBits;
	BYTE cAccumAlphaBits;
	BYTE cDepthBits;
	BYTE cStencilBits;
	BYTE cAuxBuffers;
	BYTE iLayerPlane;
	BYTE bReserved;
	COLORREF crTransparent;
} LAYERPLANEDESCRIPTOR,*PLAYERPLANEDESCRIPTOR,*LPLAYERPLANEDESCRIPTOR;
typedef struct _BLENDFUNCTION {
    BYTE BlendOp;
    BYTE BlendFlags;
    BYTE SourceConstantAlpha;
    BYTE AlphaFormat;
} BLENDFUNCTION,*PBLENDFUNCTION,*LPBLENDFUNCTION;
#define STAMP_DESIGNVECTOR (0x8000000 + 'd' + ('v' << 8))
#define STAMP_AXESLIST     (0x8000000 + 'a' + ('l' << 8))
#define MM_MAX_NUMAXES  16
typedef struct _DESIGNVECTOR {
	DWORD dvReserved;
	DWORD dvNumAxes;
	LONG dvValues[MM_MAX_NUMAXES];
} DESIGNVECTOR, *PDESIGNVECTOR, *LPDESIGNVECTOR;
typedef struct tagENUMLOGFONTEXDVA
{
	ENUMLOGFONTEXA elfEnumLogfontEx;
	DESIGNVECTOR elfDesignVector;
} ENUMLOGFONTEXDVA, *PENUMLOGFONTEXDVA, *LPENUMLOGFONTEXDVA;
typedef struct tagENUMLOGFONTEXDVW
{
	ENUMLOGFONTEXW elfEnumLogfontEx;
	DESIGNVECTOR elfDesignVector;
} ENUMLOGFONTEXDVW, *PENUMLOGFONTEXDVW, *LPENUMLOGFONTEXDVW;
typedef USHORT COLOR16;
typedef struct _TRIVERTEX {
	LONG x;
	LONG y;
	COLOR16 Red;
	COLOR16 Green;
	COLOR16 Blue;
	COLOR16 Alpha;
} TRIVERTEX, *PTRIVERTEX, *LPTRIVERTEX;
typedef struct tagEMRGRADIENTFILL {
    EMR       emr;
    RECTL     rclBounds;
    DWORD     nVer;
    DWORD     nTri;
    ULONG     ulMode;
    TRIVERTEX Ver[1];
} EMRGRADIENTFILL, *PEMRGRADIENTFILL;
typedef struct _GRADIENT_TRIANGLE {
	ULONG Vertex1;
	ULONG Vertex2;
	ULONG Vertex3;
} GRADIENT_TRIANGLE,*PGRADIENT_TRIANGLE,*LPGRADIENT_TRIANGLE;
typedef struct _GRADIENT_RECT {
	ULONG UpperLeft;
	ULONG LowerRight;
}GRADIENT_RECT,*PGRADIENT_RECT,*LPGRADIENT_RECT;
typedef struct _DISPLAY_DEVICEA {
  DWORD cb;
  CHAR DeviceName[32];
  CHAR DeviceString[128];
  DWORD StateFlags;
  CHAR DeviceID[128];
  CHAR DeviceKey[128];
} DISPLAY_DEVICEA, *PDISPLAY_DEVICEA, *LPDISPLAY_DEVICEA;
typedef struct _DISPLAY_DEVICEW {
  DWORD cb;
  WCHAR DeviceName[32];
  WCHAR DeviceString[128];
  DWORD StateFlags;
  WCHAR DeviceID[128];
  WCHAR DeviceKey[128];
} DISPLAY_DEVICEW, *PDISPLAY_DEVICEW, *LPDISPLAY_DEVICEW;
#define MM_MAX_AXES_NAMELEN 16
typedef struct _AXISINFOA
{
  LONG   axMinValue;
  LONG   axMaxValue;
  BYTE   axAxisName[MM_MAX_AXES_NAMELEN];
} AXISINFOA, *PAXISINFOA, *LPAXISINFOA;
typedef struct _AXISINFOW
{
  LONG   axMinValue;
  LONG   axMaxValue;
  WCHAR  axAxisName[MM_MAX_AXES_NAMELEN];
} AXISINFOW, *PAXISINFOW, *LPAXISINFOW;
typedef struct _AXESLISTA
{
  DWORD     axlReserved;
  DWORD     axlNumAxes;
  AXISINFOA axlAxisInfo[MM_MAX_NUMAXES];
} AXESLISTA, *PAXESLISTA, *LPAXESLISTA;
typedef struct _AXESLISTW
{
  DWORD     axlReserved;
  DWORD     axlNumAxes;
  AXISINFOW axlAxisInfo[MM_MAX_NUMAXES];
} AXESLISTW, *PAXESLISTW, *LPAXESLISTW;
typedef struct _ENUMTEXTMETRICA
{
    NEWTEXTMETRICEXA etmNewTextMetricEx;
    AXESLISTA        etmAxesList;
} ENUMTEXTMETRICA, *PENUMTEXTMETRICA, *LPENUMTEXTMETRICA;
typedef struct _ENUMTEXTMETRICW
{
    NEWTEXTMETRICEXW etmNewTextMetricEx;
    AXESLISTW        etmAxesList;
} ENUMTEXTMETRICW, *PENUMTEXTMETRICW, *LPENUMTEXTMETRICW;


#if defined(STRICT)

#if !defined(NOTEXTMETRIC)

typedef int (CALLBACK *OLDFONTENUMPROCA)(CONST LOGFONTA *, CONST TEXTMETRICA *, DWORD, LPARAM);
typedef int (CALLBACK *OLDFONTENUMPROCW)(CONST LOGFONTW *, CONST TEXTMETRICW *, DWORD, LPARAM);

#else

typedef int (CALLBACK* OLDFONTENUMPROCA)(CONST LOGFONTA *, CONST VOID *, DWORD, LPARAM);
typedef int (CALLBACK* OLDFONTENUMPROCW)(CONST LOGFONTW *, CONST VOID *, DWORD, LPARAM);

#endif

#ifdef UNICODE
#define OLDFONTENUMPROC OLDFONTENUMPROCW
#else
#define OLDFONTENUMPROC OLDFONTENUMPROCA
#endif

typedef OLDFONTENUMPROCA FONTENUMPROCA;
typedef OLDFONTENUMPROCW FONTENUMPROCW;

#ifdef UNICODE
typedef FONTENUMPROCW FONTENUMPROC;
#else
typedef FONTENUMPROCA FONTENUMPROC;
#endif

typedef INT (CALLBACK *GOBJENUMPROC)(LPVOID, LPARAM);
typedef VOID (CALLBACK *LINEDDAPROC)(INT, INT, LPARAM);

#else // defined(STRICT)

typedef FARPROC OLDFONTENUMPROC;
typedef FARPROC FONTENUMPROCA;
typedef FARPROC FONTENUMPROCW;

#ifdef UNICODE
typedef FONTENUMPROCW FONTENUMPROC;
#else
typedef FONTENUMPROCA FONTENUMPROC;
#endif

typedef FARPROC GOBJENUMPROC;
typedef FARPROC LINEDDAPROC;

#endif


typedef BOOL (CALLBACK *ABORTPROC)(HDC,int);

typedef int
(CALLBACK *MFENUMPROC)(
  _In_ HDC hdc,
  _In_reads_(nObj) HANDLETABLE FAR* lpht,
  _In_ METARECORD FAR* lpMR,
  _In_ int nObj,
  _In_opt_ LPARAM param);

typedef int
(CALLBACK *ENHMFENUMPROC)(
  _In_ HDC hdc,
  _In_reads_(nHandles) HANDLETABLE FAR* lpht,
  _In_ CONST ENHMETARECORD * lpmr,
  _In_ int nHandles,
  _In_opt_ LPARAM data);

typedef int (CALLBACK *ICMENUMPROCA)(LPSTR,LPARAM);
typedef int (CALLBACK *ICMENUMPROCW)(LPWSTR,LPARAM);
typedef UINT (CALLBACK *LPFNDEVMODE)(HWND,HMODULE,LPDEVMODEA,LPSTR,LPSTR,LPDEVMODEA,LPSTR,UINT);
typedef DWORD (CALLBACK *LPFNDEVCAPS)(LPSTR,LPSTR,UINT,LPSTR,LPDEVMODEA);


#define GetRValue(rgb) ((BYTE)(rgb))
#define GetGValue(rgb) ((BYTE)(((WORD)(rgb)) >> 8))
#define GetBValue(rgb) ((BYTE)((rgb)>>16))
#define GetAValue(rgb) ((BYTE)((rgb)>>24))

#define RGB(r,g,b)          ((COLORREF)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)))
#define RGBA(r,g,b,a)       ((COLORREF)((((DWORD)(BYTE)(a))<<24) | RGB(r,g,b)))
#define PALETTERGB(r,g,b)   (0x02000000 | RGB(r,g,b))
#define PALETTEINDEX(i)     ((COLORREF)(0x01000000 | (DWORD)(WORD)(i)))

#define MAKEPOINTS(l) (*((POINTS*)&(l)))
#define MAKEROP4(f,b) (DWORD)((((b)<<8)&0xFF000000)|(f))

INT
WINAPI
AbortDoc(
    _In_ HDC hdc);

BOOL
WINAPI
AbortPath(
    _In_ HDC hdc);

int
WINAPI
AddFontResourceA(
    _In_ LPCSTR pszFilename);

int
WINAPI
AddFontResourceW(
    _In_ LPCWSTR pszFilename);

HANDLE
WINAPI
AddFontMemResourceEx(
    _In_reads_bytes_(cjSize) PVOID pvFileView,
    _In_ DWORD cjSize,
    _Reserved_ PVOID pvResrved,
    _In_ DWORD* pNumFonts);

INT
WINAPI
AddFontResourceExA(
    _In_ LPCSTR pszFilename,
    _In_ DWORD fl,
    _Reserved_ PVOID pvReserved);

INT
WINAPI
AddFontResourceExW(
    _In_ LPCWSTR pszFilename,
    _In_ DWORD fl,
    _Reserved_ PVOID pvReserved);

BOOL
WINAPI
AngleArc(
    _In_ HDC hdc,
    _In_ INT x,
    _In_ INT y,
    _In_ DWORD dwRadius,
    _In_ FLOAT eStartAngle,
    _In_ FLOAT eSweepAngle);

BOOL
WINAPI
AnimatePalette(
    _In_ HPALETTE hPal,
    _In_ UINT iStartIndex,
    _In_ UINT cEntries,
    _In_reads_(cEntries) CONST PALETTEENTRY *ppe);

BOOL
WINAPI
Arc(
    _In_ HDC hdc,
    _In_ INT xLeft,
    _In_ INT yTop,
    _In_ INT xRight,
    _In_ INT yBottom,
    _In_ INT xStartArc,
    _In_ INT yStartArc,
    _In_ INT xEndArc,
    _In_ INT yEndArc);

BOOL
WINAPI
ArcTo(
    _In_ HDC hdc,
    _In_ INT xLeft,
    _In_ INT yTop,
    _In_ INT xRight,
    _In_ INT yBottom,
    _In_ INT xRadial1,
    _In_ INT yRadial1,
    _In_ INT xRadial2,
    _In_ INT yRadial2);

BOOL
WINAPI
BeginPath(
    _In_ HDC hdc);

BOOL
WINAPI
BitBlt(
    _In_ HDC hdcDest,
    _In_ INT xDest,
    _In_ INT yDest,
    _In_ INT cxDest,
    _In_ INT cyDest,
    _In_opt_ HDC hdcSrc,
    _In_ INT xSrc,
    _In_ INT ySrc,
    _In_ DWORD dwRop);

BOOL
WINAPI
CancelDC(
    _In_ HDC hdc);

BOOL
WINAPI
CheckColorsInGamut(
  _In_ HDC hdc,
  _In_reads_(nCount) LPVOID pRGBTriple,
  _Out_writes_bytes_(nCount) LPVOID pvBuffer,
  _In_ DWORD nCount);

BOOL
WINAPI
Chord(
    _In_ HDC hdc,
    _In_ INT xLeft,
    _In_ INT yTop,
    _In_ INT xRight,
    _In_ INT yBottom,
    _In_ INT xRadial1,
    _In_ INT yRadial1,
    _In_ INT xRadial2,
    _In_ INT yRadial2);

int
WINAPI
ChoosePixelFormat(
    _In_ HDC hdc,
    _In_ const PIXELFORMATDESCRIPTOR* ppfd);

HENHMETAFILE
WINAPI
CloseEnhMetaFile(
    _In_ HDC hdc);

BOOL
WINAPI
CloseFigure(
    _In_ HDC hdc);

HMETAFILE
WINAPI
CloseMetaFile(
    _In_ HDC hdc);

BOOL
WINAPI
ColorMatchToTarget(
    _In_ HDC hdc,
    _In_ HDC hdcTarget,
    _In_ DWORD uAction);

int
WINAPI
CombineRgn(
    _In_opt_ HRGN hrgnDest,
    _In_opt_ HRGN hrgnSrc1,
    _In_opt_ HRGN hrgnSrc2,
    _In_ int fnCombineMode);

BOOL
WINAPI
CombineTransform(
    _Out_ LPXFORM pxformResult,
    _In_ const XFORM* pxform1,
    _In_ const XFORM* pxform2);

HENHMETAFILE
WINAPI
CopyEnhMetaFileA(
    _In_ HENHMETAFILE hemfSrc,
    _In_opt_ LPCSTR pszFile);

HENHMETAFILE
WINAPI
CopyEnhMetaFileW(
    _In_ HENHMETAFILE hemfSrc,
    _In_opt_ LPCWSTR pszFile);

HMETAFILE
WINAPI
CopyMetaFileA(
    _In_ HMETAFILE hmfSrc,
    _In_opt_ LPCSTR pszFile);

HMETAFILE
WINAPI
CopyMetaFileW(
    _In_ HMETAFILE hmfSrc,
    _In_opt_ LPCWSTR pszFile);

HBITMAP
WINAPI
CreateBitmap(
    _In_ INT cx,
    _In_ INT cy,
    _In_ UINT cPlanes,
    _In_ UINT cBitsPerPel,
    _In_opt_ const VOID* pvBits);

HBITMAP
WINAPI
CreateBitmapIndirect(
    _In_ const BITMAP* pbm);

HBRUSH
WINAPI
CreateBrushIndirect(
    _In_ const LOGBRUSH* plb);

HCOLORSPACE
WINAPI
CreateColorSpaceA(
    _In_ LPLOGCOLORSPACEA pLogColorSpace);

HCOLORSPACE
WINAPI
CreateColorSpaceW(
    _In_ LPLOGCOLORSPACEW pLogColorSpace);

HBITMAP
WINAPI
CreateCompatibleBitmap(
    _In_ HDC hdc,
    _In_ INT cx,
    _In_ INT cy);

HDC
WINAPI
CreateCompatibleDC(
    _In_opt_ HDC hdc);

HDC
WINAPI
CreateDCA(
    _In_opt_ LPCSTR pszDriver,
    _In_opt_ LPCSTR pszDevice,
    _In_opt_ LPCSTR pszOutput,
    _In_opt_ const DEVMODEA* pdmInit);

HDC
WINAPI
CreateDCW(
    _In_opt_ LPCWSTR pszDriver,
    _In_opt_ LPCWSTR pszDevice,
    _In_opt_ LPCWSTR psz,
    _In_opt_ const DEVMODEW* pdmInit);

HBITMAP
WINAPI
CreateDIBitmap(
    _In_ HDC hdc,
    _In_opt_ const BITMAPINFOHEADER* pbmih,
    _In_ DWORD fdwInit,
    _In_opt_ const VOID* pvInit,
    _In_opt_ const BITMAPINFO* pbmi,
    _In_ UINT uUsage);

HBRUSH
WINAPI
CreateDIBPatternBrush(
    _In_ HGLOBAL hglbDIBPacked,
    _In_ UINT uUsage);

HBRUSH
WINAPI
CreateDIBPatternBrushPt(
    _In_ const VOID* pvPackedDIB,
    _In_ UINT uUsage);

#define GDI_WIDTHBYTES(bits)  ((DWORD)(((bits) + 31) & (~31)) / 8)
#define GDI_DIBWIDTHBYTES(bi) (DWORD)GDI_WIDTHBYTES((DWORD)(bi).biWidth * (DWORD)(bi).biBitCount)
#define GDI__DIBSIZE(bi)      (GDI_DIBWIDTHBYTES(bi) * (DWORD)(bi).biHeight)
#define GDI_DIBSIZE(bi)       ((bi).biHeight < 0 ? (-1) * (GDI__DIBSIZE(bi)) : GDI__DIBSIZE(bi))

_Success_(return != NULL)
HBITMAP
WINAPI
CreateDIBSection(
  _In_opt_ HDC hdc,
  _In_ const BITMAPINFO *pbmi,
  _In_ UINT usage,
  _When_((pbmi->bmiHeader.biBitCount != 0), _Outptr_result_bytebuffer_(GDI_DIBSIZE((pbmi->bmiHeader))))
  _When_((pbmi->bmiHeader.biBitCount == 0), _Outptr_result_bytebuffer_((pbmi->bmiHeader).biSizeImage))
    VOID **ppvBits,
  _In_opt_ HANDLE hSection,
  _In_ DWORD offset);

HBITMAP WINAPI CreateDiscardableBitmap(_In_ HDC, _In_ int, _In_ int);
HRGN WINAPI CreateEllipticRgn(_In_ int, _In_ int, _In_ int, _In_ int);
HRGN WINAPI CreateEllipticRgnIndirect(_In_ LPCRECT);
HDC WINAPI CreateEnhMetaFileA(_In_opt_ HDC, _In_opt_ LPCSTR, _In_opt_ LPCRECT, _In_opt_ LPCSTR);
HDC WINAPI CreateEnhMetaFileW(_In_opt_ HDC, _In_opt_ LPCWSTR, _In_opt_ LPCRECT, _In_opt_ LPCWSTR);
HFONT WINAPI CreateFontA(_In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_opt_ LPCSTR);
HFONT WINAPI CreateFontW(_In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_opt_ LPCWSTR);
HFONT WINAPI CreateFontIndirectA(_In_ const LOGFONTA*);
HFONT WINAPI CreateFontIndirectW(_In_ const LOGFONTW*);
HFONT WINAPI CreateFontIndirectExA(const ENUMLOGFONTEXDVA *);
HFONT WINAPI CreateFontIndirectExW(const ENUMLOGFONTEXDVW *);
HPALETTE WINAPI CreateHalftonePalette(_In_opt_ HDC);
HBRUSH WINAPI CreateHatchBrush(_In_ int, _In_ COLORREF);
HDC WINAPI CreateICA(_In_opt_ LPCSTR, _In_opt_ LPCSTR, _In_opt_ LPCSTR, _In_opt_ const DEVMODEA*);
HDC WINAPI CreateICW(_In_opt_ LPCWSTR, _In_opt_ LPCWSTR, _In_opt_ LPCWSTR, _In_opt_ const DEVMODEW*);
HDC WINAPI CreateMetaFileA(_In_opt_ LPCSTR);
HDC WINAPI CreateMetaFileW(_In_opt_ LPCWSTR);

HPALETTE
WINAPI
CreatePalette(
  _In_reads_(_Inexpressible_(2*sizeof(WORD) + plpal->palNumEntries * sizeof(PALETTEENTRY))) const LOGPALETTE*);

HBRUSH WINAPI CreatePatternBrush(_In_ HBITMAP);
HPEN WINAPI CreatePen(_In_ int, _In_ int, _In_ COLORREF);
HPEN WINAPI CreatePenIndirect(_In_ const LOGPEN*);

HRGN
WINAPI
CreatePolygonRgn(
  _In_reads_(cPoint) const POINT *pptl,
  _In_ int cPoint,
  _In_ int iMode);

HRGN
WINAPI
CreatePolyPolygonRgn(
  _In_ const POINT *pptl,
  _In_reads_(cPoly) const INT *pc,
  _In_ int cPoly,
  _In_ int iMode);

HRGN WINAPI CreateRectRgn(_In_ int, _In_ int, _In_ int, _In_ int);
HRGN WINAPI CreateRectRgnIndirect(_In_ LPCRECT);
HRGN WINAPI CreateRoundRectRgn(_In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int);
BOOL WINAPI CreateScalableFontResourceA(_In_ DWORD, _In_ LPCSTR, _In_ LPCSTR, _In_opt_ LPCSTR);
BOOL WINAPI CreateScalableFontResourceW(_In_ DWORD, _In_ LPCWSTR, _In_ LPCWSTR, _In_opt_ LPCWSTR);
HBRUSH WINAPI CreateSolidBrush(_In_ COLORREF);
BOOL WINAPI DeleteColorSpace(_In_ HCOLORSPACE);
BOOL WINAPI DeleteDC(_In_ HDC);
BOOL WINAPI DeleteEnhMetaFile(_In_opt_ HENHMETAFILE);
BOOL WINAPI DeleteMetaFile(_In_ HMETAFILE);
BOOL WINAPI DeleteObject(_In_ HGDIOBJ);

int
WINAPI
DescribePixelFormat(
  _In_ HDC hdc,
  _In_ int iPixelFormat,
  _In_ UINT nBytes,
  _Out_writes_bytes_opt_(nBytes) LPPIXELFORMATDESCRIPTOR ppfd);

DWORD
WINAPI
DeviceCapabilitiesA(
  _In_ LPCSTR pDevice,
  _In_opt_ LPCSTR pPort,
  _In_ WORD fwCapability,
  _Out_writes_opt_(_Inexpressible_(1)) LPSTR pOutput,
  _In_opt_ const DEVMODEA *pDevMode);

DWORD
WINAPI
DeviceCapabilitiesW(
  _In_ LPCWSTR pDevice,
  _In_opt_ LPCWSTR pPort,
  _In_ WORD fwCapability,
  _Out_writes_opt_(_Inexpressible_(1)) LPWSTR pOutput,
  _In_opt_ const DEVMODEW *pDevMode);

BOOL
WINAPI
DPtoLP(
  _In_ HDC hdc,
  _Inout_updates_(c) LPPOINT lppt,
  _In_ int c);

int
WINAPI
DrawEscape(
  _In_ HDC hdc,
  _In_ int iEscape,
  _In_ int cjIn,
  _In_reads_bytes_opt_(cjIn) LPCSTR lpIn);

BOOL WINAPI Ellipse(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int);
int WINAPI EndDoc(_In_ HDC);
int WINAPI EndPage(_In_ HDC);
BOOL WINAPI EndPath(_In_ HDC);
BOOL WINAPI EnumEnhMetaFile(_In_opt_ HDC, _In_ HENHMETAFILE, _In_ ENHMFENUMPROC, _In_opt_ PVOID, _In_opt_ LPCRECT);
int WINAPI EnumFontFamiliesA(_In_ HDC, _In_opt_ LPCSTR, _In_ FONTENUMPROCA, _In_ LPARAM);
int WINAPI EnumFontFamiliesW(_In_ HDC, _In_opt_ LPCWSTR, _In_ FONTENUMPROCW, _In_ LPARAM);
int WINAPI EnumFontFamiliesExA(_In_ HDC, _In_ PLOGFONTA, _In_ FONTENUMPROCA, _In_ LPARAM, _In_ DWORD);
int WINAPI EnumFontFamiliesExW(_In_ HDC, _In_ PLOGFONTW, _In_ FONTENUMPROCW, _In_ LPARAM, _In_ DWORD);
int WINAPI EnumFontsA(_In_ HDC, _In_opt_ LPCSTR, _In_ FONTENUMPROCA, _In_ LPARAM);
int WINAPI EnumFontsW(_In_ HDC, _In_opt_ LPCWSTR, _In_ FONTENUMPROCW, _In_ LPARAM);
int WINAPI EnumICMProfilesA(_In_ HDC, _In_ ICMENUMPROCA, _In_opt_ LPARAM);
int WINAPI EnumICMProfilesW(_In_ HDC, _In_ ICMENUMPROCW, _In_opt_ LPARAM);
BOOL WINAPI EnumMetaFile(_In_ HDC, _In_ HMETAFILE, _In_ MFENUMPROC, _In_opt_ LPARAM);
int WINAPI EnumObjects(_In_ HDC, _In_ int, _In_ GOBJENUMPROC, _In_ LPARAM);
BOOL WINAPI EqualRgn(_In_ HRGN, _In_ HRGN);

int
WINAPI
Escape(
  _In_ HDC hdc,
  _In_ int iEscape,
  _In_ int cjIn,
  _In_reads_bytes_opt_(cjIn) LPCSTR pvIn,
  _Out_opt_ LPVOID pvOut);

int WINAPI ExcludeClipRect(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int);
int WINAPI ExcludeUpdateRgn(HDC,HWND);

HPEN
WINAPI
ExtCreatePen(
  _In_ DWORD iPenStyle,
  _In_ DWORD cWidth,
  _In_ const LOGBRUSH *plbrush,
  _In_ DWORD cStyle,
  _In_reads_opt_(cStyle) const DWORD *pstyle);

HRGN
WINAPI
ExtCreateRegion(
  _In_opt_ const XFORM *lpx,
  _In_ DWORD nCount,
  _In_reads_bytes_(nCount) const RGNDATA *lpData);

int
WINAPI
ExtEscape(
  _In_ HDC hdc,
  _In_ int iEscape,
  _In_ int cjInput,
  _In_reads_bytes_opt_(cjInput) LPCSTR lpInData,
  _In_ int cjOutput,
  _Out_writes_bytes_opt_(cjOutput) LPSTR lpOutData);

BOOL WINAPI ExtFloodFill(_In_ HDC, _In_ int, _In_ int, _In_ COLORREF, _In_ UINT);
int WINAPI ExtSelectClipRgn(_In_ HDC, _In_opt_ HRGN, _In_ int);

BOOL
WINAPI
ExtTextOutA(
  _In_ HDC hdc,
  _In_ int x,
  _In_ int y,
  _In_ UINT options,
  _In_opt_ const RECT *lprect,
  _In_reads_opt_(c) LPCSTR lpString,
  _In_ UINT c,
  _In_reads_opt_(c) const INT *lpDx);

BOOL
WINAPI
ExtTextOutW(
  _In_ HDC hdc,
  _In_ int x,
  _In_ int y,
  _In_ UINT options,
  _In_opt_ const RECT *lprect,
  _In_reads_opt_(c) LPCWSTR lpString,
  _In_ UINT c,
  _In_reads_opt_(c) const INT *lpDx);

BOOL WINAPI FillPath(_In_ HDC);
int WINAPI FillRect(HDC,LPCRECT,HBRUSH);
int WINAPI FillRgn(_In_ HDC, _In_ HRGN, _In_ HBRUSH);
BOOL WINAPI FixBrushOrgEx(_In_ HDC, _In_ int, _In_ int, _In_opt_ LPPOINT);
BOOL WINAPI FlattenPath(_In_ HDC);
BOOL WINAPI FloodFill(_In_ HDC, _In_ int, _In_ int, _In_ COLORREF);
BOOL WINAPI FrameRgn(_In_ HDC, _In_ HRGN, _In_ HBRUSH, _In_ int, _In_ int);
BOOL WINAPI GdiAlphaBlend(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ BLENDFUNCTION);

BOOL
WINAPI
GdiComment(
  _In_ HDC hdc,
  _In_ UINT nSize,
  _In_reads_bytes_(nSize) const BYTE *lpData);

DEVMODEW * WINAPI GdiConvertToDevmodeW(const DEVMODEA *);
BOOL WINAPI GdiFlush(void);
LONG WINAPI GdiGetCharDimensions(HDC, LPTEXTMETRICW, LONG *);
DWORD WINAPI GdiGetCodePage(HDC);
DWORD WINAPI GdiGetBatchLimit(void);
DWORD WINAPI GdiSetBatchLimit(_In_ DWORD);

BOOL
WINAPI
GdiGradientFill(
  _In_ HDC hdc,
  _In_reads_(nVertex) PTRIVERTEX pVertex,
  _In_ ULONG nVertex,
  _In_ PVOID pMesh,
  _In_ ULONG nCount,
  _In_ ULONG ulMode);

BOOL WINAPI GdiTransparentBlt(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ UINT);
BOOL WINAPI GdiIsMetaFileDC(HDC);

#define GetKValue(cmyk) ((BYTE)(cmyk))
#define GetYValue(cmyk) ((BYTE)((cmyk)>> 8))
#define GetMValue(cmyk) ((BYTE)((cmyk)>>16))
#define GetCValue(cmyk) ((BYTE)((cmyk)>>24))
#define CMYK(c,m,y,k) ((COLORREF)((((BYTE)(k)|((WORD)((BYTE)(y))<<8))|(((DWORD)(BYTE)(m))<<16))|(((DWORD)(BYTE)(c))<<24)))

int WINAPI GetArcDirection(_In_ HDC);
BOOL WINAPI GetAspectRatioFilterEx(_In_ HDC, _Out_ LPSIZE);

LONG
WINAPI
GetBitmapBits(
  _In_ HBITMAP hbit,
  _In_ LONG cb,
  _Out_writes_bytes_(cb) LPVOID lpvBits);

BOOL WINAPI GetBitmapDimensionEx(_In_ HBITMAP, _Out_ LPSIZE);
COLORREF WINAPI GetBkColor(_In_ HDC);
int WINAPI GetBkMode(_In_ HDC);
UINT WINAPI GetBoundsRect(_In_ HDC, _Out_ LPRECT, _In_ UINT);
BOOL WINAPI GetBrushOrgEx(_In_ HDC, _Out_ LPPOINT);

BOOL
WINAPI
GetCharABCWidthsA(
  _In_ HDC hdc,
  _In_ UINT wFirst,
  _In_ UINT wLast,
  _Out_writes_(wLast - wFirst + 1) LPABC lpABC);

BOOL
WINAPI
GetCharABCWidthsW(
  _In_ HDC hdc,
  _In_ UINT wFirst,
  _In_ UINT wLast,
  _Out_writes_(wLast - wFirst + 1) LPABC lpABC);

BOOL
WINAPI
GetCharABCWidthsFloatA(
  _In_ HDC hdc,
  _In_ UINT iFirst,
  _In_ UINT iLast,
  _Out_writes_(iLast + 1 - iFirst) LPABCFLOAT lpABC);

BOOL
WINAPI
GetCharABCWidthsFloatW(
  _In_ HDC hdc,
  _In_ UINT iFirst,
  _In_ UINT iLast,
  _Out_writes_(iLast + 1 - iFirst) LPABCFLOAT lpABC);

BOOL
WINAPI
GetCharABCWidthsI(
  _In_ HDC hdc,
  _In_ UINT giFirst,
  _In_ UINT cgi,
  _In_reads_opt_(cgi) LPWORD pgi,
  _Out_writes_(cgi) LPABC pabc);

DWORD
WINAPI
GetCharacterPlacementA(
  _In_ HDC hdc,
  _In_reads_(nCount) LPCSTR lpString,
  _In_ int nCount,
  _In_ int nMexExtent,
  _Inout_ LPGCP_RESULTSA lpResults,
  _In_ DWORD dwFlags);

DWORD
WINAPI
GetCharacterPlacementW(
  _In_ HDC hdc,
  _In_reads_(nCount) LPCWSTR lpString,
  _In_ int nCount,
  _In_ int nMexExtent,
  _Inout_ LPGCP_RESULTSW lpResults,
  _In_ DWORD dwFlags);

BOOL
WINAPI
GetCharWidth32A(
  _In_ HDC hdc,
  _In_ UINT iFirst,
  _In_ UINT iLast,
  _Out_writes_(iLast + 1 - iFirst) LPINT lpBuffer);

BOOL
WINAPI
GetCharWidth32W(
  _In_ HDC hdc,
  _In_ UINT iFirst,
  _In_ UINT iLast,
  _Out_writes_(iLast + 1 - iFirst) LPINT lpBuffer);

BOOL
WINAPI
GetCharWidthA(
  _In_ HDC hdc,
  _In_ UINT iFirst,
  _In_ UINT iLast,
  _Out_writes_(iLast + 1 - iFirst) LPINT lpBuffer);

BOOL
WINAPI
GetCharWidthW(
  _In_ HDC hdc,
  _In_ UINT iFirst,
  _In_ UINT iLast,
  _Out_writes_(iLast + 1 - iFirst) LPINT lpBuffer);

BOOL
WINAPI
GetCharWidthI(
  _In_ HDC hdc,
  _In_ UINT giFirst,
  _In_ UINT cgi,
  _In_reads_opt_(cgi) LPWORD pgi,
  _Out_writes_(cgi) LPINT piWidths);

BOOL
WINAPI
GetCharWidthFloatA(
  _In_ HDC hdc,
  _In_ UINT iFirst,
  _In_ UINT iLast,
  _Out_writes_(iLast + 1 - iFirst) PFLOAT lpBuffer);

BOOL
WINAPI
GetCharWidthFloatW(
  _In_ HDC hdc,
  _In_ UINT iFirst,
  _In_ UINT iLast,
  _Out_writes_(iLast + 1 - iFirst) PFLOAT lpBuffer);

int WINAPI GetClipBox(_In_ HDC, _Out_ LPRECT);
int WINAPI GetClipRgn(_In_ HDC, _In_ HRGN);
BOOL WINAPI GetColorAdjustment(_In_ HDC, _Out_ LPCOLORADJUSTMENT);
HCOLORSPACE WINAPI GetColorSpace(_In_ HDC);
HGDIOBJ WINAPI GetCurrentObject(_In_ HDC, _In_ UINT);
BOOL WINAPI GetCurrentPositionEx(_In_ HDC, _Out_ LPPOINT);
HCURSOR WINAPI GetCursor(void);
BOOL WINAPI GetDCOrgEx(_In_ HDC, _Out_ LPPOINT);
#if (_WIN32_WINNT >= 0x0500)
COLORREF WINAPI GetDCBrushColor(_In_ HDC);
COLORREF WINAPI GetDCPenColor(_In_ HDC);
#endif
int WINAPI GetDeviceCaps(_In_opt_ HDC, _In_ int);

BOOL
WINAPI
GetDeviceGammaRamp(
  _In_ HDC hdc,
  _Out_writes_bytes_(3*256*2) LPVOID lpRamp);

_Ret_range_(0,cEntries)
UINT
WINAPI
GetDIBColorTable(
  _In_ HDC hdc,
  _In_ UINT iStart,
  _In_ UINT cEntries,
  _Out_writes_to_(cEntries,return) RGBQUAD *prgbq);

int
WINAPI
GetDIBits(
  _In_ HDC hdc,
  _In_ HBITMAP hbm,
  _In_ UINT start,
  _In_ UINT cLines,
  _Out_opt_ LPVOID lpvBits,
  _At_((LPBITMAPINFOHEADER)lpbmi, _Inout_) LPBITMAPINFO lpbmi,
  _In_ UINT usage);

HENHMETAFILE WINAPI GetEnhMetaFileA(_In_ LPCSTR);
HENHMETAFILE WINAPI GetEnhMetaFileW(_In_ LPCWSTR);

UINT
WINAPI
GetEnhMetaFileBits(
  _In_ HENHMETAFILE hEMF,
  _In_ UINT nSize,
  _Out_writes_bytes_opt_(nSize) LPBYTE lpData);

UINT
WINAPI
GetEnhMetaFileDescriptionA(
  _In_ HENHMETAFILE hemf,
  _In_ UINT cchBuffer,
  _Out_writes_opt_(cchBuffer) LPSTR lpDescription);

UINT
WINAPI
GetEnhMetaFileDescriptionW(
  _In_ HENHMETAFILE hemf,
  _In_ UINT cchBuffer,
  _Out_writes_opt_(cchBuffer) LPWSTR lpDescription);

UINT
WINAPI
GetEnhMetaFileHeader(
  _In_ HENHMETAFILE hemf,
  _In_ UINT nSize,
  _Out_writes_bytes_opt_(nSize) LPENHMETAHEADER lpEnhMetaHeader);

UINT
WINAPI
GetEnhMetaFilePaletteEntries(
  _In_ HENHMETAFILE hemf,
  _In_ UINT nNumEntries,
  _Out_writes_opt_(nNumEntries) LPPALETTEENTRY lpPaletteEntries);

UINT
WINAPI
GetEnhMetaFilePixelFormat(
  _In_ HENHMETAFILE hemf,
  _In_ UINT cbBuffer,
  _Out_writes_bytes_opt_(cbBuffer) PIXELFORMATDESCRIPTOR *ppfd);

_Success_(return != GDI_ERROR)
DWORD
WINAPI
GetFontData(
  _In_ HDC hdc,
  _In_ DWORD dwTable,
  _In_ DWORD dwOffset,
  _Out_writes_bytes_to_opt_(cjBuffer, return) PVOID pvBuffer,
  _In_ DWORD cjBuffer);

DWORD WINAPI GetFontLanguageInfo(_In_ HDC);
#if (_WIN32_WINNT >= 0x0500)
DWORD WINAPI GetFontUnicodeRanges(_In_ HDC, _Out_opt_ LPGLYPHSET);
#endif

DWORD
WINAPI
GetGlyphIndicesA(
  _In_ HDC hdc,
  _In_reads_(c) LPCSTR lpstr,
  _In_ int c,
  _Out_writes_(c) LPWORD pgi,
  _In_ DWORD fl);

DWORD
WINAPI
GetGlyphIndicesW(
  _In_ HDC hdc,
  _In_reads_(c) LPCWSTR lpstr,
  _In_ int c,
  _Out_writes_(c) LPWORD pgi,
  _In_ DWORD fl);

DWORD
WINAPI
GetGlyphOutlineA(
  _In_ HDC hdc,
  _In_ UINT uChar,
  _In_ UINT fuFormat,
  _Out_ LPGLYPHMETRICS lpgm,
  _In_ DWORD cjBuffer,
  _Out_writes_bytes_opt_(cjBuffer) LPVOID pvBuffer,
  _In_ CONST MAT2 *lpmat2);

DWORD
WINAPI
GetGlyphOutlineW(
  _In_ HDC hdc,
  _In_ UINT uChar,
  _In_ UINT fuFormat,
  _Out_ LPGLYPHMETRICS lpgm,
  _In_ DWORD cjBuffer,
  _Out_writes_bytes_opt_(cjBuffer) LPVOID pvBuffer,
  _In_ CONST MAT2 *lpmat2);

int WINAPI GetGraphicsMode(_In_ HDC);

BOOL
WINAPI
GetICMProfileA(
  _In_ HDC hdc,
  _Inout_ LPDWORD pBufSize,
  _Out_writes_opt_(*pBufSize) LPSTR pszFilename);

BOOL
WINAPI
GetICMProfileW(
  _In_ HDC hdc,
  _Inout_ LPDWORD pBufSize,
  _Out_writes_opt_(*pBufSize) LPWSTR pszFilename);

DWORD
WINAPI
GetKerningPairsA(
  _In_ HDC hdc,
  _In_ DWORD nPairs,
  _Out_writes_to_opt_(nPairs, return) LPKERNINGPAIR lpKernPair);

DWORD
WINAPI
GetKerningPairsW(
  _In_ HDC hdc,
  _In_ DWORD nPairs,
  _Out_writes_to_opt_(nPairs, return) LPKERNINGPAIR lpKernPair);

BOOL
WINAPI
GetLogColorSpaceA(
  _In_ HCOLORSPACE hColorSpace,
  _Out_writes_bytes_(nSize) LPLOGCOLORSPACEA lpBuffer,
  _In_ DWORD nSize);

BOOL
WINAPI
GetLogColorSpaceW(
  _In_ HCOLORSPACE hColorSpace,
  _Out_writes_bytes_(nSize) LPLOGCOLORSPACEW lpBuffer,
  _In_ DWORD nSize);

int WINAPI GetMapMode(_In_ HDC);
HMETAFILE WINAPI GetMetaFileA(_In_ LPCSTR);
HMETAFILE WINAPI GetMetaFileW(_In_ LPCWSTR);

UINT
WINAPI
GetMetaFileBitsEx(
  _In_ HMETAFILE hMF,
  _In_ UINT cbBuffer,
  _Out_writes_bytes_opt_(cbBuffer) LPVOID lpData);

int WINAPI GetMetaRgn(_In_ HDC, _In_ HRGN);
BOOL WINAPI GetMiterLimit(_In_ HDC, _Out_ PFLOAT);
COLORREF WINAPI GetNearestColor(_In_ HDC, _In_ COLORREF);
UINT WINAPI GetNearestPaletteIndex(_In_ HPALETTE, _In_ COLORREF);

int
WINAPI
GetObjectA(
  _In_ HANDLE h,
  _In_ int c,
  _Out_writes_bytes_opt_(c) LPVOID pv);

int
WINAPI
GetObjectW(
  _In_ HANDLE h,
  _In_ int c,
  _Out_writes_bytes_opt_(c) LPVOID pv);

DWORD WINAPI GetObjectType(_In_ HGDIOBJ);

UINT
WINAPI
GetOutlineTextMetricsA(
  _In_ HDC hdc,
  _In_ UINT cjCopy,
  _Out_writes_bytes_opt_(cjCopy) LPOUTLINETEXTMETRICA potm);

UINT
WINAPI
GetOutlineTextMetricsW(
  _In_ HDC hdc,
  _In_ UINT cjCopy,
  _Out_writes_bytes_opt_(cjCopy) LPOUTLINETEXTMETRICW potm);

_Ret_range_(0,cEntries)
UINT
WINAPI
GetPaletteEntries(
  _In_ HPALETTE hpal,
  _In_ UINT iStart,
  _In_ UINT cEntries,
  _Out_writes_to_opt_(cEntries,return) LPPALETTEENTRY pPalEntries);

int
WINAPI
GetPath(
  _In_ HDC hdc,
  _Out_writes_opt_(cpt) LPPOINT apt,
  _Out_writes_opt_(cpt) LPBYTE aj,
  int cpt);

COLORREF WINAPI GetPixel(_In_ HDC, _In_ int, _In_ int);
int WINAPI GetPixelFormat(_In_ HDC);
int WINAPI GetPolyFillMode(_In_ HDC);

BOOL
WINAPI
GetRasterizerCaps(
  _Out_writes_bytes_(cjBytes) LPRASTERIZER_STATUS lpraststat,
  _In_ UINT cjBytes);

int WINAPI GetRandomRgn(_In_ HDC, _In_ HRGN, _In_ INT);

DWORD
WINAPI
GetRegionData(
  _In_ HRGN hrgn,
  _In_ DWORD nCount,
  _Out_writes_bytes_to_opt_(nCount, return) LPRGNDATA lpRgnData);

int WINAPI GetRgnBox(_In_ HRGN, _Out_ LPRECT);
int WINAPI GetROP2(_In_ HDC);
HGDIOBJ WINAPI GetStockObject(_In_ int);
int WINAPI GetStretchBltMode(_In_ HDC);

UINT
WINAPI
GetSystemPaletteEntries(
  _In_ HDC  hdc,
  _In_ UINT iStart,
  _In_ UINT cEntries,
  _Out_writes_opt_(cEntries) LPPALETTEENTRY pPalEntries);

UINT WINAPI GetSystemPaletteUse(_In_ HDC);
UINT WINAPI GetTextAlign(_In_ HDC);
int WINAPI GetTextCharacterExtra(_In_ HDC);
int WINAPI GetTextCharset(_In_ HDC);
int WINAPI GetTextCharsetInfo(_In_ HDC, _Out_opt_ LPFONTSIGNATURE, _In_ DWORD);
COLORREF WINAPI GetTextColor(_In_ HDC);

BOOL
WINAPI
GetTextExtentExPointA(
  _In_ HDC hdc,
  _In_reads_(cchString) LPCSTR lpszString,
  _In_ int cchString,
  _In_ int nMaxExtent,
  _Out_opt_ LPINT lpnFit,
  _Out_writes_to_opt_ (cchString, *lpnFit) LPINT lpnDx,
  _Out_ LPSIZE lpSize);

BOOL
WINAPI
GetTextExtentExPointW(
  _In_ HDC hdc,
  _In_reads_(cchString) LPCWSTR lpszString,
  _In_ int cchString,
  _In_ int nMaxExtent,
  _Out_opt_ LPINT lpnFit,
  _Out_writes_to_opt_ (cchString, *lpnFit) LPINT lpnDx,
  _Out_ LPSIZE lpSize);

BOOL
WINAPI
GetTextExtentExPointI(
  _In_ HDC hdc,
  _In_reads_(cwchString) LPWORD lpwszString,
  _In_ int cwchString,
  _In_ int nMaxExtent,
  _Out_opt_ LPINT lpnFit,
  _Out_writes_to_opt_(cwchString, *lpnFit) LPINT lpnDx,
  _Out_ LPSIZE lpSize);

BOOL
WINAPI
GetTextExtentPointA(
  _In_ HDC hdc,
  _In_reads_(c) LPCSTR lpString,
  _In_ int c,
  _Out_ LPSIZE lpsz);

BOOL
WINAPI
GetTextExtentPointW(
  _In_ HDC hdc,
  _In_reads_(c) LPCWSTR lpString,
  _In_ int c,
  _Out_ LPSIZE lpsz);

BOOL
WINAPI
GetTextExtentPointI(
  _In_ HDC hdc,
  _In_reads_(cgi) LPWORD pgiIn,
  _In_ int cgi,
  _Out_ LPSIZE psize);

BOOL
WINAPI
GetTextExtentPoint32A(
  _In_ HDC hdc,
  _In_reads_(c) LPCSTR lpString,
  _In_ int c,
  _Out_ LPSIZE psizl);

BOOL
WINAPI
GetTextExtentPoint32W(
  _In_ HDC hdc,
  _In_reads_(c) LPCWSTR lpString,
  _In_ int c,
  _Out_ LPSIZE psizl);

int
WINAPI
GetTextFaceA(
  _In_ HDC hdc,
  _In_ int c,
  _Out_writes_to_opt_(c, return) LPSTR lpName);

int
WINAPI
GetTextFaceW(
  _In_ HDC hdc,
  _In_ int c,
  _Out_writes_to_opt_(c, return) LPWSTR lpName);

BOOL WINAPI GetTextMetricsA(_In_ HDC, _Out_ LPTEXTMETRICA);
BOOL WINAPI GetTextMetricsW(_In_ HDC, _Out_ LPTEXTMETRICW);
BOOL WINAPI GetTransform(HDC,DWORD,XFORM*);
BOOL WINAPI GetViewportExtEx(_In_ HDC, _Out_ LPSIZE);
BOOL WINAPI GetViewportOrgEx(_In_ HDC, _Out_ LPPOINT);
BOOL WINAPI GetWindowExtEx(_In_ HDC, _Out_ LPSIZE);
BOOL WINAPI GetWindowOrgEx(_In_ HDC, _Out_ LPPOINT);

UINT
WINAPI
GetWinMetaFileBits(
  _In_ HENHMETAFILE hemf,
  _In_ UINT cbData16,
  _Out_writes_bytes_opt_(cbData16) LPBYTE pData16,
  _In_ INT iMapMode,
  _In_ HDC hdcRef);

BOOL WINAPI GetWorldTransform(_In_ HDC, _Out_ LPXFORM);
int WINAPI IntersectClipRect(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int);
BOOL WINAPI InvertRgn(_In_ HDC, _In_ HRGN);
BOOL WINAPI LineDDA(_In_ int, _In_ int, _In_ int, _In_ int, _In_ LINEDDAPROC, _In_opt_ LPARAM);
BOOL WINAPI LineTo(_In_ HDC, _In_ int, _In_ int);

BOOL
WINAPI
LPtoDP(
  _In_ HDC hdc,
  _Inout_updates_(c) LPPOINT lppt,
  _In_ int c);

BOOL WINAPI MaskBlt(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ HDC, _In_ int, _In_ int, _In_ HBITMAP, _In_ int, _In_ int, _In_ DWORD);
BOOL WINAPI ModifyWorldTransform(_In_ HDC, _In_opt_ const XFORM*, _In_ DWORD);
BOOL WINAPI MoveToEx(_In_ HDC, _In_ int, _In_ int, _Out_opt_ LPPOINT);
int WINAPI OffsetClipRgn(_In_ HDC, _In_ int, _In_ int);
int WINAPI OffsetRgn(_In_ HRGN, _In_ int, _In_ int);
BOOL WINAPI OffsetViewportOrgEx(_In_ HDC, _In_ int, _In_ int, _Out_opt_ LPPOINT);
BOOL WINAPI OffsetWindowOrgEx(_In_ HDC, _In_ int, _In_ int, _Out_opt_ LPPOINT);
BOOL WINAPI PaintRgn(_In_ HDC, _In_ HRGN);
BOOL WINAPI PatBlt(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ DWORD);
HRGN WINAPI PathToRegion(_In_ HDC);
BOOL WINAPI Pie(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int);
BOOL WINAPI PlayEnhMetaFile(_In_ HDC, _In_ HENHMETAFILE, _In_ LPCRECT);

BOOL
WINAPI
PlayEnhMetaFileRecord(
  _In_ HDC hdc,
  _In_reads_(cht) LPHANDLETABLE pht,
  _In_ CONST ENHMETARECORD *pmr,
  _In_ UINT cht);

BOOL WINAPI PlayMetaFile(_In_ HDC, _In_ HMETAFILE);

BOOL
WINAPI
PlayMetaFileRecord(
  _In_ HDC hdc,
  _In_reads_(noObjs) LPHANDLETABLE lpHandleTable,
  _In_ LPMETARECORD lpMR,
  _In_ UINT noObjs);

BOOL
WINAPI
PlgBlt(
  _In_ HDC hdcDest,
  _In_reads_(3) const POINT *lpPoint,
  _In_ HDC hdcSrc,
  _In_ int xSrc,
  _In_ int ySrc,
  _In_ int width,
  _In_ int height,
  _In_opt_ HBITMAP hbmMask,
  _In_ int xMask,
  _In_ int yMask);

BOOL
WINAPI
PolyBezier(
  _In_ HDC hdc,
  _In_reads_(cpt) const POINT *apt,
  _In_ DWORD cpt);

BOOL
WINAPI
PolyBezierTo(
  _In_ HDC hdc,
  _In_reads_(cpt) const POINT *apt,
  _In_ DWORD cpt);

BOOL
WINAPI
PolyDraw(
  _In_ HDC hdc,
  _In_reads_(cpt) const POINT * apt,
  _In_reads_(cpt) const BYTE * aj,
  _In_ int cpt);

BOOL
WINAPI
Polygon(
  _In_ HDC hdc,
  _In_reads_(cpt) const POINT *apt,
  _In_ int cpt);

BOOL
WINAPI
Polyline(
  _In_ HDC hdc,
  _In_reads_(cpt) const POINT *apt,
  _In_ int cpt);

BOOL
WINAPI
PolylineTo(
  _In_ HDC hdc,
  _In_reads_(cpt) const POINT *apt,
  _In_ DWORD cpt);

BOOL
WINAPI
PolyPolygon(
  _In_ HDC hdc,
  _In_ const POINT *apt,
  _In_reads_(csz) const INT *asz,
  _In_ int csz);

BOOL
WINAPI
PolyPolyline(
  _In_ HDC hdc,
  _In_ const POINT *apt,
  _In_reads_(csz) const DWORD *asz,
  _In_ DWORD csz);

BOOL
WINAPI
PolyTextOutA(
  _In_ HDC hdc,
  _In_reads_(nstrings) const POLYTEXTA *ppt,
  _In_ int nstrings);

BOOL
WINAPI
PolyTextOutW(
  _In_ HDC hdc,
  _In_reads_(nstrings) const POLYTEXTW *ppt,
  _In_ int nstrings);

BOOL WINAPI PtInRegion(_In_ HRGN, _In_ int, _In_ int);
BOOL WINAPI PtVisible(_In_ HDC, _In_ int, _In_ int);
UINT WINAPI RealizePalette(_In_ HDC);
BOOL WINAPI Rectangle(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int);
BOOL WINAPI RectInRegion(_In_ HRGN, _In_ LPCRECT);
BOOL WINAPI RectVisible(_In_ HDC, _In_ LPCRECT);
BOOL WINAPI RemoveFontResourceA(_In_ LPCSTR);
BOOL WINAPI RemoveFontResourceW(_In_ LPCWSTR);
#if (_WIN32_WINNT >= 0x0500)
BOOL WINAPI RemoveFontMemResourceEx(_In_ HANDLE);
BOOL WINAPI RemoveFontResourceExA(_In_ LPCSTR, _In_ DWORD, _Reserved_ PVOID);
BOOL WINAPI RemoveFontResourceExW(_In_ LPCWSTR, _In_ DWORD, _Reserved_ PVOID);
#endif
HDC WINAPI ResetDCA(_In_ HDC, _In_ const DEVMODEA*);
HDC WINAPI ResetDCW(_In_ HDC, _In_ const DEVMODEW*);
BOOL WINAPI ResizePalette(_In_ HPALETTE, _In_ UINT);
BOOL WINAPI RestoreDC(_In_ HDC, _In_ int);
BOOL WINAPI RoundRect(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int);
int WINAPI SaveDC(_In_ HDC);
BOOL WINAPI ScaleViewportExtEx(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _Out_opt_ LPSIZE);
BOOL WINAPI ScaleWindowExtEx(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _Out_opt_ LPSIZE);
BOOL WINAPI SelectClipPath(_In_ HDC, _In_ int);
int WINAPI SelectClipRgn(_In_ HDC, _In_opt_ HRGN);
HGDIOBJ WINAPI SelectObject(_In_ HDC, _In_ HGDIOBJ);
HPALETTE WINAPI SelectPalette(_In_ HDC, _In_ HPALETTE, _In_ BOOL);
int WINAPI SetAbortProc(_In_ HDC, _In_ ABORTPROC);
int WINAPI SetArcDirection(_In_ HDC, _In_ int);

LONG
WINAPI
SetBitmapBits(
  _In_ HBITMAP hbm,
  _In_ DWORD cb,
  _In_reads_bytes_(cb) CONST VOID *pvBits);

BOOL WINAPI SetBitmapDimensionEx(_In_ HBITMAP, _In_ int, _In_ int, _Out_opt_ LPSIZE);
COLORREF WINAPI SetBkColor(_In_ HDC, _In_ COLORREF);
int WINAPI SetBkMode(_In_ HDC, _In_ int);
UINT WINAPI SetBoundsRect(_In_ HDC, _In_opt_ LPCRECT, _In_ UINT);
BOOL WINAPI SetBrushOrgEx(_In_ HDC, _In_ int, _In_ int, _Out_opt_ LPPOINT);
BOOL WINAPI SetColorAdjustment(_In_ HDC, _In_ const COLORADJUSTMENT*);
HCOLORSPACE WINAPI SetColorSpace(_In_ HDC, _In_ HCOLORSPACE);
#if (_WIN32_WINNT >= 0x0500)
COLORREF WINAPI SetDCBrushColor(_In_ HDC, _In_ COLORREF);
COLORREF WINAPI SetDCPenColor(_In_ HDC, _In_ COLORREF);
#endif

BOOL
WINAPI
SetDeviceGammaRamp(
  _In_ HDC hdc,
  _In_reads_bytes_(3*256*2) LPVOID lpRamp);

UINT
WINAPI
SetDIBColorTable(
  _In_ HDC  hdc,
  _In_ UINT iStart,
  _In_ UINT cEntries,
  _In_reads_(cEntries) const RGBQUAD *prgbq);

int WINAPI SetDIBits(_In_opt_ HDC, _In_ HBITMAP, _In_ UINT, _In_ UINT, _In_ CONST VOID*, _In_ CONST BITMAPINFO*, _In_ UINT);
int WINAPI SetDIBitsToDevice(_In_ HDC, _In_ int, _In_ int, _In_ DWORD, _In_ DWORD, _In_ int, _In_ int, _In_ UINT, _In_ UINT, _In_ CONST VOID*, _In_ CONST BITMAPINFO*, _In_ UINT);

HENHMETAFILE
WINAPI
SetEnhMetaFileBits(
  _In_ UINT nSize,
  _In_reads_bytes_(nSize) const BYTE * pb);

int WINAPI SetGraphicsMode(_In_ HDC, _In_ int);
int WINAPI SetICMMode(_In_ HDC, _In_ int);
BOOL WINAPI SetICMProfileA(_In_ HDC, _In_ LPSTR);
BOOL WINAPI SetICMProfileW(_In_ HDC, _In_ LPWSTR);
int WINAPI SetMapMode(_In_ HDC, _In_ int);
DWORD WINAPI SetMapperFlags(_In_ HDC, _In_ DWORD);
#if (_WIN32_WINNT >= 0x0500)
DWORD WINAPI SetLayout(_In_ HDC, _In_ DWORD);
DWORD WINAPI GetLayout(_In_ HDC);
#endif

HMETAFILE
WINAPI
SetMetaFileBitsEx(
  _In_ UINT cbBuffer,
  _In_reads_bytes_(cbBuffer) CONST BYTE *lpData);

int WINAPI SetMetaRgn(_In_ HDC);
BOOL WINAPI SetMiterLimit(_In_ HDC, _In_ FLOAT, _Out_opt_ PFLOAT);

UINT
WINAPI
SetPaletteEntries(
  _In_ HPALETTE hpal,
  _In_ UINT iStart,
  _In_ UINT cEntries,
  _In_reads_(cEntries) CONST PALETTEENTRY *pPalEntries);

COLORREF WINAPI SetPixel(_In_ HDC, _In_ int, _In_ int, _In_ COLORREF);
BOOL WINAPI SetPixelFormat(_In_ HDC, _In_ int, _In_ const PIXELFORMATDESCRIPTOR*);
BOOL WINAPI SetPixelV(_In_ HDC, _In_ int, _In_ int, _In_ COLORREF);
int WINAPI SetPolyFillMode(_In_ HDC, _In_ int);
BOOL WINAPI SetRectRgn(_In_ HRGN, _In_ int, _In_ int, _In_ int, _In_ int);
INT WINAPI SetRelAbs(HDC,INT);
int WINAPI SetROP2(_In_ HDC, _In_ int);
int WINAPI SetStretchBltMode(_In_ HDC, _In_ int);
UINT WINAPI SetSystemPaletteUse(_In_ HDC, _In_ UINT);
UINT WINAPI SetTextAlign(_In_ HDC, _In_ UINT);
int WINAPI SetTextCharacterExtra(_In_ HDC, _In_ int);
COLORREF WINAPI SetTextColor(_In_ HDC, _In_ COLORREF);
BOOL WINAPI SetTextJustification(_In_ HDC, _In_ int, _In_ int);
BOOL WINAPI SetViewportExtEx(_In_ HDC, _In_ int, _In_ int, _Out_opt_ LPSIZE);
BOOL WINAPI SetViewportOrgEx(_In_ HDC, _In_ int, _In_ int, _Out_opt_ LPPOINT);
BOOL WINAPI SetWindowExtEx(_In_ HDC, _In_ int, _In_ int, _Out_opt_ LPSIZE);
BOOL WINAPI SetWindowOrgEx(_In_ HDC, _In_ int, _In_ int, _Out_opt_ LPPOINT);

HENHMETAFILE
WINAPI
SetWinMetaFileBits(
  _In_ UINT nSize,
  _In_reads_bytes_(nSize) const BYTE *lpMeta16Data,
  _In_opt_ HDC hdcRef,
  _In_opt_ const METAFILEPICT *lpMFP);

BOOL WINAPI SetWorldTransform(_In_ HDC, _In_ const XFORM *);
int WINAPI StartDocA(_In_ HDC, _In_ const DOCINFOA*);
int WINAPI StartDocW(_In_ HDC, _In_ const DOCINFOW*);
int WINAPI StartPage(_In_ HDC);
BOOL WINAPI StretchBlt(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_opt_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ DWORD);
int WINAPI StretchDIBits(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int, _In_opt_ const VOID *, _In_ const BITMAPINFO *, _In_ UINT, _In_ DWORD);
BOOL WINAPI StrokeAndFillPath(_In_ HDC);
BOOL WINAPI StrokePath(_In_ HDC);
BOOL WINAPI SwapBuffers(HDC);

BOOL
WINAPI
TextOutA(
  _In_ HDC hdc,
  _In_ int x,
  _In_ int y,
  _In_reads_(c) LPCSTR lpString,
  _In_ int c);

BOOL
WINAPI
TextOutW(
  _In_ HDC hdc,
  _In_ int x,
  _In_ int y,
  _In_reads_(c) LPCWSTR lpString,
  _In_ int c);

BOOL WINAPI TranslateCharsetInfo(_Inout_ PDWORD, _Out_ LPCHARSETINFO, _In_ DWORD);
BOOL WINAPI UnrealizeObject(_In_ HGDIOBJ);
BOOL WINAPI UpdateColors(_In_ HDC);
BOOL WINAPI UpdateICMRegKeyA(_Reserved_ DWORD, _In_ LPSTR, _In_ LPSTR, _In_ UINT);
BOOL WINAPI UpdateICMRegKeyW(_Reserved_ DWORD, _In_ LPWSTR, _In_ LPWSTR, _In_ UINT);
BOOL WINAPI WidenPath(_In_ HDC);
BOOL WINAPI wglCopyContext(HGLRC,HGLRC,UINT);
HGLRC WINAPI wglCreateContext(HDC);
HGLRC WINAPI wglCreateLayerContext(HDC,int);
BOOL WINAPI wglDeleteContext(HGLRC);
BOOL WINAPI wglDescribeLayerPlane(HDC,int,int,UINT,LPLAYERPLANEDESCRIPTOR);
HGLRC WINAPI wglGetCurrentContext(void);
HDC WINAPI wglGetCurrentDC(void);
int WINAPI wglGetLayerPaletteEntries(HDC,int,int,int,COLORREF*);
PROC WINAPI wglGetProcAddress(LPCSTR);
BOOL WINAPI wglMakeCurrent(HDC,HGLRC);
BOOL WINAPI wglRealizeLayerPalette(HDC,int,BOOL);
int WINAPI wglSetLayerPaletteEntries(HDC,int,int,int,const COLORREF*);
BOOL WINAPI wglShareLists(HGLRC,HGLRC);
BOOL WINAPI wglSwapLayerBuffers(HDC,UINT);
BOOL WINAPI wglUseFontBitmapsA(HDC,DWORD,DWORD,DWORD);
BOOL WINAPI wglUseFontBitmapsW(HDC,DWORD,DWORD,DWORD);
BOOL WINAPI wglUseFontOutlinesA(HDC,DWORD,DWORD,DWORD,FLOAT,FLOAT,int,LPGLYPHMETRICSFLOAT);
BOOL WINAPI wglUseFontOutlinesW(HDC,DWORD,DWORD,DWORD,FLOAT,FLOAT,int,LPGLYPHMETRICSFLOAT);

#if (WINVER >= 0x0500)

typedef struct _WGLSWAP
{
    HDC hdc;
    UINT uiFlags;
} WGLSWAP, *PWGLSWAP, FAR *LPWGLSWAP;

#define WGL_SWAPMULTIPLE_MAX 16

DWORD WINAPI wglSwapMultipleBuffers(UINT, CONST WGLSWAP *);

#endif // (WINVER >= 0x0500)

#if (WINVER>= 0x0500)

BOOL WINAPI AlphaBlend(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ BLENDFUNCTION);

BOOL
WINAPI
GradientFill(
  _In_ HDC hdc,
  _In_reads_(nVertex) PTRIVERTEX pVertex,
  _In_ ULONG nVertex,
  _In_ PVOID pMesh,
  _In_ ULONG nMesh,
  _In_ ULONG ulMode);

BOOL WINAPI TransparentBlt(_In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ HDC, _In_ int, _In_ int, _In_ int, _In_ int, _In_ UINT);

#endif

#ifdef UNICODE
typedef AXESLISTW AXESLIST;
typedef PAXESLISTW PAXESLIST;
typedef LPAXESLISTW LPAXESLIST;
typedef AXISINFOA AXISINFO;
typedef PAXISINFOA PAXISINFO;
typedef LPAXISINFOA LPAXISINFO;
typedef WCHAR BCHAR;
typedef DOCINFOW DOCINFO, *LPDOCINFO;
typedef LOGFONTW LOGFONT,*PLOGFONT,*LPLOGFONT;
typedef TEXTMETRICW TEXTMETRIC,*PTEXTMETRIC,*LPTEXTMETRIC;
#define ICMENUMPROC ICMENUMPROCW
typedef DEVMODEW DEVMODE,*PDEVMODE,*LPDEVMODE;
typedef ENUMLOGFONTEXDVW ENUMLOGFONTEXDV;
typedef PENUMLOGFONTEXDVW PENUMLOGFONTEXDV;
typedef LPENUMLOGFONTEXDVW LPENUMLOGFONTEXDV;
typedef ENUMTEXTMETRICW ENUMTEXTMETRIC;
typedef PENUMTEXTMETRICW PENUMTEXTMETRIC;
typedef LPENUMTEXTMETRICW LPENUMTEXTMETRIC;
typedef EXTLOGFONTW EXTLOGFONT,*PEXTLOGFONT,*LPEXTLOGFONT;
typedef GCP_RESULTSW GCP_RESULTS,*LPGCP_RESULTS;
typedef OUTLINETEXTMETRICW OUTLINETEXTMETRIC,*POUTLINETEXTMETRIC,*LPOUTLINETEXTMETRIC;
typedef POLYTEXTW POLYTEXT,*PPOLYTEXT,*LPPOLYTEXT;
typedef LOGCOLORSPACEW LOGCOLORSPACE,*LPLOGCOLORSPACE;
typedef NEWTEXTMETRICW NEWTEXTMETRIC,*PNEWTEXTMETRIC,*LPNEWTEXTMETRIC;
typedef NEWTEXTMETRICEXW NEWTEXTMETRICEX;
typedef ENUMLOGFONTW ENUMLOGFONT,*LPENUMLOGFONT;
typedef ENUMLOGFONTEXW ENUMLOGFONTEX,*LPENUMLOGFONTEX;
typedef DISPLAY_DEVICEW DISPLAY_DEVICE, *PDISPLAY_DEVICE, *LPDISPLAY_DEVICE;
#define AddFontResource AddFontResourceW
#if (_WIN32_WINNT >= 0x0500)
#define AddFontResourceEx AddFontResourceExW
#endif
#define CopyEnhMetaFile CopyEnhMetaFileW
#define CopyMetaFile CopyMetaFileW
#define CreateDC CreateDCW
#define CreateEnhMetaFile CreateEnhMetaFileW
#define CreateFont CreateFontW
#define CreateFontIndirect CreateFontIndirectW
#define CreateFontIndirectEx CreateFontIndirectExW
#define CreateIC CreateICW
#define CreateMetaFile CreateMetaFileW
#define CreateScalableFontResource CreateScalableFontResourceW
#define DeviceCapabilities DeviceCapabilitiesW
#define EnumFontFamilies EnumFontFamiliesW
#define EnumFontFamiliesEx EnumFontFamiliesExW
#define EnumFonts EnumFontsW
#define EnumICMProfiles EnumICMProfilesW
#define ExtTextOut ExtTextOutW
#define GetCharABCWidthsFloat GetCharABCWidthsFloatW
#define GetCharABCWidths GetCharABCWidthsW
#define GetCharacterPlacement GetCharacterPlacementW
#define GetCharWidth32 GetCharWidth32W
#define GetCharWidthFloat GetCharWidthFloatW
#define GetCharWidth GetCharWidthW
#define GetEnhMetaFile GetEnhMetaFileW
#define GetEnhMetaFileDescription GetEnhMetaFileDescriptionW
#define GetGlyphOutline GetGlyphOutlineW
#define GetICMProfile GetICMProfileW
#define GetKerningPairs GetKerningPairsW
#define GetLogColorSpace GetLogColorSpaceW
#define GetMetaFile GetMetaFileW
#define GetObject GetObjectW
#define GetOutlineTextMetrics GetOutlineTextMetricsW
#define GetTextExtentPoint GetTextExtentPointW
#define GetTextExtentExPoint GetTextExtentExPointW
#define GetTextExtentPoint32 GetTextExtentPoint32W
#define GetTextFace GetTextFaceW
#define GetTextMetrics GetTextMetricsW
#define PolyTextOut PolyTextOutW
#define RemoveFontResource RemoveFontResourceW
#if (_WIN32_WINNT >= 0x0500)
#define RemoveFontResourceEx RemoveFontResourceExW
#endif
#define ResetDC ResetDCW
#define SetICMProfile SetICMProfileW
#define StartDoc StartDocW
#define TextOut TextOutW
#define UpdateICMRegKey UpdateICMRegKeyW
#define wglUseFontBitmaps wglUseFontBitmapsW
#define wglUseFontOutlines wglUseFontOutlinesW
#else
typedef AXESLISTA AXESLIST;
typedef PAXESLISTA PAXESLIST;
typedef LPAXESLISTA LPAXESLIST;
typedef AXISINFOA AXISINFO;
typedef PAXISINFOA PAXISINFO;
typedef LPAXISINFOA LPAXISINFO;
typedef BYTE BCHAR;
typedef DOCINFOA DOCINFO, *LPDOCINFO;
typedef LOGFONTA LOGFONT,*PLOGFONT,*LPLOGFONT;
typedef TEXTMETRICA TEXTMETRIC,*PTEXTMETRIC,*LPTEXTMETRIC;
#define ICMENUMPROC ICMENUMPROCA
typedef DEVMODEA DEVMODE,*PDEVMODE,*LPDEVMODE;
typedef ENUMLOGFONTEXDVA ENUMLOGFONTEXDV;
typedef PENUMLOGFONTEXDVA PENUMLOGFONTEXDV;
typedef LPENUMLOGFONTEXDVA LPENUMLOGFONTEXDV;
typedef ENUMTEXTMETRICA ENUMTEXTMETRIC;
typedef PENUMTEXTMETRICA PENUMTEXTMETRIC;
typedef LPENUMTEXTMETRICA LPENUMTEXTMETRIC;
typedef EXTLOGFONTA EXTLOGFONT,*PEXTLOGFONT,*LPEXTLOGFONT;
typedef GCP_RESULTSA GCP_RESULTS,*LPGCP_RESULTS;
typedef OUTLINETEXTMETRICA OUTLINETEXTMETRIC,*POUTLINETEXTMETRIC,*LPOUTLINETEXTMETRIC;
typedef POLYTEXTA POLYTEXT,*PPOLYTEXT,*LPPOLYTEXT;
typedef LOGCOLORSPACEA LOGCOLORSPACE,*LPLOGCOLORSPACE;
typedef NEWTEXTMETRICA NEWTEXTMETRIC,*PNEWTEXTMETRIC,*LPNEWTEXTMETRIC;
typedef NEWTEXTMETRICEXA NEWTEXTMETRICEX;
typedef ENUMLOGFONTA ENUMLOGFONT,*LPENUMLOGFONT;
typedef ENUMLOGFONTEXA ENUMLOGFONTEX,*LPENUMLOGFONTEX;
typedef DISPLAY_DEVICEA DISPLAY_DEVICE, *PDISPLAY_DEVICE, *LPDISPLAY_DEVICE;
#define AddFontResource AddFontResourceA
#if (_WIN32_WINNT >= 0x0500)
#define AddFontResourceEx AddFontResourceExA
#endif
#define CopyEnhMetaFile CopyEnhMetaFileA
#define CopyMetaFile CopyMetaFileA
#define CreateDC CreateDCA
#define CreateEnhMetaFile CreateEnhMetaFileA
#define CreateFont CreateFontA
#define CreateFontIndirect CreateFontIndirectA
#define CreateFontIndirectEx CreateFontIndirectExA
#define CreateIC CreateICA
#define CreateMetaFile CreateMetaFileA
#define CreateScalableFontResource CreateScalableFontResourceA
#define DeviceCapabilities DeviceCapabilitiesA
#define EnumFontFamilies EnumFontFamiliesA
#define EnumFontFamiliesEx EnumFontFamiliesExA
#define EnumFonts EnumFontsA
#define EnumICMProfiles EnumICMProfilesA
#define ExtTextOut ExtTextOutA
#define GetCharWidthFloat GetCharWidthFloatA
#define GetCharWidth GetCharWidthA
#define GetCharacterPlacement GetCharacterPlacementA
#define GetCharABCWidths GetCharABCWidthsA
#define GetCharABCWidthsFloat GetCharABCWidthsFloatA
#define GetCharWidth32 GetCharWidth32A
#define GetEnhMetaFile GetEnhMetaFileA
#define GetEnhMetaFileDescription GetEnhMetaFileDescriptionA
#define GetGlyphOutline GetGlyphOutlineA
#define GetICMProfile GetICMProfileA
#define GetKerningPairs GetKerningPairsA
#define GetLogColorSpace GetLogColorSpaceA
#define GetMetaFile GetMetaFileA
#define GetObject GetObjectA
#define GetOutlineTextMetrics GetOutlineTextMetricsA
#define GetTextExtentPoint GetTextExtentPointA
#define GetTextExtentExPoint GetTextExtentExPointA
#define GetTextExtentPoint32 GetTextExtentPoint32A
#define GetTextFace GetTextFaceA
#define GetTextMetrics GetTextMetricsA
#define PolyTextOut PolyTextOutA
#define RemoveFontResource RemoveFontResourceA
#if (_WIN32_WINNT >= 0x0500)
#define RemoveFontResourceEx RemoveFontResourceExA
#endif
#define ResetDC ResetDCA
#define SetICMProfile SetICMProfileA
#define StartDoc StartDocA
#define TextOut TextOutA
#define UpdateICMRegKey UpdateICMRegKeyA
#define wglUseFontBitmaps wglUseFontBitmapsA
#define wglUseFontOutlines wglUseFontOutlinesA
#endif
#endif

#ifdef __WINESRC__
/* the DC hook support is only exported on Win16, the 32-bit version is a Wine extension */

#define DCHC_INVALIDVISRGN      0x0001
#define DCHC_DELETEDC           0x0002
#define DCHF_INVALIDATEVISRGN   0x0001
#define DCHF_VALIDATEVISRGN     0x0002

typedef BOOL (CALLBACK *DCHOOKPROC)(HDC,WORD,DWORD_PTR,LPARAM);

WINGDIAPI DWORD_PTR WINAPI GetDCHook(HDC,DCHOOKPROC*);
WINGDIAPI BOOL      WINAPI SetDCHook(HDC,DCHOOKPROC,DWORD_PTR);
WINGDIAPI WORD      WINAPI SetHookFlags(HDC,WORD);
WINGDIAPI INT       WINAPI SelectVisRgn(HDC,HRGN);
#endif /* __WINESRC__ */

#ifdef _MSC_VER
#pragma warning(pop)
#endif

#ifdef __cplusplus
}
#endif

#endif //!NOGDI
#endif // _WINGDI_H
