typedef struct _CERTIFICATE_BLOB {
	DWORD dwCertEncodingType;
	DWORD cbData;
	PBYTE pbData;
} EFS_CERTIFICATE_BLOB, *PEFS_CERTIFICATE_BLOB;

typedef struct _EFS_HASH_BLOB {
	DWORD cbData;
	PBYTE pbData;
} EFS_HASH_BLOB, *PEFS_HASH_BLOB;

typedef struct _ENCRYPTION_CERTIFICATE {
	DWORD cbTotalLength;
	SID* pUserSid;
	PEFS_CERTIFICATE_BLOB pCertBlob;
} ENCRYPTION_CERTIFICATE, *PENCRYPTION_CERTIFICATE;

typedef struct _ENCRYPTION_CERTIFICATE_HASH {
	DWORD cbTotalLength;
	SID* pUserSid;
	PEFS_HASH_BLOB pHash;
	LPWSTR lpDisplayInformation;
} ENCRYPTION_CERTIFICATE_HASH, *PENCRYPTION_CERTIFICATE_HASH;

typedef struct _ENCRYPTION_CERTIFICATE_LIST {
	DWORD nUsers;
	PENCRYPTION_CERTIFICATE* pUsers;
} ENCRYPTION_CERTIFICATE_LIST, *PENCRYPTION_CERTIFICATE_LIST;

typedef struct _ENCRYPTION_CERTIFICATE_HASH_LIST {
	DWORD nCert_Hash;
	PENCRYPTION_CERTIFICATE_HASH* pUsers;
} ENCRYPTION_CERTIFICATE_HASH_LIST, *PENCRYPTION_CERTIFICATE_HASH_LIST;

DWORD WINAPI AddUsersToEncryptedFile (
	LPCWSTR,
	PENCRYPTION_CERTIFICATE_LIST
	);

DWORD WINAPI RemoveUsersFromEncryptedFile (
	LPCWSTR,
	PENCRYPTION_CERTIFICATE_HASH_LIST
	);

BOOL WINAPI EncryptionDisable (
	LPCWSTR,
	BOOL
	);

BOOL WINAPI FileEncryptionStatus (
	_In_ LPCTSTR,
	_Out_ LPDWORD
	);

DWORD WINAPI QueryUsersOnEncryptedFile (
	LPCWSTR,
	PENCRYPTION_CERTIFICATE_HASH_LIST*
	);

void WINAPI FreeEncryptionCertificateHashList (
	PENCRYPTION_CERTIFICATE_HASH_LIST
	);

DWORD WINAPI QueryRecoveryAgentsOnEncryptedFile (
	LPCWSTR,
	PENCRYPTION_CERTIFICATE_HASH_LIST*
	);
