
#pragma once
#define __INTRIN_H_

#ifndef RC_INVOKED

#include <crtdefs.h>
#include <setjmp.h>
#include <stddef.h>

#if defined(_M_IX86) || defined(_M_X64)
//#include <immintrin.h>
//#include <ammintrin.h>
#endif /* _M_IX86 || _M_X64 */

#if defined(_M_IX86)
//#include <mm3dnow.h>
#endif /* _M_IX86 */

#if defined(_M_ARM)
//#include <arm_neon.h>
#include <armintr.h>
#endif /* _M_ARM */

#if defined(__cplusplus)
extern "C" {
#endif

void* _AddressOfReturnAddress(void);
unsigned char _BitScanForward(unsigned long * _Index, unsigned long _Mask);
unsigned char _BitScanReverse(unsigned long * _Index, unsigned long _Mask);
long _InterlockedAnd(_Interlocked_operand_ long volatile * _Value, long _Mask);
short _InterlockedAnd16(_Interlocked_operand_ short volatile * _Value, short _Mask);
char _InterlockedAnd8(_Interlocked_operand_ char volatile * _Value, char _Mask);
long __cdecl _InterlockedCompareExchange(_Interlocked_operand_ long volatile * _Destination, long _Exchange, long _Comparand);
short _InterlockedCompareExchange16(_Interlocked_operand_ short volatile * _Destination, short _Exchange, short _Comparand);
__int64 _InterlockedCompareExchange64(_Interlocked_operand_ __int64 volatile * _Destination, __int64 _Exchange, __int64 _Comparand);
char _InterlockedCompareExchange8(_Interlocked_operand_ char volatile * _Destination, char _Exchange, char _Comparand);
void * _InterlockedCompareExchangePointer(_Interlocked_operand_ void * volatile * _Destination, void * _Exchange, void * _Comparand);
long __cdecl _InterlockedDecrement(_Interlocked_operand_ long volatile * _Addend);
short _InterlockedDecrement16(_Interlocked_operand_ short volatile * _Addend);
long __cdecl _InterlockedExchange(_Interlocked_operand_ long volatile * _Target, long _Value);
short _InterlockedExchange16(_Interlocked_operand_ short volatile * _Target, short _Value);
char _InterlockedExchange8(_Interlocked_operand_ char volatile * _Target, char _Value);
long __cdecl _InterlockedExchangeAdd(_Interlocked_operand_ long volatile * _Addend, long _Value);
short _InterlockedExchangeAdd16(_Interlocked_operand_ short volatile * _Addend, short _Value);
char _InterlockedExchangeAdd8(_Interlocked_operand_ char volatile * _Addend, char _Value);
void * _InterlockedExchangePointer(_Interlocked_operand_ void * volatile * _Target, void * _Value);
long __cdecl _InterlockedIncrement(_Interlocked_operand_ long volatile * _Addend);
short _InterlockedIncrement16(_Interlocked_operand_ short volatile * _Addend);
long _InterlockedOr(_Interlocked_operand_ long volatile * _Value, long _Mask);
short _InterlockedOr16(_Interlocked_operand_ short volatile * _Value, short _Mask);
char _InterlockedOr8(_Interlocked_operand_ char volatile * _Value, char _Mask);
long _InterlockedXor(_Interlocked_operand_ long volatile * _Value, long _Mask);
short _InterlockedXor16(_Interlocked_operand_ short volatile * _Value, short _Mask);
char _InterlockedXor8(_Interlocked_operand_ char volatile * _Value, char _Mask);
void _ReadBarrier(void);
void _ReadWriteBarrier(void);
void * _ReturnAddress(void);
void _WriteBarrier(void);
void __code_seg(const char *);
void __cdecl __debugbreak(void);
__declspec(noreturn) void __fastfail(unsigned int);
void __nop(void);
__int64 __cdecl _abs64(__int64);
unsigned char _bittest(long const *, long);
unsigned char _bittestandcomplement(long *, long);
unsigned char _bittestandreset(long *, long);
unsigned char _bittestandset(long *, long);
_Check_return_ unsigned __int64 __cdecl _byteswap_uint64(_In_ unsigned __int64);
_Check_return_ unsigned long __cdecl _byteswap_ulong(_In_ unsigned long);
_Check_return_ unsigned short __cdecl _byteswap_ushort(_In_ unsigned short);
void __cdecl _disable(void);
void __cdecl _enable(void);
unsigned char _interlockedbittestandreset(long volatile *, long);
unsigned char _interlockedbittestandset(long volatile *, long);
_Check_return_ unsigned long __cdecl _lrotl(_In_ unsigned long, _In_ int);
_Check_return_ unsigned long __cdecl _lrotr(_In_ unsigned long, _In_ int);
_Check_return_ unsigned int __cdecl _rotl(_In_ unsigned int _Value, _In_ int _Shift);
_Check_return_ unsigned short __cdecl _rotl16(_In_ unsigned short _Value, _In_ unsigned char _Shift);
_Check_return_ unsigned __int64 __cdecl _rotl64(_In_ unsigned __int64 _Value, _In_ int _Shift);
_Check_return_ unsigned char __cdecl _rotl8(_In_ unsigned char _Value, _In_ unsigned char _Shift);
_Check_return_ unsigned int __cdecl _rotr(_In_ unsigned int _Value, _In_ int _Shift);
_Check_return_ unsigned short __cdecl _rotr16(_In_ unsigned short _Value, _In_ unsigned char _Shift);
_Check_return_ unsigned __int64 __cdecl _rotr64(_In_ unsigned __int64 _Value, _In_ int _Shift);
_Check_return_ unsigned char __cdecl _rotr8(_In_ unsigned char _Value, _In_ unsigned char _Shift);

#if defined(_M_IX86) || defined(_M_X64)

void __cpuid(int[4], int);
void __cpuidex(int[4], int, int);
__int64 __emul(int, int);
unsigned __int64 __emulu(unsigned int, unsigned int);
unsigned int __getcallerseflags(void);
void __halt(void);
unsigned char __inbyte(unsigned short);
void __inbytestring(unsigned short, unsigned char *, unsigned long);
unsigned long __indword(unsigned short);
void __indwordstring(unsigned short, unsigned long *, unsigned long);
void __int2c(void);
void __invlpg(void *);
unsigned short __inword(unsigned short);
void __inwordstring(unsigned short, unsigned short *, unsigned long);
void __lidt(void *);
unsigned __int64 __ll_lshift(unsigned __int64, int);
__int64 __ll_rshift(__int64, int);
unsigned int __lzcnt(unsigned int);
unsigned short __lzcnt16(unsigned short);
void __movsb(unsigned char *, unsigned char const *, size_t);
void __movsd(unsigned long *, unsigned long const *, size_t);
void __movsw(unsigned short *, unsigned short const *, size_t);
void __nvreg_restore_fence(void);
void __nvreg_save_fence(void);
void __outbyte(unsigned short, unsigned char);
void __outbytestring(unsigned short, unsigned char *, unsigned long);
void __outdword(unsigned short, unsigned long);
void __outdwordstring(unsigned short, unsigned long *, unsigned long);
void __outword(unsigned short, unsigned short);
void __outwordstring(unsigned short, unsigned short *, unsigned long);
unsigned int __popcnt(unsigned int);
unsigned short __popcnt16(unsigned short);
unsigned __int64 __rdtsc(void);
unsigned __int64 __rdtscp(unsigned int *);
unsigned __int64 __readmsr(unsigned long);
unsigned __int64 __readpmc(unsigned long);
unsigned long __segmentlimit(unsigned long);
void __sidt(void *);
void _sgdt(void *);
void __stosb(unsigned char *, unsigned char, size_t);
void __stosd(unsigned long *, unsigned long, size_t);
void __stosw(unsigned short *, unsigned short, size_t);
void __svm_clgi(void);
void __svm_invlpga(void *, int);
void __svm_skinit(int);
void __svm_stgi(void);
void __svm_vmload(size_t);
void __svm_vmrun(size_t);
void __svm_vmsave(size_t);
void __ud2(void);
unsigned __int64 __ull_rshift(unsigned __int64, int);
void __vmx_off(void);
void __vmx_vmptrst(unsigned __int64 *);
void __wbinvd(void);
void __writemsr(unsigned long, unsigned __int64);
int __cdecl _inp(unsigned short);
unsigned long __cdecl _inpd(unsigned short);
unsigned short __cdecl _inpw(unsigned short);
void _m_prefetch(void *);
void _m_prefetchw(volatile const void *);

void _mm_mfence(void);
void _mm_lfence(void);
void _mm_sfence(void);
void _mm_pause(void);

#if 0
__m128i _mm_abs_epi16(__m128i);
__m128i _mm_abs_epi32(__m128i);
__m128i _mm_abs_epi8(__m128i);
__m64 _mm_abs_pi16(__m64);
__m64 _mm_abs_pi32(__m64);
__m64 _mm_abs_pi8(__m64);
__m128i _mm_add_epi16(__m128i, __m128i);
__m128i _mm_add_epi32(__m128i, __m128i);
__m128i _mm_add_epi64(__m128i, __m128i);
__m128i _mm_add_epi8(__m128i, __m128i);
__m128d _mm_add_pd(__m128d, __m128d);
__m128 _mm_add_ps(__m128, __m128);
__m128d _mm_add_sd(__m128d, __m128d);
__m128 _mm_add_ss(__m128, __m128);
__m128i _mm_adds_epi16(__m128i, __m128i);
__m128i _mm_adds_epi8(__m128i, __m128i);
__m128i _mm_adds_epu16(__m128i, __m128i);
__m128i _mm_adds_epu8(__m128i, __m128i);
__m128d _mm_addsub_pd(__m128d, __m128d);
__m128 _mm_addsub_ps(__m128, __m128);
__m128i _mm_alignr_epi8(__m128i, __m128i, int);
__m64 _mm_alignr_pi8(__m64, __m64, int);
__m128d _mm_and_pd(__m128d, __m128d);
__m128 _mm_and_ps(__m128, __m128);
__m128i _mm_and_si128(__m128i, __m128i);
__m128d _mm_andnot_pd(__m128d, __m128d);
__m128 _mm_andnot_ps(__m128, __m128);
__m128i _mm_andnot_si128(__m128i, __m128i);
__m128i _mm_avg_epu16(__m128i, __m128i);
__m128i _mm_avg_epu8(__m128i, __m128i);
__m128i _mm_blend_epi16(__m128i, __m128i, int);
__m128d _mm_blend_pd(__m128d, __m128d, int);
__m128 _mm_blend_ps(__m128, __m128, int);
__m128i _mm_blendv_epi8(__m128i, __m128i, __m128i);
__m128d _mm_blendv_pd(__m128d, __m128d, __m128d);
__m128 _mm_blendv_ps(__m128, __m128, __m128);
void _mm_clflush(void const *);
__m128i _mm_cmpeq_epi16(__m128i, __m128i);
__m128i _mm_cmpeq_epi32(__m128i, __m128i);
__m128i _mm_cmpeq_epi64(__m128i, __m128i);
__m128i _mm_cmpeq_epi8(__m128i, __m128i);
__m128d _mm_cmpeq_pd(__m128d, __m128d);
__m128 _mm_cmpeq_ps(__m128, __m128);
__m128d _mm_cmpeq_sd(__m128d, __m128d);
__m128 _mm_cmpeq_ss(__m128, __m128);
int _mm_cmpestra(__m128i, int, __m128i, int, int);
int _mm_cmpestrc(__m128i, int, __m128i, int, int);
int _mm_cmpestri(__m128i, int, __m128i, int, int);
__m128i _mm_cmpestrm(__m128i, int, __m128i, int, int);
int _mm_cmpestro(__m128i, int, __m128i, int, int);
int _mm_cmpestrs(__m128i, int, __m128i, int, int);
int _mm_cmpestrz(__m128i, int, __m128i, int, int);
__m128d _mm_cmpge_pd(__m128d, __m128d);
__m128 _mm_cmpge_ps(__m128, __m128);
__m128d _mm_cmpge_sd(__m128d, __m128d);
__m128 _mm_cmpge_ss(__m128, __m128);
__m128i _mm_cmpgt_epi16(__m128i, __m128i);
__m128i _mm_cmpgt_epi32(__m128i, __m128i);
__m128i _mm_cmpgt_epi64(__m128i, __m128i);
__m128i _mm_cmpgt_epi8(__m128i, __m128i);
__m128d _mm_cmpgt_pd(__m128d, __m128d);
__m128 _mm_cmpgt_ps(__m128, __m128);
__m128d _mm_cmpgt_sd(__m128d, __m128d);
__m128 _mm_cmpgt_ss(__m128, __m128);
int _mm_cmpistra(__m128i, __m128i, int);
int _mm_cmpistrc(__m128i, __m128i, int);
int _mm_cmpistri(__m128i, __m128i, int);
__m128i _mm_cmpistrm(__m128i, __m128i, int);
int _mm_cmpistro(__m128i, __m128i, int);
int _mm_cmpistrs(__m128i, __m128i, int);
int _mm_cmpistrz(__m128i, __m128i, int);
__m128d _mm_cmple_pd(__m128d, __m128d);
__m128 _mm_cmple_ps(__m128, __m128);
__m128d _mm_cmple_sd(__m128d, __m128d);
__m128 _mm_cmple_ss(__m128, __m128);
__m128i _mm_cmplt_epi16(__m128i, __m128i);
__m128i _mm_cmplt_epi32(__m128i, __m128i);
__m128i _mm_cmplt_epi8(__m128i, __m128i);
__m128d _mm_cmplt_pd(__m128d, __m128d);
__m128 _mm_cmplt_ps(__m128, __m128);
__m128d _mm_cmplt_sd(__m128d, __m128d);
__m128 _mm_cmplt_ss(__m128, __m128);
__m128d _mm_cmpneq_pd(__m128d, __m128d);
__m128 _mm_cmpneq_ps(__m128, __m128);
__m128d _mm_cmpneq_sd(__m128d, __m128d);
__m128 _mm_cmpneq_ss(__m128, __m128);
__m128d _mm_cmpnge_pd(__m128d, __m128d);
__m128 _mm_cmpnge_ps(__m128, __m128);
__m128d _mm_cmpnge_sd(__m128d, __m128d);
__m128 _mm_cmpnge_ss(__m128, __m128);
__m128d _mm_cmpngt_pd(__m128d, __m128d);
__m128 _mm_cmpngt_ps(__m128, __m128);
__m128d _mm_cmpngt_sd(__m128d, __m128d);
__m128 _mm_cmpngt_ss(__m128, __m128);
__m128d _mm_cmpnle_pd(__m128d, __m128d);
__m128 _mm_cmpnle_ps(__m128, __m128);
__m128d _mm_cmpnle_sd(__m128d, __m128d);
__m128 _mm_cmpnle_ss(__m128, __m128);
__m128d _mm_cmpnlt_pd(__m128d, __m128d);
__m128 _mm_cmpnlt_ps(__m128, __m128);
__m128d _mm_cmpnlt_sd(__m128d, __m128d);
__m128 _mm_cmpnlt_ss(__m128, __m128);
__m128d _mm_cmpord_pd(__m128d, __m128d);
__m128 _mm_cmpord_ps(__m128, __m128);
__m128d _mm_cmpord_sd(__m128d, __m128d);
__m128 _mm_cmpord_ss(__m128, __m128);
__m128d _mm_cmpunord_pd(__m128d, __m128d);
__m128 _mm_cmpunord_ps(__m128, __m128);
__m128d _mm_cmpunord_sd(__m128d, __m128d);
__m128 _mm_cmpunord_ss(__m128, __m128);
int _mm_comieq_sd(__m128d, __m128d);
int _mm_comieq_ss(__m128, __m128);
int _mm_comige_sd(__m128d, __m128d);
int _mm_comige_ss(__m128, __m128);
int _mm_comigt_sd(__m128d, __m128d);
int _mm_comigt_ss(__m128, __m128);
int _mm_comile_sd(__m128d, __m128d);
int _mm_comile_ss(__m128, __m128);
int _mm_comilt_sd(__m128d, __m128d);
int _mm_comilt_ss(__m128, __m128);
int _mm_comineq_sd(__m128d, __m128d);
int _mm_comineq_ss(__m128, __m128);
unsigned int _mm_crc32_u16(unsigned int, unsigned short);
unsigned int _mm_crc32_u32(unsigned int, unsigned int);
unsigned int _mm_crc32_u8(unsigned int, unsigned char);
__m128 _mm_cvt_si2ss(__m128, int);
int _mm_cvt_ss2si(__m128);
__m128i _mm_cvtepi16_epi32(__m128i);
__m128i _mm_cvtepi16_epi64(__m128i);
__m128i _mm_cvtepi32_epi64(__m128i);
__m128d _mm_cvtepi32_pd(__m128i);
__m128 _mm_cvtepi32_ps(__m128i);
__m128i _mm_cvtepi8_epi16(__m128i);
__m128i _mm_cvtepi8_epi32(__m128i);
__m128i _mm_cvtepi8_epi64(__m128i);
__m128i _mm_cvtepu16_epi32(__m128i);
__m128i _mm_cvtepu16_epi64(__m128i);
__m128i _mm_cvtepu32_epi64(__m128i);
__m128i _mm_cvtepu8_epi16(__m128i);
__m128i _mm_cvtepu8_epi32(__m128i);
__m128i _mm_cvtepu8_epi64(__m128i);
__m128i _mm_cvtpd_epi32(__m128d);
__m128 _mm_cvtpd_ps(__m128d);
__m128i _mm_cvtps_epi32(__m128);
__m128d _mm_cvtps_pd(__m128);
int _mm_cvtsd_si32(__m128d);
__m128 _mm_cvtsd_ss(__m128, __m128d);
int _mm_cvtsi128_si32(__m128i);
__m128d _mm_cvtsi32_sd(__m128d, int);
__m128i _mm_cvtsi32_si128(int);
__m128d _mm_cvtss_sd(__m128d, __m128);
int _mm_cvtt_ss2si(__m128);
__m128i _mm_cvttpd_epi32(__m128d);
__m128i _mm_cvttps_epi32(__m128);
int _mm_cvttsd_si32(__m128d);
__m128d _mm_div_pd(__m128d, __m128d);
__m128 _mm_div_ps(__m128, __m128);
__m128d _mm_div_sd(__m128d, __m128d);
__m128 _mm_div_ss(__m128, __m128);
__m128d _mm_dp_pd(__m128d, __m128d, int);
__m128 _mm_dp_ps(__m128, __m128, int);
int _mm_extract_epi16(__m128i, int);
int _mm_extract_epi32(__m128i, int);
int _mm_extract_epi8(__m128i, int);
int _mm_extract_ps(__m128, int);
__m128i _mm_extract_si64(__m128i, __m128i);
__m128i _mm_extracti_si64(__m128i, int, int);
unsigned int _mm_getcsr(void);
__m128i _mm_hadd_epi16(__m128i, __m128i);
__m128i _mm_hadd_epi32(__m128i, __m128i);
__m128d _mm_hadd_pd(__m128d, __m128d);
__m64 _mm_hadd_pi16(__m64, __m64);
__m64 _mm_hadd_pi32(__m64, __m64);
__m128 _mm_hadd_ps(__m128, __m128);
__m128i _mm_hadds_epi16(__m128i, __m128i);
__m64 _mm_hadds_pi16(__m64, __m64);
__m128i _mm_hsub_epi16(__m128i, __m128i);
__m128i _mm_hsub_epi32(__m128i, __m128i);
__m128d _mm_hsub_pd(__m128d, __m128d);
__m64 _mm_hsub_pi16(__m64, __m64);
__m64 _mm_hsub_pi32(__m64, __m64);
__m128 _mm_hsub_ps(__m128, __m128);
__m128i _mm_hsubs_epi16(__m128i, __m128i);
__m64 _mm_hsubs_pi16(__m64, __m64);
__m128i _mm_insert_epi16(__m128i, int, int);
__m128i _mm_insert_epi32(__m128i, int, int);
__m128i _mm_insert_epi8(__m128i, int, int);
__m128 _mm_insert_ps(__m128, __m128, int);
__m128i _mm_insert_si64(__m128i, __m128i);
__m128i _mm_inserti_si64(__m128i, __m128i, int, int);
__m128i _mm_lddqu_si128(__m128i const *);
__m128d _mm_load1_pd(double const *);
__m128d _mm_load_pd(double const *);
__m128 _mm_load_ps(float const *);
__m128 _mm_load_ps1(float const *);
__m128d _mm_load_sd(double const *);
__m128i _mm_load_si128(__m128i const *);
__m128 _mm_load_ss(float const *);
__m128d _mm_loaddup_pd(double const *);
__m128d _mm_loadh_pd(__m128d, double const *);
__m128 _mm_loadh_pi(__m128, __m64 const *);
__m128i _mm_loadl_epi64(__m128i const *);
__m128d _mm_loadl_pd(__m128d, double const *);
__m128 _mm_loadl_pi(__m128, __m64 const *);
__m128d _mm_loadr_pd(double const *);
__m128 _mm_loadr_ps(float const *);
__m128d _mm_loadu_pd(double const *);
__m128 _mm_loadu_ps(float const *);
__m128i _mm_loadu_si128(__m128i const *);
__m128i _mm_madd_epi16(__m128i, __m128i);
__m128i _mm_maddubs_epi16(__m128i, __m128i);
__m64 _mm_maddubs_pi16(__m64, __m64);
void _mm_maskmoveu_si128(__m128i, __m128i, _Out_writes_bytes_(16) char *);
__m128i _mm_max_epi16(__m128i, __m128i);
__m128i _mm_max_epi32(__m128i, __m128i);
__m128i _mm_max_epi8(__m128i, __m128i);
__m128i _mm_max_epu16(__m128i, __m128i);
__m128i _mm_max_epu32(__m128i, __m128i);
__m128i _mm_max_epu8(__m128i, __m128i);
__m128d _mm_max_pd(__m128d, __m128d);
__m128 _mm_max_ps(__m128, __m128);
__m128d _mm_max_sd(__m128d, __m128d);
__m128 _mm_max_ss(__m128, __m128);
__m128i _mm_min_epi16(__m128i, __m128i);
__m128i _mm_min_epi32(__m128i, __m128i);
__m128i _mm_min_epi8(__m128i, __m128i);
__m128i _mm_min_epu16(__m128i, __m128i);
__m128i _mm_min_epu32(__m128i, __m128i);
__m128i _mm_min_epu8(__m128i, __m128i);
__m128d _mm_min_pd(__m128d, __m128d);
__m128 _mm_min_ps(__m128, __m128);
__m128d _mm_min_sd(__m128d, __m128d);
__m128 _mm_min_ss(__m128, __m128);
__m128i _mm_minpos_epu16(__m128i);
void _mm_monitor(void const *, unsigned int, unsigned int);
__m128i _mm_move_epi64(__m128i);
__m128d _mm_move_sd(__m128d, __m128d);
__m128 _mm_move_ss(__m128, __m128);
__m128d _mm_movedup_pd(__m128d);
__m128 _mm_movehdup_ps(__m128);
__m128 _mm_movehl_ps(__m128, __m128);
__m128 _mm_moveldup_ps(__m128);
__m128 _mm_movelh_ps(__m128, __m128);
int _mm_movemask_epi8(__m128i);
int _mm_movemask_pd(__m128d);
int _mm_movemask_ps(__m128);
__m64 _mm_movepi64_pi64(__m128i);
__m128i _mm_movpi64_epi64(__m64);
__m128i _mm_mpsadbw_epu8(__m128i, __m128i, int);
__m128i _mm_mul_epi32(__m128i, __m128i);
__m128i _mm_mul_epu32(__m128i, __m128i);
__m128d _mm_mul_pd(__m128d, __m128d);
__m128 _mm_mul_ps(__m128, __m128);
__m128d _mm_mul_sd(__m128d, __m128d);
__m128 _mm_mul_ss(__m128, __m128);
__m128i _mm_mulhi_epi16(__m128i, __m128i);
__m128i _mm_mulhi_epu16(__m128i, __m128i);
__m128i _mm_mulhrs_epi16(__m128i, __m128i);
__m64 _mm_mulhrs_pi16(__m64, __m64);
__m128i _mm_mullo_epi16(__m128i, __m128i);
__m128i _mm_mullo_epi32(__m128i, __m128i);
void _mm_mwait(unsigned int, unsigned int);
__m128d _mm_or_pd(__m128d, __m128d);
__m128 _mm_or_ps(__m128, __m128);
__m128i _mm_or_si128(__m128i, __m128i);
__m128i _mm_packs_epi16(__m128i, __m128i);
__m128i _mm_packs_epi32(__m128i, __m128i);
__m128i _mm_packus_epi16(__m128i, __m128i);
__m128i _mm_packus_epi32(__m128i, __m128i);
int _mm_popcnt_u32(unsigned int);
void _mm_prefetch(_In_ char const *, _In_ int);
__m128 _mm_rcp_ps(__m128);
__m128 _mm_rcp_ss(__m128);
__m128d _mm_round_pd(__m128d, int);
__m128 _mm_round_ps(__m128, int);
__m128d _mm_round_sd(__m128d, __m128d, int);
__m128 _mm_round_ss(__m128, __m128, int);
__m128 _mm_rsqrt_ps(__m128);
__m128 _mm_rsqrt_ss(__m128);
__m128i _mm_sad_epu8(__m128i, __m128i);
__m128i _mm_set1_epi16(short);
__m128i _mm_set1_epi32(int);
__m128i _mm_set1_epi8(char);
__m128d _mm_set1_pd(double);
__m128i _mm_set_epi16(short, short, short, short, short, short, short, short);
__m128i _mm_set_epi32(int, int, int, int);
__m128i _mm_set_epi8(char, char, char, char, char, char, char, char, char, char, char, char, char, char, char, char);
__m128d _mm_set_pd(double, double);
__m128 _mm_set_ps(float, float, float, float);
__m128 _mm_set_ps1(float);
__m128d _mm_set_sd(double);
__m128 _mm_set_ss(float);
void _mm_setcsr(unsigned int);
__m128i _mm_setl_epi64(__m128i);
__m128i _mm_setr_epi16(short, short, short, short, short, short, short, short);
__m128i _mm_setr_epi32(int, int, int, int);
__m128i _mm_setr_epi8(char, char, char, char, char, char, char, char, char, char, char, char, char, char, char, char);
__m128d _mm_setr_pd(double, double);
__m128 _mm_setr_ps(float, float, float, float);
__m128d _mm_setzero_pd(void);
__m128 _mm_setzero_ps(void);
__m128i _mm_setzero_si128(void);
__m128i _mm_shuffle_epi32(__m128i, int);
__m128i _mm_shuffle_epi8(__m128i, __m128i);
__m128d _mm_shuffle_pd(__m128d, __m128d, int);
__m64 _mm_shuffle_pi8(__m64, __m64);
__m128 _mm_shuffle_ps(__m128, __m128, unsigned int);
__m128i _mm_shufflehi_epi16(__m128i, int);
__m128i _mm_shufflelo_epi16(__m128i, int);
__m128i _mm_sign_epi16(__m128i, __m128i);
__m128i _mm_sign_epi32(__m128i, __m128i);
__m128i _mm_sign_epi8(__m128i, __m128i);
__m64 _mm_sign_pi16(__m64, __m64);
__m64 _mm_sign_pi32(__m64, __m64);
__m64 _mm_sign_pi8(__m64, __m64);
__m128i _mm_sll_epi16(__m128i, __m128i);
__m128i _mm_sll_epi32(__m128i, __m128i);
__m128i _mm_sll_epi64(__m128i, __m128i);
__m128i _mm_slli_epi16(__m128i, int);
__m128i _mm_slli_epi32(__m128i, int);
__m128i _mm_slli_epi64(__m128i, int);
__m128i _mm_slli_si128(__m128i, int);
__m128d _mm_sqrt_pd(__m128d);
__m128 _mm_sqrt_ps(__m128);
__m128d _mm_sqrt_sd(__m128d, __m128d);
__m128 _mm_sqrt_ss(__m128);
__m128i _mm_sra_epi16(__m128i, __m128i);
__m128i _mm_sra_epi32(__m128i, __m128i);
__m128i _mm_srai_epi16(__m128i, int);
__m128i _mm_srai_epi32(__m128i, int);
__m128i _mm_srl_epi16(__m128i, __m128i);
__m128i _mm_srl_epi32(__m128i, __m128i);
__m128i _mm_srl_epi64(__m128i, __m128i);
__m128i _mm_srli_epi16(__m128i, int);
__m128i _mm_srli_epi32(__m128i, int);
__m128i _mm_srli_epi64(__m128i, int);
__m128i _mm_srli_si128(__m128i, int);
void _mm_store1_pd(double *, __m128d);
void _mm_store_pd(double *, __m128d);
void _mm_store_ps(float *, __m128);
void _mm_store_ps1(float *, __m128);
void _mm_store_sd(double *, __m128d);
void _mm_store_si128(__m128i *, __m128i);
void _mm_store_ss(float *, __m128);
void _mm_storeh_pd(double *, __m128d);
void _mm_storeh_pi(__m64 *, __m128);
void _mm_storel_epi64(__m128i *, __m128i);
void _mm_storel_pd(double *, __m128d);
void _mm_storel_pi(__m64 *, __m128);
void _mm_storer_pd(double *, __m128d);
void _mm_storer_ps(float *, __m128);
void _mm_storeu_pd(double *, __m128d);
void _mm_storeu_ps(float *, __m128);
void _mm_storeu_si128(__m128i *, __m128i);
__m128i _mm_stream_load_si128(__m128i *);
void _mm_stream_pd(double *, __m128d);
void _mm_stream_ps(float *, __m128);
void _mm_stream_sd(double *, __m128d);
void _mm_stream_si128(__m128i *, __m128i);
void _mm_stream_si32(int *, int);
void _mm_stream_ss(float *, __m128);
__m128i _mm_sub_epi16(__m128i, __m128i);
__m128i _mm_sub_epi32(__m128i, __m128i);
__m128i _mm_sub_epi64(__m128i, __m128i);
__m128i _mm_sub_epi8(__m128i, __m128i);
__m128d _mm_sub_pd(__m128d, __m128d);
__m128 _mm_sub_ps(__m128, __m128);
__m128d _mm_sub_sd(__m128d, __m128d);
__m128 _mm_sub_ss(__m128, __m128);
__m128i _mm_subs_epi16(__m128i, __m128i);
__m128i _mm_subs_epi8(__m128i, __m128i);
__m128i _mm_subs_epu16(__m128i, __m128i);
__m128i _mm_subs_epu8(__m128i, __m128i);
int _mm_testc_si128(__m128i, __m128i);
int _mm_testnzc_si128(__m128i, __m128i);
int _mm_testz_si128(__m128i, __m128i);
int _mm_ucomieq_sd(__m128d, __m128d);
int _mm_ucomieq_ss(__m128, __m128);
int _mm_ucomige_sd(__m128d, __m128d);
int _mm_ucomige_ss(__m128, __m128);
int _mm_ucomigt_sd(__m128d, __m128d);
int _mm_ucomigt_ss(__m128, __m128);
int _mm_ucomile_sd(__m128d, __m128d);
int _mm_ucomile_ss(__m128, __m128);
int _mm_ucomilt_sd(__m128d, __m128d);
int _mm_ucomilt_ss(__m128, __m128);
int _mm_ucomineq_sd(__m128d, __m128d);
int _mm_ucomineq_ss(__m128, __m128);
__m128i _mm_unpackhi_epi16(__m128i, __m128i);
__m128i _mm_unpackhi_epi32(__m128i, __m128i);
__m128i _mm_unpackhi_epi64(__m128i, __m128i);
__m128i _mm_unpackhi_epi8(__m128i, __m128i);
__m128d _mm_unpackhi_pd(__m128d, __m128d);
__m128 _mm_unpackhi_ps(__m128, __m128);
__m128i _mm_unpacklo_epi16(__m128i, __m128i);
__m128i _mm_unpacklo_epi32(__m128i, __m128i);
__m128i _mm_unpacklo_epi64(__m128i, __m128i);
__m128i _mm_unpacklo_epi8(__m128i, __m128i);
__m128d _mm_unpacklo_pd(__m128d, __m128d);
__m128 _mm_unpacklo_ps(__m128, __m128);
__m128d _mm_xor_pd(__m128d, __m128d);
__m128 _mm_xor_ps(__m128, __m128);
__m128i _mm_xor_si128(__m128i, __m128i);
#endif // 0

int __cdecl _outp(unsigned short, int);
unsigned long __cdecl _outpd(unsigned short, unsigned long);
unsigned short __cdecl _outpw(unsigned short, unsigned short);
int __cdecl inp(unsigned short);
unsigned long __cdecl inpd(unsigned short);
unsigned short __cdecl inpw(unsigned short);
int __cdecl outp(unsigned short, int);
unsigned long __cdecl outpd(unsigned short, unsigned long);
unsigned short __cdecl outpw(unsigned short, unsigned short);

#endif /* _M_IX86 || _M_X64 */

#if defined(_M_IX86)

long _InterlockedAddLargeStatistic(_Interlocked_operand_ __int64 volatile * _Addend, long _Value);
void __addfsbyte(unsigned long, unsigned char);
void __addfsdword(unsigned long, unsigned long);
void __addfsword(unsigned long, unsigned short);
void __incfsbyte(unsigned long);
void __incfsdword(unsigned long);
void __incfsword(unsigned long);
unsigned long __readcr0(void);
unsigned long __readcr2(void);
unsigned long __readcr3(void);
unsigned long __readcr4(void);
unsigned long __readcr8(void);
unsigned int __readdr(unsigned int);
unsigned int __readeflags(void);
unsigned char __readfsbyte(unsigned long);
unsigned long __readfsdword(unsigned long);
unsigned short __readfsword(unsigned long);
void __writecr0(unsigned int);
void __writecr3(unsigned int);
void __writecr4(unsigned int);
void __writecr8(unsigned int);
void __writedr(unsigned int, unsigned int);
void __writeeflags(unsigned int);
void __writefsbyte(unsigned long, unsigned char);
void __writefsdword(unsigned long, unsigned long);
void __writefsword(unsigned long, unsigned short);
void _m_empty(void);
void _m_femms(void);

#if 0
__m64 _m_from_float(float);
__m64 _m_from_int(int);
void _m_maskmovq(__m64, __m64, _Out_writes_bytes_(8) char *);
__m64 _m_packssdw(__m64, __m64);
__m64 _m_packsswb(__m64, __m64);
__m64 _m_packuswb(__m64, __m64);
__m64 _m_paddb(__m64, __m64);
__m64 _m_paddd(__m64, __m64);
__m64 _m_paddsb(__m64, __m64);
__m64 _m_paddsw(__m64, __m64);
__m64 _m_paddusb(__m64, __m64);
__m64 _m_paddusw(__m64, __m64);
__m64 _m_paddw(__m64, __m64);
__m64 _m_pand(__m64, __m64);
__m64 _m_pandn(__m64, __m64);
__m64 _m_pavgb(__m64, __m64);
__m64 _m_pavgusb(__m64, __m64);
__m64 _m_pavgw(__m64, __m64);
__m64 _m_pcmpeqb(__m64, __m64);
__m64 _m_pcmpeqd(__m64, __m64);
__m64 _m_pcmpeqw(__m64, __m64);
__m64 _m_pcmpgtb(__m64, __m64);
__m64 _m_pcmpgtd(__m64, __m64);
__m64 _m_pcmpgtw(__m64, __m64);
int _m_pextrw(__m64, int);
__m64 _m_pf2id(__m64);
__m64 _m_pf2iw(__m64);
__m64 _m_pfacc(__m64, __m64);
__m64 _m_pfadd(__m64, __m64);
__m64 _m_pfcmpeq(__m64, __m64);
__m64 _m_pfcmpge(__m64, __m64);
__m64 _m_pfcmpgt(__m64, __m64);
__m64 _m_pfmax(__m64, __m64);
__m64 _m_pfmin(__m64, __m64);
__m64 _m_pfmul(__m64, __m64);
__m64 _m_pfnacc(__m64, __m64);
__m64 _m_pfpnacc(__m64, __m64);
__m64 _m_pfrcp(__m64);
__m64 _m_pfrcpit1(__m64, __m64);
__m64 _m_pfrcpit2(__m64, __m64);
__m64 _m_pfrsqit1(__m64, __m64);
__m64 _m_pfrsqrt(__m64);
__m64 _m_pfsub(__m64, __m64);
__m64 _m_pfsubr(__m64, __m64);
__m64 _m_pi2fd(__m64);
__m64 _m_pi2fw(__m64);
__m64 _m_pinsrw(__m64, int, int);
__m64 _m_pmaddwd(__m64, __m64);
__m64 _m_pmaxsw(__m64, __m64);
__m64 _m_pmaxub(__m64, __m64);
__m64 _m_pminsw(__m64, __m64);
__m64 _m_pminub(__m64, __m64);
int _m_pmovmskb(__m64);
__m64 _m_pmulhrw(__m64, __m64);
__m64 _m_pmulhuw(__m64, __m64);
__m64 _m_pmulhw(__m64, __m64);
__m64 _m_pmullw(__m64, __m64);
__m64 _m_por(__m64, __m64);
__m64 _m_psadbw(__m64, __m64);
__m64 _m_pshufw(__m64, int);
__m64 _m_pslld(__m64, __m64);
__m64 _m_pslldi(__m64, int);
__m64 _m_psllq(__m64, __m64);
__m64 _m_psllqi(__m64, int);
__m64 _m_psllw(__m64, __m64);
__m64 _m_psllwi(__m64, int);
__m64 _m_psrad(__m64, __m64);
__m64 _m_psradi(__m64, int);
__m64 _m_psraw(__m64, __m64);
__m64 _m_psrawi(__m64, int);
__m64 _m_psrld(__m64, __m64);
__m64 _m_psrldi(__m64, int);
__m64 _m_psrlq(__m64, __m64);
__m64 _m_psrlqi(__m64, int);
__m64 _m_psrlw(__m64, __m64);
__m64 _m_psrlwi(__m64, int);
__m64 _m_psubb(__m64, __m64);
__m64 _m_psubd(__m64, __m64);
__m64 _m_psubsb(__m64, __m64);
__m64 _m_psubsw(__m64, __m64);
__m64 _m_psubusb(__m64, __m64);
__m64 _m_psubusw(__m64, __m64);
__m64 _m_psubw(__m64, __m64);
__m64 _m_pswapd(__m64);
__m64 _m_punpckhbw(__m64, __m64);
__m64 _m_punpckhdq(__m64, __m64);
__m64 _m_punpckhwd(__m64, __m64);
__m64 _m_punpcklbw(__m64, __m64);
__m64 _m_punpckldq(__m64, __m64);
__m64 _m_punpcklwd(__m64, __m64);
__m64 _m_pxor(__m64, __m64);
float _m_to_float(__m64);
int _m_to_int(__m64);
__m64 _mm_add_si64(__m64, __m64);
__m128 _mm_cvt_pi2ps(__m128, __m64);
__m64 _mm_cvt_ps2pi(__m128);
__m64 _mm_cvtpd_pi32(__m128d);
__m128d _mm_cvtpi32_pd(__m64);
__m64 _mm_cvtt_ps2pi(__m128);
__m64 _mm_cvttpd_pi32(__m128d);
__m64 _mm_mul_su32(__m64, __m64);
__m128i _mm_set1_epi64(__m64);
__m64 _mm_set1_pi16(short);
__m64 _mm_set1_pi32(int);
__m64 _mm_set1_pi8(char);
__m128i _mm_set_epi64(__m64, __m64);
__m64 _mm_set_pi16(short, short, short, short);
__m64 _mm_set_pi32(int, int);
__m64 _mm_set_pi8(char, char, char, char, char, char, char, char);
__m128i _mm_setr_epi64(__m64, __m64);
__m64 _mm_setr_pi16(short, short, short, short);
__m64 _mm_setr_pi32(int, int);
__m64 _mm_setr_pi8(char, char, char, char, char, char, char, char);
__m64 _mm_setzero_si64(void);
void _mm_stream_pi(__m64 *, __m64);
__m64 _mm_sub_si64(__m64, __m64);
#endif // 0

#endif /* _M_IX86 */

#if defined(_M_X64)

unsigned char _BitScanForward64(unsigned long * _Index, unsigned __int64 _Mask);
unsigned char _BitScanReverse64(unsigned long * _Index, unsigned __int64 _Mask);
short _InterlockedAnd16_np(short volatile * _Value, short _Mask);
__int64 _InterlockedAnd64_np(__int64 volatile * _Value, __int64 _Mask);
char _InterlockedAnd8_np(char volatile * _Value, char _Mask);
long _InterlockedAnd_np(long volatile * _Value, long _Mask);
unsigned char _InterlockedCompareExchange128(_Interlocked_operand_ __int64 volatile * _Destination, __int64 _ExchangeHigh, __int64 _ExchangeLow, __int64 * _ComparandResult);
unsigned char _InterlockedCompareExchange128_np(__int64 volatile * _Destination, __int64 _ExchangeHigh, __int64 _ExchangeLow, __int64 * _ComparandResult);
short _InterlockedCompareExchange16_np(short volatile * _Destination, short _Exchange, short _Comparand);
__int64 _InterlockedCompareExchange64_np(__int64 volatile * _Destination, __int64 _Exchange, __int64 _Comparand);
void * _InterlockedCompareExchangePointer_np(void * volatile * _Destination, void * _Exchange, void * _Comparand);
long _InterlockedCompareExchange_np(long volatile * _Destination, long _Exchange, long _Comparand);
short _InterlockedOr16_np(short volatile * _Value, short _Mask);
__int64 _InterlockedOr64_np(__int64 volatile * _Value, __int64 _Mask);
char _InterlockedOr8_np(char volatile * _Value, char _Mask);
long _InterlockedOr_np(long volatile * _Value, long _Mask);
short _InterlockedXor16_np(short volatile * _Value, short _Mask);
__int64 _InterlockedXor64_np(__int64 volatile * _Value, __int64 _Mask);
char _InterlockedXor8_np(char volatile * _Value, char _Mask);
long _InterlockedXor_np(long volatile * _Value, long _Mask);
void __addgsbyte(unsigned long, unsigned char);
void __addgsdword(unsigned long, unsigned long);
void __addgsqword(unsigned long, unsigned __int64);
void __addgsword(unsigned long, unsigned short);
void __faststorefence(void);
void __incgsbyte(unsigned long);
void __incgsdword(unsigned long);
void __incgsqword(unsigned long);
void __incgsword(unsigned long);
unsigned __int64 __lzcnt64(unsigned __int64);
void __movsq(unsigned long long *, unsigned long long const *, size_t);
__int64 __mulh(__int64, __int64);
__int64 _mul128(__int64 _Multiplier, __int64 _Multiplicand, __int64 * _HighProduct);
unsigned __int64 _umul128(unsigned __int64 _Multiplier, unsigned __int64 _Multiplicand, unsigned __int64 * _HighProduct);
unsigned __int64 __popcnt64(unsigned __int64);
unsigned __int64 __readcr0(void);
unsigned __int64 __readcr2(void);
unsigned __int64 __readcr3(void);
unsigned __int64 __readcr4(void);
unsigned __int64 __readcr8(void);
unsigned __int64 __readdr(unsigned int);
unsigned __int64 __readeflags(void);
unsigned char __readgsbyte(unsigned long);
unsigned long __readgsdword(unsigned long);
unsigned __int64 __readgsqword(unsigned long);
unsigned short __readgsword(unsigned long);
unsigned __int64 __shiftleft128(unsigned __int64 _LowPart, unsigned __int64 _HighPart, unsigned char _Shift);
unsigned __int64 __shiftright128(unsigned __int64 _LowPart, unsigned __int64 _HighPart, unsigned char _Shift);
void __stosq(unsigned __int64 *, unsigned __int64, size_t);
unsigned __int64 __umulh(unsigned __int64, unsigned __int64);
unsigned char __vmx_on(unsigned __int64 *);
unsigned char __vmx_vmclear(unsigned __int64 *);
unsigned char __vmx_vmlaunch(void);
unsigned char __vmx_vmptrld(unsigned __int64 *);
unsigned char __vmx_vmread(size_t, size_t *);
unsigned char __vmx_vmresume(void);
unsigned char __vmx_vmwrite(size_t, size_t);
void __writecr0(unsigned __int64);
void __writecr3(unsigned __int64);
void __writecr4(unsigned __int64);
void __writecr8(unsigned __int64);
void __writedr(unsigned int, unsigned __int64);
void __writeeflags(unsigned __int64);
void __writegsbyte(unsigned long, unsigned char);
void __writegsdword(unsigned long, unsigned long);
void __writegsqword(unsigned long, unsigned __int64);
void __writegsword(unsigned long, unsigned short);
unsigned char _bittest64(__int64 const *, __int64);
unsigned char _bittestandcomplement64(__int64 *, __int64);
unsigned char _bittestandreset64(__int64 *, __int64);
unsigned char _bittestandset64(__int64 *, __int64);
unsigned char _interlockedbittestandreset64(__int64 volatile *, __int64);
unsigned char _interlockedbittestandset64(__int64 volatile *, __int64);
unsigned __int64 _mm_crc32_u64(unsigned __int64, unsigned __int64);
#if 0
__int64 _mm_cvtsd_si64(__m128d);
__int64 _mm_cvtsd_si64x(__m128d);
__int64 _mm_cvtsi128_si64(__m128i);
__int64 _mm_cvtsi128_si64x(__m128i);
__m128d _mm_cvtsi64_sd(__m128d, __int64);
__m128i _mm_cvtsi64_si128(__int64);
__m128 _mm_cvtsi64_ss(__m128, __int64);
__m128d _mm_cvtsi64x_sd(__m128d, __int64);
__m128i _mm_cvtsi64x_si128(__int64);
__m128 _mm_cvtsi64x_ss(__m128, __int64);
__int64 _mm_cvtss_si64(__m128);
__int64 _mm_cvtss_si64x(__m128);
__int64 _mm_cvttsd_si64(__m128d);
__int64 _mm_cvttsd_si64x(__m128d);
__int64 _mm_cvttss_si64(__m128);
__int64 _mm_cvttss_si64x(__m128);
__int64 _mm_extract_epi64(__m128i, int);
__m128i _mm_insert_epi64(__m128i, __int64, int);
__int64 _mm_popcnt_u64(unsigned __int64);
__m128i _mm_set1_epi64x(__int64);
__m128i _mm_set_epi64x(__int64, __int64);
void _mm_stream_si64x(__int64 *, __int64);
#endif
#endif /* _M_X64 */

#if defined(_M_ARM) || defined(_M_X64)

__int64 _InterlockedAnd64(_Interlocked_operand_ __int64 volatile * _Value, __int64 _Mask);
__int64 _InterlockedDecrement64(_Interlocked_operand_ __int64 volatile * _Addend);
__int64 _InterlockedExchange64(_Interlocked_operand_ __int64 volatile * _Target, __int64 _Value);
__int64 _InterlockedExchangeAdd64(_Interlocked_operand_ __int64 volatile * _Addend, __int64 _Value);
__int64 _InterlockedIncrement64(_Interlocked_operand_ __int64 volatile * _Addend);
__int64 _InterlockedOr64(_Interlocked_operand_ __int64 volatile * _Value, __int64 _Mask);
__int64 _InterlockedXor64(_Interlocked_operand_ __int64 volatile * _Value, __int64 _Mask);

#endif /* _M_ARM || _M_X64 */

#if defined(_M_ARM)

int _AddSatInt(int, int);
double _CopyDoubleFromInt64(__int64);
float _CopyFloatFromInt32(__int32);
__int32 _CopyInt32FromFloat(float);
__int64 _CopyInt64FromDouble(double);
unsigned int _CountLeadingOnes(unsigned long);
unsigned int _CountLeadingOnes64(unsigned __int64);
unsigned int _CountLeadingSigns(long);
unsigned int _CountLeadingSigns64(__int64);
unsigned int _CountLeadingZeros(unsigned long);
unsigned int _CountLeadingZeros64(unsigned __int64);
unsigned int _CountOneBits(unsigned long);
unsigned int _CountOneBits64(unsigned __int64);
int _DAddSatInt(int, int);
int _DSubSatInt(int, int);
long _InterlockedAdd(_Interlocked_operand_ long volatile * _Addend, long _Value);
__int64 _InterlockedAdd64(_Interlocked_operand_ __int64 volatile * _Addend, __int64 _Value);
__int64 _InterlockedAdd64_acq(__int64 volatile * _Addend, __int64 _Value);
__int64 _InterlockedAdd64_nf(__int64 volatile * _Addend, __int64 _Value);
__int64 _InterlockedAdd64_rel(__int64 volatile * _Addend, __int64 _Value);
long _InterlockedAdd_acq(long volatile * _Addend, long _Value);
long _InterlockedAdd_nf(long volatile * _Addend, long _Value);
long _InterlockedAdd_rel(long volatile * _Addend, long _Value);
short _InterlockedAnd16_acq(short volatile * _Value, short _Mask);
short _InterlockedAnd16_nf(short volatile * _Value, short _Mask);
short _InterlockedAnd16_rel(short volatile * _Value, short _Mask);
__int64 _InterlockedAnd64_acq(__int64 volatile * _Value, __int64 _Mask);
__int64 _InterlockedAnd64_nf(__int64 volatile * _Value, __int64 _Mask);
__int64 _InterlockedAnd64_rel(__int64 volatile * _Value, __int64 _Mask);
char _InterlockedAnd8_acq(char volatile * _Value, char _Mask);
char _InterlockedAnd8_nf(char volatile * _Value, char _Mask);
char _InterlockedAnd8_rel(char volatile * _Value, char _Mask);
long _InterlockedAnd_acq(long volatile * _Value, long _Mask);
long _InterlockedAnd_nf(long volatile * _Value, long _Mask);
long _InterlockedAnd_rel(long volatile * _Value, long _Mask);
short _InterlockedCompareExchange16_acq(short volatile * _Destination, short _Exchange, short _Comparand);
short _InterlockedCompareExchange16_nf(short volatile * _Destination, short _Exchange, short _Comparand);
short _InterlockedCompareExchange16_rel(short volatile * _Destination, short _Exchange, short _Comparand);
__int64 _InterlockedCompareExchange64_acq(__int64 volatile * _Destination, __int64 _Exchange, __int64 _Comparand);
__int64 _InterlockedCompareExchange64_nf(__int64 volatile * _Destination, __int64 _Exchange, __int64 _Comparand);
__int64 _InterlockedCompareExchange64_rel(__int64 volatile * _Destination, __int64 _Exchange, __int64 _Comparand);
char _InterlockedCompareExchange8_acq(char volatile * _Destination, char _Exchange, char _Comparand);
char _InterlockedCompareExchange8_nf(char volatile * _Destination, char _Exchange, char _Comparand);
char _InterlockedCompareExchange8_rel(char volatile * _Destination, char _Exchange, char _Comparand);
void * _InterlockedCompareExchangePointer_acq(void * volatile * _Destination, void * _Exchange, void * _Comparand);
void * _InterlockedCompareExchangePointer_nf(void * volatile * _Destination, void * _Exchange, void * _Comparand);
void * _InterlockedCompareExchangePointer_rel(void * volatile * _Destination, void * _Exchange, void * _Comparand);
long _InterlockedCompareExchange_acq(long volatile * _Destination, long _Exchange, long _Comparand);
long _InterlockedCompareExchange_nf(long volatile * _Destination, long _Exchange, long _Comparand);
long _InterlockedCompareExchange_rel(long volatile * _Destination, long _Exchange, long _Comparand);
short _InterlockedDecrement16_acq(short volatile * _Addend);
short _InterlockedDecrement16_nf(short volatile * _Addend);
short _InterlockedDecrement16_rel(short volatile * _Addend);
__int64 _InterlockedDecrement64_acq(__int64 volatile * _Addend);
__int64 _InterlockedDecrement64_nf(__int64 volatile * _Addend);
__int64 _InterlockedDecrement64_rel(__int64 volatile * _Addend);
long _InterlockedDecrement_acq(long volatile * _Addend);
long _InterlockedDecrement_nf(long volatile * _Addend);
long _InterlockedDecrement_rel(long volatile * _Addend);
short _InterlockedExchange16_acq(short volatile * _Target, short _Value);
short _InterlockedExchange16_nf(short volatile * _Target, short _Value);
__int64 _InterlockedExchange64_acq(__int64 volatile * _Target, __int64 _Value);
__int64 _InterlockedExchange64_nf(__int64 volatile * _Target, __int64 _Value);
char _InterlockedExchange8_acq(char volatile * _Target, char _Value);
char _InterlockedExchange8_nf(char volatile * _Target, char _Value);
short _InterlockedExchangeAdd16_acq(short volatile * _Addend, short _Value);
short _InterlockedExchangeAdd16_nf(short volatile * _Addend, short _Value);
short _InterlockedExchangeAdd16_rel(short volatile * _Addend, short _Value);
__int64 _InterlockedExchangeAdd64_acq(__int64 volatile * _Addend, __int64 _Value);
__int64 _InterlockedExchangeAdd64_nf(__int64 volatile * _Addend, __int64 _Value);
__int64 _InterlockedExchangeAdd64_rel(__int64 volatile * _Addend, __int64 _Value);
char _InterlockedExchangeAdd8_acq(char volatile * _Addend, char _Value);
char _InterlockedExchangeAdd8_nf(char volatile * _Addend, char _Value);
char _InterlockedExchangeAdd8_rel(char volatile * _Addend, char _Value);
long _InterlockedExchangeAdd_acq(long volatile * _Addend, long _Value);
long _InterlockedExchangeAdd_nf(long volatile * _Addend, long _Value);
long _InterlockedExchangeAdd_rel(long volatile * _Addend, long _Value);
void * _InterlockedExchangePointer_acq(void * volatile * _Target, void * _Value);
void * _InterlockedExchangePointer_nf(void * volatile * _Target, void * _Value);
long _InterlockedExchange_acq(long volatile * _Target, long _Value);
long _InterlockedExchange_nf(long volatile * _Target, long _Value);
short _InterlockedIncrement16_acq(short volatile * _Addend);
short _InterlockedIncrement16_nf(short volatile * _Addend);
short _InterlockedIncrement16_rel(short volatile * _Addend);
__int64 _InterlockedIncrement64_acq(__int64 volatile * _Addend);
__int64 _InterlockedIncrement64_nf(__int64 volatile * _Addend);
__int64 _InterlockedIncrement64_rel(__int64 volatile * _Addend);
long _InterlockedIncrement_acq(long volatile * _Addend);
long _InterlockedIncrement_nf(long volatile * _Addend);
long _InterlockedIncrement_rel(long volatile * _Addend);
short _InterlockedOr16_acq(short volatile * _Value, short _Mask);
short _InterlockedOr16_nf(short volatile * _Value, short _Mask);
short _InterlockedOr16_rel(short volatile * _Value, short _Mask);
__int64 _InterlockedOr64_acq(__int64 volatile * _Value, __int64 _Mask);
__int64 _InterlockedOr64_nf(__int64 volatile * _Value, __int64 _Mask);
__int64 _InterlockedOr64_rel(__int64 volatile * _Value, __int64 _Mask);
char _InterlockedOr8_acq(char volatile * _Value, char _Mask);
char _InterlockedOr8_nf(char volatile * _Value, char _Mask);
char _InterlockedOr8_rel(char volatile * _Value, char _Mask);
long _InterlockedOr_acq(long volatile * _Value, long _Mask);
long _InterlockedOr_nf(long volatile * _Value, long _Mask);
long _InterlockedOr_rel(long volatile * _Value, long _Mask);
short _InterlockedXor16_acq(short volatile * _Value, short _Mask);
short _InterlockedXor16_nf(short volatile * _Value, short _Mask);
short _InterlockedXor16_rel(short volatile * _Value, short _Mask);
__int64 _InterlockedXor64_acq(__int64 volatile * _Value, __int64 _Mask);
__int64 _InterlockedXor64_nf(__int64 volatile * _Value, __int64 _Mask);
__int64 _InterlockedXor64_rel(_Interlocked_operand_ __int64 volatile * _Value, __int64 _Mask);
char _InterlockedXor8_acq(char volatile * _Value, char _Mask);
char _InterlockedXor8_nf(char volatile * _Value, char _Mask);
char _InterlockedXor8_rel(char volatile * _Value, char _Mask);
long _InterlockedXor_acq(long volatile * _Value, long _Mask);
long _InterlockedXor_nf(long volatile * _Value, long _Mask);
long _InterlockedXor_rel(long volatile * _Value, long _Mask);
#if _MSC_FULL_VER >= 170040825
unsigned int _MoveFromCoprocessor(unsigned int, unsigned int, unsigned int, unsigned int, unsigned int);
unsigned int _MoveFromCoprocessor2(unsigned int, unsigned int, unsigned int, unsigned int, unsigned int);
#else
int _MoveFromCoprocessor(unsigned int, unsigned int, unsigned int, unsigned int, unsigned int);
int _MoveFromCoprocessor2(unsigned int, unsigned int, unsigned int, unsigned int, unsigned int);
#endif
unsigned __int64 _MoveFromCoprocessor64(unsigned int, unsigned int, unsigned int);
void _MoveToCoprocessor(unsigned int, unsigned int, unsigned int, unsigned int, unsigned int, unsigned int);
void _MoveToCoprocessor2(unsigned int, unsigned int, unsigned int, unsigned int, unsigned int, unsigned int);
void _MoveToCoprocessor64(unsigned __int64, unsigned int, unsigned int, unsigned int);
long _MulHigh(long, long);
unsigned long _MulUnsignedHigh(unsigned long, unsigned long);
int _ReadStatusReg(int);
int _SubSatInt(int, int);
void _WriteStatusReg(int, int, int);
void __emit(unsigned __int32);
__int64 __ldrexd(__int64 volatile *);
void __cdecl __prefetch(const void *);
unsigned __int64 __rdpmccntr64(void);
void __sev(void);
void __static_assert(int, const char *);
unsigned int __swi(unsigned int, ...);
unsigned int __hvc(unsigned int, ...);
int __trap(int, ...);
__int16 __iso_volatile_load16(const volatile __int16 *);
__int32 __iso_volatile_load32(const volatile __int32 *);
__int64 __iso_volatile_load64(const volatile __int64 *);
__int8 __iso_volatile_load8(const volatile __int8 *);
void __iso_volatile_store16(volatile __int16 *, __int16);
void __iso_volatile_store32(volatile __int32 *, __int32);
void __iso_volatile_store64(volatile __int64 *, __int64);
void __iso_volatile_store8(volatile __int8 *, __int8);
void __wfe(void);
void __wfi(void);
void __yield(void);
unsigned char _interlockedbittestandreset_acq(long volatile *, long);
unsigned char _interlockedbittestandreset_nf(long volatile *, long);
unsigned char _interlockedbittestandreset_rel(long volatile *, long);
unsigned char _interlockedbittestandset_acq(long volatile *, long);
unsigned char _interlockedbittestandset_nf(long volatile *, long);
unsigned char _interlockedbittestandset_rel(long volatile *, long);
int _isunordered(double, double);
int _isunorderedf(float, float);

#endif /* _M_ARM */

#if defined(_M_CEE_PURE)

long _InterlockedCompareExchange(_Interlocked_operand_ long volatile * _Destination, long _Exchange, long _Comparand);
long _InterlockedDecrement(_Interlocked_operand_ long volatile * _Addend);
long _InterlockedIncrement(_Interlocked_operand_ long volatile * _Addend);

#endif /* _M_CEE_PURE */

#if defined(__cplusplus)
}
#endif /* __cplusplus */

#if defined(__GNUC__) && defined(_WIN32) // We can't use __MINGW32__ here
#  include "mingw32/intrin.h"
#elif defined(_MSC_VER)
#  include "msc/intrin.h"
#else
#  error Please implement intrinsics for your target compiler
#endif

#endif
