#pragma once

MUI_LAYOUTS ptBRLayouts[] =
{
    { L"0416", L"00000416" },
    { L"0409", L"00000409" },
    { NULL, NULL }
};

static MUI_ENTRY ptBRLanguagePageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Seleo do idioma",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Por favor, selecione o idioma a ser utilizado durante a instalao.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Ento pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  O idioma selecionado tambm ser o idioma padro do sistema.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continuar  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRWelcomePageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Bem-vindo  instalao do ReactOS.",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        11,
        "Esta parte da instalao prepara o ReactOS para ser",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "executado em seu computador.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Para instalar o ReactOS agora, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Para reparar uma instalao do ReactOS, pressione R.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Para ver os termos e condies da licena, pressione L.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Para sair sem instalar o ReactOS, pressione F3.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Para maiores informaes sobre o ReactOS, visite o stio:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "http://www.reactos.org",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        0,
        0,
        "ENTER=Continuar  R=Reparar  L=Licena  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRIntroPageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "O instalador do ReactOS est em fase inicial de desenvolvimento e",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "ainda no suporta todas as funes de instalao.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "As seguintes limitaes se aplicam:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "- O instalador suporta somente o sistema de arquivos FAT.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "- O verificador de integridade de sistema de arquivos ainda no est",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "  implementado.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "\x07  Para continuar a instalao do ReactOS, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        27,
        "\x07  Para sair sem instalar o ReactOS, pressione F3.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continuar  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRLicensePageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        6,
        "Licena:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        8,
        "O ReactOS est licenciado sob os termos da licena",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        9,
        "GNU GPL contendo partes de cdigo licenciados sob outras",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "licenas compatveis, como X11 ou BSD e GNU LGPL.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "Todo o software que faz parte do ReactOS  portanto, liberado",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "sob a licena GNU GPL, bem como a manuteno da licena",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "original.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Este software vem sem NENHUMA GARANTIA ou restrio de uso",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "exceto onde leis locais e internacionais so aplicaveis. A licena",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "do ReactOS abrange apenas a distribuio a terceiros.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "Se por alguma razo voc no recebeu uma cpia da licena",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "GNU General Public License com o ReactOS por favor visite",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "http://www.gnu.org/licenses/licenses.html",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        22,
        "Garantia:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        24,
        "Este  um software livre; veja o cdigo fonte para condies de cpia.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "NO h garantia; nem mesmo para COMERCIALIZAO ou",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        26,
        "ADEQUAO PARA UM PROPSITO PARTICULAR",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Voltar",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRDevicePageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "A lista a seguir mostra as configuraes de dispositivos atual.",
        TEXT_STYLE_NORMAL
    },
    {
        24,
        11,
        "Computador:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        12,
        "Vdeo:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        13,
        "Teclado:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        14,
        "Leiaute teclado:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        16,
        "Aceitar:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        25,
        16, "Aceitar essas configuraes de dispositivo",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        19,
        "Use as teclas SETA PARA CIMA e SETA PARA BAIXO para mudar de opo.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        20,
        "Para escolher uma configurao alternativa, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        22,
        "Quanto finalizar os ajustes, selecione \"Aceitar essas configuraes",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "de dispositivo\" e pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continuar  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRRepairPageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "O instalador do ReactOS est em fase inicial de desenvolvimento e",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "ainda no suporta todas as funes de instalao.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "As funes reparao ainda no foram implementadas.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Para atualizar o sistema operacional, pressione U.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Para abrir o console de recuperao, pressione R.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Para voltar a pgina principal, pressione ESC.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Para reiniciar o computador, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ESC=Pgina principal  U=Atualizar  R=Recuperar  ENTER=Reiniciar",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRComputerPageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "A lista a seguir mostra os tipos de computadores disponveis",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "para instalao.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "Use as teclas SETA PARA CIMA e SETA PARA BAIXO para selecionar",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "um item na lista.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "\x07  Para escolher o item selecionado, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "\x07  Para cancelar a alterao, pressione ESC.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continuar  ESC=Cancelar  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRFlushPageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "O sistema est agora certificando que todos os dados estejam sendo",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        7,
        "armazenados corretamente no disco.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Esta operao pode demorar um minuto.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "Quando terminar, o computador ser reiniciado automaticamente.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Esvaziando o cache",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRQuitPageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "O ReactOS no foi totalmente instalado neste computador.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Se houver algum disquete na unidade A: ou disco nas unidades",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "de CD-ROM, remova-os.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Para reiniciar o computador, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Por favor, aguarde...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG,
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRDisplayPageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "A lista a seguir mostra os tipos de vdeo disponveis para instalao.",
        TEXT_STYLE_NORMAL
    },
    {   6,
        10,
         "Use as teclas SETA PARA CIMA e SETA PARA BAIXO para selecionar",
         TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "um item na lista.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Para escolher o item selecionado, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Para cancelar a alterao, pressione ESC.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continuar  ESC=Cancelar  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRSuccessPageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Os componentes bsicos do ReactOS foram instalados com sucesso.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Se houver algum disquete na unidade A: ou disco nas unidades",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "de CD-ROM, remova-os.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Para reiniciar o computador, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Reiniciar",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRBootPageEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "O instalador no pde instalar o gernciador de inicializao no disco",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "rgido do computador.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "Por favor insira um disquete formatado na unidade A: e",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "pressione ENTER.",
        TEXT_STYLE_NORMAL,
    },
    {
        0,
        0,
        "ENTER=Continuar  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }

};

static MUI_ENTRY ptBRSelectPartitionEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        7,
        "A lista a seguir mostra as parties existentes e os espaos",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        8,
        "no-particionados neste computador.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Use as teclas SETA PARA CIMA e SETA PARA BAIXO para selecionar",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "um item na lista.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Para configurar o ReactOS no item selecionado, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Press P to create a primary partition.",
//        "\x07  Para criar uma partio no espao no particionado, pressione C.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Press E to create an extended partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Press L to create a logical partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Para excluir a partio selecionada, pressione D.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Por favor, aguarde...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRConfirmDeleteSystemPartitionEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "You have chosen to delete the system partition.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "System partitions can contain diagnostic programs, hardware configuration",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "programs, programs to start an operating system (like ReactOS) or other",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "programs provided by the hardware manufacturer.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Delete a system partition only when you are sure that there are no such",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "programs on the partition, or when you are sure you want to delete them.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "When you delete the partition, you might not be able to boot the",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        17,
        "computer from the harddisk until you finished the ReactOS Setup.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "\x07  Press ENTER to delete the system partition. You will be asked",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "   to confirm the deletion of the partition again later.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "\x07  Press ESC to return to the previous page. The partition will",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "   not be deleted.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continue  ESC=Cancel",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRFormatPartitionEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Formatar partio",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "O instalador ir formatar a partio. Para continuar, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continuar  F3=Sair",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        TEXT_STYLE_NORMAL
    }
};

static MUI_ENTRY ptBRInstallDirectoryEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "O instalador ir copiar os arquivos para a partio selecionada.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "Selecione um diretrio onde deseja que o ReactOS seja instalado:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Para mudar o diretrio sugerido, pressione a tecla BACKSPACE para apagar",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "o texto e escreva o nome do diretrio onde deseja que o ReactOS",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "seja instalado.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continuar  F3 = Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRFileCopyEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        0,
        12,
        "Por favor aguarde enquanto o instalador copia os",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        13,
        "arquivos do ReactOS para a pasta de instalao.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        14,
        "Esta operao pode demorar alguns minutos.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        50,
        0,
        "\xB3 Por favor, aguarde...",     
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRBootLoaderEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "O instalador ir configurar o gernciador de inicializao",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "Instalar o gernciador de inic. no disco rgido (MBR e VBR)",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "Instalar o gernciador de inic. no disco rgido (apenas VBR)",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "Instalar o gernciador de inicializao em um disquete",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Pular a instalao do gernciador de inicializao",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continuar  F3=Sair",
        TEXT_TYPE_STATUS  | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRKeyboardSettingsEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "A lista a seguir mostra os tipos de teclados disponveis para instalao.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Use as teclas SETA PARA CIMA e SETA PARA BAIXO para selecionar",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "um item na lista.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Para escolher o item selecionado, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Para cancelar a alterao, pressione ESC.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continuar  ESC=Cancelar  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRLayoutSettingsEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "A lista a seguir mostra os tipos de leiautes de teclado disponveis",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "para instalao.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "Use as teclas SETA PARA CIMA e SETA PARA BAIXO para selecionar",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "um item na lista.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "\x07  Para escolher o item selecionado, pressione ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "\x07  Para cancelar a alterao, pressione ESC.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continuar  ESC=Cancelar  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY ptBRPrepareCopyEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "O instalador est preparando o computador para copiar os arquivos",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "do ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Montando a lista de arquivos a serem copiados...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY ptBRSelectFSEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        16,
        "Selecione um sistema de arquivos para a nova partio na lista abaixo.",
        0
    },
    {
        6,
        17,
        "Use as teclas SETA PARA CIMA e SETA PARA BAIXO para selecionar o",
        0
    },
    {
        6,
        18,
        "sistema de arquivos de arquivos desejado e pressione ENTER.",
        0
    },
    {
        8,
        20,
        "Se desejar selecionar uma partio diferente, pressione ESC.",
        0
    },
    {
        0,
        0,
        "ENTER=Continuar  ESC=Cancelar  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },

    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRDeletePartitionEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Voc solicitou a excluso da partio",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "\x07  Para excluir esta partio, pressione D",
        TEXT_STYLE_NORMAL
    },
    {
        11,
        19,
        "CUIDADO: todos os dados da partio sero perdidos!",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Para retornar  tela anterior sem excluir",
        TEXT_STYLE_NORMAL
    },
    {
        11,
        22,
        "a partio, pressione ESC.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "D=Excluir  ESC=Cancelar  F3=Sair",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY ptBRRegistryEntries[] =
{
    {
        4,
        3,
        " Instalao do ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "O instalador est atualizando a configurao do sistema.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Criando a estrutura de registro...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

MUI_ERROR ptBRErrorEntries[] =
{
    {
        // NOT_AN_ERROR
        "Success\n"
    },
    {
        //ERROR_NOT_INSTALLED
        "O ReactOS no est completamente instalado no computador.\n"
        "Se voc sair da instalao agora, precisar executa-la\n"
        "novamente para instalar o ReactOS.\n"
        "\n"
        "  \x07  Para continuar a instalao, pressione ENTER.\n"
        "  \x07  Para sair da instalao, pressione F3.",
        "F3=Sair  ENTER=Continuar"
    },
    {
        //ERROR_NO_HDD
        "No foi possvel localizar um disco rdigo.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_NO_SOURCE_DRIVE
        "No foi possvel localizar a unidade de origem.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_LOAD_TXTSETUPSIF
        "No foi possvel carregar o arquivo TXTSETUP.SIF.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_CORRUPT_TXTSETUPSIF
        "O arquivos TXTSETUP.SIF est corrompido.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_SIGNATURE_TXTSETUPSIF,
        "O arquivo TXTSETUP.SIF est com a assinatura incorreta.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_DRIVE_INFORMATION
        "No foi possvel obter as informaes sobre o disco do sistema.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_WRITE_BOOT,
        "Erro ao escrever o cdigo de inicializao na partio do sistema.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_LOAD_COMPUTER,
        "No foi possvel carregar a lista de tipos de computadores.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_LOAD_DISPLAY,
        "No foi possvel carregar a lista de tipos de vdeo.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_LOAD_KEYBOARD,
        "No foi possvel carregar a lista de tipos de teclado.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_LOAD_KBLAYOUT,
        "No foi possvel carregar a lista de leiautes de teclado.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_WARN_PARTITION,
        "O instalador encontrou uma tabela de partio incompatvel\n"
        "que no pode ser utilizada corretamente!\n"
        "\n"
        "Criar ou excluir parties pode destruir a tabela de partio.\n"
        "\n"
        "  \x07  Para sair da instalao, pressione F3.\n"
        "  \x07  Para continuar, pressione ENTER.",
        "F3=Sair  ENTER=Continuar"
    },
    {
        //ERROR_NEW_PARTITION,
        "Voc no pode criar uma partio dentro de\n"
        "outra partio j existente!\n"
        "\n"
        "  * Pressione qualquer tecla para continuar.",
        NULL
    },
    {
        //ERROR_DELETE_SPACE,
        "Voc no pode excluir um espao no-particionado!\n"
        "\n"
        "  * Pressione qualquer tecla para continuar.",
        NULL
    },
    {
        //ERROR_INSTALL_BOOTCODE,
        "Erro ao instalar o cdigo de inicializao na partio do sistema.",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_NO_FLOPPY,
        "No h disco na unidade A:.",
        "ENTER=Continuar"
    },
    {
        //ERROR_UPDATE_KBSETTINGS,
        "No foi possvel atualizar a configurao de leiaute de teclado.",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_UPDATE_DISPLAY_SETTINGS,
        "No foi possvel atualizar a configurao de vdeo.",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_IMPORT_HIVE,
        "No foi possvel importar o arquivo de estrutura.",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_FIND_REGISTRY
        "No foi possvel encontrar os arquivos do registro.",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_CREATE_HIVE,
        "No foi possvel criar as estruturas do registro.",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_INITIALIZE_REGISTRY,
        "No foi possvel inicializar o registro.",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_INVALID_CABINET_INF,
        "O arquivo cab no contm um arquivo inf vlido.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_CABINET_MISSING,
        "No foi possvel econtrar o arquivo cab.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_CABINET_SCRIPT,
        "O arquivo cab no contm um script de instalao.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_COPY_QUEUE,
        "No foi possvel abrir a lista de arquivos para cpia.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_CREATE_DIR,
        "No foi possvel criar os diretrios de instalao.",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_TXTSETUP_SECTION,
        "No foi possvel encontrar a seo 'Directories' no\n"
        "arquivo TXTSETUP.SIF.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_CABINET_SECTION,
        "No foi possvel encontrar a seo 'Directories' no\n"
        "arquivo cab.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_CREATE_INSTALL_DIR
        "No foi possvel criar o diretrio de instalao.",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_FIND_SETUPDATA,
        "No foi possvel encontrar a seo 'SetupData' no\n"
        "arquivo TXTSETUP.SIF.\n",
        "ENTER=Reiniciar"
    },
    {
        //ERROR_WRITE_PTABLE,
        "No foi possvel escrever a tabela de parties.\n"
        "ENTER=Reiniciar"
    },
    {
        //ERROR_ADDING_CODEPAGE,
        "No foi possvel adicionar o cdigo de localidade no registro.\n"
        "ENTER=Reiniciar"
    },
    {
        //ERROR_UPDATE_LOCALESETTINGS,
        "No foi possvel configurar o idioma do sistema.\n"
        "ENTER=Reiniciar"
    },
    {
        //ERROR_ADDING_KBLAYOUTS,
        "No foi possvel adicionar o leiaute do teclado no registro.\n"
        "ENTER=Reiniciar"
    },
    {
        //ERROR_UPDATE_GEOID,
        "No foi possvel configurar a identificao geogrfica.\n"
        "ENTER=Reiniciar"
    },
    {
        //ERROR_DIRECTORY_NAME,
        "Invalid directory name.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_INSUFFICIENT_PARTITION_SIZE,
        "The selected partition is not large enough to install ReactOS.\n"
        "The install partition must have a size of at least %lu MB.\n"
        "\n"
        "  * Pressione qualquer tecla para continuar.",
        NULL
    },
    {
        //ERROR_PARTITION_TABLE_FULL,
        "You can not create a new primary or extended partition in the\n"
        "partition table of this disk because the partition table is full.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_ONLY_ONE_EXTENDED,
        "You can not create more than one extended partition per disk.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_FORMATTING_PARTITION,
        "Setup is unable to format the partition:\n"
        " %S\n"
        "\n"
        "ENTER = Reboot computer"
    },
    {
        NULL,
        NULL
    }
};

MUI_PAGE ptBRPages[] =
{
    {
        LANGUAGE_PAGE,
        ptBRLanguagePageEntries
    },
    {
        START_PAGE,
        ptBRWelcomePageEntries
    },
    {
        INSTALL_INTRO_PAGE,
        ptBRIntroPageEntries
    },
    {
        LICENSE_PAGE,
        ptBRLicensePageEntries
    },
    {
        DEVICE_SETTINGS_PAGE,
        ptBRDevicePageEntries
    },
    {
        REPAIR_INTRO_PAGE,
        ptBRRepairPageEntries
    },
    {
        COMPUTER_SETTINGS_PAGE,
        ptBRComputerPageEntries
    },
    {
        DISPLAY_SETTINGS_PAGE,
        ptBRDisplayPageEntries
    },
    {
        FLUSH_PAGE,
        ptBRFlushPageEntries
    },
    {
        SELECT_PARTITION_PAGE,
        ptBRSelectPartitionEntries
    },
    {
        CONFIRM_DELETE_SYSTEM_PARTITION_PAGE,
        ptBRConfirmDeleteSystemPartitionEntries
    },
    {
        SELECT_FILE_SYSTEM_PAGE,
        ptBRSelectFSEntries
    },
    {
        FORMAT_PARTITION_PAGE,
        ptBRFormatPartitionEntries
    },
    {
        DELETE_PARTITION_PAGE,
        ptBRDeletePartitionEntries
    },
    {
        INSTALL_DIRECTORY_PAGE,
        ptBRInstallDirectoryEntries
    },
    {
        PREPARE_COPY_PAGE,
        ptBRPrepareCopyEntries
    },
    {
        FILE_COPY_PAGE,
        ptBRFileCopyEntries
    },
    {
        KEYBOARD_SETTINGS_PAGE,
        ptBRKeyboardSettingsEntries
    },
    {
        BOOT_LOADER_PAGE,
        ptBRBootLoaderEntries
    },
    {
        LAYOUT_SETTINGS_PAGE,
        ptBRLayoutSettingsEntries
    },
    {
        QUIT_PAGE,
        ptBRQuitPageEntries
    },
    {
        SUCCESS_PAGE,
        ptBRSuccessPageEntries
    },
    {
        BOOT_LOADER_FLOPPY_PAGE,
        ptBRBootPageEntries
    },
    {
        REGISTRY_PAGE,
        ptBRRegistryEntries
    },
    {
        -1,
        NULL
    }
};

MUI_STRING ptBRStrings[] =
{
    {STRING_PLEASEWAIT,
    "   Por favor, aguarde..."},
    {STRING_INSTALLCREATEPARTITION,
     "   ENTER = Install   P = Create Primary   E = Create Extended   F3 = Quit"},
//    "   ENTER=Instalar  C=Criar partio  F3=Sair"},
    {STRING_INSTALLCREATELOGICAL,
     "   ENTER = Install   L = Create Logical Partition   F3 = Quit"},
    {STRING_INSTALLDELETEPARTITION,
    "   ENTER=Instalar  D=Apagar partio  F3=Sair"},
    {STRING_DELETEPARTITION,
     "   D = Delete Partition   F3 = Quit"},
    {STRING_PARTITIONSIZE,
    "Tamanho da nova partio:"},
    {STRING_CHOOSENEWPARTITION,
     "You have chosen to create a primary partition on"},
//    "Voc solicitou a criao de uma nova partio em"},
    {STRING_CHOOSE_NEW_EXTENDED_PARTITION,
     "You have chosen to create an extended partition on"},
    {STRING_CHOOSE_NEW_LOGICAL_PARTITION,
     "You have chosen to create a logical partition on"},
    {STRING_HDDSIZE,
    "Por favor, insira o tamanho da nova partio em megabytes (MB)."},
    {STRING_CREATEPARTITION,
    "   ENTER=Criar partio  ESC=Cancelar  F3=Sair"},
    {STRING_PARTFORMAT,
    "Esta partio ser formatada logo em seguida."},
    {STRING_NONFORMATTEDPART,
    "Voc solicitou instalar o ReactOS em uma partio nova ou sem formato."},
    {STRING_NONFORMATTEDSYSTEMPART,
    "The system partition is not formatted yet."},
    {STRING_NONFORMATTEDOTHERPART,
    "The new partition is not formatted yet."},
    {STRING_INSTALLONPART,
    "O instalador instala o ReactOS na partio"},
    {STRING_CHECKINGPART,
    "O instalador est verificando a partio selecionada."},
    {STRING_CONTINUE,
    "ENTER=Continuar"},
    {STRING_QUITCONTINUE,
    "F3=Sair  ENTER=Continuar"},
    {STRING_REBOOTCOMPUTER,
    "ENTER=Reiniciar"},
    {STRING_TXTSETUPFAILED,
    "No foi possvel econtrar a seo '%S' no\narquivo TXTSETUP.SIF.\n"},
    {STRING_COPYING,
    "   Copiando arquivo: %S"},
    {STRING_SETUPCOPYINGFILES,
    "O instalador est copiando os arquivos..."},
    {STRING_REGHIVEUPDATE,
    "   Atualizando a estrutura do registro..."},
    {STRING_IMPORTFILE,
    "   Importando %S..."},
    {STRING_DISPLAYETTINGSUPDATE,
    "   Atualizando as configuraes de vdeo..."},
    {STRING_LOCALESETTINGSUPDATE,
    "   Atualizando as configuraes regionais..."},
    {STRING_KEYBOARDSETTINGSUPDATE,
    "   Atualizando as configuraes de leiaute do teclado..."},
    {STRING_CODEPAGEINFOUPDATE,
    "   Adicionando as informaes de localidade no registro..."},
    {STRING_DONE,
    "   Pronto..."},
    {STRING_REBOOTCOMPUTER2,
    "   ENTER=Reiniciar"},
    {STRING_CONSOLEFAIL1,
    "No foi possvel abrir o console\r\n\r\n"},
    {STRING_CONSOLEFAIL2,
    "A causa mais comm  a utilizao de um teclado USB\r\n"},
    {STRING_CONSOLEFAIL3,
    "Os teclados USB ainda no so completamente suportados\r\n"},
    {STRING_FORMATTINGDISK,
    "O instalador est formatando o disco"},
    {STRING_CHECKINGDISK,
    "O instalador est verificando o disco"},
    {STRING_FORMATDISK1,
    " Formatar a partio utilizando o sistema de arquivos %S (Rpido) "},
    {STRING_FORMATDISK2,
    " Formatar a partio utilizando o sistema de arquivos %S "},
    {STRING_KEEPFORMAT,
    " Manter o sistema de arquivos atual (sem alteraes) "},
    {STRING_HDINFOPARTCREATE,
    "%I64u %s  Disco %lu  (Porta=%hu, Barramento=%hu, Id=%hu) em %wZ."},
    {STRING_HDDINFOUNK1,
    "%I64u %s  Disco %lu  (Porta=%hu, Barramento=%hu, Id=%hu)."},
    {STRING_HDDINFOUNK2,
    "   %c%c  Tipo 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTDELETE,
    "em %I64u %s  Disco %lu  (Porta=%hu, Barramento=%hu, Id=%hu) em %wZ."},
    {STRING_HDDINFOUNK3,
    "em %I64u %s  Disco %lu  (Porta=%hu, Barramento=%hu, Id=%hu)."},
    {STRING_HDINFOPARTZEROED,
    "Disco %lu (%I64u %s), Porta=%hu, Barramento=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK4,
    "%c%c  Tipo 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTEXISTS,
    "em Disco %lu (%I64u %s), Porta=%hu, Barramento=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK5,
    "%c%c %c %sTipo %-3u%s                      %6lu %s"},
    {STRING_HDINFOPARTSELECT,
    "%6lu %s  Disco %lu  (Porta=%hu, Barramento=%hu, Id=%hu) em %S"},
    {STRING_HDDINFOUNK6,
    "%6lu %s  Disco %lu  (Porta=%hu, Barramento=%hu, Id=%hu)"},
    {STRING_NEWPARTITION,
    "O instalador criou uma nova partio em"},
    {STRING_UNPSPACE,
    "    %sEspao no particionado%s            %6lu %s"},
    {STRING_MAXSIZE,
    "MB (max. %lu MB)"},
    {STRING_EXTENDED_PARTITION,
    "Extended Partition"},
    {STRING_UNFORMATTED,
    "Novo (sem formato)"},
    {STRING_FORMATUNUSED,
    "Livre"},
    {STRING_FORMATUNKNOWN,
    "desconhecido"},
    {STRING_KB,
    "KB"},
    {STRING_MB,
    "MB"},
    {STRING_GB,
    "GB"},
    {STRING_ADDKBLAYOUTS,
    "Adicionando leiautes de teclado"},
    {0, 0}
};
