/* TRANSLATOR:  Mrio Kamr /Mario Kacmar/ aka Kario (kario@szm.sk)
 * DATE OF TR:  22-01-2008
 * Encoding  :  Latin II (852)
 * LastChange:  22-05-2011
 */

#pragma once

MUI_LAYOUTS skSKLayouts[] =
{
    { L"041B", L"0000041B" },
    { L"041B", L"0001041B" },
    { L"0409", L"00000409" },
    { NULL, NULL }
};

static MUI_ENTRY skSKLanguagePageEntries[] =
{
    {
        4,
        3,
         " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Vber jazyka.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Zvote si jazyk, ktor sa pouije poas intalcie.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Potom stlate ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Tento jazyk bude predvolenm jazykom naintalovanho systmu.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraova   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKWelcomePageEntries[] =
{
    {
        4,
        3,
         " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Vta Vs Intaltor systmu ReactOS",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        11,
        "Tento stupe Intaltora skopruje operan systm ReactOS na V",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "pota a priprav druh stupe Intaltora.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Stlate ENTER pre naintalovanie systmu ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Stlate R pre opravu alebo aktualizciu systmu ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Stlate L, ak chcete zobrazi licenn podmienky systmu ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Stlate F3 pre skonenie intalcie, systm ReactOS sa nenaintaluje.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Pre viac informci o systme ReactOS, navtvte prosm:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "http://www.reactos.org",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        0,
        0,
        "ENTER = Pokraova  R = Opravi  L = Licencia  F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKIntroPageEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Intaltor systmu ReactOS je v zaiatonom tdiu vvoja. Zatia",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "nepodporuje vetky funkcie plne vyuvajce program Intaltor.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "M nasledujce obmedzenia:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "- Intaltor podporuje iba sborov systm FAT.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "- Kontrola sborovho systmu zatia nie je implementovan.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        23,
        "\x07  Stlate ENTER pre naintalovanie systmu ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "\x07  Stlate F3 pre skonenie intalcie, systm ReactOS sa nenaintaluje.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraova   F3 = Skoni",
        TEXT_TYPE_STATUS| TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKLicensePageEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        6,
        "Licencia:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        8,
        "Systm ReactOS je vydan za podmienok licencie",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        9,
        "GNU GPL s asami obsahujcimi kd z inch kompatibilnch",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "licenci ako s X11 alebo BSD a licencie GNU LGPL.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "Preto vetok softvr, ktor je sasou systmu ReactOS,",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "je vydan pod licenciou GNU GPL, a rovnako s zachovan",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "aj pvodn licencie.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Tento softvr prichdza BEZ ZRUKY alebo obmedzen pouvania",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "s vnimkou platnho miestneho a medzinrodnho prva. Licencia",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "systmu ReactOS pokrva iba distribciu k trenm stranm.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "Ak z nejakho dvodu neobdrte kpiu licencie GNU GPL",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "spolu so systmom ReactOS, navtvte, prosm, strnku:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "http://www.gnu.org/licenses/licenses.html",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        22,
        "Zruka:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        24,
        "Toto je slobodn softvr; see the source for copying conditions.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "There is NO warranty; not even for MERCHANTABILITY or",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        26,
        "FITNESS FOR A PARTICULAR PURPOSE",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Nvrat",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKDevicePageEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Zoznam niie, zobrazuje sasn nastavenia zariaden.",
        TEXT_STYLE_NORMAL
    },
    {
        24,
        11,
        "Pota:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        12,
        "Monitor:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        13,
        "Klvesnica:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        14,
        "Rozloenie kl.:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        16,
        "Akceptova:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        25,
        16, "Akceptova tieto nastavenia zariaden",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        19,
        "Mete zmeni hardvrov nastavenia stlaenm klvesov HORE alebo DOLE",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        20,
        "pre vber poloky. Potom stlate klves ENTER pre vber alternatvnych",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        21,
        "nastaven.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Ak s vetky nastavenia sprvne, vyberte poloku",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "\"Akceptova tieto nastavenia zariaden\" a stlate ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraova   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKRepairPageEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Intaltor systmu ReactOS je v zaiatonom tdiu vvoja. Zatia",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "nepodporuje vetky funkcie plne vyuvajce program Intaltor.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Funkcie na opravu systmu zatia nie s implementovan.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Stlate U pre aktualizciu OS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Stlate R pre zchrann konzolu.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Stlate ESC pre nvrat na hlavn strnku.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Stlate ENTER pre retart potaa.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ESC = Hlavn strnka  U = Aktualizova  R = Zchrana  ENTER = Retart",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKComputerPageEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Chcete zmeni typ potaa, ktor m by naintalovan.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Stlate klves HORE alebo DOLE pre vber poadovanho typu potaa.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Potom stlate ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Stlate klves ESC pre nvrat na predchdzajcu strnku bez zmeny",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   typu potaa.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraova   ESC = Zrui   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKFlushPageEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Systm prve overuje vetky uloen daje na Vaom disku",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "To me trva niekoko mint",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "Ke skon, pota sa automaticky retartuje",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Vyprzdujem cache", //Flushing cache (zapisuje sa na disk obsah cache, doslovne "Preplachovanie cashe")
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKQuitPageEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Systm ReactOS nie je naintalovan kompletne",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Vyberte disketu z mechaniky A: a",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "vetky mdi CD-ROM z CD mechank.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Stlate ENTER pre retart potaa.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Pokajte, prosm ...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG,
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKDisplayPageEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Chcete zmeni typ monitora, ktor m by naintalovan.",
        TEXT_STYLE_NORMAL
    },
    {   8,
        10,
         "\x07  Stlate klves HORE alebo DOLE pre vber poadovanho typu monitora.",
         TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Potom stlate ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Stlate klves ESC pre nvrat na predchdzajcu strnku bez zmeny",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   typu monitora.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraova   ESC = Zrui   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKSuccessPageEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Zkladn sast systmu ReactOS boli spene naintalovan.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Vyberte disketu z mechaniky A: a",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "vetky mdi CD-ROM z CD mechank.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Stlate ENTER pre retart potaa.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Retart potaa",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKBootPageEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Intaltor neme naintalova zavdza systmu na pevn disk Vho", //bootloader = zavdza systmu
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "potaa",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "Vlote prosm, naformtovan disketu do mechaniky A:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "a stlate ENTER.",
        TEXT_STYLE_NORMAL,
    },
    {
        0,
        0,
        "ENTER = Pokraova   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }

};

static MUI_ENTRY skSKSelectPartitionEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Zoznam niie, zobrazuje existujce oblasti a nevyuit miesto",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "na disku vhodn pre nov oblasti.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "\x07  Stlate HORE alebo DOLE pre vber zo zoznamu poloiek.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Stlate ENTER pre intalciu systmu ReactOS na vybran oblas.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Press P to create a primary partition.",
//        "\x07  Stlate C pre vytvorenie novej oblasti.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Press E to create an extended partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Press L to create a logical partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Stlate D pre vymazanie existujcej oblasti.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Pokajte, prosm ...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKConfirmDeleteSystemPartitionEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "You have chosen to delete the system partition.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "System partitions can contain diagnostic programs, hardware configuration",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "programs, programs to start an operating system (like ReactOS) or other",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "programs provided by the hardware manufacturer.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Delete a system partition only when you are sure that there are no such",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "programs on the partition, or when you are sure you want to delete them.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "When you delete the partition, you might not be able to boot the",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        17,
        "computer from the harddisk until you finished the ReactOS Setup.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "\x07  Press ENTER to delete the system partition. You will be asked",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "   to confirm the deletion of the partition again later.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "\x07  Press ESC to return to the previous page. The partition will",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "   not be deleted.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continue  ESC=Cancel",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKFormatPartitionEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Formtovanie oblasti",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Intaltor teraz naformtuje oblas. Stlate ENTER pre pokraovanie.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraova   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        TEXT_STYLE_NORMAL
    }
};

static MUI_ENTRY skSKInstallDirectoryEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Intaltor naintaluje sbory systmu ReactOS na zvolen oblas.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "Vyberte adresr kam chcete naintalova systm ReactOS:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Ak chcete zmeni odporan adresr, stlate BACKSPACE a vymate",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "znaky. Potom napte nzov adresra, v ktorom chcete aby bol",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "systm ReactOS naintalovan.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraova   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKFileCopyEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        11,
        12,
        "Pokajte, prosm, km Intaltor skopruje sbory do intalanho",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        30,
        13,
        "prieinka pre ReactOS.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        20,
        14,
        "Dokonenie me trva niekoko mint.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        50,
        0,
        "\xB3 Pokajte, prosm ...    ",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKBootLoaderEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Intaltor je pripraven naintalova zavdza operanho systmu",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "Naintalova zavdza systmu na pevn disk (MBR a VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "Naintalova zavdza systmu na pevn disk (iba VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "Naintalova zavdza systmu na disketu.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Preskoi intalciu zavdzaa systmu.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraova   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKKeyboardSettingsEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Chcete zmeni typ klvesnice, ktor m by naintalovan.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Stlate klves HORE alebo DOLE a vyberte poadovan typ klvesnice.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Potom stlate ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Stlate klves ESC pre nvrat na predchdzajcu strnku bez zmeny",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   typu klvesnice.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraova   ESC = Zrui   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKLayoutSettingsEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Prosm, vyberte rozloenie, ktor sa naintaluje ako predvolen.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Stlate klves HORE alebo DOLE pre vber poadovanho rozloenia",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   klvesnice. Potom stlate ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Stlate klves ESC pre nvrat na predchdzajcu strnku bez zmeny",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   rozloenia klvesnice.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Pokraova   ESC = Zrui   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY skSKPrepareCopyEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Pripravuje sa koprovanie sborov systmu ReactOS. ",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Vytvra sa zoznam potrebnch sborov ...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY skSKSelectFSEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        17,
        "Vyberte systm sborov zo zoznamu uvedenho niie.",
        0
    },
    {
        8,
        19,
        "\x07  Stlate HORE alebo DOLE pre vber systmu sborov.",
        0
    },
    {
        8,
        21,
        "\x07  Stlate ENTER pre formtovanie oblasti.",
        0
    },
    {
        8,
        23,
        "\x07  Stlate ESC pre vber inej oblasti.",
        0
    },
    {
        0,
        0,
        "ENTER = Pokraova   ESC = Zrui   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },

    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKDeletePartitionEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Vybrali ste si odstrnenie oblasti",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "\x07  Stlate D pre odstrnenie oblasti.",
        TEXT_STYLE_NORMAL
    },
    {
        11,
        19,
        "UPOZORNENIE: Vetky daje na tejto oblasti sa nenvratne stratia!",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Stlate ESC pre zruenie.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "D = Odstrni oblas   ESC = Zrui   F3 = Skoni",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY skSKRegistryEntries[] =
{
    {
        4,
        3,
        " Intaltor systmu ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Aktualizuj sa systmov nastavenia.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Vytvraj sa poloky registrov ...", //registry hives
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

MUI_ERROR skSKErrorEntries[] =
{
    {
        // NOT_AN_ERROR
        "Success\n"
    },
    {
        //ERROR_NOT_INSTALLED
        "Systm ReactOS nie je kompletne naintalovan na Vaom\n"
        "potai. Ak teraz prerute intalciu, budete musie\n"
        "spusti Intaltor znova, aby sa systm ReactOS naintaloval.\n"
        "\n"
        "  \x07  Stlate ENTER pre pokraovanie v intalcii.\n"
        "  \x07  Stlate F3 pre skonenie intalcie.",
        "F3 = Skoni  ENTER = Pokraova"
    },
    {
        //ERROR_NO_HDD
        "Intaltoru sa nepodarilo njs pevn disk.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_NO_SOURCE_DRIVE
        "Intaltoru sa nepodarilo njs jej zdrojov mechaniku.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_LOAD_TXTSETUPSIF
        "Intaltor zlyhal pri nahrvan sboru TXTSETUP.SIF.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_CORRUPT_TXTSETUPSIF
        "Intaltor naiel pokoden sbor TXTSETUP.SIF.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_SIGNATURE_TXTSETUPSIF,
        "Setup found an invalid signature in TXTSETUP.SIF.\n", //chybn (neplatn) podpis (znak, znaka, ifra)
        "ENTER = Retart potaa"
    },
    {
        //ERROR_DRIVE_INFORMATION
        "Intaltor nemohol zska informcie o systmovch diskoch.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_WRITE_BOOT,
        "Intaltoru sa nepodarilo naintalova zavdzac kd sborovho\n"
        "systmu FAT na systmov partciu.",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_LOAD_COMPUTER,
        "Intaltor zlyhal pri nahrvan zoznamu typov potaov.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_LOAD_DISPLAY,
        "Intaltor zlyhal pri nahrvan zoznamu nastaven monitora.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_LOAD_KEYBOARD,
        "Intaltor zlyhal pri nahrvan zoznamu typov klvesnc.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_LOAD_KBLAYOUT,
        "Intaltor zlyhal pri nahrvan zoznamu rozloenia klvesnc.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_WARN_PARTITION,
//          "Intaltor zistil, e najmenej jeden pevn disk obsahuje nekompatibiln\n"
          "Intaltor naiel najmenej na jednom pevnom disku nekompatibiln\n"
          "tabuku oblast, s ktorou sa ned sprvne zaobchdza!\n"
          "\n"
          "Vytvorenie alebo odstrnenie oblast me znii tabuku oblast.\n"
          "\n"
          "  \x07  Stlate F3 pre skonenie intalcie.\n"
          "  \x07  Stlate ENTER pre pokraovanie.",
          "F3 = Skoni  ENTER = Pokraova"
    },
    {
        //ERROR_NEW_PARTITION,
        "Nemete vytvori nov oblas\n"
        "vo vntri u existujcej oblasti!\n"
        "\n"
        "  * Pokraujte stlaenm ubovonho klvesu.",
        NULL
    },
    {
        //ERROR_DELETE_SPACE,
        "Nemete odstrni miesto na disku, ktor nie je oblasou!\n"
        "\n"
        "  * Pokraujte stlaenm ubovonho klvesu.",
        NULL
    },
    {
        //ERROR_INSTALL_BOOTCODE,
        "Intaltoru sa nepodarilo naintalova zavdzac kd sborovho\n"
        "systmu FAT na systmov partciu.",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_NO_FLOPPY,
        "V mechanike A: nie je disketa.",
        "ENTER = Pokraova"
    },
    {
        //ERROR_UPDATE_KBSETTINGS,
        "Intaltor zlyhal pri aktualizcii nastaven rozloenia klvesnice.",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_UPDATE_DISPLAY_SETTINGS,
        "Setup failed to update display registry settings.",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_IMPORT_HIVE,
        "Setup failed to import a hive file.",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_FIND_REGISTRY
        "Setup failed to find the registry data files.",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_CREATE_HIVE,
        "Setup failed to create the registry hives.",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_INITIALIZE_REGISTRY,
        "Setup failed to set the initialize the registry.",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_INVALID_CABINET_INF,
        "Cabinet has no valid inf file.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_CABINET_MISSING,
        "Cabinet not found.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_CABINET_SCRIPT,
        "Cabinet has no setup script.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_COPY_QUEUE,
        "Setup failed to open the copy file queue.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_CREATE_DIR,
        "Intaltor nemohol vytvori intalan adresre.",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_TXTSETUP_SECTION,
        "Setup failed to find the 'Directories' section\n"
        "in TXTSETUP.SIF.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_CABINET_SECTION,
        "Setup failed to find the 'Directories' section\n"
        "in the cabinet.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_CREATE_INSTALL_DIR
        "Intaltor nemohol vytvori intalan adresr.", //could not = nemohol
        "ENTER = Retart potaa"
    },
    {
        //ERROR_FIND_SETUPDATA,
        "Intaltor zlyhal pri hadan sekcie 'SetupData'\n"
        "v sbore TXTSETUP.SIF.\n",
        "ENTER = Retart potaa"
    },
    {
        //ERROR_WRITE_PTABLE,
        "Intaltor zlyhal pri zpise do tabuliek oblast.\n"
        "ENTER = Retart potaa"
    },
    {
        //ERROR_ADDING_CODEPAGE,
        "Intaltor zlyhal pri pridvan kdovej strnky do registrov.\n"
        "ENTER = Retart potaa"
    },
    {
        //ERROR_UPDATE_LOCALESETTINGS,
        "Setup could not set the system locale.\n"
        "ENTER = Retart potaa"
    },
    {
        //ERROR_ADDING_KBLAYOUTS,
        "Intaltor zlyhal pri pridvan rozloen klvesnice do registrov.\n"
        "ENTER = Retart potaa"
    },
    {
        //ERROR_UPDATE_GEOID,
        "Intaltor nemohol nastavi geo id.\n"
        "ENTER = Retart potaa"
    },
    {
        //ERROR_DIRECTORY_NAME,
        "Invalid directory name.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_INSUFFICIENT_PARTITION_SIZE,
        "The selected partition is not large enough to install ReactOS.\n"
        "The install partition must have a size of at least %lu MB.\n"
        "\n"
        "  * Pokraujte stlaenm ubovonho klvesu.",
        NULL
    },
    {
        //ERROR_PARTITION_TABLE_FULL,
        "You can not create a new primary or extended partition in the\n"
        "partition table of this disk because the partition table is full.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_ONLY_ONE_EXTENDED,
        "You can not create more than one extended partition per disk.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_FORMATTING_PARTITION,
        "Setup is unable to format the partition:\n"
        " %S\n"
        "\n"
        "ENTER = Reboot computer"
    },
    {
        NULL,
        NULL
    }
};

MUI_PAGE skSKPages[] =
{
    {
        LANGUAGE_PAGE,
        skSKLanguagePageEntries
    },
    {
        START_PAGE,
        skSKWelcomePageEntries
    },
    {
        INSTALL_INTRO_PAGE,
        skSKIntroPageEntries
    },
    {
        LICENSE_PAGE,
        skSKLicensePageEntries
    },
    {
        DEVICE_SETTINGS_PAGE,
        skSKDevicePageEntries
    },
    {
        REPAIR_INTRO_PAGE,
        skSKRepairPageEntries
    },
    {
        COMPUTER_SETTINGS_PAGE,
        skSKComputerPageEntries
    },
    {
        DISPLAY_SETTINGS_PAGE,
        skSKDisplayPageEntries
    },
    {
        FLUSH_PAGE,
        skSKFlushPageEntries
    },
    {
        SELECT_PARTITION_PAGE,
        skSKSelectPartitionEntries
    },
    {
        CONFIRM_DELETE_SYSTEM_PARTITION_PAGE,
        skSKConfirmDeleteSystemPartitionEntries
    },
    {
        SELECT_FILE_SYSTEM_PAGE,
        skSKSelectFSEntries
    },
    {
        FORMAT_PARTITION_PAGE,
        skSKFormatPartitionEntries
    },
    {
        DELETE_PARTITION_PAGE,
        skSKDeletePartitionEntries
    },
    {
        INSTALL_DIRECTORY_PAGE,
        skSKInstallDirectoryEntries
    },
    {
        PREPARE_COPY_PAGE,
        skSKPrepareCopyEntries
    },
    {
        FILE_COPY_PAGE,
        skSKFileCopyEntries
    },
    {
        KEYBOARD_SETTINGS_PAGE,
        skSKKeyboardSettingsEntries
    },
    {
        BOOT_LOADER_PAGE,
        skSKBootLoaderEntries
    },
    {
        LAYOUT_SETTINGS_PAGE,
        skSKLayoutSettingsEntries
    },
    {
        QUIT_PAGE,
        skSKQuitPageEntries
    },
    {
        SUCCESS_PAGE,
        skSKSuccessPageEntries
    },
    {
        BOOT_LOADER_FLOPPY_PAGE,
        skSKBootPageEntries
    },
    {
        REGISTRY_PAGE,
        skSKRegistryEntries
    },
    {
        -1,
        NULL
    }
};

MUI_STRING skSKStrings[] =
{
    {STRING_PLEASEWAIT,
     "   Pokajte, prosm ..."},
    {STRING_INSTALLCREATEPARTITION,
     "   ENTER = Install   P = Create Primary   E = Create Extended   F3 = Quit"},
//     "   ENTER = Intalova   C = Vytvori oblas   F3 = Skoni"},
    {STRING_INSTALLCREATELOGICAL,
     "   ENTER = Install   L = Create Logical Partition   F3 = Quit"},
    {STRING_INSTALLDELETEPARTITION,
     "   ENTER = Intalova   D = Odstrni oblas   F3 = Skoni"},
    {STRING_DELETEPARTITION,
     "   D = Delete Partition   F3 = Quit"},
    {STRING_PARTITIONSIZE,
     "Vekos novej oblasti:"},
    {STRING_CHOOSENEWPARTITION,
     "You have chosen to create a primary partition on"},
//     "Zvolili ste vytvorenie novej oblasti na"},
    {STRING_CHOOSE_NEW_EXTENDED_PARTITION,
     "You have chosen to create an extended partition on"},
    {STRING_CHOOSE_NEW_LOGICAL_PARTITION,
     "You have chosen to create a logical partition on"},
    {STRING_HDDSIZE,
    "Zadajte, prosm, vekos novej oblasti v megabajtoch."},
    {STRING_CREATEPARTITION,
     "   ENTER = Vytvori oblas   ESC = Zrui   F3 = Skoni"},
    {STRING_PARTFORMAT,
    "Tto oblas sa bude formtova ako alia."},
    {STRING_NONFORMATTEDPART,
    "Zvolili ste intalciu systmu ReactOS na nov alebo nenaformtovan oblas."},
    {STRING_NONFORMATTEDSYSTEMPART,
    "The system partition is not formatted yet."},
    {STRING_NONFORMATTEDOTHERPART,
    "The new partition is not formatted yet."},
    {STRING_INSTALLONPART,
    "Intaltor naintaluje systm ReactOS na oblas"},
    {STRING_CHECKINGPART,
    "Intaltor teraz skontroluje vybran oblas."},
    {STRING_CONTINUE,
    "ENTER = Pokraova"},
    {STRING_QUITCONTINUE,
    "F3 = Skoni  ENTER = Pokraova"},
    {STRING_REBOOTCOMPUTER,
    "ENTER = Retart potaa"},
    {STRING_TXTSETUPFAILED,
    "Intaltor zlyhal pri hadan sekcie '%S'\nv sbore TXTSETUP.SIF.\n"},
    {STRING_COPYING,
     "   Kopruje sa sbor: %S"},
    {STRING_SETUPCOPYINGFILES,
     "Intaltor kopruje sbory..."},
    {STRING_REGHIVEUPDATE,
    "   Aktualizujem poloky registrov..."},
    {STRING_IMPORTFILE,
    "   Importujem %S..."},
    {STRING_DISPLAYETTINGSUPDATE,
    "   Aktualizujem nastavenia obrazovky v registrov..."}, //display registry settings
    {STRING_LOCALESETTINGSUPDATE,
    "   Aktualizujem miestne nastavenia..."},
    {STRING_KEYBOARDSETTINGSUPDATE,
    "   Aktualizujem nastavenia rozloenia klvesnice..."},
    {STRING_CODEPAGEINFOUPDATE,
    "   Pridvam do registrov informcie o kdovej strnke..."},
    {STRING_DONE,
    "   Hotovo..."},
    {STRING_REBOOTCOMPUTER2,
    "   ENTER = Retart potaa"},
    {STRING_CONSOLEFAIL1,
    "Nemono otvori konzolu\r\n\r\n"},
    {STRING_CONSOLEFAIL2,
    "Najbenejou prinou tohto je pouitie USB klvesnice\r\n"},
    {STRING_CONSOLEFAIL3,
    "USB klvesnica ete nie je plne podporovan\r\n"},
    {STRING_FORMATTINGDISK,
    "Intaltor formtuje V disk"},
    {STRING_CHECKINGDISK,
    "Intaltor kontroluje V disk"},
    {STRING_FORMATDISK1,
    " Naformtova oblas ako systm sborov %S (rchly formt) "},
    {STRING_FORMATDISK2,
    " Naformtova oblas ako systm sborov %S "},
    {STRING_KEEPFORMAT,
    " Ponecha sasn systm sborov (bez zmeny) "},
    {STRING_HDINFOPARTCREATE,
    "%I64u %s  pevnom disku %lu  (Port=%hu, Bus=%hu, Id=%hu) na %wZ."},
    {STRING_HDDINFOUNK1,
    "%I64u %s  pevn disk %lu  (Port=%hu, Bus=%hu, Id=%hu)."},
    {STRING_HDDINFOUNK2,
    "   %c%c  typ 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTDELETE,
    "na %I64u %s  pevnom disku %lu  (Port=%hu, Bus=%hu, Id=%hu) na %wZ."},
    {STRING_HDDINFOUNK3,
    "na %I64u %s  pevnom disku %lu  (Port=%hu, Bus=%hu, Id=%hu)."},
    {STRING_HDINFOPARTZEROED,
    "pevn disk %lu (%I64u %s), Port=%hu, Bus=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK4,
    "%c%c  typ 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTEXISTS,
    "na pevnom disku %lu (%I64u %s), Port=%hu, Bus=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK5,
    "%c%c %c %styp %-3u%s                      %6lu %s"},
    {STRING_HDINFOPARTSELECT,
    "%6lu %s  pevn disk %lu  (Port=%hu, Bus=%hu, Id=%hu) na %S"},
    {STRING_HDDINFOUNK6,
    "%6lu %s  pevnom disku %lu  (Port=%hu, Bus=%hu, Id=%hu)"},
    {STRING_NEWPARTITION,
    "Intaltor vytvoril nov oblas na"},
    {STRING_UNPSPACE,
    "    %sMiesto bez oblast%s             %6lu %s"},
    {STRING_MAXSIZE,
    "MB (max. %lu MB)"},
    {STRING_EXTENDED_PARTITION,
    "Extended Partition"},
    {STRING_UNFORMATTED,
    "Nov (Nenaformtovan)"},
    {STRING_FORMATUNUSED,
    "Nepouit"},
    {STRING_FORMATUNKNOWN,
    "Neznme"},
    {STRING_KB,
    "KB"},
    {STRING_MB,
    "MB"},
    {STRING_GB,
    "GB"},
    {STRING_ADDKBLAYOUTS,
    "Pridvam rozloenia klvesnice"},
    {0, 0}
};
