/*
 *      translated by Caemyr (Jan-Feb, Apr, 2008)
 *      Use ReactOS forum PM or IRC to contact me
 *      http://www.reactos.org
 *      IRC: irc.freenode.net #reactos-pl;
 *      Updated by Wojo664 (July, 2014)
 *      Updated by Saibamen (July, 2015)
 */

#pragma once

MUI_LAYOUTS plPLLayouts[] =
{
    { L"0415", L"00000415" },
    { L"0415", L"00010415" },
    { L"0409", L"00000409" },
    { NULL, NULL }
};

static MUI_ENTRY plPLLanguagePageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Wybr jzyka",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Prosz wybra jzyk dla procesu instalacji systemu",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   i nacisn ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Wybrany jzyk bdzie domylnym dla zainstalowanego systemu.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja  F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLWelcomePageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Witamy w programie instalacyjnym systemu ReactOS",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        11,
        " Na tym etapie, instalator skopiuje niezbdne pliki systemu operacyjnego",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "na twj komputer i rozpocznie kolejny etap procesu instalacji.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Nacinij ENTER, aby zainstalowa system ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Nacinij R, aby naprawi zainstalowany system ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Nacinij L, aby zapozna si z licencj ReactOS",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Nacinij F3, aby wyj bez instalacji systemu ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Wicej informacji o systemie ReactOS mona znale na stronie:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "http://www.reactos.org",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        0,
        0,
        "ENTER = Kontynuacja  R = Naprawa F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLIntroPageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalator ReactOS wci jest we wczesnej fazie rozwoju. Nadal nie",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "obsuguje wszystkich funkcji, niezbdnych dla programu instalacyjnego.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Najwaniejsze ograniczenia:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "- Instalator obsuguje jedynie system plikw FAT.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "- Brakuje sprawdzenia poprawnoci systemu plikw.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        23,
        "\x07  Nacinij ENTER, aby zainstalowa system ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "\x07  Nacinij F3, aby wyj bez instalacji systemu ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   F3 = Wyjcie",
        TEXT_TYPE_STATUS| TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLLicensePageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        6,
        "Licencja:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        8,
        "System ReactOS jest licencjonowany na warunkach licencji",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        9,
        "GNU GPL z elementami kodu pochodzcego z kompatybilnych",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "licencji, takich jak X11 czy BSD albo GNU LGPL. Cae",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "oprogramowanie, bdce czci systemu ReactOS podlega wic",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "licencji GNU GPL jak i odpowiedniej licencji oryginalnej.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "To oprogramowanie wydawane jest BEZ JAKIEJKOLWIEK gwarancji",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "czy te ogranicze w uyciu, poza przepisami prawa lokalnego",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "bd midzynarodowego. Licencja systemu ReactOS",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "reguluje wycznie zasady dystrybucji dla osb trzecich.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "Jeli z jakiego powodu nie otrzymae kopii licencji",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "GNU GPL wraz z systemem ReactOS, prosimy odwiedzi stron:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "http://www.gnu.org/licenses/licenses.html",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        22,
        "Gwarancja:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        24,
        "Niniejszy program jest wolnym oprogramowaniem; szczegy",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "dotyczce kopiowania w rdach. Nie ma ADNEJ gwarancji",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        26,
        "PRZYDATNOCI HANDLOWEJ LUB DO OKRELONYCH ZASTOSOWA",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Powrt",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLDevicePageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Ponisza lista zawiera obecne ustawienia sprztu.",
        TEXT_STYLE_NORMAL
    },
    {
        24,
        11,
        "Komputer:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        12,
        "Ekran:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        13,
        "Klawiatura:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        14,
        "Uk. klawiatury:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        16,
        "Zapisz:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        25,
        16, "Akceptuj ustawienia sprztu",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        19,
        "Moesz zmieni poszczeglne ustawienia za pomoc klawiszy GRA i D,",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        20,
        "aby wybra kategori. Potem nacinij ENTER, by przej do menu z ",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        21,
        "ustawieniami szczegowymi do wyboru.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Gdy wszystkie ustawienia s poprawne, wybierz: ",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "\"Akceptuj ustawienia sprztu\" i nacinij ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLRepairPageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalator ReactOS wci jest we wczesnej fazie rozwoju. Nadal nie",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "obsuguje wszystkich funkcji, niezbdnych dla programu instalacyjnego.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Naprawa istniejcej instalacji systemu nie jest jeszcze moliwa.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Nacinij U eby uaktualni system.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Nacinij R, by uruchomi Konsol Odtwarzania.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Nacinij ESC, by powrci do gwnego menu.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Nacinij ENTER, by zrestartowa komputer.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ESC = Menu gwne  ENTER = Restart",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLComputerPageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Aby zmieni typ komputera, na ktrym chcesz zainstalowa ReactOS",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Nacinij klawisz GRA albo D, by wybra odpowiedni typ komputera.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   a nastpnie nacinij ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Nacinij klawisz ESC, aby powrci do poprzedniej strony bez zmiany",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   typu komputera.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   ESC = Anulowanie   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLFlushPageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "System obecnie sprawdza czy dane s poprawnie zapisane na dysku",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "To moe zaj minut.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "Po zakoczeniu, system zrestartuje komputer automatycznie.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Czyszczenie pamici podrcznej",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLQuitPageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "ReactOS zosta ju poprawnie zainstalowany",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Upewnij si e w Napdzie A: nie ma dyskietki i",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "w napdach optycznych - adnych pyt.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Nacinij ENTER, by zrestartowa komputer.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Prosz czeka ...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG,
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLDisplayPageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Chcesz zmieni rozdzielczo ekranu.",
        TEXT_STYLE_NORMAL
    },
    {   8,
        10,
         "\x07  Nacinij klawisz GRA albo D, by wybra rozdzielczo i liczb",
         TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   kolorw, a nastpnie nacinij ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Nacinij ESC, aby powrci do poprzedniej strony bez zmiany",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   rozdzielczoci czy iloci kolorw.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   ESC = Anulowanie   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLSuccessPageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Podstawowe skadniki systemu ReactOS zostay zainstalowane.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Upewnij si e w Napdzie A: nie ma dyskietki i",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "w napdach optycznych - adnych pyt.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Nacinij ENTER, by zrestartowa komputer.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Restart komputera",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLBootPageEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalator ReactOS nie moe zainstalowa menedera",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "rozruchu na twoim dysku twardym",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "Prosz umieci sformatowan dyskietk w napdzie A:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "i nacisn klawisz ENTER.",
        TEXT_STYLE_NORMAL,
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }

};

static MUI_ENTRY plPLSelectPartitionEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Ponisza lista pokazuje istniejce partycje i puste",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "miejsce na nowe partycje.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "\x07  Nacinij GRA lub D, by wybra pozycj z listy.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Nacinij ENTER, by zainstalowa ReactOS na wybranej partycji.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Nacinij P, by stworzy partycj podstawow.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Nacinij E, by stworzy partycj rozszerzon.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Nacinij L, by stworzy partycj logiczn.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Nacinij D, by usun istniejc partycj.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Prosz czeka...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLConfirmDeleteSystemPartitionEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Zadano usunicia partycji systemowej",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Partycje systemowe mog zawiera programy diagnostyczne, konfigurujce",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "urzdzenia, programy uruchamiajce systemy operacyjne (na przykad",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "ReactOS) i inne programy dostarczane przez producentw.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Partycj systemow moesz usun tylko wtedy, gdy masz pewno, e nie",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "zawiera ona takich programw albo gdy chcesz je usun. Usunicie",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "partycji systemowej moe uniemoliwi uruchomienie komputera z dysku",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        17,
        "twardego do czasu zakoczenia instalacji systemu ReactOS.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "\x07  Nacinij ENTER, aby usun t partycj. Instalator wywietli monit",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "   o potwierdzenie, przed usuniciem tej partycji.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "\x07  Nacinij ESC, aby powrci do poprzedniego ekranu",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "   nie usuwajc partycji.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja  ESC = Anulowanie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLFormatPartitionEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Formatowanie partycji",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Instalator sformatuje teraz partycj. Nacinij ENTER, aby kontynuowa.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        TEXT_STYLE_NORMAL
    }
};

static MUI_ENTRY plPLInstallDirectoryEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalator skopiuje pliki systemu na wybran partycj. Wybierz",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "katalog, do ktrego chcesz zainstalowa system ReactOS:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Aby zmieni domylny katalog, uyj klawisza BACKSPACE, by usun",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "a nastpnie wprowad now ciek do katalogu, do ktrego system",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "ma zosta zainstalowany.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLFileCopyEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        11,
        12,
        "Prosz czeka, Instalator ReactOS kopiuje pliki do wybranego",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        30,
        13,
        "katalogu.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        20,
        14,
        "To moe zaj kilka minut.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        50,
        0,
        "\xB3 Prosz czeka...    ",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLBootLoaderEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalator musi teraz zainstalowa meneder rozruchu",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "Instaluj meneder rozruchu na dysku twardym (MBR i VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "Instaluj rozruchu na dysku twardym (tylko VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "Instaluj meneder rozruchu na dyskietce.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Pomi instalacj menedera rozruchu.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLKeyboardSettingsEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Chcesz zmieni typ klawiatury, jaki ma by zainstalowany.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Nacinij klawisz GRA albo D, by wybra odpowiedni typ klawiatury.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   a nastpnie nacinij ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Nacinij ESC, aby powrci do poprzedniej strony bez zmiany",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   typu klawiatury.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   ESC = Anulowanie   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLLayoutSettingsEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Prosz wybra domylnie instalowany ukad klawiatury.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Nacinij klawisz GRA albo D, by wybra odpowiedni ukad",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   klawiatury. Nastpnie nacinij ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Nacinij ESC, aby powrci do poprzedniej strony bez zmiany",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   ukadu klawiatury.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   ESC = Anulowanie   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY plPLPrepareCopyEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalator przygotuje twj komputer do skopiowania plikw systemu. ",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Tworzenie listy plikw do skopiowania...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY plPLSelectFSEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        17,
        "Wybierz system plikw z listy poniej.",
        0
    },
    {
        8,
        19,
        "\x07  Nacinij klawisz GRA alub D, by wybra system plikw.",
        0
    },
    {
        8,
        21,
        "\x07  Nacinij ENTER, aby sformatowa partycj.",
        0
    },
    {
        8,
        23,
        "\x07  Nacinij ESC, aby wybra inn partycj.",
        0
    },
    {
        0,
        0,
        "ENTER = Kontynuacja   ESC = Anulowanie   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },

    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLDeletePartitionEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Chcesz usun wybran partycj",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "\x07  Nacinij D, by usun partycj.",
        TEXT_STYLE_NORMAL
    },
    {
        11,
        19,
        "UWAGA: Wszystkie dane, zapisane na tej partycji zostan utracone!",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Nacinij ESC, aby anulowa.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "D = Usunicie partycji   ESC = Anulowanie   F3 = Wyjcie",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY plPLRegistryEntries[] =
{
    {
        4,
        3,
        " Instalator ReactOS " KERNEL_VERSION_STR " ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Instalator uaktualnia wanie konfiguracj systemu. ",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Tworzenie gazi rejestru...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

MUI_ERROR plPLErrorEntries[] =
{
    {
        // NOT_AN_ERROR
        "Sukces\n"
    },
    {
        //ERROR_NOT_INSTALLED
        "ReactOS nie zosta w peni zainstalowany na twoim\n"
        "komputerze. Jeli wyjdziesz teraz, trzeba bdzie\n"
        "ponownie uruchomi instalator, by zainstalowa ReactOS.\n"
        "\n"
        "  \x07  Nacinij ENTER, aby kontynuowa instalacj.\n"
        "  \x07  Nacinij F3, aby wyj z instalatora.",
        "F3 = Wyjcie  ENTER = Kontynuacja"
    },
    {
        //ERROR_NO_HDD
        "Instalator nie znalaz adnego dysku twardego.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_NO_SOURCE_DRIVE
        "Instalator nie znalaz napdu rdowego.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_LOAD_TXTSETUPSIF
        "Instalator nie mg zaadowa pliku TXTSETUP.SIF.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_CORRUPT_TXTSETUPSIF
        "Instalator znalaz uszkodzony plik TXTSETUP.SIF.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_SIGNATURE_TXTSETUPSIF,
        "Instalator znalaz nieprawidowy wpis w TXTSETUP.SIF.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_DRIVE_INFORMATION
        "Instalator nie mg odczyta informacji o napdzie.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_WRITE_BOOT,
        "Nieudane zapisanie FAT bootcode na partycji systemowej.",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_LOAD_COMPUTER,
        "Instalator nie mg zaadowa listy typw komputera.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_LOAD_DISPLAY,
        "Instalator nie mg zaadowa listy ustawie ekranu.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_LOAD_KEYBOARD,
        "Instalator nie mg zaadowa listy typw klawiatury.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_LOAD_KBLAYOUT,
        "Instalator nie mg zaadowa listy ukadw klawiatury.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_WARN_PARTITION,
        "Instalator wykry, e co najmniej jeden dysk twardy zawiera niekompatybiln \n"
        "tablic partycji, ktra nie bdzie poprawnie obsugiwana!\n"
        "\n"
        "Tworzenie lub kasowanie partycji moe zniszczy ca tablic partycji.\n"
        "\n"
        "  \x07  Nacinij F3, aby wyj z instalatora.\n"
        "  \x07  Nacinij ENTER, aby kontynuowa.",
        "F3 = Wyjcie  ENTER = Kontynuacja"
    },
    {
        //ERROR_NEW_PARTITION,
        "Nie moesz stworzy nowej partycji w miejscu ju\n"
        "istniejcej!\n"
        "\n"
        "  * Nacinij dowolny klawisz, aby kontynuowa.",
        NULL
    },
    {
        //ERROR_DELETE_SPACE,
        "Nie moesz usun pustej przestrzeni, gdzie nie ma adnej partycji!\n"
        "\n"
        "  * Nacinij dowolny klawisz, aby kontynuowa.",
        NULL
    },
    {
        //ERROR_INSTALL_BOOTCODE,
        "Nieudana instalacja FAT bootcode na partycji systemowej.",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_NO_FLOPPY,
        "Brak dyskietki w napdzie A:.",
        "ENTER = Kontynuacja"
    },
    {
        //ERROR_UPDATE_KBSETTINGS,
        "Instalator nie mg zmieni ukadu klawiatury.",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_UPDATE_DISPLAY_SETTINGS,
        "Instalator nie mg zmieni ustawie ekranu w rejestrze.",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_IMPORT_HIVE,
        "Instalator nie by w stanie zaimportowa pliku gazi rejestru.",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_FIND_REGISTRY
        "Instalator nie by w stanie znale plikw z danymi rejestru.",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_CREATE_HIVE,
        "Instalator nie mg stworzy gazi rejestru.",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_INITIALIZE_REGISTRY,
        "Instalator nie by w stanie ustawi inicjalizacji rejestru.",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_INVALID_CABINET_INF,
        "Cabinet nie zawiera prawidowego pliku inf.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_CABINET_MISSING,
        "Cabinet nie zosta znaleziony.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_CABINET_SCRIPT,
        "Cabinet nie zawiera skryptu instalacji.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_COPY_QUEUE,
        "Instalator nie by w stanie otworzy kolejki kopiowania pliku.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_CREATE_DIR,
        "Instalator nie mg stworzy katalogw.",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_TXTSETUP_SECTION,
        "Instalator nie by w stanie znale sekcji 'Directories'\n"
        "w pliku TXTSETUP.SIF.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_CABINET_SECTION,
        "Instalator nie by w stanie znale sekcji 'Directories'\n"
        "w pliku cabinet.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_CREATE_INSTALL_DIR
        "Instalator nie mg stworzy katalogu instalacji.",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_FIND_SETUPDATA,
        "Instalator nie by w stanie znale sekcji 'SetupData'\n"
        "w pliku TXTSETUP.SIF.\n",
        "ENTER = Restart komputera"
    },
    {
        //ERROR_WRITE_PTABLE,
        "Instalator nie mg zapisa zmian w tablicy partycji.\n"
        "ENTER = Restart komputera"
    },
    {
        //ERROR_ADDING_CODEPAGE,
        "Instalator nie mg doda strony kodowania do rejestru.\n"
        "ENTER = Restart komputera"
    },
    {
        //ERROR_UPDATE_LOCALESETTINGS,
        "Instalator nie mg ustawi wersji jzykowej.\n"
        "ENTER = Restart komputera"
    },
    {
        //ERROR_ADDING_KBLAYOUTS,
        "Instalator nie mg doda ukadw klawiatury do rejestru.\n"
        "ENTER = Restart komputera"
    },
    {
        //ERROR_UPDATE_GEOID,
        "Instalator nie mg ustawi lokalizacji geograficznej.\n"
        "ENTER = Restart komputera"
    },
    {
        //ERROR_DIRECTORY_NAME,
        "Nieprawidowa nazwa katalogu.\n"
        "\n"
        "  * Nacinij dowolny klawisz, aby kontynuowa."
    },
    {
        //ERROR_INSUFFICIENT_PARTITION_SIZE,
        "Wybrana partycja nie jest wystarczajco dua, aby zainstalowa ReactOS.\n"
        "Instalacyjna partycja musi mie rozmiar co najmniej %lu MB.\n"
        "\n"
        "  * Nacinij dowolny klawisz, aby kontynuowa.",
        NULL
    },
    {
        //ERROR_PARTITION_TABLE_FULL,
        "Nie mona utworzy na tym dysku partycji podstawowej lub\n" // FIXME
        "rozszerzonej, poniewa tabela partycji jest pena.\n"
        "\n"
        "  * Nacinij dowolny klawisz, aby kontynuowa."
    },
    {
        //ERROR_ONLY_ONE_EXTENDED,
        "Nie moesz utworzy wicej ni jednej partycji rozszerzonej na dysku.\n"
        "\n"
        "  * Nacinij dowolny klawisz, aby kontynuowa."
    },
    {
        //ERROR_FORMATTING_PARTITION,
        "Instalator nie mg sformatowa partycji:\n"
        " %S\n"
        "\n"
        "ENTER = Restart komputera"
    },
    {
        NULL,
        NULL
    }
};

MUI_PAGE plPLPages[] =
{
    {
        LANGUAGE_PAGE,
        plPLLanguagePageEntries
    },
    {
        START_PAGE,
        plPLWelcomePageEntries
    },
    {
        INSTALL_INTRO_PAGE,
        plPLIntroPageEntries
    },
    {
        LICENSE_PAGE,
        plPLLicensePageEntries
    },
    {
        DEVICE_SETTINGS_PAGE,
        plPLDevicePageEntries
    },
    {
        REPAIR_INTRO_PAGE,
        plPLRepairPageEntries
    },
    {
        COMPUTER_SETTINGS_PAGE,
        plPLComputerPageEntries
    },
    {
        DISPLAY_SETTINGS_PAGE,
        plPLDisplayPageEntries
    },
    {
        FLUSH_PAGE,
        plPLFlushPageEntries
    },
    {
        SELECT_PARTITION_PAGE,
        plPLSelectPartitionEntries
    },
    {
        CONFIRM_DELETE_SYSTEM_PARTITION_PAGE,
        plPLConfirmDeleteSystemPartitionEntries
    },
    {
        SELECT_FILE_SYSTEM_PAGE,
        plPLSelectFSEntries
    },
    {
        FORMAT_PARTITION_PAGE,
        plPLFormatPartitionEntries
    },
    {
        DELETE_PARTITION_PAGE,
        plPLDeletePartitionEntries
    },
    {
        INSTALL_DIRECTORY_PAGE,
        plPLInstallDirectoryEntries
    },
    {
        PREPARE_COPY_PAGE,
        plPLPrepareCopyEntries
    },
    {
        FILE_COPY_PAGE,
        plPLFileCopyEntries
    },
    {
        KEYBOARD_SETTINGS_PAGE,
        plPLKeyboardSettingsEntries
    },
    {
        BOOT_LOADER_PAGE,
        plPLBootLoaderEntries
    },
    {
        LAYOUT_SETTINGS_PAGE,
        plPLLayoutSettingsEntries
    },
    {
        QUIT_PAGE,
        plPLQuitPageEntries
    },
    {
        SUCCESS_PAGE,
        plPLSuccessPageEntries
    },
    {
        BOOT_LOADER_FLOPPY_PAGE,
        plPLBootPageEntries
    },
    {
        REGISTRY_PAGE,
        plPLRegistryEntries
    },
    {
        -1,
        NULL
    }
};

MUI_STRING plPLStrings[] =
{
    {STRING_PLEASEWAIT,
     "   Prosz czeka..."},
    {STRING_INSTALLCREATEPARTITION,
     "  ENTER = Instalacja   P = Partycja Podstawowa   E = Rozszerzona   F3 = Wyjcie"},
    {STRING_INSTALLCREATELOGICAL,
     "   ENTER = Instalacja   L = Utworzenie Partycji Logicznej   F3 = Wyjcie"},
    {STRING_INSTALLDELETEPARTITION,
     "   ENTER = Instalacja   D = Usunicie Partycji   F3 = Wyjcie"},
    {STRING_DELETEPARTITION,
     "   D = Usunicie Partycji   F3 = Wyjcie"},
    {STRING_PARTITIONSIZE,
     "Rozmiar nowej partycji:"},
    {STRING_CHOOSENEWPARTITION,
     "Wybrane: utworzenie nowej partycji podstawowej na"},
    {STRING_CHOOSE_NEW_EXTENDED_PARTITION,
     "Wybrane: utworzenie nowej partycji rozszerzonej na"},
    {STRING_CHOOSE_NEW_LOGICAL_PARTITION,
     "Wybrane: utworzenie nowej partycji logicznej na"},
    {STRING_HDDSIZE,
    "Prosz wprowadzi rozmiar nowej partycji w megabajtach."},
    {STRING_CREATEPARTITION,
     "   ENTER = Utworzenie Partycji   ESC = Anulowanie   F3 = Wyjcie"},
    {STRING_PARTFORMAT,
    "Nastpujca partycja zostanie sformatowana."},
    {STRING_NONFORMATTEDPART,
    "Moesz zainstalowa ReactOS na nowej lub niesformatowanej partycji."},
    {STRING_NONFORMATTEDSYSTEMPART,
    "Partycja systemowa nie jest jeszcze sformatowana."},
    {STRING_NONFORMATTEDOTHERPART,
    "Nowa partycja nie jest jeszcze sformatowana."},
    {STRING_INSTALLONPART,
    "Instalator kopiuje pliki systemu na wybran partycj."},
    {STRING_CHECKINGPART,
    "Instalator sprawdza wybran partycj."},
    {STRING_CONTINUE,
    "ENTER = Kontynuacja"},
    {STRING_QUITCONTINUE,
    "F3 = Wyjcie  ENTER = Kontynuacja"},
    {STRING_REBOOTCOMPUTER,
    "ENTER = Restart komputera"},
    {STRING_TXTSETUPFAILED,
    "Instalator nie by w stanie odnale sekcji '%S'\nw pliku TXTSETUP.SIF.\n"},
    {STRING_COPYING,
     "   Kopiowanie plikw: %S"},
    {STRING_SETUPCOPYINGFILES,
     "Instalator kopiuje pliki..."},
    {STRING_REGHIVEUPDATE,
    "   Uaktualnianie..."},
    {STRING_IMPORTFILE,
    "   Importowanie %S..."},
    {STRING_DISPLAYETTINGSUPDATE,
    "   Zmiana ustawie ekranu w rejestrze..."},
    {STRING_LOCALESETTINGSUPDATE,
    "   Zmiana wersji jzykowej..."},
    {STRING_KEYBOARDSETTINGSUPDATE,
    "   Zmiana ukadu klawiatury..."},
    {STRING_CODEPAGEINFOUPDATE,
    "   Dodawanie informacji o stronie kodowej do rejestru..."},
    {STRING_DONE,
    "   Ukoczone..."},
    {STRING_REBOOTCOMPUTER2,
    "   ENTER = Restart komputera"},
    {STRING_CONSOLEFAIL1,
    "Otwarcie konsoli nieudane\r\n\r\n"},
    {STRING_CONSOLEFAIL2,
    "Najczstsz tego przyczyn jest uycie klawiatury USB.\r\n"},
    {STRING_CONSOLEFAIL3,
    "Nie s obecnie w peni obsugiwane.\r\n"},
    {STRING_FORMATTINGDISK,
    "Instalator formatuje twj dysk"},
    {STRING_CHECKINGDISK,
    "Instalator sprawdza twj dysk"},
    {STRING_FORMATDISK1,
    " Sformatuj partycj z systemem plikw %S (szybkie formatowanie) "},
    {STRING_FORMATDISK2,
    " Sformatuj partycj z systemem plikw %S "},
    {STRING_KEEPFORMAT,
    " Zachowaj obecny system plikw (bez zmian) "},
    {STRING_HDINFOPARTCREATE,
    "%I64u %s  Dysku Twardym %lu  (Port=%hu, Szyna=%hu, Id=%hu) na %wZ."},
    {STRING_HDDINFOUNK1,
    "%I64u %s  Dysk 02 Twardy %lu  (Port=%hu, Szyna=%hu, Id=%hu)."},
    {STRING_HDDINFOUNK2,
    "   %c%c  03Typ 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTDELETE,
    "na %I64u %s  Dysku Twardym %lu  (Port=%hu, Szyna=%hu, Id=%hu) na %wZ."},
    {STRING_HDDINFOUNK3,
    "na %I64u %s  Dysku 05 Twardym %lu  (Port=%hu, Szyna=%hu, Id=%hu)."},
    {STRING_HDINFOPARTZEROED,
    "Dysk Twardy %lu (%I64u %s), Port=%hu, Szyna=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK4,
    "%c%c  07Typ 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTEXISTS,
    "na Dysku Twardym %lu (%I64u %s), Port=%hu, Szyna=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK5,
    "%c%c %c %s09Typ %-3u%s                      %6lu %s"},
    {STRING_HDINFOPARTSELECT,
    "%6lu %s  Dysk Twardy %lu  (Port=%hu, Szyna=%hu, Id=%hu) na %S"},
    {STRING_HDDINFOUNK6,
    "%6lu %s  Dysk11 Twardy %lu  (Port=%hu, Szyna=%hu, Id=%hu)"},
    {STRING_NEWPARTITION,
    "Instalator utworzy now partycj"},
    {STRING_UNPSPACE,
    "    %sMiejsce poza partycjami%s            %6lu %s"},
    {STRING_MAXSIZE,
    "MB (maks. %lu MB)"},
    {STRING_EXTENDED_PARTITION,
    "Partycja Rozszerzona"},
    {STRING_UNFORMATTED,
    "Nowa (Niesformatowana)"},
    {STRING_FORMATUNUSED,
    "Nieuyte"},
    {STRING_FORMATUNKNOWN,
    "Nieznane"},
    {STRING_KB,
    "KB"},
    {STRING_MB,
    "MB"},
    {STRING_GB,
    "GB"},
    {STRING_ADDKBLAYOUTS,
    "Dodawanie ukadw klawiatury"},
    {0, 0}
};
