#pragma once

MUI_LAYOUTS etEELayouts[] =
{
    { L"0425", L"00000425" },
    { NULL, NULL }
};

static MUI_ENTRY etEELanguagePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Keele valik",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Vali keel, mida paigaldamisel kasutada.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Ja vajuta ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Seda keelt kasutatakse hiljem ssteemi keelena.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Jtka  F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEWelcomePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Tere tulemast ReactOSi paigaldama",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        6,
        11,
        "Selles paigaldamise osas kopeeritakse ReactOSi failid arvutisse ja",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "valmistatakse ette paigaldamise teine jrk.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Vajuta ENTER, et ReactOS paigaldada.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Vajuta R, et ReactOSi parandada.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Vajuta L, et nha ReactOSi litsentsi ja kasutamise tingimusi",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Vajuta F3, et vljuda ReactOSi paigaldamata.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "ReactOSi kohta saab rohkem infot:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "http://www.reactos.org",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        0,
        0,
        "ENTER = Jtka  R = Paranda  L = Litsents  F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEIntroPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ReactOSi paigaldusprogramm on varajases arendusfaasis. Praegu ei ole",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "veel kik korraliku paigaldusprogrammi funktsioonid toetatud.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Kehtivad jrgmised piirangud:",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "- Toetatud on ainult FAT failissteem.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "- Failissteemi kontrollimist veel ei tehta.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        23,
        "\x07  Vajuta ENTER, et ReactOS paigaldada.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "\x07  Vajuta F3, et vljuda ReactOSi paigaldamata.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Jtka   F3 = Vlju",
        TEXT_TYPE_STATUS| TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEELicensePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        6,
        "Litsents:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        8,
        "ReactOS kasutab GNU ldist avalikku litsentsi(GPL),",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        9,
        "mned komponendid kasutavad muid hilduvaid litsentse,",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "nagu niteks X11, BSD ja GNU LGPL.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "Kogu ReactOSi ssteem on seega kaitstud GPL litsentsiga",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "ning samas kehtivad ka algsed litsentsid.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "Kesoleva tarkvaraga ei anta kaasa garantiid ega mrata kasutamise",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        16,
        "piiranguid kehtiva seadusega stestatud piirides. ReactOSi",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "litsents mrab ainult levitamise kolmandatele osapooltele.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "Kui mingil phjusel ei olnud tarkvaraga kaasas GNU GPL",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "ldist avalikku litsentsi, siis saab seda vaadata lehel",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "http://www.gnu.org/licenses/licenses.html",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        22,
        "Garantii:",
        TEXT_STYLE_HIGHLIGHT
    },
    {
        8,
        24,
        "Tegemist on vaba tarkvaraga; kopeerimise tingimused on kirjas algkoodis.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "Garantii puudub; pole isegi turustamiseks vi mingil",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        26,
        "kindlal eesmrgil kasutamiseks sobivuse garantiid",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Tagasi",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEDevicePageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Jrgnev nimekiri nitab riistvara seadeid.",
        TEXT_STYLE_NORMAL
    },
    {
        24,
        11,
        "Arvuti:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        12,
        "Monitor:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        13,
        "Klaviatuur:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        14,
        "Klaviatuuri asetus:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        24,
        16,
        "Rakenda:",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_RIGHT
    },
    {
        25,
        16, "Rakenda need seaded",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        19,
        "Riistvara seadeid saab muuta les ja alla liikudes.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        20,
        "Seadistuse muutmiseks vajuta ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        21,
        "",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        23,
        "Kui seadistus on paigas, vali \"Rakenda need seaded\"",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        24,
        "ja vajuta ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Jtka   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEERepairPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ReactOSi paigaldusprogramm on varajases arendusfaasis. Praegu ei ole",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "veel kik korraliku paigaldusprogrammi funktsioonid toetatud.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "Parandamine ei ole veel toetatud.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Vajuta U, et ssteemi uuendada.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Vajuta R, et kasutada taastuskonsooli.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Vajuta ESC, et minna tagasi pealehele.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Vajuta ENTER, et arvuti taaskivitada.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ESC = Pealeht  U = Uuenda  R = Taastamine  ENTER = Taaskivitus",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEComputerPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Arvuti tbi muutmine.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Liigu les-alla, et valida sobiv arvuti tp.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Seejrel vajuta ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Vajuta ESC, et minna tagasi eelmisele lehele",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   ilma arvuti tpi muutmata.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Jtka   ESC = Katkesta   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEFlushPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "Ssteem kirjutab nd andmed kettale",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Vib kuluda veidi aega",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "Lpetamisel taaskivitub arvuti automaatselt",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Vahemlu thjendamine",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEQuitPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "ReactOS ei ole tielikult paigaldatud",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Eemalda flopiketas ja CD-ROMid draividest.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Vajuta ENTER, et arvuti taaskivitada.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Palun oota...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG,
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEDisplayPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Monitori tbi muutmine.",
        TEXT_STYLE_NORMAL
    },
    {   8,
        10,
         "\x07  Liigu les-alla, et monitori tpi muuta.",
         TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Seejrel vajuta ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Vajuta ESC, et minna tagasi eelmisele lehele",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   ilma monitori tpi muutmata.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Jtka   ESC = Katkesta   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEESuccessPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        10,
        6,
        "ReactOSi philised komponendid on edukalt paigaldatud.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        8,
        "Eemalda flopiketas ja CD-ROMid draividest.",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        9,
        "",
        TEXT_STYLE_NORMAL
    },
    {
        10,
        11,
        "Vajuta ENTER, et arvuti taaskivitada.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Taaskivita arvuti",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEBootPageEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Alglaadurit ei saanud kettale kirjutada.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        13,
        "Sisesta vormindatud flopiketas draivi A:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "ja vajuta ENTER.",
        TEXT_STYLE_NORMAL,
    },
    {
        0,
        0,
        "ENTER = Jtka   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }

};

static MUI_ENTRY etEESelectPartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "See nimekiri nitab partitsioone ja vaba ruumi",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "uute partitsioonide jaoks.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "\x07  Liigu les-alla, et valida kirje.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Vajuta ENTER, et paigaldada ReactOS valitud partitsioonile.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "\x07  Press P to create a primary partition.",
//        "\x07  Vajuta C, et teha uus partitsioon.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        17,
        "\x07  Press E to create an extended partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        19,
        "\x07  Press L to create a logical partition.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Vajuta D, et kustutada olemasolev partitsioon.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Palun oota...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEConfirmDeleteSystemPartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "You have chosen to delete the system partition.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "System partitions can contain diagnostic programs, hardware configuration",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        11,
        "programs, programs to start an operating system (like ReactOS) or other",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        12,
        "programs provided by the hardware manufacturer.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Delete a system partition only when you are sure that there are no such",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "programs on the partition, or when you are sure you want to delete them.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "When you delete the partition, you might not be able to boot the",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        17,
        "computer from the harddisk until you finished the ReactOS Setup.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        20,
        "\x07  Press ENTER to delete the system partition. You will be asked",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "   to confirm the deletion of the partition again later.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        24,
        "\x07  Press ESC to return to the previous page. The partition will",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        25,
        "   not be deleted.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER=Continue  ESC=Cancel",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEFormatPartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Partitsiooni vormindamine",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        10,
        "Nd vormindatakse partitsioon. Vajuta ENTER, et jtkata.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Jtka   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        TEXT_STYLE_NORMAL
    }
};

static MUI_ENTRY etEEInstallDirectoryEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "ReactOS paigaldatakse valitud partitsioonile.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        9,
        "Vali kaust, kuhu ReactOS paigaldada:",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        14,
        "Kausta muutmiseks kustuta kirje BACKSPACE klahviga ja",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        15,
        "trki asemele kaust, kuhu ReactOS installeerida.",
        TEXT_STYLE_NORMAL
    },
    {
        6,
        16,
        "",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Jtka   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEFileCopyEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        0,
        12,
        "Palun oota, kuni ReactOS paigaldatakse sihtkausta.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        13,
        "",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        0,
        14,
        "Vib kuluda mitu minutit.",
        TEXT_STYLE_NORMAL | TEXT_ALIGN_CENTER
    },
    {
        50,
        0,
        "\xB3 Palun oota...    ",
        TEXT_TYPE_STATUS
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEBootLoaderEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Alglaaduri paigaldamine",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        12,
        "Paigalda alglaadur kvakettale (MBR ja VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "Paigalda alglaadur kvakettale (ainult VBR).",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "Paigalda alglaadur flopikettale.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        15,
        "ra paigalda alglaadurit.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Jtka   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEKeyboardSettingsEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Klaviatuuri tbi muutmine.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Vajuta les-alla, et valida klaviatuuri tp.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "   Seejrel vajuta ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Vajuta ESC, et minna tagasi eelmisele lehele",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   klaviatuuri tpi muutmata.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Jtka   ESC = Katkesta   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEELayoutSettingsEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Vali vaikimisi klaviatuuriasetus.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        10,
        "\x07  Liigu les-alla, et valida klaviatuuriasetus.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        11,
        "    Seejrel vajuta ENTER.",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        13,
        "\x07  Vajuta ESC, et minna tagasi eelmisele lehele",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        14,
        "   klaviatuuriasetust muutmata.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "ENTER = Jtka   ESC = Katkesta   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY etEEPrepareCopyEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Arvutit valmistatakse ette ReactOSi failide kopeerimiseks.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Failide nimekirja loomine...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

static MUI_ENTRY etEESelectFSEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        17,
        "Vali nimekirjast failissteem.",
        0
    },
    {
        8,
        19,
        "\x07  Liigu les-alla, et valida failissteem.",
        0
    },
    {
        8,
        21,
        "\x07  Vajuta ENTER, et partitsioon vormindada.",
        0
    },
    {
        8,
        23,
        "\x07  Vajuta ESC, et valida muu partitsioon.",
        0
    },
    {
        0,
        0,
        "ENTER = Jtka   ESC = Katkesta   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },

    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEEDeletePartitionEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Oled valinud partitsiooni kustutamise",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        18,
        "\x07  Vajuta D, et partitsioon kustutada.",
        TEXT_STYLE_NORMAL
    },
    {
        11,
        19,
        "HOIATUS: Kik andmed partitsioonil kustutatakse!",
        TEXT_STYLE_NORMAL
    },
    {
        8,
        21,
        "\x07  Vajuta ESC, et katkestada.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "D = Kustuta partitsioon   ESC = Katkesta   F3 = Vlju",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    }
};

static MUI_ENTRY etEERegistryEntries[] =
{
    {
        4,
        3,
        " ReactOS " KERNEL_VERSION_STR " paigaldamine ",
        TEXT_STYLE_UNDERLINE
    },
    {
        6,
        8,
        "Uuendatakse ssteemi seadistust.",
        TEXT_STYLE_NORMAL
    },
    {
        0,
        0,
        "Registri vtmete loomine...",
        TEXT_TYPE_STATUS | TEXT_PADDING_BIG
    },
    {
        0,
        0,
        NULL,
        0
    },

};

MUI_ERROR etEEErrorEntries[] =
{
    {
        // NOT_AN_ERROR
        "Success\n"
    },
    {
        //ERROR_NOT_INSTALLED
        "ReactOS ei ole tielikult paigaldatud.\n"
        "Kui paigaldamine praegu katkestada, siis tuleb\n"
        "ReactOSi paigaldamiseks paigaldusprogramm uuesti kivitada.\n"
        "\n"
        "  \x07  Vajuta ENTER, et paigaldamist jtkata.\n"
        "  \x07  Vajuta F3, et paigaldamie peatada.",
        "F3 = Vlju  ENTER = Jtka"
    },
    {
        //ERROR_NO_HDD
        "Kvaketast ei leitud.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_NO_SOURCE_DRIVE
        "Paigaldusprogramm ei leidnud ketast, millelt see kivitati.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_LOAD_TXTSETUPSIF
        "TXTSETUP.SIF faili ei nnestunud laadida.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_CORRUPT_TXTSETUPSIF
        "TXTSETUP.SIF on vigane.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_SIGNATURE_TXTSETUPSIF,
        "TXTSETUP.SIF faili signatuur on vigane.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_DRIVE_INFORMATION
        "Ssteemiketta parameetreid ei nnestunud lugeda.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_WRITE_BOOT,
        "Ssteemikettale ei nnestunud kirjutada FAT alglaadimiskoodi.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_LOAD_COMPUTER,
        "Arvutitpide nimekirja ei nnestunud laadida.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_LOAD_DISPLAY,
        "Monitoride nimekirja ei nnestunud laadida.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_LOAD_KEYBOARD,
        "Klaviatuuri tpide nimekirja ei nnestunud laadida.\n",
         "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_LOAD_KBLAYOUT,
        "Klaviatuuriasetuste nimekirja ei nnestunud laadida.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_WARN_PARTITION,
          "Leiti vhemalt ks kvaketas, millel on hildamatu partitsioonitabel,\n"
          "millega ei saanud korralikult mber kia!\n"
          "\n"
          "Partitsioonide loomine vi kustutamine vib vigastada partitsioonitabelit.\n"
          "\n"
          "  \x07  Vajuta F3, et vljuda paigaldusest..\n"
          "  \x07  Vajuta ENTER, et jtkata.",
          "F3 = Vlju  ENTER = Jtka"
    },
    {
        //ERROR_NEW_PARTITION,
        "Uut partitsioonitabelit ei saa juba olemasoleva\n"
        "partitsiooni sisse tekitada!\n"
        "\n"
        "  * Vajuta suvalist klahvi, et jtkata.",
        NULL
    },
    {
        //ERROR_DELETE_SPACE,
        "Partitsioneerimata kettaruumi ei saa kustutada!\n"
        "\n"
        "  * Vajuta suvalist klahvi, et jtkata.",
        NULL
    },
    {
        //ERROR_INSTALL_BOOTCODE,
        "Ssteemikettale ei nnestunud paigaldada FAT alglaadimiskoodi.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_NO_FLOPPY,
        "Draivis A: ei ole flopiketast.",
        "ENTER = Jtka"
    },
    {
        //ERROR_UPDATE_KBSETTINGS,
        "Klaviatuuriasetuse seadistust ei nnestunud uuendada.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_UPDATE_DISPLAY_SETTINGS,
        "Monitori seadistust registris ei nnestunud uuendada.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_IMPORT_HIVE,
        "Tarufaili ei nnestunud importida.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_FIND_REGISTRY
        "Registri andmete faile ei leitud.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_CREATE_HIVE,
        "Registri tarusid ei nnestunud luua.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_INITIALIZE_REGISTRY,
        "Registrit ei nnestunud luua.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_INVALID_CABINET_INF,
        "Kapifailis ei olnud pdevaid inf faile.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_CABINET_MISSING,
        "Kapifaili ei leitud.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_CABINET_SCRIPT,
        "Kapifailis puudub paigaldusskript.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_COPY_QUEUE,
        "Kopeeritavate failide nimekirja ei nnestunud avada.\n",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_CREATE_DIR,
        "Paigalduskaustu ei nnestunud luua.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_TXTSETUP_SECTION,
        "TXTSETUP.SIF failist ei leitud 'Directories' sektsiooni.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_CABINET_SECTION,
        "Kapifailist ei leitud 'Directories' sektsiooni.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_CREATE_INSTALL_DIR
        "Paigalduskausta ei nnestunud luua.",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_FIND_SETUPDATA,
        "TXTSETUP.SIF failist ei leitud 'SetupData' sektsiooni",
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_WRITE_PTABLE,
        "Partitsioonitabeleid ei nnestunud kirjutada.\n"
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_ADDING_CODEPAGE,
        "Kooditabelit ei nnestunud registrisse lisada.\n"
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_UPDATE_LOCALESETTINGS,
        "Ssteemilokaati ei nnestunud sedistada.\n"
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_ADDING_KBLAYOUTS,
        "Klaviatuuriasetusi ei nnestunud registrisse lisada.\n"
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_UPDATE_GEOID,
        "Geograafilist asukohta ei nnestunud seadistada.\n"
        "ENTER = Taaskivita arvuti"
    },
    {
        //ERROR_DIRECTORY_NAME,
        "Invalid directory name.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_INSUFFICIENT_PARTITION_SIZE,
        "The selected partition is not large enough to install ReactOS.\n"
        "The install partition must have a size of at least %lu MB.\n"
        "\n"
        "  * Vajuta suvalist klahvi, et jtkata.",
        NULL
    },
    {
        //ERROR_PARTITION_TABLE_FULL,
        "You can not create a new primary or extended partition in the\n"
        "partition table of this disk because the partition table is full.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_ONLY_ONE_EXTENDED,
        "You can not create more than one extended partition per disk.\n"
        "\n"
        "  * Press any key to continue."
    },
    {
        //ERROR_FORMATTING_PARTITION,
        "Setup is unable to format the partition:\n"
        " %S\n"
        "\n"
        "ENTER = Reboot computer"
    },
    {
        NULL,
        NULL
    }
};

MUI_PAGE etEEPages[] =
{
    {
        LANGUAGE_PAGE,
        etEELanguagePageEntries
    },
    {
        START_PAGE,
        etEEWelcomePageEntries
    },
    {
        INSTALL_INTRO_PAGE,
        etEEIntroPageEntries
    },
    {
        LICENSE_PAGE,
        etEELicensePageEntries
    },
    {
        DEVICE_SETTINGS_PAGE,
        etEEDevicePageEntries
    },
    {
        REPAIR_INTRO_PAGE,
        etEERepairPageEntries
    },
    {
        COMPUTER_SETTINGS_PAGE,
        etEEComputerPageEntries
    },
    {
        DISPLAY_SETTINGS_PAGE,
        etEEDisplayPageEntries
    },
    {
        FLUSH_PAGE,
        etEEFlushPageEntries
    },
    {
        SELECT_PARTITION_PAGE,
        etEESelectPartitionEntries
    },
    {
        CONFIRM_DELETE_SYSTEM_PARTITION_PAGE,
        etEEConfirmDeleteSystemPartitionEntries
    },
    {
        SELECT_FILE_SYSTEM_PAGE,
        etEESelectFSEntries
    },
    {
        FORMAT_PARTITION_PAGE,
        etEEFormatPartitionEntries
    },
    {
        DELETE_PARTITION_PAGE,
        etEEDeletePartitionEntries
    },
    {
        INSTALL_DIRECTORY_PAGE,
        etEEInstallDirectoryEntries
    },
    {
        PREPARE_COPY_PAGE,
        etEEPrepareCopyEntries
    },
    {
        FILE_COPY_PAGE,
        etEEFileCopyEntries
    },
    {
        KEYBOARD_SETTINGS_PAGE,
        etEEKeyboardSettingsEntries
    },
    {
        BOOT_LOADER_PAGE,
        etEEBootLoaderEntries
    },
    {
        LAYOUT_SETTINGS_PAGE,
        etEELayoutSettingsEntries
    },
    {
        QUIT_PAGE,
        etEEQuitPageEntries
    },
    {
        SUCCESS_PAGE,
        etEESuccessPageEntries
    },
    {
        BOOT_LOADER_FLOPPY_PAGE,
        etEEBootPageEntries
    },
    {
        REGISTRY_PAGE,
        etEERegistryEntries
    },
    {
        -1,
        NULL
    }
};

MUI_STRING etEEStrings[] =
{
    {STRING_PLEASEWAIT,
     "   Palun oota..."},
    {STRING_INSTALLCREATEPARTITION,
     "   ENTER = Install   P = Create Primary   E = Create Extended   F3 = Quit"},
//     "   ENTER = Paigalda  C = Loo partitsioon    F3 = Vlju"},
    {STRING_INSTALLCREATELOGICAL,
     "   ENTER = Install   L = Create Logical Partition   F3 = Quit"},
    {STRING_INSTALLDELETEPARTITION,
     "   ENTER = Paigalda  D = Kustuta partitsioon  F3 = Vlju"},
    {STRING_DELETEPARTITION,
     "   D = Delete Partition   F3 = Quit"},
    {STRING_PARTITIONSIZE,
     "Uue partitsiooni suurus:"},
    {STRING_CHOOSENEWPARTITION,
     "You have chosen to create a primary partition on"},
//     "Oled valinud kettale uue partitsiooni loomise"},
    {STRING_CHOOSE_NEW_EXTENDED_PARTITION,
     "You have chosen to create an extended partition on"},
    {STRING_CHOOSE_NEW_LOGICAL_PARTITION,
     "You have chosen to create a logical partition on"},
    {STRING_HDDSIZE,
    "Sisesta uue partitsiooni suurus megabaitides."},
    {STRING_CREATEPARTITION,
     "   ENTER = Loo partitsioon   ESC = Katkesta   F3 = Vlju"},
    {STRING_PARTFORMAT,
    "Jrgmisena vormindatakse seda partitsiooni."},
    {STRING_NONFORMATTEDPART,
    "Oled valinud ReactOSi paigaldamise uuele vi vormindamata partitsioonile."},
    {STRING_NONFORMATTEDSYSTEMPART,
    "The system partition is not formatted yet."},
    {STRING_NONFORMATTEDOTHERPART,
    "The new partition is not formatted yet."},
    {STRING_INSTALLONPART,
    "ReactOS paigaldatakse partitsioonile"},
    {STRING_CHECKINGPART,
    "Valitud partitsiooni kontrollitakse."},
    {STRING_CONTINUE,
    "ENTER = Jtka"},
    {STRING_QUITCONTINUE,
    "F3 = Vlju  ENTER = Jtka"},
    {STRING_REBOOTCOMPUTER,
    "ENTER = Taaskivita arvuti"},
    {STRING_TXTSETUPFAILED,
     "TXTSETUP.SIF failist ei leitud '%S' sektsiooni\n"},
    {STRING_COPYING,
     "   Kopeerimine: %S"},
    {STRING_SETUPCOPYINGFILES,
     "Failide kopeerimine..."},
    {STRING_REGHIVEUPDATE,
    "   Registritarude uuendamine..."},
    {STRING_IMPORTFILE,
    "   %S importimine..."},
    {STRING_DISPLAYETTINGSUPDATE,
    "   Monitori seadistuse uuendamine registris..."},
    {STRING_LOCALESETTINGSUPDATE,
    "   Lokaadi seadistuse uuendamine..."},
    {STRING_KEYBOARDSETTINGSUPDATE,
    "   Klaviatuuriasetuse seadistuse uuendamine..."},
    {STRING_CODEPAGEINFOUPDATE,
    "   Kooditabeli info lisamine registrisse..."},
    {STRING_DONE,
    "   Valmis..."},
    {STRING_REBOOTCOMPUTER2,
    "   ENTER = Taaskivita arvuti"},
    {STRING_CONSOLEFAIL1,
    "Konsooli ei nnestunud avada\r\n\r\n"},
    {STRING_CONSOLEFAIL2,
    "Tenoliselt on probleem USB klaviatuuri kasutamises\r\n"},
    {STRING_CONSOLEFAIL3,
    "USB klaviatuurid ei ole veel toetatud\r\n"},
    {STRING_FORMATTINGDISK,
    "Kvaketta vormindamine"},
    {STRING_CHECKINGDISK,
    "Kvaketta kontrollimine"},
    {STRING_FORMATDISK1,
    " Vorminda partitsioon %S failissteemiga (kiire vormindus) "},
    {STRING_FORMATDISK2,
    " Vorminda partitsioon %S failissteemiga "},
    {STRING_KEEPFORMAT,
    " ra muuda praegust failissteemi "},
    {STRING_HDINFOPARTCREATE,
    "%I64u %s  Kvaketas %lu  (Port=%hu, Siin=%hu, Id=%hu) - %wZ."},
    {STRING_HDDINFOUNK1,
    "%I64u %s  Kvaketas %lu  (Port=%hu, Siin=%hu, Id=%hu)."},
    {STRING_HDDINFOUNK2,
    "   %c%c  Type 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTDELETE,
    "%I64u %s  Kvaketas %lu  (Port=%hu, Siin=%hu, Id=%hu) - %wZ."},
    {STRING_HDDINFOUNK3,
    "%I64u %s  Kvaketas %lu  (Port=%hu, Siin=%hu, Id=%hu)."},
    {STRING_HDINFOPARTZEROED,
    "Kvaketas %lu (%I64u %s), Port=%hu, Siin=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK4,
    "%c%c  Type 0x%02X    %I64u %s"},
    {STRING_HDINFOPARTEXISTS,
    "Kvaketas %lu (%I64u %s), Port=%hu, Siin=%hu, Id=%hu (%wZ)."},
    {STRING_HDDINFOUNK5,
    "%c%c %c %sTp %-3u%s                      %6lu %s"},
    {STRING_HDINFOPARTSELECT,
    "%6lu %s  Kvaketas %lu  (Port=%hu, Siin=%hu, Id=%hu) on %S"},
    {STRING_HDDINFOUNK6,
    "%6lu %s  Kvaketas %lu  (Port=%hu, Siin=%hu, Id=%hu)"},
    {STRING_NEWPARTITION,
    "Loodi uus partitsioon"},
    {STRING_UNPSPACE,
    "    %sKasutamata kettaruum%s              %6lu %s"},
    {STRING_MAXSIZE,
    "MB (maks. %lu MB)"},
    {STRING_EXTENDED_PARTITION,
    "Extended Partition"},
    {STRING_UNFORMATTED,
    "Uus (Vormindamata)"},
    {STRING_FORMATUNUSED,
    "Kasutamata"},
    {STRING_FORMATUNKNOWN,
    "Tundmatu"},
    {STRING_KB,
    "KB"},
    {STRING_MB,
    "MB"},
    {STRING_GB,
    "GB"},
    {STRING_ADDKBLAYOUTS,
    "Klaviatuuriasetuste lisamine"},
    {0, 0}
};
